//
//  calcPerfC172.m
//  FlightPad
//
//  Created by Claus Richter on 11/27/18.
//

#import "calcPerfC172.h"

#import "calcPerfClass.h"


float PAlevelShortfield = 0;
float gR_0_low = 0; float cl_0_low = 0;  float gR_10_low = 0; float cl_10_low = 0; float gR_20_low = 0; float cl_20_low = 0; float gR_30_low = 0; float cl_30_low = 0; float gR_40_low = 0; float cl_40_low = 0;
float gR_0_hig = 0; float cl_0_hig = 0;  float gR_10_hig = 0; float cl_10_hig = 0; float gR_20_hig = 0; float cl_20_hig = 0; float gR_30_hig = 0; float cl_30_hig = 0; float gR_40_hig = 0; float cl_40_hig = 0;


float gR_0_lowLD = 0; float cl_0_lowLD = 0;  float gR_10_lowLD = 0; float cl_10_lowLD = 0; float gR_20_lowLD = 0; float cl_20_lowLD = 0; float gR_30_lowLD = 0; float cl_30_lowLD = 0; float gR_40_lowLD = 0; float cl_40_lowLD = 0;
float gR_0_higLD = 0; float cl_0_higLD = 0;  float gR_10_higLD = 0; float cl_10_higLD = 0; float gR_20_higLD = 0; float cl_20_higLD = 0; float gR_30_higLD = 0; float cl_30_higLD = 0; float gR_40_higLD = 0; float cl_40_higLD = 0;


float M20_BHP_DWN = 83; float M20_KTAS_DWN = 125; float M20_GPH_DWN = 11.1;  float STD_BHP_DWN = 77; float STD_KTAS_DWN = 124; float STD_GPH_DWN = 10.4;  float P20_BHP_DWN = 71; float P20_KTAS_DWN = 123; float P20_GPH_DWN = 9.7;

float M20_BHP_UPP = 78; float M20_KTAS_UPP = 124; float M20_GPH_UPP = 10.5;  float STD_BHP_UPP = 72; float STD_KTAS_UPP = 123; float STD_GPH_UPP = 9.8;  float P20_BHP_UPP = 67; float P20_KTAS_UPP = 122; float P20_GPH_UPP = 9.3;


float M20_BHP_DWN2 = 83; float M20_KTAS_DWN2 = 125; float M20_GPH_DWN2 = 11.1;  float STD_BHP_DWN2 = 77; float STD_KTAS_DWN2 = 124; float STD_GPH_DWN2 = 10.4;  float P20_BHP_DWN2 = 71; float P20_KTAS_DWN2 = 123; float P20_GPH_DWN2 = 9.7;

float M20_BHP_UPP2 = 78; float M20_KTAS_UPP2 = 124; float M20_GPH_UPP2 = 10.5;  float STD_BHP_UPP2 = 72; float STD_KTAS_UPP2 = 123; float STD_GPH_UPP2 = 9.8;  float P20_BHP_UPP2 = 67; float P20_KTAS_UPP2 = 122; float P20_GPH_UPP2 = 9.3;

float M20_BHP_DWN_MED = 83; float M20_KTAS_DWN_MED = 125; float M20_GPH_DWN_MED = 11.1;  float STD_BHP_DWN_MED = 77; float STD_KTAS_DWN_MED = 124; float STD_GPH_DWN_MED = 10.4;  float P20_BHP_DWN_MED = 71; float P20_KTAS_DWN_MED = 123; float P20_GPH_DWN_MED = 9.7;

float M20_BHP_UPP_MED = 78; float M20_KTAS_UPP_MED = 124; float M20_GPH_UPP_MED = 10.5;  float STD_BHP_UPP_MED = 72; float STD_KTAS_UPP_MED = 123; float STD_GPH_UPP_MED = 9.8;  float P20_BHP_UPP_MED = 67; float P20_KTAS_UPP_MED = 122; float P20_GPH_UPP_MED = 9.3;
float PressAltAbzug = 0; float BHPinterpol =0;

float sliderRPMmin =0; float sliderRPMmax =0;
float RPM_LOW =0; float RPM_HIGH =0; 
float GPH = 0; float KTAS = 0; 
float temp = 0; float RPM = 0; float low_BHP = 0; float low_KTAS =0; float low_GPH = 0; float high_BHP = 0; float high_KTAS =0; float high_GPH = 0;

float ObstClearance_1 = 0; float ObstClearance_2 = 0;  float ObstClearance_interpolated = 0;
float GrndRollShortField_1 = 0; float GrndRollShortField_2 = 0; float GrndRollShortField_interpolated = 0;
float ObstClearance_12400 = 0; float ObstClearance_22400 = 0;  float ObstClearance_interpolated2400 = 0;
float GrndRollShortField_12400 = 0; float GrndRollShortField_22400 = 0; float GrndRollShortField_interpolated2400 = 0;
float ObstClearance_12550 = 0; float ObstClearance_22550 = 0;  float ObstClearance_interpolated2550 = 0;
float GrndRollShortField_12550 = 0; float GrndRollShortField_22550 = 0; float GrndRollShortField_interpolated2550 = 0;

float PressureAltitude = 0;  float ACweightLBS = 0; float GroundRolltoWeight = 0; float totalToClear = 0;
float totalToClearSumme = 0; float liftoffspeed = 0;

float GrndRollShortField_1LandingLD = 0;
float PAlevelShortfieldLD = 0;
float GrndRollShortField_2LandingLD = 0; float GrndRollShortField_interpolatedLandingLD = 0;
float ObstClearance_1LandingLD = 0; float ObstClearance_2LandingLD = 0; float ObstClearance_interpolatedLandingLD =0;

float climb_low2  = 0; float RoC_low2  = 0; float time_low2  = 0; float fuel_low2  = 0;  float distNM_low2   = 0;
float climb_high2 = 0; float RoC_high2 = 0; float time_high2 = 0; float fuel_high2 = 0;  float distNM_high2  = 0; float PAlevel2 = 0;



float sliderOATvalue = 0;

@interface calcPerfC172 ()

@end

@implementation calcPerfC172

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    
}

- (void) shortfieldC182H_2000 {
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
      gR_0_low = 295; cl_0_low = 655;    gR_10_low = 295; cl_10_low = 655;   gR_20_low = 295; cl_20_low = 655;   gR_30_low = 295; cl_30_low = 655;   gR_40_low = 295; cl_40_low = 655;    gR_0_hig = 295; cl_0_hig = 655;    gR_10_hig = 295; cl_10_hig = 655;   gR_20_hig = 295; cl_20_hig = 655;   gR_30_hig = 295; cl_30_hig = 655;   gR_40_hig = 295; cl_40_hig = 655; 
        
        PAlevelShortfield = 0;
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 295; cl_0_low = 655;    gR_10_low = 295; cl_10_low = 655;   gR_20_low = 295; cl_20_low = 655;   gR_30_low = 295; cl_30_low = 655;   gR_40_low = 295; cl_40_low = 655;    gR_0_hig = 350; cl_0_hig = 745;    gR_10_hig = 350; cl_10_hig = 745;   gR_20_hig = 350; cl_20_hig = 745;   gR_30_hig = 350; cl_30_hig = 745;   gR_40_hig = 350; cl_40_hig = 745; 
        
        PAlevelShortfield = 1000;
     
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
       gR_0_low = 350; cl_0_low = 745;    gR_10_low = 350; cl_10_low = 745;   gR_20_low = 350; cl_20_low = 745;   gR_30_low = 350; cl_30_low = 745;   gR_40_low = 350; cl_40_low = 745;    gR_0_hig = 350; cl_0_hig = 745;    gR_10_hig = 350; cl_10_hig = 745;   gR_20_hig = 350; cl_20_hig = 745;   gR_30_hig = 350; cl_30_hig = 745;   gR_40_hig = 350; cl_40_hig = 745; 
        
        PAlevelShortfield = 2000;
        
       
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 350; cl_0_low = 745;    gR_10_low = 350; cl_10_low = 745;   gR_20_low = 350; cl_20_low = 745;   gR_30_low = 350; cl_30_low = 745;   gR_40_low = 350; cl_40_low = 745;    gR_0_hig = 350; cl_0_hig = 745;    gR_10_hig = 350; cl_10_hig = 745;   gR_20_hig = 350; cl_20_hig = 745;   gR_30_hig = 350; cl_30_hig = 745;   gR_40_hig = 350; cl_40_hig = 745; 
        
        PAlevelShortfield = 3000;
        
        
        
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
      gR_0_low = 350; cl_0_low = 745;    gR_10_low = 350; cl_10_low = 745;   gR_20_low = 350; cl_20_low = 745;   gR_30_low = 350; cl_30_low = 745;   gR_40_low = 350; cl_40_low = 745;    gR_0_hig = 415; cl_0_hig = 855;    gR_10_hig = 415; cl_10_hig = 855;   gR_20_hig = 415; cl_20_hig = 855;   gR_30_hig = 415; cl_30_hig = 855;   gR_40_hig = 415; cl_40_hig = 855; 
        
        
        PAlevelShortfield = 4000;
        
     
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
       gR_0_low = 415; cl_0_low = 855;    gR_10_low = 415; cl_10_low = 855;   gR_20_low = 415; cl_20_low = 855;   gR_30_low = 415; cl_30_low = 855;   gR_40_low = 415; cl_40_low = 855;    gR_0_hig = 415; cl_0_hig = 855;    gR_10_hig = 415; cl_10_hig = 855;   gR_20_hig = 415; cl_20_hig = 855;   gR_30_hig = 415; cl_30_hig = 855;   gR_40_hig = 415; cl_40_hig = 855; 
        
        PAlevelShortfield = 5000;
        
      
        
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 415; cl_0_low = 855;    gR_10_low = 415; cl_10_low = 855;   gR_20_low = 415; cl_20_low = 855;   gR_30_low = 415; cl_30_low = 855;   gR_40_low = 415; cl_40_low = 855;    gR_0_hig = 500; cl_0_hig = 1005;    gR_10_hig = 500; cl_10_hig = 1005;   gR_20_hig = 500; cl_20_hig = 1005;   gR_30_hig = 500; cl_30_hig = 1005;   gR_40_hig = 500; cl_40_hig = 1005; 
        
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
       gR_0_low = 500; cl_0_low = 1005;    gR_10_low = 500; cl_10_low = 1005;   gR_20_low = 500; cl_20_low = 1005;   gR_30_low = 500; cl_30_low = 1005;   gR_40_low = 500; cl_40_low = 1005;    gR_0_hig = 500; cl_0_hig = 1005;    gR_10_hig = 500; cl_10_hig = 1005;   gR_20_hig = 500; cl_20_hig = 1005;   gR_30_hig = 500; cl_30_hig = 1005;   gR_40_hig = 500; cl_40_hig = 1005; 
        
        PAlevelShortfield = 7000;
        
     
        
        
    } // end if
    
    
   
    
    
      [self shortfield2200C172_interpolation];
    
    
  
    
    return;
    
}
- (void) shortfieldC182H_2400 {
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
     gR_0_low = 440; cl_0_low = 895;    gR_10_low = 440; cl_10_low = 895;   gR_20_low = 440; cl_20_low = 895;   gR_30_low = 440; cl_30_low = 895;   gR_40_low = 440; cl_40_low = 895;   gR_0_hig = 440; cl_0_hig = 895;    gR_10_hig = 440; cl_10_hig = 895;   gR_20_hig = 440; cl_20_hig = 895;   gR_30_hig = 440; cl_30_hig = 895;   gR_40_hig = 440; cl_40_hig = 895; 
        
        PAlevelShortfield = 0;
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
       gR_0_low = 440; cl_0_low = 895;    gR_10_low = 440; cl_10_low = 895;   gR_20_low = 440; cl_20_low = 895;   gR_30_low = 440; cl_30_low = 895;   gR_40_low = 440; cl_40_low = 895;   gR_0_hig = 525; cl_0_hig = 1035;    gR_10_hig = 525; cl_10_hig = 1035;   gR_20_hig = 525; cl_20_hig = 1035;   gR_30_hig = 525; cl_30_hig = 1035;   gR_40_hig = 525; cl_40_hig = 1035; 
        
        PAlevelShortfield = 1000;
     
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
      gR_0_low = 525; cl_0_low = 1035;    gR_10_low = 525; cl_10_low = 1035;   gR_20_low = 525; cl_20_low = 1035;   gR_30_low = 525; cl_30_low = 1035;   gR_40_low = 525; cl_40_low = 1035;   gR_0_hig = 525; cl_0_hig = 1035;    gR_10_hig = 525; cl_10_hig = 1035;   gR_20_hig = 525; cl_20_hig = 1035;   gR_30_hig = 525; cl_30_hig = 1035;   gR_40_hig = 525; cl_40_hig = 1035; 
        
        PAlevelShortfield = 2000;
        
       
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
       gR_0_low = 525; cl_0_low = 1035;    gR_10_low = 525; cl_10_low = 1035;   gR_20_low = 525; cl_20_low = 1035;   gR_30_low = 525; cl_30_low = 1035;   gR_40_low = 525; cl_40_low = 1035;   gR_0_hig = 525; cl_0_hig = 1035;    gR_10_hig = 525; cl_10_hig = 1035;   gR_20_hig = 525; cl_20_hig = 1035;   gR_30_hig = 525; cl_30_hig = 1035;   gR_40_hig = 525; cl_40_hig = 1035; 
        
        PAlevelShortfield = 3000;
        
        
        
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
      gR_0_low = 525; cl_0_low = 1035;    gR_10_low = 525; cl_10_low = 1035;   gR_20_low = 525; cl_20_low = 1035;   gR_30_low = 525; cl_30_low = 1035;   gR_40_low = 525; cl_40_low = 1035;   gR_0_hig = 630; cl_0_hig = 1210;    gR_10_hig = 630; cl_10_hig = 1210;   gR_20_hig = 630; cl_20_hig = 1210;   gR_30_hig = 630; cl_30_hig = 1210;   gR_40_hig = 630; cl_40_hig = 1210; 
        
        
        PAlevelShortfield = 4000;
        
     
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
      gR_0_low = 630; cl_0_low = 1210;    gR_10_low = 630; cl_10_low = 1210;   gR_20_low = 630; cl_20_low = 1210;   gR_30_low = 630; cl_30_low = 1210;   gR_40_low = 630; cl_40_low = 1210;   gR_0_hig = 630; cl_0_hig = 1210;    gR_10_hig = 630; cl_10_hig = 1210;   gR_20_hig = 630; cl_20_hig = 1210;   gR_30_hig = 630; cl_30_hig = 1210;   gR_40_hig = 630; cl_40_hig = 1210; 
        
        PAlevelShortfield = 5000;
        
      
        
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
       gR_0_low = 630; cl_0_low = 1210;    gR_10_low = 630; cl_10_low = 1210;   gR_20_low = 630; cl_20_low = 1210;   gR_30_low = 630; cl_30_low = 1210;   gR_40_low = 630; cl_40_low = 1210;   gR_0_hig = 765; cl_0_hig = 1460;    gR_10_hig = 765; cl_10_hig = 1460;   gR_20_hig = 765; cl_20_hig = 1460;   gR_30_hig = 765; cl_30_hig = 1460;   gR_40_hig = 765; cl_40_hig = 1460;  
        
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
       gR_0_low = 765; cl_0_low = 1460;    gR_10_low = 765; cl_10_low = 1460;   gR_20_low = 765; cl_20_low = 1460;   gR_30_low = 765; cl_30_low = 1460;   gR_40_low = 765; cl_40_low = 1460;   gR_0_hig = 765; cl_0_hig = 1460;    gR_10_hig = 765; cl_10_hig = 1460;   gR_20_hig = 765; cl_20_hig = 1460;   gR_30_hig = 765; cl_30_hig = 1460;   gR_40_hig = 765; cl_40_hig = 1460; 
        
        PAlevelShortfield = 7000;
        
     
        
        
    } // end if
    
    
   
    
    
      [self shortfield2400C172_interpolation];
    
    
  
    
    return;
    
}
- (void) shortfieldC182H_2800 {
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
      gR_0_low = 625; cl_0_low = 1205;    gR_10_low = 625; cl_10_low = 1205;   gR_20_low = 625; cl_20_low = 1205;   gR_30_low = 625; cl_30_low = 1205;   gR_40_low = 625; cl_40_low = 1205;   gR_0_hig = 625; cl_0_hig = 1205;    gR_10_hig = 625; cl_10_hig = 1205;   gR_20_hig = 625; cl_20_hig = 1205;   gR_30_hig = 625; cl_30_hig = 1205;   gR_40_hig = 625; cl_40_hig = 1205; 
        
        PAlevelShortfield = 0;
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
       gR_0_low = 625; cl_0_low = 1205;    gR_10_low = 625; cl_10_low = 1205;   gR_20_low = 625; cl_20_low = 1205;   gR_30_low = 625; cl_30_low = 1205;   gR_40_low = 625; cl_40_low = 1205;   gR_0_hig = 745; cl_0_hig = 1420;    gR_10_hig = 745; cl_10_hig = 1420;   gR_20_hig = 745; cl_20_hig = 1420;   gR_30_hig = 745; cl_30_hig = 1420;   gR_40_hig = 745; cl_40_hig = 1420; 
        
        PAlevelShortfield = 1000;
     
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
       gR_0_low = 745; cl_0_low = 1420;    gR_10_low = 745; cl_10_low = 1420;   gR_20_low = 745; cl_20_low = 1420;   gR_30_low = 745; cl_30_low = 1420;   gR_40_low = 745; cl_40_low = 1420;   gR_0_hig = 745; cl_0_hig = 1420;    gR_10_hig = 745; cl_10_hig = 1420;   gR_20_hig = 745; cl_20_hig = 1420;   gR_30_hig = 745; cl_30_hig = 1420;   gR_40_hig = 745; cl_40_hig = 1420; 
        
        PAlevelShortfield = 2000;
        
       
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
       gR_0_low = 745; cl_0_low = 1420;    gR_10_low = 745; cl_10_low = 1420;   gR_20_low = 745; cl_20_low = 1420;   gR_30_low = 745; cl_30_low = 1420;   gR_40_low = 745; cl_40_low = 1420;   gR_0_hig = 745; cl_0_hig = 1420;    gR_10_hig = 745; cl_10_hig = 1420;   gR_20_hig = 745; cl_20_hig = 1420;   gR_30_hig = 745; cl_30_hig = 1420;   gR_40_hig = 745; cl_40_hig = 1420;  
        
        PAlevelShortfield = 3000;
        
        
        
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
      gR_0_low = 745; cl_0_low = 1420;    gR_10_low = 745; cl_10_low = 1420;   gR_20_low = 745; cl_20_low = 1420;   gR_30_low = 745; cl_30_low = 1420;   gR_40_low = 745; cl_40_low = 1420;   gR_0_hig = 895; cl_0_hig = 1695;    gR_10_hig = 895; cl_10_hig = 1695;   gR_20_hig = 895; cl_20_hig = 1695;   gR_30_hig = 895; cl_30_hig = 1695;   gR_40_hig = 895; cl_40_hig = 1695; 
        
        
        PAlevelShortfield = 4000;
        
     
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
      gR_0_low = 895; cl_0_low = 1695;    gR_10_low = 895; cl_10_low = 1695;   gR_20_low = 895; cl_20_low = 1695;   gR_30_low = 895; cl_30_low = 1695;   gR_40_low = 895; cl_40_low = 1695;   gR_0_hig = 895; cl_0_hig = 1695;    gR_10_hig = 895; cl_10_hig = 1695;   gR_20_hig = 895; cl_20_hig = 1695;   gR_30_hig = 895; cl_30_hig = 1695;   gR_40_hig = 895; cl_40_hig = 1695; 
        
        PAlevelShortfield = 5000;
        
      
        
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 895; cl_0_low = 1695;    gR_10_low = 895; cl_10_low = 1695;   gR_20_low = 895; cl_20_low = 1695;   gR_30_low = 895; cl_30_low = 1695;   gR_40_low = 895; cl_40_low = 1695;   gR_0_hig = 1095; cl_0_hig = 2090;    gR_10_hig = 1095; cl_10_hig = 2090;   gR_20_hig = 1095; cl_20_hig = 2090;   gR_30_hig = 1095; cl_30_hig = 2090;   gR_40_hig = 1095; cl_40_hig = 2090; 
        
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
       gR_0_low = 1095; cl_0_low = 2090;    gR_10_low = 1095; cl_10_low = 2090;   gR_20_low = 1095; cl_20_low = 2090;   gR_30_low = 1095; cl_30_low = 2090;   gR_40_low = 1095; cl_40_low = 2090;   gR_0_hig = 1095; cl_0_hig = 2090;    gR_10_hig = 1095; cl_10_hig = 2090;   gR_20_hig = 1095; cl_20_hig = 2090;   gR_30_hig = 1095; cl_30_hig = 2090;   gR_40_hig = 1095; cl_40_hig = 2090; 
        
        PAlevelShortfield = 7000;
        
     
        
        
    } // end if
    
    
   
    
    
      [self shortfield2550C172S_interpolation];
    
    
  
    
    return;
    
}
- (void) shortfiedC182HInterpolationToACWEight {
    
    
    if (ACweightLBS >= 2000 & ACweightLBS < 2400) {                
        
        GroundRolltoWeight = GrndRollShortField_interpolated + ( ( (GrndRollShortField_interpolated2400 - GrndRollShortField_interpolated)/400 ) * (ACweightLBS-2000))  ;
        
        totalToClear = ObstClearance_interpolated + ( ( (ObstClearance_interpolated2400 - ObstClearance_interpolated)/400 ) * (ACweightLBS-2000))  ;
              
    }
    
    
    
    if (ACweightLBS >= 2400 & ACweightLBS <= 2800) {                
        
        GroundRolltoWeight = GrndRollShortField_interpolated2400 + ( ( (GrndRollShortField_interpolated2550 - GrndRollShortField_interpolated2400)/400 ) * (ACweightLBS-2400)) ;
        
        totalToClear = ObstClearance_interpolated2400 + ( ( (ObstClearance_interpolated2550 - ObstClearance_interpolated2400)/400 ) * (ACweightLBS-2400))  ;
              
        
    }
    
    resultTODistancefeet = totalToClear;
    
    resultTOGroundRollfeet = GroundRolltoWeight;
    
    
    
}

- (void) shortfield_LandingC182H {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
       gR_0_lowLD = 550; cl_0_lowLD = 1290;    gR_10_lowLD = 570; cl_10_lowLD = 1320;   gR_20_lowLD = 590; cl_20_lowLD = 1350;   gR_30_lowLD = 610; cl_30_lowLD = 1380;   gR_40_lowLD = 630; cl_40_lowLD = 1410;   gR_0_higLD = 600; cl_0_higLD = 1250;    gR_10_higLD = 620; cl_10_higLD = 1280;   gR_20_higLD = 645; cl_20_higLD = 1300;   gR_30_higLD = 660; cl_30_higLD = 1330;   gR_40_higLD = 680; cl_40_higLD = 1360; 
        
        PAlevelShortfieldLD = 0;
        
        
      
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
      gR_0_lowLD = 600; cl_0_lowLD = 1250;    gR_10_lowLD = 625; cl_10_lowLD = 1270;   gR_20_lowLD = 645; cl_20_lowLD = 1300;   gR_30_lowLD = 660; cl_30_lowLD = 1330;   gR_40_lowLD = 680; cl_40_lowLD = 1360;   gR_0_higLD = 620; cl_0_higLD = 1280;    gR_10_higLD = 640; cl_10_higLD = 1430;   gR_20_higLD = 660; cl_20_higLD = 1350;   gR_30_higLD = 680; cl_30_higLD = 1380;   gR_40_higLD = 700; cl_40_higLD = 1400; 
        
        PAlevelShortfieldLD = 1000;
       
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
    gR_0_lowLD = 620; cl_0_lowLD = 1280;    gR_10_lowLD = 640; cl_10_lowLD = 1430;   gR_20_lowLD = 660; cl_20_lowLD = 1350;   gR_30_lowLD = 680; cl_30_lowLD = 1380;   gR_40_lowLD = 700; cl_40_lowLD = 1400;   gR_0_higLD = 620; cl_0_higLD = 1400;    gR_10_higLD = 640; cl_10_higLD = 1430;   gR_20_higLD = 660; cl_20_higLD = 1460;   gR_30_higLD = 680; cl_30_higLD = 1490;   gR_40_higLD = 700; cl_40_higLD = 1520; 
        
        PAlevelShortfieldLD = 2000;
        
       
        
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
      gR_0_lowLD = 620; cl_0_lowLD = 1400;    gR_10_lowLD = 640; cl_10_lowLD = 1430;   gR_20_lowLD = 660; cl_20_lowLD = 1460;   gR_30_lowLD = 680; cl_30_lowLD = 1490;   gR_40_lowLD = 700; cl_40_lowLD = 1520;   gR_0_higLD = 640; cl_0_higLD = 1437.5;    gR_10_higLD = 680; cl_10_higLD = 1505;   gR_20_higLD = 680; cl_20_higLD = 1497.5;   gR_30_higLD = 700; cl_30_higLD = 1527.5;   gR_40_higLD = 720; cl_40_higLD = 1557.5; 
        
        PAlevelShortfieldLD = 3000;
        
       
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
       gR_0_lowLD = 640; cl_0_lowLD = 1437.5;    gR_10_lowLD = 660; cl_10_lowLD = 1467.5;   gR_20_lowLD = 680; cl_20_lowLD = 1497.5;   gR_30_lowLD = 700; cl_30_lowLD = 1527.5;   gR_40_lowLD = 720; cl_40_lowLD = 1557.5;   gR_0_higLD = 660; cl_0_higLD = 1475;    gR_10_higLD = 680; cl_10_higLD = 1505;   gR_20_higLD = 700; cl_20_higLD = 1535;   gR_30_higLD = 720; cl_30_higLD = 1565;   gR_40_higLD = 740; cl_40_higLD = 1595; 
        
        PAlevelShortfieldLD = 4000;
        
      
        
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
       gR_0_lowLD = 660; cl_0_lowLD = 1475;    gR_10_lowLD = 680; cl_10_lowLD = 1505;   gR_20_lowLD = 700; cl_20_lowLD = 1535;   gR_30_lowLD = 720; cl_30_lowLD = 1565;   gR_40_lowLD = 740; cl_40_lowLD = 1595;   gR_0_higLD = 695; cl_0_higLD = 1450;    gR_10_higLD = 715; cl_10_higLD = 1480;   gR_20_higLD = 730; cl_20_higLD = 1495;   gR_30_higLD = 755; cl_30_higLD = 1520;   gR_40_higLD = 775; cl_40_higLD = 1550; 
        
        PAlevelShortfieldLD = 5000;
        
       
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 695; cl_0_lowLD = 1450;    gR_10_lowLD = 715; cl_10_lowLD = 1480;   gR_20_lowLD = 730; cl_20_lowLD = 1495;   gR_30_lowLD = 755; cl_30_lowLD = 1520;   gR_40_lowLD = 775; cl_40_lowLD = 1550;   gR_0_higLD = 715; cl_0_higLD = 1490;    gR_10_higLD = 730; cl_10_higLD = 1500;   gR_20_higLD = 750; cl_20_higLD = 1530;   gR_30_higLD = 775; cl_30_higLD = 1575;   gR_40_higLD = 795; cl_40_higLD = 1590; 
        
        PAlevelShortfieldLD = 6000;
        
      
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 715; cl_0_lowLD = 1490;    gR_10_lowLD = 730; cl_10_lowLD = 1500;   gR_20_lowLD = 750; cl_20_lowLD = 1530;   gR_30_lowLD = 775; cl_30_lowLD = 1575;   gR_40_lowLD = 795; cl_40_lowLD = 1590;   gR_0_higLD = 740; cl_0_higLD = 1595;    gR_10_higLD = 760; cl_10_higLD = 1625;   gR_20_higLD = 780; cl_20_higLD = 1655;   gR_30_higLD = 800; cl_30_higLD = 1685;   gR_40_higLD = 820; cl_40_higLD = 1715; 
        
        PAlevelShortfieldLD = 7000;
        
       
        
    } // end if
    
    
   
    
    return;
    
} // end void
- (void) shortfieldLandingC182H_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_1LandingLD = gR_0_lowLD + ( (gR_0_higLD -  gR_0_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_10_lowLD + ( (gR_10_higLD -  gR_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD -  GrndRollShortField_1LandingLD) / 10) * (sliderOATvalue));
        
        
        ObstClearance_1LandingLD = cl_0_lowLD + ( (cl_0_higLD -  cl_0_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_10_lowLD + ( (cl_10_higLD -  cl_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 10) * (sliderOATvalue));
        
        
    }  
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 15) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_1LandingLD = gR_10_lowLD + ( (gR_10_higLD -  gR_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_20_lowLD + ( (gR_20_higLD -  gR_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD -  GrndRollShortField_1LandingLD) / 5) * (sliderOATvalue -10 ));
        
        
        ObstClearance_1LandingLD = cl_10_lowLD + ( (cl_10_higLD -  cl_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_20_lowLD + ( (cl_20_higLD -  cl_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 5) * (sliderOATvalue -10 ));
        
        
        
    } 
    
    
    if (sliderOATvalue >= 15 & sliderOATvalue < 30) {
        
        GrndRollShortField_1LandingLD = gR_20_lowLD + ( (gR_20_higLD -  gR_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_30_lowLD + ( (gR_30_higLD -  gR_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD-  GrndRollShortField_1LandingLD) / 15) * (sliderOATvalue -15 ));
        
        
        ObstClearance_1LandingLD = cl_20_lowLD + ( (cl_20_higLD -  cl_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_30_lowLD + ( (cl_30_higLD -  cl_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 15) * (sliderOATvalue -15 ));
        
        
    } 
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_1LandingLD = gR_30_lowLD + ( (gR_30_higLD -  gR_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_40_lowLD + ( (gR_40_higLD -  gR_40_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD -  GrndRollShortField_1LandingLD) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_1LandingLD = cl_30_lowLD + ( (cl_30_higLD -  cl_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_40_lowLD + ( (cl_40_higLD -  cl_40_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 10) * (sliderOATvalue -30 ));
        
        
        
    } 
    
    
    
    
    return;
    
    
    
}

- (void) calculate_ClimbC182H {
    
    if (PressureAltitude >=0 & PressureAltitude < 5000) {  
       climb_low2  = 76; RoC_low2   = 980; time_low2   = 0; fuel_low2   = 0;    distNM_low2   = 0; climb_high2 = 75; RoC_high2  = 745; time_high2  = 6.71140939597315; fuel_high2  = 3.7;    distNM_high2   = 8.38926174496644; PAlevel2 = 0;   
        
    }
    
    if (PressureAltitude >=5000 & PressureAltitude < 10000) {
        
       climb_low2  = 75; RoC_low2   = 745; time_low2   = 6.71140939597315; fuel_low2   = 3.7;    distNM_low2   = 8.38926174496644; PAlevel2 = 5000;   climb_high2 = 73; RoC_high2  = 510; time_high2  = 16.5153309646006; fuel_high2  = 6.3;    distNM_high2   = 28.4829144185639; PAlevel2 = 5000;     
        
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 15000) {
        
       climb_low2  = 73; RoC_low2   = 510; time_low2   = 16.5153309646006; fuel_low2   = 6.3;    distNM_low2   = 28.4829144185639; PAlevel2 = 10000;   climb_high2 = 71; RoC_high2  = 280; time_high2  = 34.3724738217435; fuel_high2  = 10.2;    distNM_high2   = 69.1570084409603; PAlevel2 = 10000;
        
    }
    
    
    if (PressureAltitude >=15000 & PressureAltitude < 20000) {
        
       climb_low2  = 71; RoC_low2   = 280; time_low2   = 34.3724738217435; fuel_low2   = 10.2;    distNM_low2   = 69.1570084409603; PAlevel2 = 15000;   climb_high2 = 69; RoC_high2  = 50; time_high2  = 134.372473821743; fuel_high2  = 20.5;    distNM_high2   = 223.685353335965; PAlevel2 = 15000;  
        
    }
    
    
    
    
    [self interpolateClimbC182H];
    
}
- (void) interpolateClimbC182H {
    
    // interpolate Climb Speed
    resultClimbSpeed = climb_low2 - (((climb_low2 - climb_high2)/5000) *  (PressureAltitude - PAlevel2));  
    
    // interpolate ROC
    resultClimbRoC = RoC_low2 - (((RoC_low2 - RoC_high2)/5000) *  (PressureAltitude - PAlevel2)); 
    
    // interpolate Time in Minutes
    resultClimbTime = time_low2 - (((time_low2 - time_high2)/5000) *  (PressureAltitude - PAlevel2));    
    
    // interpolate Fuel used
    resultClimbFuel = fuel_low2 - (((fuel_low2 - fuel_high2 )/5000) *  (PressureAltitude - PAlevel2));
    
    // interpolate Distance
    resultClimbDistance = distNM_low2 - (((distNM_low2 - distNM_high2)/5000) *  (PressureAltitude - PAlevel2));
    
    //NSLog(@"**************************");
    //NSLog(@"resultClimbSpeed %f", resultClimbSpeed);
    //NSLog(@"resultClimbRoC %f", resultClimbRoC);
    //NSLog(@"resultClimbTime %f", resultClimbTime);
    //NSLog(@"resultClimbFuel %f", resultClimbFuel);
    //NSLog(@"resultClimbDistance %f", resultClimbDistance);
    
    
}
- (void) setRPMsliderValuesC182H {
      
      
       sliderRPMmin = 2000;
      sliderRPMmax = 2450;
      
      
      resultRPMmin = sliderRPMmin;
      resultRPMmax = sliderRPMmax;
      
      
  }
- (void) computeCruiseC182H {
    
    
    //NSLog(@"PressureAltitude %.0f", PressureAltitude);  
    //NSLog(@"RPM %.0f", RPM);  
    
    RPM = engineRPMcruise;
    
    if (RPM < 2000) {
        return;
    }
    
    if (PressureAltitude <=2500) {
        if (RPM >=2000 & RPM < 2200) { resultCruiseBHP = 47; resultCruiseFuelBurn = 8.7; resultCruiseKTAS = 126 * 0.87 ; }
        if (RPM >=2200 & RPM < 2300) { resultCruiseBHP = 67; resultCruiseFuelBurn = 12.1; resultCruiseKTAS = 149 * 0.87 ; }
        if (RPM >=2300 & RPM < 2450) { resultCruiseBHP = 71; resultCruiseFuelBurn = 13.1; resultCruiseKTAS = 154 * 0.87 ; }
        if (RPM >=2450 & RPM < 2490) { resultCruiseBHP = 76; resultCruiseFuelBurn = 14.2; resultCruiseKTAS = 158 * 0.87 ; }
    }
    
    if (PressureAltitude >2500 & PressureAltitude <=5000) {
       if (RPM >=2000 & RPM < 2200) { resultCruiseBHP = 45; resultCruiseFuelBurn = 8.5; resultCruiseKTAS = 126 * 0.87 ; }
        if (RPM >=2200 & RPM < 2300) { resultCruiseBHP = 68; resultCruiseFuelBurn = 12.4; resultCruiseKTAS = 155 * 0.87 ; }
        if (RPM >=2300 & RPM < 2450) { resultCruiseBHP = 73; resultCruiseFuelBurn = 13.4; resultCruiseKTAS = 158 * 0.87 ; }
        if (RPM >=2450 & RPM < 2490) { resultCruiseBHP = 78; resultCruiseFuelBurn = 14.5; resultCruiseKTAS = 163 * 0.87 ; }
    }
    if (PressureAltitude >5000 & PressureAltitude <=7500) {
       if (RPM >=2000 & RPM < 2200) { resultCruiseBHP = 47; resultCruiseFuelBurn = 8.7; resultCruiseKTAS = 131 * 0.87 ; }
        if (RPM >=2200 & RPM < 2300) { resultCruiseBHP = 62; resultCruiseFuelBurn = 11.4; resultCruiseKTAS = 152 * 0.87 ; }
        if (RPM >=2300 & RPM < 2450) { resultCruiseBHP = 66; resultCruiseFuelBurn = 12.2; resultCruiseKTAS = 156 * 0.87 ; }
        if (RPM >=2450 & RPM < 2490) { resultCruiseBHP = 71; resultCruiseFuelBurn = 13.1; resultCruiseKTAS = 161 * 0.87 ; }
    }
    
    if (PressureAltitude >7500 & PressureAltitude <=10000) {
       if (RPM >=2000 & RPM < 2200) { resultCruiseBHP = 44; resultCruiseFuelBurn = 8.4; resultCruiseKTAS = 128 * 0.87 ; }
        if (RPM >=2200 & RPM < 2300) { resultCruiseBHP = 56; resultCruiseFuelBurn = 10.4; resultCruiseKTAS = 148 * 0.87 ; }
        if (RPM >=2300 & RPM < 2450) { resultCruiseBHP = 50; resultCruiseFuelBurn = 11.1; resultCruiseKTAS = 152 * 0.87 ; }
        if (RPM >=2450 & RPM < 2490) { resultCruiseBHP = 63; resultCruiseFuelBurn = 11.9; resultCruiseKTAS = 156 * 0.87 ; }
    }
    
    if (PressureAltitude >10000 & PressureAltitude <=150000) {
       if (RPM >=2000 & RPM < 2200) { resultCruiseBHP = 40; resultCruiseFuelBurn = 7.8; resultCruiseKTAS = 122 * 0.87 ; }
        if (RPM >=2200 & RPM < 2300) { resultCruiseBHP = 47; resultCruiseFuelBurn = 9.1; resultCruiseKTAS = 138 * 0.87 ; }
        if (RPM >=2300 & RPM < 2450) { resultCruiseBHP = 50; resultCruiseFuelBurn = 9.6; resultCruiseKTAS = 143 * 0.87 ; }
        if (RPM >=2450 & RPM < 2490) { resultCruiseBHP = 54; resultCruiseFuelBurn = 10.4; resultCruiseKTAS = 150 * 0.87 ; }
    }
    
    
}

- (void) fwValueTransfer:  (float)receivedOAT  sendPA:(float)receivedPA  sendISAdiff:(float)receivedISAdiff sendQNH_USA:(float)receivedQNH_USA sendHeadWindKts:(float)receivedHeadWindKts sendACweight:(float)receivedACweight  sendACType:(NSString*)receivedACtype sendComputation:(NSString*)receivedComputation{
    
    
    headWindKts = receivedHeadWindKts;
    
    
    ACType = receivedACtype;
    
    ISAdiff = receivedISAdiff;
    
    //NSLog(@"receivedOAT %.1f", receivedOAT);
    
    PressureAltitude = receivedPA;
    sliderOATvalue = receivedOAT;
    ACweightLBS = receivedACweight;
    
    
    //NSLog(@"PressureAltitude %.0f", PressureAltitude);
    //NSLog(@"sliderOATvalue %.0f", sliderOATvalue);
    //NSLog(@"ACweightLBS %.0f", ACweightLBS);
    
    //NSLog(@"receivedComputation %@", receivedComputation);
    
     //*******************************************************************************************
    
    if ([receivedComputation isEqualToString:@"C182HCruise"]) { 
        [self setRPMsliderValuesC182H];
        [self computeCruiseC182H];
        
        NSLog(@"resultCruiseBHP %.0f", resultCruiseBHP);   
        NSLog(@"resultCruiseFuelBurn %.1f", resultCruiseFuelBurn); 
        NSLog(@"resultCruiseKTAS %.0f", resultCruiseKTAS); 
    }
    
    if ([receivedComputation isEqualToString:@"C182HClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC182H];      
    }
    
    
    if ([receivedComputation isEqualToString:@"C182Hlanding"]) {  
        
        if (sliderOATvalue < 0) {
            sliderOATvalue = 0;
        }        
        if (sliderOATvalue > 40) {
            sliderOATvalue = 40;
        }
        [self shortfield_LandingC182H];
        [self shortfieldLandingC182H_interpolation];
        //NSLog(@"result LAND GroundRollfeet %.0f", GrndRollShortField_interpolatedLandingLD);
        //NSLog(@"result LAND Distancefeet %.0f", ObstClearance_interpolatedLandingLD);
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
       
    }
    
    
    if ([receivedComputation isEqualToString:@"C182Htakeoff"]) {   
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2800) {
            ACweightLBS = 2800;
        }
        [self shortfieldC182H_2000];
        [self shortfieldC182H_2400];
        [self shortfieldC182H_2800];
        [self shortfiedC182HInterpolationToACWEight];
        //NSLog(@"resultTOGroundRollfeet %.0f", resultTOGroundRollfeet);
        //NSLog(@"resultTODistancefeet %.0f", resultTODistancefeet);
        resultGroundRoll = resultTOGroundRollfeet;
        resultDistanceOverObstacle = resultTODistancefeet;
    }
    
    
    
    
    
     //*******************************************************************************************
    
    if ([receivedComputation isEqualToString:@"C172Stakeoff"]) {   
        if (ACweightLBS < 2200) {
            ACweightLBS = 2200;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }
        [self shortfieldC172S_2200];
        [self shortfieldC172S_2400];
        [self shortfieldC172S_2550];
        [self shortfiedC172SlInterpolationToACWEight];
        //NSLog(@"resultTOGroundRollfeet %.0f", resultTOGroundRollfeet);
        //NSLog(@"resultTODistancefeet %.0f", resultTODistancefeet);
        resultGroundRoll = resultTOGroundRollfeet;
        resultDistanceOverObstacle = resultTODistancefeet;
    }
    
    if ([receivedComputation isEqualToString:@"C172SClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC172S];      
    }
    
    
    if ([receivedComputation isEqualToString:@"C172SCruise"]) { 
        [self setRPMsliderValuesC172S];
        [self InterpolateCruiseValuesC172S];
    }
    
    if ([receivedComputation isEqualToString:@"C172Slanding"]) {  
        
        if (sliderOATvalue < 0) {
            sliderOATvalue = 0;
        }        
        if (sliderOATvalue > 40) {
            sliderOATvalue = 40;
        }
        [self shortfield_LandingC172S];
        [self shortfieldLandingC172_interpolation];
        //NSLog(@"result LAND GroundRollfeet %.0f", resultTOGroundRollfeet);
        //NSLog(@"result LAND Distancefeet %.0f", resultTODistancefeet);
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
       
    }
    
    
    //*******************************************************************************************
    
    if ([receivedComputation isEqualToString:@"C172Rtakeoff"]) {        
        
        ACweightLBS = 2450;  
        [self shortfield_2450_C172R];      
        [self shortfiedC172RlInterpolationToACWEightC172R];
        
        resultGroundRoll = resultTOGroundRollfeet;
        resultDistanceOverObstacle = resultTODistancefeet;
    }
    
    if ([receivedComputation isEqualToString:@"C172RClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC172R];       
    }
    
    if ([receivedComputation isEqualToString:@"C172RCruise"]) { 
        [self setRPMsliderValuesC172S];
        [self InterpolateCruiseValuesC172R];
    }
    
    
    if ([receivedComputation isEqualToString:@"C172Rlanding"]) {        
        
        [self shortfield_LandingC172R];
        [self shortfieldLandingC172_interpolation];
        
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
    }
    
    
    //*******************************************************************************************
    
    if ([receivedComputation isEqualToString:@"C172Ptakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2400) {
            ACweightLBS = 2400;
        }    
        
        [self shortfieldC172P_2200];  // leicht        
        [self shortfieldC172P_2400];  // medium        
        [self shortfieldC172P_2550];  // heavy
        
        [self shortfiedlC172PInterpolationToACWEight];        
        resultGroundRoll = GroundRolltoWeight;
        resultDistanceOverObstacle = totalToClear;
    }
    
    if ([receivedComputation isEqualToString:@"C172PClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC172P];      
    }    
    
    if ([receivedComputation isEqualToString:@"C172PCruise"]) { 
        [self setRPMsliderValuesC172S];
        [self InterpolateCruiseValuesC172P];
    }    
    if ([receivedComputation isEqualToString:@"C172Planding"]) {        
        
        [self shortfield_LandingC172R];
        [self shortfieldLandingC172_interpolation];        
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
    }
    
    
    //*******************************************************************************************
    
    if ([receivedComputation isEqualToString:@"C172Ntakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2400) {
            ACweightLBS = 2400;
        }    
        
        [self shortfieldC172N_2200];  // leicht        
        [self shortfieldC172N_2400];  // medium        
        [self shortfieldC172N_2550];  // heavy
        
        [self shortfiedlC172NInterpolationToACWEight];        
        resultGroundRoll = GroundRolltoWeight;
        resultDistanceOverObstacle = totalToClear;
    }
    
    if ([receivedComputation isEqualToString:@"C172NClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC172N];        
    } 
    
    if ([receivedComputation isEqualToString:@"C172NCruise"]) { 
        [self setRPMsliderValuesC172N];
        [self InterpolateCruiseValuesC172N];
    }
    
    if ([receivedComputation isEqualToString:@"C172Nlanding"]) {        
        
        [self shortfield_LandingC172N];
        [self shortfieldLandingC172_interpolation];        
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
    }
    
    
    //*******************************************************************************************
    
    
    if ([receivedComputation isEqualToString:@"C172Mtakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2300) {
            ACweightLBS = 2300;
        }    
        
        [self shortfieldC172M_2200];  // leicht        
        [self shortfieldC172M_2400];  // medium        
        [self shortfieldC172M_2550];  // heavy
        
        [self shortfiedlC172NInterpolationToACWEight];        
        resultGroundRoll = GroundRolltoWeight;
        resultDistanceOverObstacle = totalToClear;
    }
    
    if ([receivedComputation isEqualToString:@"C172MClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC172M];
    } 
    
    if ([receivedComputation isEqualToString:@"C172MCruise"]) { 
        [self setRPMsliderValuesC172N];
        [self InterpolateCruiseValuesC172M];
    }
    
    if ([receivedComputation isEqualToString:@"C172Mlanding"]) {        
        
        [self shortfield_LandingC172M];
        [self shortfieldLandingC172_interpolation];        
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
    }
    
    
    //*******************************************************************************************
   
    if ([receivedComputation isEqualToString:@"PA28ArcherIItakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }   
        
        [self takeoff_PA28ArcherIIFlaps25];  // from graphs  
    }
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIIlanding"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }    
        
        [self landing_PA28ArcherIIFlaps25];  // from graphs  
        
    }
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIIClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_PA28ArcherIIClimb];        
    } 
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIICruise"]) {        
        [self calculate_PA28ArcherIICruise];
    }
    
    
     //*******************************************************************************************
    
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIIItakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }   
        
        [self takeoff_PA28ArcherIIIFlaps25];  // from graphs  
    }
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIIIlanding"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }    
        
        [self landing_PA28ArcherIIIFlaps25];  // from graphs  
        
    }
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIIIClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_PA28ArcherIIIClimb];        
    } 
    
    if ([receivedComputation isEqualToString:@"PA28ArcherIIICruise"]) {        
        [self calculate_PA28ArcherIIICruise];
    }
    
    
    //*******************************************************************************************
    
    
    
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIIItakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }   
        
        [self takeoff_PA28WarriorIII];  // from graphs  
    }
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIIIlanding"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }    
        
        [self landing_PA28WarriorIII];  // from graphs  
        
    }
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIIIClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_PA28WarriorIIIClimb];        
    } 
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIIICruise"]) {        
        [self calculate_PA28WarriorIIICruise];
    }
    
    
    //*******************************************************************************************
    
    
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIItakeoff"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }   
        
        [self takeoff_PA28WarriorII];  // from graphs  
    }
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIIlanding"]) {   
        
        if (ACweightLBS < 2000) {
            ACweightLBS = 2000;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }    
        
        [self landing_PA28WarriorII];  // from graphs  
        
    }
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIIClimb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_PA28WarriorIIClimb];        
    } 
    
    if ([receivedComputation isEqualToString:@"PA28WarriorIICruise"]) {        
        [self calculate_PA28WarriorIICruise];
    }
    
    
    //*******************************************************************************************
    
    if ([receivedComputation isEqualToString:@"C152takeoff"]) {   
        if (ACweightLBS < 2200) {
            ACweightLBS = 2200;
        }
        if (ACweightLBS > 2550) {
            ACweightLBS = 2550;
        }
        [self shortfieldC152_2200];
        [self shortfieldC152_2400];
        [self shortfieldC152_2550];
        [self shortfiedC172SlInterpolationToACWEight];
        //NSLog(@"resultTOGroundRollfeet %.0f", resultTOGroundRollfeet);
        //NSLog(@"resultTODistancefeet %.0f", resultTODistancefeet);
        resultGroundRoll = resultTOGroundRollfeet;
        resultDistanceOverObstacle = resultTODistancefeet;
    }
    
    if ([receivedComputation isEqualToString:@"C152Climb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self calculate_ClimbC152];      
    }
    
    
    if ([receivedComputation isEqualToString:@"C152Cruise"]) { 
        [self setRPMsliderValuesC152];
        [self InterpolateCruiseValuesC172S];
    }
    
    if ([receivedComputation isEqualToString:@"C152landing"]) {  
        
        if (sliderOATvalue < 0) {
            sliderOATvalue = 0;
        }        
        if (sliderOATvalue > 40) {
            sliderOATvalue = 40;
        }
        [self shortfield_LandingC152];
        [self shortfieldLandingC172_interpolation];
        //NSLog(@"result LAND GroundRollfeet %.0f", resultTOGroundRollfeet);
        //NSLog(@"result LAND Distancefeet %.0f", resultTODistancefeet);
        resultGroundRoll = GrndRollShortField_interpolatedLandingLD;
        resultDistanceOverObstacle = ObstClearance_interpolatedLandingLD;
        
    }
    
    
    //*******************************************************************************************
    
    
    
    
    if ([receivedComputation isEqualToString:@"DA40-180takeoff"]) {   
        
        [self takeoff_DA40180];  // from graphs  
    }
    
    if ([receivedComputation isEqualToString:@"DA40-180landing"]) {   
       
        [self landing_DA40180];  // from graphs  
    }
    
    
    if ([receivedComputation isEqualToString:@"DA40-180Climb"]) {
        //NSLog(@"C172SClimb PressureAltitude %.0f", PressureAltitude);        
        [self climb_DA40180];        
    } 
    
    if ([receivedComputation isEqualToString:@"DA40-180Cruise"]) {        
        [self cruiseDA40180];
    }
    
     //*******************************************************************************************
    
    
    
    
    
}


// C172 N **************************************************************************************************


- (void) shortfieldC172N_2200 {  // leichteste
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
        gR_0_low = 470; cl_0_low = 865;    gR_10_low = 505; cl_10_low = 920;   gR_20_low = 540; cl_20_low = 985;   gR_30_low = 580; cl_30_low = 1045;   gR_40_low = 620; cl_40_low = 1115;     gR_0_hig = 515; cl_0_hig = 940;    gR_10_hig = 550; cl_10_hig = 1005;   gR_20_hig = 590; cl_20_hig = 1070;   gR_30_hig = 635; cl_30_hig = 1140;   gR_40_hig = 680; cl_40_hig = 1215;
        
        PAlevelShortfield = 0;
        
       
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 515; cl_0_low = 940;    gR_10_low = 550; cl_10_low = 1005;   gR_20_low = 590; cl_20_low = 1070;   gR_30_low = 635; cl_30_low = 1140;   gR_40_low = 680; cl_40_low = 1215;     gR_0_hig = 560; cl_0_hig = 1025;    gR_10_hig = 605; cl_10_hig = 1095;   gR_20_hig = 645; cl_20_hig = 1170;   gR_30_hig = 695; cl_30_hig = 1245;   gR_40_hig = 745; cl_40_hig = 1330;
        
        PAlevelShortfield = 1000;

        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 560; cl_0_low = 1025;    gR_10_low = 605; cl_10_low = 1095;   gR_20_low = 645; cl_20_low = 1170;   gR_30_low = 695; cl_30_low = 1245;   gR_40_low = 745; cl_40_low = 1330;     gR_0_hig = 615; cl_0_hig = 1115;    gR_10_hig = 660; cl_10_hig = 1195;   gR_20_hig = 710; cl_20_hig = 1275;   gR_30_hig = 760; cl_30_hig = 1365;   gR_40_hig = 815; cl_40_hig = 1455;
        
        PAlevelShortfield = 2000;
   
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 615; cl_0_low = 1115;    gR_10_low = 660; cl_10_low = 1195;   gR_20_low = 710; cl_20_low = 1275;   gR_30_low = 760; cl_30_low = 1365;   gR_40_low = 815; cl_40_low = 1455;     gR_0_hig = 670; cl_0_hig = 1220;    gR_10_hig = 725; cl_10_hig = 1305;   gR_20_hig = 780; cl_20_hig = 1400;   gR_30_hig = 835; cl_30_hig = 1495;   gR_40_hig = 895; cl_40_hig = 1595;
        
        PAlevelShortfield = 3000;
        
       
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 670; cl_0_low = 1220;    gR_10_low = 725; cl_10_low = 1305;   gR_20_low = 780; cl_20_low = 1400;   gR_30_low = 835; cl_30_low = 1495;   gR_40_low = 895; cl_40_low = 1595;     gR_0_hig = 740; cl_0_hig = 1340;    gR_10_hig = 795; cl_10_hig = 1435;   gR_20_hig = 855; cl_20_hig = 1535;   gR_30_hig = 920; cl_30_hig = 1640;   gR_40_hig = 985; cl_40_hig = 1755;
        
        PAlevelShortfield = 4000;
             
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 740; cl_0_low = 1340;    gR_10_low = 795; cl_10_low = 1435;   gR_20_low = 855; cl_20_low = 1535;   gR_30_low = 920; cl_30_low = 1640;   gR_40_low = 985; cl_40_low = 1755;     gR_0_hig = 810; cl_0_hig = 1470;    gR_10_hig = 875; cl_10_hig = 1575;   gR_20_hig = 940; cl_20_hig = 1690;   gR_30_hig = 1010; cl_30_hig = 1810;   gR_40_hig = 1085; cl_40_hig = 1940;
        
        PAlevelShortfield = 5000;
        

        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 810; cl_0_low = 1470;    gR_10_low = 875; cl_10_low = 1575;   gR_20_low = 940; cl_20_low = 1690;   gR_30_low = 1010; cl_30_low = 1810;   gR_40_low = 1085; cl_40_low = 1940;     gR_0_hig = 895; cl_0_hig = 1620;    gR_10_hig = 965; cl_10_hig = 1740;   gR_20_hig = 1035; cl_20_hig = 1865;   gR_30_hig = 1115; cl_30_hig = 2000;   gR_40_hig = 1195; cl_40_hig = 2145;
        
        PAlevelShortfield = 6000;

        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 895; cl_0_low = 1620;    gR_10_low = 965; cl_10_low = 1740;   gR_20_low = 1035; cl_20_low = 1865;   gR_30_low = 1115; cl_30_low = 2000;   gR_40_low = 1195; cl_40_low = 2145;     gR_0_hig = 985; cl_0_hig = 1790;    gR_10_hig = 1065; cl_10_hig = 1925;   gR_20_hig = 1145; cl_20_hig = 2065;   gR_30_hig = 1230; cl_30_hig = 2220;   gR_40_hig = 1320; cl_40_hig = 2385;
        
        PAlevelShortfield = 7000;
        

        
    } // end if  
    
    
    
    
    // interpolate ground roll
    [self shortfield2200C172_interpolation];   
    
    
    
    
    
    return;
    
}
- (void) shortfieldC172N_2400 { // middle
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 585; cl_0_low = 1070;    gR_10_low = 630; cl_10_low = 1140;   gR_20_low = 680; cl_20_low = 1220;   gR_30_low = 725; cl_30_low = 1300;   gR_40_low = 780; cl_40_low = 1390;     gR_0_hig = 640; cl_0_hig = 1165;    gR_10_hig = 690; cl_10_hig = 1245;   gR_20_hig = 740; cl_20_hig = 1330;   gR_30_hig = 795; cl_30_hig = 1420;   gR_40_hig = 850; cl_40_hig = 1520;
        
        PAlevelShortfield = 0;
        
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 640; cl_0_low = 1165;    gR_10_low = 690; cl_10_low = 1245;   gR_20_low = 740; cl_20_low = 1330;   gR_30_low = 795; cl_30_low = 1420;   gR_40_low = 850; cl_40_low = 1520;   gR_0_hig = 700; cl_0_hig = 1270;    gR_10_hig = 755; cl_10_hig = 1360;   gR_20_hig = 810; cl_20_hig = 1455;   gR_30_hig = 870; cl_30_hig = 1555;   gR_40_hig = 935; cl_40_hig = 1665;

        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 700; cl_0_low = 1270;    gR_10_low = 755; cl_10_low = 1360;   gR_20_low = 810; cl_20_low = 1455;   gR_30_low = 870; cl_30_low = 1555;   gR_40_low = 935; cl_40_low = 1665;   gR_0_hig = 770; cl_0_hig = 1390;    gR_10_hig = 830; cl_10_hig = 1490;   gR_20_hig = 890; cl_20_hig = 1595;   gR_30_hig = 955; cl_30_hig = 1710;   gR_40_hig = 1025; cl_40_hig = 1830;
        
        PAlevelShortfield = 2000;
   
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 770; cl_0_low = 1390;    gR_10_low = 830; cl_10_low = 1490;   gR_20_low = 890; cl_20_low = 1595;   gR_30_low = 955; cl_30_low = 1710;   gR_40_low = 1025; cl_40_low = 1830;   gR_0_hig = 845; cl_0_hig = 1525;    gR_10_hig = 910; cl_10_hig = 1640;   gR_20_hig = 980; cl_20_hig = 1755;   gR_30_hig = 1050; cl_30_hig = 1880;   gR_40_hig = 1130; cl_40_hig = 2015;
        
        PAlevelShortfield = 3000;
       
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 845; cl_0_low = 1525;    gR_10_low = 910; cl_10_low = 1640;   gR_20_low = 980; cl_20_low = 1755;   gR_30_low = 1050; cl_30_low = 1880;   gR_40_low = 1130; cl_40_low = 2015;   gR_0_hig = 930; cl_0_hig = 1680;    gR_10_hig = 1000; cl_10_hig = 1805;   gR_20_hig = 1075; cl_20_hig = 1935;   gR_30_hig = 1155; cl_30_hig = 2075;   gR_40_hig = 1240; cl_40_hig = 2230;
        
        PAlevelShortfield = 4000;
        
      
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 930; cl_0_low = 1680;    gR_10_low = 1000; cl_10_low = 1805;   gR_20_low = 1075; cl_20_low = 1935;   gR_30_low = 1155; cl_30_low = 2075;   gR_40_low = 1240; cl_40_low = 2230;   gR_0_hig = 1025; cl_0_hig = 1850;    gR_10_hig = 1100; cl_10_hig = 1990;   gR_20_hig = 1185; cl_20_hig = 2140;   gR_30_hig = 1275; cl_30_hig = 2300;   gR_40_hig = 1370; cl_40_hig = 2475;
        
        PAlevelShortfield = 5000;
   
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1025; cl_0_low = 1850;    gR_10_low = 1100; cl_10_low = 1990;   gR_20_low = 1185; cl_20_low = 2140;   gR_30_low = 1275; cl_30_low = 2300;   gR_40_low = 1370; cl_40_low = 2475;   gR_0_hig = 1130; cl_0_hig = 2050;    gR_10_hig = 1215; cl_10_hig = 2210;   gR_20_hig = 1310; cl_20_hig = 2380;   gR_30_hig = 1410; cl_30_hig = 2560;   gR_40_hig = 1515; cl_40_hig = 2755;
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
 
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1130; cl_0_low = 2050;    gR_10_low = 1215; cl_10_low = 2210;   gR_20_low = 1310; cl_20_low = 2380;   gR_30_low = 1410; cl_30_low = 2560;   gR_40_low = 1515; cl_40_low = 2755;   gR_0_hig = 1245; cl_0_hig = 2275;    gR_10_hig = 1345; cl_10_hig = 2460;   gR_20_hig = 1450; cl_20_hig = 2655;   gR_30_hig = 1560; cl_30_hig = 2865;   gR_40_hig = 1680; cl_40_hig = 3090;
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        

        
        
    } // end if  
    
    
    
    
    // interpolate ground roll
    
    [self shortfield2400C172_interpolation];      
    
    return;
    
} // end void
- (void) shortfieldC172N_2550 { // high
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 720; cl_0_low = 1300;    gR_10_low = 775; cl_10_low = 1390;   gR_20_low = 835; cl_20_low = 1490;   gR_30_low = 895; cl_30_low = 1590;   gR_40_low = 960; cl_40_low = 1700;   gR_0_hig = 790; cl_0_hig = 1420;    gR_10_hig = 850; cl_10_hig = 1525;   gR_20_hig = 915; cl_20_hig = 1630;   gR_30_hig = 980; cl_30_hig = 1745;   gR_40_hig = 1050; cl_40_hig = 1865;
        PAlevelShortfield = 0;
        
       
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 790; cl_0_low = 1420;    gR_10_low = 850; cl_10_low = 1525;   gR_20_low = 915; cl_20_low = 1630;   gR_30_low = 980; cl_30_low = 1745;   gR_40_low = 1050; cl_40_low = 1865;   gR_0_hig = 865; cl_0_hig = 1555;    gR_10_hig = 930; cl_10_hig = 1670;   gR_20_hig = 1000; cl_20_hig = 1790;   gR_30_hig = 1075; cl_30_hig = 1915;   gR_40_hig = 1155; cl_40_hig = 2055;
        
        PAlevelShortfield = 1000;
    
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 865; cl_0_low = 1555;    gR_10_low = 930; cl_10_low = 1670;   gR_20_low = 1000; cl_20_low = 1790;   gR_30_low = 1075; cl_30_low = 1915;   gR_40_low = 1155; cl_40_low = 2055;   gR_0_hig = 950; cl_0_hig = 1710;    gR_10_hig = 1025; cl_10_hig = 1835;   gR_20_hig = 1100; cl_20_hig = 1970;   gR_30_hig = 1185; cl_30_hig = 2115;   gR_40_hig = 1270; cl_40_hig = 2265;
        
        PAlevelShortfield = 2000;
        
      
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 950; cl_0_low = 1710;    gR_10_low = 1025; cl_10_low = 1835;   gR_20_low = 1100; cl_20_low = 1970;   gR_30_low = 1185; cl_30_low = 2115;   gR_40_low = 1270; cl_40_low = 2265;   gR_0_hig = 1045; cl_0_hig = 1880;    gR_10_hig = 1125; cl_10_hig = 2025;   gR_20_hig = 1210; cl_20_hig = 2175;   gR_30_hig = 1300; cl_30_hig = 2335;   gR_40_hig = 1400; cl_40_hig = 2510;
        
        PAlevelShortfield = 3000;
        
            
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1045; cl_0_low = 1880;    gR_10_low = 1125; cl_10_low = 2025;   gR_20_low = 1210; cl_20_low = 2175;   gR_30_low = 1300; cl_30_low = 2335;   gR_40_low = 1400; cl_40_low = 2510;   gR_0_hig = 1150; cl_0_hig = 2075;    gR_10_hig = 1240; cl_10_hig = 2240;   gR_20_hig = 1335; cl_20_hig = 2410;   gR_30_hig = 1435; cl_30_hig = 2595;   gR_40_hig = 1540; cl_40_hig = 2795;
        
        PAlevelShortfield = 4000;
        
     
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1150; cl_0_low = 2075;    gR_10_low = 1240; cl_10_low = 2240;   gR_20_low = 1335; cl_20_low = 2410;   gR_30_low = 1435; cl_30_low = 2595;   gR_40_low = 1540; cl_40_low = 2795;   gR_0_hig = 1265; cl_0_hig = 2305;    gR_10_hig = 1365; cl_10_hig = 2485;   gR_20_hig = 1475; cl_20_hig = 2680;   gR_30_hig = 1585; cl_30_hig = 2895;   gR_40_hig = 1705; cl_40_hig = 3125;
        
        PAlevelShortfield = 5000;
    
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1265; cl_0_low = 2305;    gR_10_low = 1365; cl_10_low = 2485;   gR_20_low = 1475; cl_20_low = 2680;   gR_30_low = 1585; cl_30_low = 2895;   gR_40_low = 1705; cl_40_low = 3125;   gR_0_hig = 1400; cl_0_hig = 2565;    gR_10_hig = 1510; cl_10_hig = 2770;   gR_20_hig = 1630; cl_20_hig = 3000;   gR_30_hig = 1755; cl_30_hig = 3245;   gR_40_hig = 1890; cl_40_hig = 3515;
        
        PAlevelShortfield = 6000;
        
     
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1400; cl_0_low = 2565;    gR_10_low = 1510; cl_10_low = 2770;   gR_20_low = 1630; cl_20_low = 3000;   gR_30_low = 1755; cl_30_low = 3245;   gR_40_low = 1890; cl_40_low = 3515;   gR_0_hig = 1550; cl_0_hig = 2870;    gR_10_hig = 1675; cl_10_hig = 3110;   gR_20_hig = 1805; cl_20_hig = 3375;   gR_30_hig = 1945; cl_30_hig = 3670;   gR_40_hig = 2095; cl_40_hig = 3990;         
        PAlevelShortfield = 7000;
        
      
        
        
    } // end if  
    
    
    [self shortfield2550C172_interpolation];
    
    
    return;
    
} // end void
- (void) shortfiedlC172NInterpolationToACWEight {
    
    
    if (ACweightLBS >= 1900 & ACweightLBS < 2100) {  // 
        GroundRolltoWeight = GrndRollShortField_interpolated + ( ( (GrndRollShortField_interpolated2400 - GrndRollShortField_interpolated)/200 ) * (ACweightLBS-1900)) ;
        
        totalToClear = ObstClearance_interpolated + ( ( (ObstClearance_interpolated2400 - ObstClearance_interpolated)/200 ) * (ACweightLBS-1900));        
        liftoffspeed = 47 +  ( 0.0125 * (ACweightLBS-1900));
        
    } 
    
    
    
    if (ACweightLBS >= 2100 & ACweightLBS <= 2300) {
        GroundRolltoWeight = GrndRollShortField_interpolated2400 + ( ( (GrndRollShortField_interpolated2550 - GrndRollShortField_interpolated2400)/200 ) * (ACweightLBS-2100))  ;
        totalToClear = ObstClearance_interpolated2400 + ( ( (ObstClearance_interpolated2550 - ObstClearance_interpolated2400)/200 ) * (ACweightLBS-2100)) ;        
        liftoffspeed = 47 +  ( 0.0125 * (ACweightLBS-1900));
    } 
    
    
}
- (void) setRPMsliderValuesC172N {
    
    
    if (PressureAltitude >= 0 & PressureAltitude < 4000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2550;
    }
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2600;
        
      
        
    }
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000 ) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2650;
        
        
     
    }
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2700;
        
       
    }
    
    if (PressureAltitude >= 10000 & PressureAltitude < 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2700;
        
        
    }
    
    if (PressureAltitude >= 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2650;
        
       
    }
    
    
    resultRPMmin = sliderRPMmin;
    resultRPMmax = sliderRPMmax;
    
    
}
- (void) shortfield_LandingC172N {
    
    
   
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_lowLD = 495; cl_0_lowLD = 1205;    gR_10_lowLD = 510; cl_10_lowLD = 1235;   gR_20_lowLD = 530; cl_20_lowLD = 1265;   gR_30_lowLD = 545; cl_30_lowLD = 1295;   gR_40_lowLD = 565; cl_40_lowLD = 1330;   gR_0_higLD = 510; cl_0_higLD = 1235;    gR_10_higLD = 530; cl_10_higLD = 1265;   gR_20_higLD = 550; cl_20_higLD = 1300;   gR_30_higLD = 565; cl_30_higLD = 1330;   gR_40_higLD = 585; cl_40_higLD = 1365; 
        
        
        PAlevelShortfieldLD = 0;
        
       
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_lowLD = 510; cl_0_lowLD = 1235;    gR_10_lowLD = 530; cl_10_lowLD = 1265;   gR_20_lowLD = 550; cl_20_lowLD = 1300;   gR_30_lowLD = 565; cl_30_lowLD = 1330;   gR_40_lowLD = 585; cl_40_lowLD = 1365;   
        gR_0_higLD = 530; cl_0_higLD = 1265;    gR_10_higLD = 550; cl_10_higLD = 1300;   gR_20_higLD = 570; cl_20_higLD = 1335;   gR_30_higLD = 590; cl_30_higLD = 1370;   gR_40_higLD = 610; cl_40_higLD = 1405;         
        PAlevelShortfieldLD = 1000;
       
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_lowLD = 530; cl_0_lowLD = 1265;    gR_10_lowLD = 550; cl_10_lowLD = 1300;   gR_20_lowLD = 570; cl_20_lowLD = 1335;   gR_30_lowLD = 590; cl_30_lowLD = 1370;   gR_40_lowLD = 610; cl_40_lowLD = 1405;   
        gR_0_higLD = 550; cl_0_higLD = 1300;    gR_10_higLD = 570; cl_10_higLD = 1335;   gR_20_higLD = 590; cl_20_higLD = 1370;   gR_30_higLD = 610; cl_30_higLD = 1405;   gR_40_higLD = 630; cl_40_higLD = 1440; 
        
        PAlevelShortfieldLD = 2000;
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_lowLD = 550; cl_0_lowLD = 1300;    gR_10_lowLD = 570; cl_10_lowLD = 1335;   gR_20_lowLD = 590; cl_20_lowLD = 1370;   gR_30_lowLD = 610; cl_30_lowLD = 1405;   gR_40_lowLD = 630; cl_40_lowLD = 1440;   
        gR_0_higLD = 570; cl_0_higLD = 1335;    gR_10_higLD = 590; cl_10_higLD = 1370;   gR_20_higLD = 615; cl_20_higLD = 1410;   gR_30_higLD = 635; cl_30_higLD = 1445;   gR_40_higLD = 655; cl_40_higLD = 1480;         
        PAlevelShortfieldLD = 3000;
       
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_lowLD = 570; cl_0_lowLD = 1335;    gR_10_lowLD = 590; cl_10_lowLD = 1370;   gR_20_lowLD = 615; cl_20_lowLD = 1410;   gR_30_lowLD = 635; cl_30_lowLD = 1445;   gR_40_lowLD = 655; cl_40_lowLD = 1480;   
        gR_0_higLD = 590; cl_0_higLD = 1370;    gR_10_higLD = 615; cl_10_higLD = 1415;   gR_20_higLD = 635; cl_20_higLD = 1450;   gR_30_higLD = 655; cl_30_higLD = 1485;   gR_40_higLD = 680; cl_40_higLD = 1525; 
        
        PAlevelShortfieldLD = 4000;
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_lowLD = 590; cl_0_lowLD = 1370;    gR_10_lowLD = 615; cl_10_lowLD = 1415;   gR_20_lowLD = 635; cl_20_lowLD = 1450;   gR_30_lowLD = 655; cl_30_lowLD = 1485;   gR_40_lowLD = 680; cl_40_lowLD = 1525;   
        gR_0_higLD = 615; cl_0_higLD = 1415;    gR_10_higLD = 640; cl_10_higLD = 1455;   gR_20_higLD = 660; cl_20_higLD = 1490;   gR_30_higLD = 685; cl_30_higLD = 1535;   gR_40_higLD = 705; cl_40_higLD = 1570; 
        
        PAlevelShortfieldLD = 5000;
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 615; cl_0_lowLD = 1415;    gR_10_lowLD = 640; cl_10_lowLD = 1455;   gR_20_lowLD = 660; cl_20_lowLD = 1490;   gR_30_lowLD = 685; cl_30_lowLD = 1535;   gR_40_lowLD = 705; cl_40_lowLD = 1570;   
        gR_0_higLD = 640; cl_0_higLD = 1455;    gR_10_higLD = 660; cl_10_higLD = 1495;   gR_20_higLD = 685; cl_20_higLD = 1535;   gR_30_higLD = 710; cl_30_higLD = 1575;   gR_40_higLD = 730; cl_40_higLD = 1615; 
        
        PAlevelShortfieldLD = 6000;
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 640; cl_0_lowLD = 1455;    gR_10_lowLD = 660; cl_10_lowLD = 1495;   gR_20_lowLD = 685; cl_20_lowLD = 1535;   gR_30_lowLD = 710; cl_30_lowLD = 1575;   gR_40_lowLD = 730; cl_40_lowLD = 1615;   
        gR_0_higLD = 665; cl_0_higLD = 1500;    gR_10_higLD = 690; cl_10_higLD = 1540;   gR_20_higLD = 710; cl_20_higLD = 1580;   gR_30_higLD = 735; cl_30_higLD = 1620;   gR_40_higLD = 760; cl_40_higLD = 1665; 
        
        PAlevelShortfieldLD = 7000;
        
    } // end if  
    
    
    return;
    
} 
- (void) shortfieldLandingC172_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_1LandingLD = gR_0_lowLD + ( (gR_0_higLD -  gR_0_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_10_lowLD + ( (gR_10_higLD -  gR_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD -  GrndRollShortField_1LandingLD) / 10) * (sliderOATvalue));
        
        
        ObstClearance_1LandingLD = cl_0_lowLD + ( (cl_0_higLD -  cl_0_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_10_lowLD + ( (cl_10_higLD -  cl_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 10) * (sliderOATvalue));
        
        
    }  
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 20) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_1LandingLD = gR_10_lowLD + ( (gR_10_higLD -  gR_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_20_lowLD + ( (gR_20_higLD -  gR_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD -  GrndRollShortField_1LandingLD) / 10) * (sliderOATvalue -10 ));
        
        
        ObstClearance_1LandingLD = cl_10_lowLD + ( (cl_10_higLD -  cl_10_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_20_lowLD + ( (cl_20_higLD -  cl_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 10) * (sliderOATvalue -10 ));
        
        
        
    } 
    
    
    if (sliderOATvalue >= 20 & sliderOATvalue < 30) {
        
        GrndRollShortField_1LandingLD = gR_20_lowLD + ( (gR_20_higLD -  gR_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_30_lowLD + ( (gR_30_higLD -  gR_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD-  GrndRollShortField_1LandingLD) / 10) * (sliderOATvalue -20 ));
        
        
        ObstClearance_1LandingLD = cl_20_lowLD + ( (cl_20_higLD -  cl_20_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_30_lowLD + ( (cl_30_higLD -  cl_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 10) * (sliderOATvalue -20 ));
        
        
    } 
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_1LandingLD = gR_30_lowLD + ( (gR_30_higLD -  gR_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_2LandingLD = gR_40_lowLD + ( (gR_40_higLD -  gR_40_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        GrndRollShortField_interpolatedLandingLD =  GrndRollShortField_1LandingLD + (((GrndRollShortField_2LandingLD -  GrndRollShortField_1LandingLD) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_1LandingLD = cl_30_lowLD + ( (cl_30_higLD -  cl_30_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_2LandingLD = cl_40_lowLD + ( (cl_40_higLD -  cl_40_lowLD) / 1000 ) * (PressureAltitude - PAlevelShortfieldLD);
        
        ObstClearance_interpolatedLandingLD = ObstClearance_1LandingLD + (((ObstClearance_2LandingLD -  ObstClearance_1LandingLD) / 10) * (sliderOATvalue -30 ));
        
        
        
    } 
    
    
    
    
    return;
    
    
    
}
- (void) calculate_ClimbC172N {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {
        
        climb_low2  = 73; RoC_low2   = 770; time_low2   = 0; fuel_low2   = 0;    distNM_low2   = 0; 
        climb_high2 = 73; RoC_high2  = 725; time_high2  = 1; fuel_high2  = 0.3;    distNM_high2   = 2; PAlevel2 = 0;
        
        
        
    }
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        climb_low2  = 73; RoC_low2   = 725; time_low2   = 1; fuel_low2   = 0.3;    distNM_low2   = 2; PAlevel2 = 1000;   
        climb_high2 = 72; RoC_high2  = 675; time_high2  = 3; fuel_high2  = 0.6;    distNM_high2   = 3; PAlevel2 = 1000;
        
        
    }
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        climb_low2  = 72; RoC_low2   = 675; time_low2   = 3; fuel_low2   = 0.6;    distNM_low2   = 3; PAlevel2 = 2000;   
        climb_high2 = 72; RoC_high2  = 630; time_high2  = 4; fuel_high2  = 0.9;    distNM_high2   = 5; PAlevel2 = 2000;
        
        
    }
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        climb_low2  = 72; RoC_low2   = 630; time_low2   = 4; fuel_low2   = 0.9;    distNM_low2   = 5; PAlevel2 = 3000;   
        climb_high2 = 71; RoC_high2  = 580; time_high2  = 6; fuel_high2  = 1.2;    distNM_high2   = 8; PAlevel2 = 3000;
        
        
    }
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        climb_low2  = 71; RoC_low2   = 580; time_low2   = 6; fuel_low2   = 1.2;    distNM_low2   = 8; PAlevel2 = 4000;   
        climb_high2 = 71; RoC_high2  = 535; time_high2  = 8; fuel_high2  = 1.6;    distNM_high2   = 10; PAlevel2 = 4000;
        
        
    }
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        climb_low2  = 71; RoC_low2   = 535; time_low2   = 8; fuel_low2   = 1.6;    distNM_low2   = 10; PAlevel2 = 5000;   
        climb_high2 = 70; RoC_high2  = 485; time_high2  = 10; fuel_high2  = 1.9;    distNM_high2   = 12; PAlevel2 = 5000;
        
    }
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        climb_low2  = 70; RoC_low2   = 485; time_low2   = 10; fuel_low2   = 1.9;    distNM_low2   = 12; PAlevel2 = 6000;   
        climb_high2 = 69; RoC_high2  = 440; time_high2  = 12; fuel_high2  = 2.3;    distNM_high2   = 15; PAlevel2 = 6000;
        
    }
    
    if (PressureAltitude >=7000 & PressureAltitude < 8000) {
        
        climb_low2  = 69; RoC_low2   = 440; time_low2   = 12; fuel_low2   = 2.3;    distNM_low2   = 15; PAlevel2 = 7000;   
        climb_high2 = 69; RoC_high2  = 390; time_high2  = 15; fuel_high2  = 2.7;    distNM_high2   = 19; PAlevel2 = 7000;
        
        
    }
    
    if (PressureAltitude >=8000 & PressureAltitude < 9000) {
        
        climb_low2  = 69; RoC_low2   = 390; time_low2   = 15; fuel_low2   = 2.7;    distNM_low2   = 19; PAlevel2 = 8000;   
        climb_high2 = 68; RoC_high2  = 345; time_high2  = 17; fuel_high2  = 3.2;    distNM_high2   = 22; PAlevel2 = 8000;
        
        
    }
    
    
    if (PressureAltitude >=9000 & PressureAltitude < 10000) {
        
        climb_low2  = 68; RoC_low2   = 345; time_low2   = 17; fuel_low2   = 3.2;    distNM_low2   = 22; PAlevel2 = 9000;   
        climb_high2 = 68; RoC_high2  = 295; time_high2  = 21; fuel_high2  = 3.7;    distNM_high2   = 27; PAlevel2 = 9000;        
        
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 11000) {
        
        climb_low2  = 68; RoC_low2   = 295; time_low2   = 21; fuel_low2   = 3.7;    distNM_low2   = 27; PAlevel2 = 10000;   
        climb_high2 = 67; RoC_high2  = 250; time_high2  = 24; fuel_high2  = 4.2;    distNM_high2   = 32; PAlevel2 = 10000;
        
        
    }
    
    if (PressureAltitude >=11000 & PressureAltitude < 12000) {
        
        climb_low2  = 67; RoC_low2   = 250; time_low2   = 24; fuel_low2   = 4.2;    distNM_low2   = 32; PAlevel2 = 11000;   
        climb_high2 = 67; RoC_high2  = 200; time_high2  = 29; fuel_high2  = 4.9;    distNM_high2   = 38; PAlevel2 = 11000;
        
    }
    
    
    if (PressureAltitude >=12000 ) {
        
        climb_low2  = 67; RoC_low2   = 200; time_low2   = 29; fuel_low2   = 4.9;    distNM_low2   = 38; PAlevel2 = 12000;   
        climb_high2 = 67; RoC_high2  = 200; time_high2  = 29; fuel_high2  = 4.9;    distNM_high2   = 38; PAlevel2 = 12000;
        
        
    }
    
    
    [self interpolateClimbC172S];
}
- (void) InterpolateCruiseValuesC172N {
    
    
    RPM = engineRPMcruise;
    
    // define RPM  high and low
    
    
    
    
    
    
    // define RPM  high and low
    
    if (RPM >= 2100 & RPM < 2200) {
        RPM_LOW = 2100; RPM_HIGH = 2200;
    }
    
    if (RPM >= 2200 & RPM < 2300) {
        RPM_LOW = 2200; RPM_HIGH = 2300;
    }
    
    if (RPM >= 2300 & RPM < 2400) {
        RPM_LOW = 2300; RPM_HIGH = 2400;
    }
    
    if (RPM >= 2400 & RPM < 2500) {
        RPM_LOW = 2400; RPM_HIGH = 2500;
    }
    
    if (RPM >= 2500 & RPM < 2600) {
        RPM_LOW = 2500; RPM_HIGH = 2600;
    }
    
    if (RPM >= 2600 & RPM <= 2700) {
        RPM_LOW = 2600; RPM_HIGH = 2700;
    }
    
    if (RPM >= 2600 & RPM <= 2700 & PressureAltitude > 11999) {
        RPM_LOW = 2600; RPM_HIGH = 2650;
    }
    
    
    
    //NSLog (@"RPM_LOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_LOW]);    
    //NSLog (@"RPM_HIGH %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_HIGH]);
    
    
    
    // get RPM
    
    if (PressureAltitude < 2001) {
        PressureAltitude = 2001;
    }
    
    if (PressureAltitude > 11999) {
        PressureAltitude = 12000;
    }
    
    
    if (PressureAltitude >= 2000 & PressureAltitude < 4000) {
        
        PressAltAbzug = 2000;
        
        
        //NSLog (@"Hello 2000");
        
        
        if (RPM == 2650) {M20_BHP_DWN = 0;  M20_KTAS_DWN = 0;  M20_GPH_DWN = 0;   STD_BHP_DWN = 0;  STD_KTAS_DWN = 0;  STD_GPH_DWN = 0;   P20_BHP_DWN = 0;  P20_KTAS_DWN = 0;  P20_GPH_DWN = 0;M20_BHP_UPP = 0;  M20_KTAS_UPP = 0;  M20_GPH_UPP = 0;   STD_BHP_UPP = 0;  STD_KTAS_UPP = 0;  STD_GPH_UPP = 0;   P20_BHP_UPP = 0;  P20_KTAS_UPP = 0;  P20_GPH_UPP = 0; }
        if (RPM == 2600) {M20_BHP_DWN = 0;  M20_KTAS_DWN = 0;  M20_GPH_DWN = 0;   STD_BHP_DWN = 0;  STD_KTAS_DWN = 0;  STD_GPH_DWN = 0;   P20_BHP_DWN = 0;  P20_KTAS_DWN = 0;  P20_GPH_DWN = 0;M20_BHP_UPP = 76;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.5;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 8.4;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 7.9; }
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 116;  STD_GPH_DWN = 8.4;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 7.9;M20_BHP_UPP = 76;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.5;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 115;  STD_GPH_UPP = 8;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.5; }
        if (RPM == 2400) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 8;   STD_BHP_DWN = 67;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 7.5;   P20_BHP_DWN = 63;  P20_KTAS_DWN = 110;  P20_GPH_DWN = 7.1;M20_BHP_UPP = 68;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 7.6;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 110;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 6.7; }
        if (RPM == 2300) {M20_BHP_DWN = 64;  M20_KTAS_DWN = 106;  M20_GPH_DWN = 7.1;   STD_BHP_DWN = 60;  STD_KTAS_DWN = 105;  STD_GPH_DWN = 6.7;   P20_BHP_DWN = 56;  P20_KTAS_DWN = 105;  P20_GPH_DWN = 6.3;M20_BHP_UPP = 60;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 6.8;   STD_BHP_UPP = 57;  STD_KTAS_UPP = 105;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 104;  P20_GPH_UPP = 6.1; }
        if (RPM == 2200) {M20_BHP_DWN = 56;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 6.3;   STD_BHP_DWN = 53;  STD_KTAS_DWN = 100;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 50;  P20_KTAS_DWN = 99;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 54;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 99;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 48;  P20_KTAS_UPP = 98;  P20_GPH_UPP = 5.7; }
        if (RPM == 2100) {M20_BHP_DWN = 50;  M20_KTAS_DWN = 95;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 47;  STD_KTAS_DWN = 94;  STD_GPH_DWN = 5.6;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 93;  P20_GPH_DWN = 5.4;M20_BHP_UPP = 48;  M20_KTAS_UPP = 94;  M20_GPH_UPP = 5.6;   STD_BHP_UPP = 46;  STD_KTAS_UPP = 93;  STD_GPH_UPP = 5.5;   P20_BHP_UPP = 44;  P20_KTAS_UPP = 92;  P20_GPH_UPP = 5.3; }       
        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 0;  M20_KTAS_DWN2 = 0;  M20_GPH_DWN2 = 0;   STD_BHP_DWN2 = 0;  STD_KTAS_DWN2 = 0;  STD_GPH_DWN2 = 0;   P20_BHP_DWN2 = 0;  P20_KTAS_DWN2 = 0;  P20_GPH_DWN2 = 0;M20_BHP_UPP2 = 0;  M20_KTAS_UPP2 = 0;  M20_GPH_UPP2 = 0;   STD_BHP_UPP2 = 0;  STD_KTAS_UPP2 = 0;  STD_GPH_UPP2 = 0;   P20_BHP_UPP2 = 0;  P20_KTAS_UPP2 = 0;  P20_GPH_UPP2 = 0; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 0;  M20_KTAS_DWN2 = 0;  M20_GPH_DWN2 = 0;   STD_BHP_DWN2 = 0;  STD_KTAS_DWN2 = 0;  STD_GPH_DWN2 = 0;   P20_BHP_DWN2 = 0;  P20_KTAS_DWN2 = 0;  P20_GPH_DWN2 = 0;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.5;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 8.4;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 7.9; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 116;  STD_GPH_DWN2 = 8.4;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 7.9;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.5;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 115;  STD_GPH_UPP2 = 8;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.5; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 8;   STD_BHP_DWN2 = 67;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 7.5;   P20_BHP_DWN2 = 63;  P20_KTAS_DWN2 = 110;  P20_GPH_DWN2 = 7.1;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 7.6;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 110;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 6.7; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 64;  M20_KTAS_DWN2 = 106;  M20_GPH_DWN2 = 7.1;   STD_BHP_DWN2 = 60;  STD_KTAS_DWN2 = 105;  STD_GPH_DWN2 = 6.7;   P20_BHP_DWN2 = 56;  P20_KTAS_DWN2 = 105;  P20_GPH_DWN2 = 6.3;M20_BHP_UPP2 = 60;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 6.8;   STD_BHP_UPP2 = 57;  STD_KTAS_UPP2 = 105;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 104;  P20_GPH_UPP2 = 6.1; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 56;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 6.3;   STD_BHP_DWN2 = 53;  STD_KTAS_DWN2 = 100;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 50;  P20_KTAS_DWN2 = 99;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 54;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 99;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 48;  P20_KTAS_UPP2 = 98;  P20_GPH_UPP2 = 5.7; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 50;  M20_KTAS_DWN2 = 95;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 47;  STD_KTAS_DWN2 = 94;  STD_GPH_DWN2 = 5.6;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 93;  P20_GPH_DWN2 = 5.4;M20_BHP_UPP2 = 48;  M20_KTAS_UPP2 = 94;  M20_GPH_UPP2 = 5.6;   STD_BHP_UPP2 = 46;  STD_KTAS_UPP2 = 93;  STD_GPH_UPP2 = 5.5;   P20_BHP_UPP2 = 44;  P20_KTAS_UPP2 = 92;  P20_GPH_UPP2 = 5.3; }   
        
        
        
        
    } // end if Pressue Alt zwischen 2000 und 4000
    
    
    
    
    
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        
        PressAltAbzug = 4000;
        
        //NSLog (@"Hello 4000");
        
        if (RPM == 2650) {M20_BHP_DWN = 0;  M20_KTAS_DWN = 0;  M20_GPH_DWN = 0;   STD_BHP_DWN = 0;  STD_KTAS_DWN = 0;  STD_GPH_DWN = 0;   P20_BHP_DWN = 0;  P20_KTAS_DWN = 0;  P20_GPH_DWN = 0;M20_BHP_UPP = 0;  M20_KTAS_UPP = 0;  M20_GPH_UPP = 0;   STD_BHP_UPP = 0;  STD_KTAS_UPP = 0;  STD_GPH_UPP = 0;   P20_BHP_UPP = 0;  P20_KTAS_UPP = 0;  P20_GPH_UPP = 0; }
        if (RPM == 2600) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.5;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 8.4;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 7.9;M20_BHP_UPP = 72;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.1;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 8.4;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 120;  P20_GPH_UPP = 7.9; }
        if (RPM == 2500) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.5;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 8;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 7.5;M20_BHP_UPP = 72;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.1;   STD_BHP_UPP = 67;  STD_KTAS_UPP = 115;  STD_GPH_UPP = 7.6;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 114;  P20_GPH_UPP = 7.1; }
        if (RPM == 2400) {M20_BHP_DWN = 68;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 7.6;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 110;  STD_GPH_DWN = 7.1;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 6.7;M20_BHP_UPP = 64;  M20_KTAS_UPP = 110;  M20_GPH_UPP = 7.2;   STD_BHP_UPP = 60;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 6.8;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 6.4; }
        if (RPM == 2300) {M20_BHP_DWN = 60;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 6.8;   STD_BHP_DWN = 57;  STD_KTAS_DWN = 105;  STD_GPH_DWN = 6.4;   P20_BHP_DWN = 54;  P20_KTAS_DWN = 104;  P20_GPH_DWN = 6.1;M20_BHP_UPP = 57;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 6.5;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 104;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 52;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 5.9; }
        if (RPM == 2200) {M20_BHP_DWN = 54;  M20_KTAS_DWN = 100;  M20_GPH_DWN = 6.1;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 99;  STD_GPH_DWN = 5.9;   P20_BHP_DWN = 48;  P20_KTAS_DWN = 98;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 51;  M20_KTAS_UPP = 99;  M20_GPH_UPP = 5.9;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 98;  STD_GPH_UPP = 5.7;   P20_BHP_UPP = 47;  P20_KTAS_UPP = 97;  P20_GPH_UPP = 5.5; }
        if (RPM == 2100) {M20_BHP_DWN = 48;  M20_KTAS_DWN = 94;  M20_GPH_DWN = 5.6;   STD_BHP_DWN = 46;  STD_KTAS_DWN = 93;  STD_GPH_DWN = 5.5;   P20_BHP_DWN = 44;  P20_KTAS_DWN = 92;  P20_GPH_DWN = 5.3;M20_BHP_UPP = 46;  M20_KTAS_UPP = 93;  M20_GPH_UPP = 5.5;   STD_BHP_UPP = 44;  STD_KTAS_UPP = 92;  STD_GPH_UPP = 5.4;   P20_BHP_UPP = 42;  P20_KTAS_UPP = 91;  P20_GPH_UPP = 5.2; }    
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 0;  M20_KTAS_DWN2 = 0;  M20_GPH_DWN2 = 0;   STD_BHP_DWN2 = 0;  STD_KTAS_DWN2 = 0;  STD_GPH_DWN2 = 0;   P20_BHP_DWN2 = 0;  P20_KTAS_DWN2 = 0;  P20_GPH_DWN2 = 0;M20_BHP_UPP2 = 0;  M20_KTAS_UPP2 = 0;  M20_GPH_UPP2 = 0;   STD_BHP_UPP2 = 0;  STD_KTAS_UPP2 = 0;  STD_GPH_UPP2 = 0;   P20_BHP_UPP2 = 0;  P20_KTAS_UPP2 = 0;  P20_GPH_UPP2 = 0; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.5;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 8.4;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 7.9;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.1;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 8.4;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 120;  P20_GPH_UPP2 = 7.9; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.5;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 8;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 7.5;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.1;   STD_BHP_UPP2 = 67;  STD_KTAS_UPP2 = 115;  STD_GPH_UPP2 = 7.6;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 114;  P20_GPH_UPP2 = 7.1; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 68;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 7.6;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 110;  STD_GPH_DWN2 = 7.1;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 6.7;M20_BHP_UPP2 = 64;  M20_KTAS_UPP2 = 110;  M20_GPH_UPP2 = 7.2;   STD_BHP_UPP2 = 60;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 6.8;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 6.4; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 60;  M20_KTAS_DWN2 = 105;  M20_GPH_DWN2 = 6.8;   STD_BHP_DWN2 = 57;  STD_KTAS_DWN2 = 105;  STD_GPH_DWN2 = 6.4;   P20_BHP_DWN2 = 54;  P20_KTAS_DWN2 = 104;  P20_GPH_DWN2 = 6.1;M20_BHP_UPP2 = 57;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 6.5;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 104;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 52;  P20_KTAS_UPP2 = 103;  P20_GPH_UPP2 = 5.9; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 54;  M20_KTAS_DWN2 = 100;  M20_GPH_DWN2 = 6.1;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 99;  STD_GPH_DWN2 = 5.9;   P20_BHP_DWN2 = 48;  P20_KTAS_DWN2 = 98;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 51;  M20_KTAS_UPP2 = 99;  M20_GPH_UPP2 = 5.9;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 98;  STD_GPH_UPP2 = 5.7;   P20_BHP_UPP2 = 47;  P20_KTAS_UPP2 = 97;  P20_GPH_UPP2 = 5.5; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 48;  M20_KTAS_DWN2 = 94;  M20_GPH_DWN2 = 5.6;   STD_BHP_DWN2 = 46;  STD_KTAS_DWN2 = 93;  STD_GPH_DWN2 = 5.5;   P20_BHP_DWN2 = 44;  P20_KTAS_DWN2 = 92;  P20_GPH_DWN2 = 5.3;M20_BHP_UPP2 = 46;  M20_KTAS_UPP2 = 93;  M20_GPH_UPP2 = 5.5;   STD_BHP_UPP2 = 44;  STD_KTAS_UPP2 = 92;  STD_GPH_UPP2 = 5.4;   P20_BHP_UPP2 = 42;  P20_KTAS_UPP2 = 91;  P20_GPH_UPP2 = 5.2; }
        
        
        
    } // end if Pressue Alt zwischen 4000 und 6000
    
    
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000) {
        
        //NSLog (@"Hello 6000");
        
        PressAltAbzug = 6000;
        
        
        if (RPM == 2650) {M20_BHP_DWN = 0;  M20_KTAS_DWN = 0;  M20_GPH_DWN = 0;   STD_BHP_DWN = 0;  STD_KTAS_DWN = 0;  STD_GPH_DWN = 0;   P20_BHP_DWN = 0;  P20_KTAS_DWN = 0;  P20_GPH_DWN = 0;M20_BHP_UPP = 76;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 8.4;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 120;  P20_GPH_UPP = 7.9; }
        if (RPM == 2600) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 8.4;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 120;  P20_GPH_DWN = 7.9;M20_BHP_UPP = 76;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 8;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 119;  P20_GPH_UPP = 7.5; }
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 67;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 7.6;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 7.1;M20_BHP_UPP = 68;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 7.7;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 7.2;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 113;  P20_GPH_UPP = 6.8; }
        if (RPM == 2400) {M20_BHP_DWN = 64;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 7.2;   STD_BHP_DWN = 60;  STD_KTAS_DWN = 109;  STD_GPH_DWN = 6.8;   P20_BHP_DWN = 57;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 6.4;M20_BHP_UPP = 61;  M20_KTAS_UPP = 110;  M20_GPH_UPP = 6.9;   STD_BHP_UPP = 58;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 6.5;   P20_BHP_UPP = 55;  P20_KTAS_UPP = 108;  P20_GPH_UPP = 6.2; }
        if (RPM == 2300) {M20_BHP_DWN = 57;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 6.5;   STD_BHP_DWN = 54;  STD_KTAS_DWN = 104;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 52;  P20_KTAS_DWN = 103;  P20_GPH_DWN = 5.9;M20_BHP_UPP = 55;  M20_KTAS_UPP = 104;  M20_GPH_UPP = 6.2;   STD_BHP_UPP = 52;  STD_KTAS_UPP = 103;  STD_GPH_UPP = 6;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 102;  P20_GPH_UPP = 5.8; }
        if (RPM == 2200) {M20_BHP_DWN = 51;  M20_KTAS_DWN = 99;  M20_GPH_DWN = 5.9;   STD_BHP_DWN = 49;  STD_KTAS_DWN = 98;  STD_GPH_DWN = 5.7;   P20_BHP_DWN = 47;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 5.5;M20_BHP_UPP = 49;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 5.7;   STD_BHP_UPP = 47;  STD_KTAS_UPP = 97;  STD_GPH_UPP = 5.5;   P20_BHP_UPP = 45;  P20_KTAS_UPP = 96;  P20_GPH_UPP = 5.4; }
        if (RPM == 2100) {M20_BHP_DWN = 46;  M20_KTAS_DWN = 93;  M20_GPH_DWN = 5.5;   STD_BHP_DWN = 44;  STD_KTAS_DWN = 92;  STD_GPH_DWN = 5.4;   P20_BHP_DWN = 42;  P20_KTAS_DWN = 91;  P20_GPH_DWN = 5.2;M20_BHP_UPP = 0;  M20_KTAS_UPP = 0;  M20_GPH_UPP = 0;   STD_BHP_UPP = 0;  STD_KTAS_UPP = 0;  STD_GPH_UPP = 0;   P20_BHP_UPP = 0;  P20_KTAS_UPP = 0;  P20_GPH_UPP = 0; }        
        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 0;  M20_KTAS_DWN2 = 0;  M20_GPH_DWN2 = 0;   STD_BHP_DWN2 = 0;  STD_KTAS_DWN2 = 0;  STD_GPH_DWN2 = 0;   P20_BHP_DWN2 = 0;  P20_KTAS_DWN2 = 0;  P20_GPH_DWN2 = 0;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 8.4;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 120;  P20_GPH_UPP2 = 7.9; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 8.4;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 120;  P20_GPH_DWN2 = 7.9;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 8;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 119;  P20_GPH_UPP2 = 7.5; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 67;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 7.6;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 7.1;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 7.7;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 7.2;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 113;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 64;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 7.2;   STD_BHP_DWN2 = 60;  STD_KTAS_DWN2 = 109;  STD_GPH_DWN2 = 6.8;   P20_BHP_DWN2 = 57;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 6.4;M20_BHP_UPP2 = 61;  M20_KTAS_UPP2 = 110;  M20_GPH_UPP2 = 6.9;   STD_BHP_UPP2 = 58;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 6.5;   P20_BHP_UPP2 = 55;  P20_KTAS_UPP2 = 108;  P20_GPH_UPP2 = 6.2; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 57;  M20_KTAS_DWN2 = 105;  M20_GPH_DWN2 = 6.5;   STD_BHP_DWN2 = 54;  STD_KTAS_DWN2 = 104;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 52;  P20_KTAS_DWN2 = 103;  P20_GPH_DWN2 = 5.9;M20_BHP_UPP2 = 55;  M20_KTAS_UPP2 = 104;  M20_GPH_UPP2 = 6.2;   STD_BHP_UPP2 = 52;  STD_KTAS_UPP2 = 103;  STD_GPH_UPP2 = 6;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 102;  P20_GPH_UPP2 = 5.8; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 51;  M20_KTAS_DWN2 = 99;  M20_GPH_DWN2 = 5.9;   STD_BHP_DWN2 = 49;  STD_KTAS_DWN2 = 98;  STD_GPH_DWN2 = 5.7;   P20_BHP_DWN2 = 47;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 5.5;M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 5.7;   STD_BHP_UPP2 = 47;  STD_KTAS_UPP2 = 97;  STD_GPH_UPP2 = 5.5;   P20_BHP_UPP2 = 45;  P20_KTAS_UPP2 = 96;  P20_GPH_UPP2 = 5.4; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 46;  M20_KTAS_DWN2 = 93;  M20_GPH_DWN2 = 5.5;   STD_BHP_DWN2 = 44;  STD_KTAS_DWN2 = 92;  STD_GPH_DWN2 = 5.4;   P20_BHP_DWN2 = 42;  P20_KTAS_DWN2 = 91;  P20_GPH_DWN2 = 5.2;M20_BHP_UPP2 = 0;  M20_KTAS_UPP2 = 0;  M20_GPH_UPP2 = 0;   STD_BHP_UPP2 = 0;  STD_KTAS_UPP2 = 0;  STD_GPH_UPP2 = 0;   P20_BHP_UPP2 = 0;  P20_KTAS_UPP2 = 0;  P20_GPH_UPP2 = 0; }
        
        
        
        
    } // end if Pressue Alt zwischen 6000 und 8000
    
    
    
    
    
    
    
    
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        
        //NSLog (@"Hello 8000");
        
        PressAltAbzug = 8000;
        
        
        
        
        if (RPM == 2650) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 8.4;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 120;  P20_GPH_DWN = 7.9;M20_BHP_UPP = 76;  M20_KTAS_UPP = 122;  M20_GPH_UPP = 8.5;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 122;  STD_GPH_UPP = 8;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 121;  P20_GPH_UPP = 7.5; }
        if (RPM == 2600) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 8;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 119;  P20_GPH_DWN = 7.5;M20_BHP_UPP = 72;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 8.1;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 7.6;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 7.1; }
        if (RPM == 2500) {M20_BHP_DWN = 68;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 7.7;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 7.2;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 113;  P20_GPH_DWN = 6.8;M20_BHP_UPP = 65;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 7.3;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 6.8;   P20_BHP_UPP = 58;  P20_KTAS_UPP = 112;  P20_GPH_UPP = 6.5; }
        if (RPM == 2400) {M20_BHP_DWN = 61;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 6.9;   STD_BHP_DWN = 58;  STD_KTAS_DWN = 109;  STD_GPH_DWN = 6.5;   P20_BHP_DWN = 55;  P20_KTAS_DWN = 108;  P20_GPH_DWN = 6.2;M20_BHP_UPP = 58;  M20_KTAS_UPP = 109;  M20_GPH_UPP = 6.5;   STD_BHP_UPP = 55;  STD_KTAS_UPP = 108;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 52;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 6; }
        if (RPM == 2300) {M20_BHP_DWN = 55;  M20_KTAS_DWN = 104;  M20_GPH_DWN = 6.2;   STD_BHP_DWN = 52;  STD_KTAS_DWN = 103;  STD_GPH_DWN = 6;   P20_BHP_DWN = 50;  P20_KTAS_DWN = 102;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 52;  M20_KTAS_UPP = 103;  M20_GPH_UPP = 6;   STD_BHP_UPP = 50;  STD_KTAS_UPP = 102;  STD_GPH_UPP = 5.8;   P20_BHP_UPP = 48;  P20_KTAS_UPP = 101;  P20_GPH_UPP = 5.6; }
        if (RPM == 2200) {M20_BHP_DWN = 49;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 5.7;   STD_BHP_DWN = 47;  STD_KTAS_DWN = 97;  STD_GPH_DWN = 5.5;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 96;  P20_GPH_DWN = 5.4;M20_BHP_UPP = 47;  M20_KTAS_UPP = 97;  M20_GPH_UPP = 5.6;   STD_BHP_UPP = 45;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 5.4;   P20_BHP_UPP = 44;  P20_KTAS_UPP = 95;  P20_GPH_UPP = 5.3; }
        if (RPM == 2100) {M20_BHP_DWN = 0;  M20_KTAS_DWN = 0;  M20_GPH_DWN = 0;   STD_BHP_DWN = 0;  STD_KTAS_DWN = 0;  STD_GPH_DWN = 0;   P20_BHP_DWN = 0;  P20_KTAS_DWN = 0;  P20_GPH_DWN = 0;M20_BHP_UPP = 0;  M20_KTAS_UPP = 0;  M20_GPH_UPP = 0;   STD_BHP_UPP = 0;  STD_KTAS_UPP = 0;  STD_GPH_UPP = 0;   P20_BHP_UPP = 0;  P20_KTAS_UPP = 0;  P20_GPH_UPP = 0; }        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 8.4;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 120;  P20_GPH_DWN2 = 7.9;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 122;  M20_GPH_UPP2 = 8.5;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 122;  STD_GPH_UPP2 = 8;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 121;  P20_GPH_UPP2 = 7.5; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 8;   P20_BHP_DWN2 = 46;  P20_KTAS_DWN2 = 119;  P20_GPH_DWN2 = 7.5;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 8.1;   STD_BHP_UPP2 = 68;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 7.6;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 7.1; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 68;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 7.7;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 7.2;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 113;  P20_GPH_DWN2 = 6.8;M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 7.3;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 6.8;   P20_BHP_UPP2 = 58;  P20_KTAS_UPP2 = 112;  P20_GPH_UPP2 = 6.5; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 61;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 6.9;   STD_BHP_DWN2 = 58;  STD_KTAS_DWN2 = 109;  STD_GPH_DWN2 = 6.5;   P20_BHP_DWN2 = 55;  P20_KTAS_DWN2 = 108;  P20_GPH_DWN2 = 6.2;M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 109;  M20_GPH_UPP2 = 6.5;   STD_BHP_UPP2 = 55;  STD_KTAS_UPP2 = 108;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 52;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 6; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 55;  M20_KTAS_DWN2 = 104;  M20_GPH_DWN2 = 6.2;   STD_BHP_DWN2 = 52;  STD_KTAS_DWN2 = 103;  STD_GPH_DWN2 = 6;   P20_BHP_DWN2 = 50;  P20_KTAS_DWN2 = 102;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 103;  M20_GPH_UPP2 = 6;   STD_BHP_UPP2 = 50;  STD_KTAS_UPP2 = 102;  STD_GPH_UPP2 = 5.8;   P20_BHP_UPP2 = 48;  P20_KTAS_UPP2 = 101;  P20_GPH_UPP2 = 5.6; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 49;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 5.7;   STD_BHP_DWN2 = 47;  STD_KTAS_DWN2 = 97;  STD_GPH_DWN2 = 5.5;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 96;  P20_GPH_DWN2 = 5.4;M20_BHP_UPP2 = 47;  M20_KTAS_UPP2 = 97;  M20_GPH_UPP2 = 5.6;   STD_BHP_UPP2 = 45;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 5.4;   P20_BHP_UPP2 = 44;  P20_KTAS_UPP2 = 95;  P20_GPH_UPP2 = 5.3; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 0;  M20_KTAS_DWN2 = 0;  M20_GPH_DWN2 = 0;   STD_BHP_DWN2 = 0;  STD_KTAS_DWN2 = 0;  STD_GPH_DWN2 = 0;   P20_BHP_DWN2 = 0;  P20_KTAS_DWN2 = 0;  P20_GPH_DWN2 = 0;M20_BHP_UPP2 = 0;  M20_KTAS_UPP2 = 0;  M20_GPH_UPP2 = 0;   STD_BHP_UPP2 = 0;  STD_KTAS_UPP2 = 0;  STD_GPH_UPP2 = 0;   P20_BHP_UPP2 = 0;  P20_KTAS_UPP2 = 0;  P20_GPH_UPP2 = 0; }        
        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    
    if (PressureAltitude >= 10000 & PressureAltitude <= 12000) {
        
        //NSLog (@"Hello 10000");
        
        PressAltAbzug = 10000;
        
        if (RPM == 2650) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 122;  M20_GPH_DWN = 8.5;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 122;  STD_GPH_DWN = 8;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 121;  P20_GPH_DWN = 7.5;M20_BHP_UPP = 68;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 7.7;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 7.2;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 6.8; }
        if (RPM == 2600) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 119;  STD_GPH_DWN = 7.6;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 7.1;M20_BHP_UPP = 68;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 7.7;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 7.2;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 6.8; }
        if (RPM == 2500) {M20_BHP_DWN = 65;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 7.3;   STD_BHP_DWN = 61;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 6.8;   P20_BHP_DWN = 58;  P20_KTAS_DWN = 112;  P20_GPH_DWN = 6.5;M20_BHP_UPP = 62;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 6.9;   STD_BHP_UPP = 58;  STD_KTAS_UPP = 113;  STD_GPH_UPP = 6.5;   P20_BHP_UPP = 55;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 6.2; }
        if (RPM == 2400) {M20_BHP_DWN = 58;  M20_KTAS_DWN = 109;  M20_GPH_DWN = 6.5;   STD_BHP_DWN = 55;  STD_KTAS_DWN = 108;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 52;  P20_KTAS_DWN = 107;  P20_GPH_DWN = 6;M20_BHP_UPP = 56;  M20_KTAS_UPP = 108;  M20_GPH_UPP = 6.3;   STD_BHP_UPP = 53;  STD_KTAS_UPP = 107;  STD_GPH_UPP = 6;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 106;  P20_GPH_UPP = 5.8; }
        if (RPM == 2300) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 103;  M20_GPH_DWN = 6;   STD_BHP_DWN = 50;  STD_KTAS_DWN = 102;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 48;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 5.6;M20_BHP_UPP = 50;  M20_KTAS_UPP = 102;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 101;  STD_GPH_UPP = 5.6;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 100;  P20_GPH_UPP = 5.5; }
        if (RPM == 2200) {M20_BHP_DWN = 47;  M20_KTAS_DWN = 97;  M20_GPH_DWN = 5.6;   STD_BHP_DWN = 45;  STD_KTAS_DWN = 96;  STD_GPH_DWN = 5.4;   P20_BHP_DWN = 44;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 5.3;M20_BHP_UPP = 46;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 5.5;   STD_BHP_UPP = 44;  STD_KTAS_UPP = 95;  STD_GPH_UPP = 5.4;   P20_BHP_UPP = 43;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 5.3; }
        if (RPM == 2100) {M20_BHP_DWN = 0;  M20_KTAS_DWN = 0;  M20_GPH_DWN = 0;   STD_BHP_DWN = 0;  STD_KTAS_DWN = 0;  STD_GPH_DWN = 0;   P20_BHP_DWN = 0;  P20_KTAS_DWN = 0;  P20_GPH_DWN = 0;M20_BHP_UPP = 0;  M20_KTAS_UPP = 0;  M20_GPH_UPP = 0;   STD_BHP_UPP = 0;  STD_KTAS_UPP = 0;  STD_GPH_UPP = 0;   P20_BHP_UPP = 0;  P20_KTAS_UPP = 0;  P20_GPH_UPP = 0; }       
        
        
        
        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 122;  M20_GPH_DWN2 = 8.5;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 122;  STD_GPH_DWN2 = 8;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 121;  P20_GPH_DWN2 = 7.5;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 7.7;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 7.2;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 119;  STD_GPH_DWN2 = 7.6;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 7.1;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 7.7;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 7.2;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 7.3;   STD_BHP_DWN2 = 61;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 6.8;   P20_BHP_DWN2 = 58;  P20_KTAS_DWN2 = 112;  P20_GPH_DWN2 = 6.5;M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 6.9;   STD_BHP_UPP2 = 58;  STD_KTAS_UPP2 = 113;  STD_GPH_UPP2 = 6.5;   P20_BHP_UPP2 = 55;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 6.2; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 109;  M20_GPH_DWN2 = 6.5;   STD_BHP_DWN2 = 55;  STD_KTAS_DWN2 = 108;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 52;  P20_KTAS_DWN2 = 107;  P20_GPH_DWN2 = 6;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 108;  M20_GPH_UPP2 = 6.3;   STD_BHP_UPP2 = 53;  STD_KTAS_UPP2 = 107;  STD_GPH_UPP2 = 6;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 106;  P20_GPH_UPP2 = 5.8; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 103;  M20_GPH_DWN2 = 6;   STD_BHP_DWN2 = 50;  STD_KTAS_DWN2 = 102;  STD_GPH_DWN2 = 5.8;   P20_BHP_DWN2 = 48;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 5.6;M20_BHP_UPP2 = 50;  M20_KTAS_UPP2 = 102;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 101;  STD_GPH_UPP2 = 5.6;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 100;  P20_GPH_UPP2 = 5.5; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 47;  M20_KTAS_DWN2 = 97;  M20_GPH_DWN2 = 5.6;   STD_BHP_DWN2 = 45;  STD_KTAS_DWN2 = 96;  STD_GPH_DWN2 = 5.4;   P20_BHP_DWN2 = 44;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 5.3;M20_BHP_UPP2 = 46;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 5.5;   STD_BHP_UPP2 = 44;  STD_KTAS_UPP2 = 95;  STD_GPH_UPP2 = 5.4;   P20_BHP_UPP2 = 43;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 5.3; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 0;  M20_KTAS_DWN2 = 0;  M20_GPH_DWN2 = 0;   STD_BHP_DWN2 = 0;  STD_KTAS_DWN2 = 0;  STD_GPH_DWN2 = 0;   P20_BHP_DWN2 = 0;  P20_KTAS_DWN2 = 0;  P20_GPH_DWN2 = 0;M20_BHP_UPP2 = 0;  M20_KTAS_UPP2 = 0;  M20_GPH_UPP2 = 0;   STD_BHP_UPP2 = 0;  STD_KTAS_UPP2 = 0;  STD_GPH_UPP2 = 0;   P20_BHP_UPP2 = 0;  P20_KTAS_UPP2 = 0;  P20_GPH_UPP2 = 0; }  
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    // interpolate RPM
    
    M20_BHP_DWN_MED = M20_BHP_DWN + ((M20_BHP_DWN2 - M20_BHP_DWN ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_BHP_UPP_MED = M20_BHP_UPP + ((M20_BHP_UPP2 - M20_BHP_UPP ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    
    
    M20_KTAS_DWN_MED = M20_KTAS_DWN + ((M20_KTAS_DWN2 - M20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_KTAS_UPP_MED = M20_KTAS_UPP + ((M20_KTAS_UPP2 - M20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    M20_GPH_DWN_MED = M20_GPH_DWN + ((M20_GPH_DWN2 - M20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_GPH_UPP_MED = M20_GPH_UPP + ((M20_GPH_UPP2 - M20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_BHP_DWN_MED = STD_BHP_DWN + ((STD_BHP_DWN2 - STD_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_BHP_UPP_MED = STD_BHP_UPP + ((STD_BHP_UPP2 - STD_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_KTAS_DWN_MED = STD_KTAS_DWN + ((STD_KTAS_DWN2 - STD_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_KTAS_UPP_MED = STD_KTAS_UPP + ((STD_KTAS_UPP2 - STD_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_GPH_DWN_MED = STD_GPH_DWN + ((STD_GPH_DWN2 - STD_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_GPH_UPP_MED = STD_GPH_UPP + ((STD_GPH_UPP2 - STD_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_BHP_DWN_MED = P20_BHP_DWN + ((P20_BHP_DWN2 - P20_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_BHP_UPP_MED = P20_BHP_UPP + ((P20_BHP_UPP2 - P20_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_KTAS_DWN_MED = P20_KTAS_DWN + ((P20_KTAS_DWN2 - P20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_KTAS_UPP_MED = P20_KTAS_UPP + ((P20_KTAS_UPP2 - P20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_GPH_DWN_MED = P20_GPH_DWN + ((P20_GPH_DWN2 - P20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_GPH_UPP_MED = P20_GPH_UPP + ((P20_GPH_UPP2 - P20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    temp = ISAdiff;
    //NSLog(@"temp = %.1f ", temp);
    
    // interpolate temperature
    
    if (temp >= 0 & temp <= 20) {
        
        low_BHP     = STD_BHP_DWN_MED      - (( (STD_BHP_DWN_MED   - P20_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED     - (( (STD_KTAS_DWN_MED  - P20_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED      - (( (STD_GPH_DWN_MED   - P20_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        high_BHP    = STD_BHP_UPP_MED     - (( (STD_BHP_UPP_MED   - P20_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS   = STD_KTAS_UPP_MED    - (( (STD_KTAS_UPP_MED  - P20_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED     - (( (STD_GPH_UPP_MED   - P20_GPH_UPP_MED)  / 20 ) * temp) ;
        
        
        
        
    }
    
    
    
    if (temp < 0 & temp >= -20) {
        
        low_BHP     = STD_BHP_DWN_MED   - (( (M20_BHP_DWN_MED   - STD_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED  - (( (M20_KTAS_DWN_MED  - STD_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED   - (( (M20_GPH_DWN_MED   - STD_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        
        high_BHP   = STD_BHP_UPP_MED    - (( (M20_BHP_UPP_MED   - STD_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS  = STD_KTAS_UPP_MED   - (( (M20_KTAS_UPP_MED  - STD_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED   - (( (M20_GPH_UPP_MED   - STD_GPH_UPP_MED)  / 20 ) * temp) ;
    }
    
    
    
    // interpolate for PRESSURE ALT    
    resultCruiseBHP =    low_BHP -  ( ((low_BHP - high_BHP) / 2000) * (PressureAltitude - PressAltAbzug) );
    resultCruiseKTAS =  low_KTAS -  ( ((low_KTAS - high_KTAS) / 2000) * (PressureAltitude - PressAltAbzug) );    
    resultCruiseFuelBurn =    low_GPH -  ( ((low_GPH - high_GPH) / 2000) * (PressureAltitude - PressAltAbzug) );
    
    //NSLog(@"RPM %f", RPM);
    //NSLog(@"resultCruiseBHP %f", resultCruiseBHP);
    
    return;
    
    
}

// C172 M **************************************************************************************************

- (void) shortfieldC172M_2200 {  // leichteste
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
        gR_0_low = 505; cl_0_low = 915;    gR_10_low = 540; cl_10_low = 975;   gR_20_low = 580; cl_20_low = 1035;   gR_30_low = 620; cl_30_low = 1105;   gR_40_low = 665; cl_40_low = 1175;    
        gR_0_hig = 550; cl_0_hig = 995;    gR_10_hig = 590; cl_10_hig = 1060;   gR_20_hig = 635; cl_20_hig = 1130;   gR_30_hig = 680; cl_30_hig = 1205;   gR_40_hig = 725; cl_40_hig = 1280; 
        
        PAlevelShortfield = 0;
        
       
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 550; cl_0_low = 995;    gR_10_low = 590; cl_10_low = 1060;   gR_20_low = 635; cl_20_low = 1130;   gR_30_low = 680; cl_30_low = 1205;   gR_40_low = 725; cl_40_low = 1280;    
        gR_0_hig = 600; cl_0_hig = 1085;    gR_10_hig = 645; cl_10_hig = 1155;   gR_20_hig = 695; cl_20_hig = 1230;   gR_30_hig = 745; cl_30_hig = 1315;   gR_40_hig = 795; cl_40_hig = 1400;         
        PAlevelShortfield = 1000;
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 600; cl_0_low = 1085;    gR_10_low = 645; cl_10_low = 1155;   gR_20_low = 695; cl_20_low = 1230;   gR_30_low = 745; cl_30_low = 1315;   gR_40_low = 795; cl_40_low = 1400;    
        gR_0_hig = 660; cl_0_hig = 1180;    gR_10_hig = 710; cl_10_hig = 1260;   gR_20_hig = 760; cl_20_hig = 1345;   gR_30_hig = 815; cl_30_hig = 1435;   gR_40_hig = 870; cl_40_hig = 1530; 
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
      
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 660; cl_0_low = 1180;    gR_10_low = 710; cl_10_low = 1260;   gR_20_low = 760; cl_20_low = 1345;   gR_30_low = 815; cl_30_low = 1435;   gR_40_low = 870; cl_40_low = 1530;    
        gR_0_hig = 725; cl_0_hig = 1290;    gR_10_hig = 775; cl_10_hig = 1380;   gR_20_hig = 835; cl_20_hig = 1475;   gR_30_hig = 895; cl_30_hig = 1575;   gR_40_hig = 955; cl_40_hig = 1680;  
        
        PAlevelShortfield = 3000;
        
       
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 725; cl_0_low = 1290;    gR_10_low = 775; cl_10_low = 1380;   gR_20_low = 835; cl_20_low = 1475;   gR_30_low = 895; cl_30_low = 1575;   gR_40_low = 955; cl_40_low = 1680;    
        gR_0_hig = 795; cl_0_hig = 1415;    gR_10_hig = 855; cl_10_hig = 1515;   gR_20_hig = 915; cl_20_hig = 1620;   gR_30_hig = 985; cl_30_hig = 1735;   gR_40_hig = 1055; cl_40_hig = 1850;  
        
        PAlevelShortfield = 4000;
        
       
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 795; cl_0_low = 1415;    gR_10_low = 855; cl_10_low = 1515;   gR_20_low = 915; cl_20_low = 1620;   gR_30_low = 985; cl_30_low = 1735;   gR_40_low = 1055; cl_40_low = 1850;    
        gR_0_hig = 870; cl_0_hig = 1555;    gR_10_hig = 940; cl_10_hig = 1670;   gR_20_hig = 1010; cl_20_hig = 1785;   gR_30_hig = 1080; cl_30_hig = 1910;   gR_40_hig = 1160; cl_40_hig = 2045; 
        
        PAlevelShortfield = 5000;
        
       
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 870; cl_0_low = 1555;    gR_10_low = 940; cl_10_low = 1670;   gR_20_low = 1010; cl_20_low = 1785;   gR_30_low = 1080; cl_30_low = 1910;   gR_40_low = 1160; cl_40_low = 2045;    
        gR_0_hig = 960; cl_0_hig = 1715;    gR_10_hig = 1035; cl_10_hig = 1840;   gR_20_hig = 1110; cl_20_hig = 1975;   gR_30_hig = 1195; cl_30_hig = 2115;   gR_40_hig = 1280; cl_40_hig = 2265;         
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 960; cl_0_low = 1715;    gR_10_low = 1035; cl_10_low = 1840;   gR_20_low = 1110; cl_20_low = 1975;   gR_30_low = 1195; cl_30_low = 2115;   gR_40_low = 1280; cl_40_low = 2265;    
        gR_0_hig = 1060; cl_0_hig = 1900;    gR_10_hig = 1140; cl_10_hig = 2040;   gR_20_hig = 1225; cl_20_hig = 2190;   gR_30_hig = 1320; cl_30_hig = 2350;   gR_40_hig = 1405; cl_40_hig = 2420; 
        
        PAlevelShortfield = 7000;
        
        //
        
    } // end if  
    
    
    
    
    // interpolate ground roll
    [self shortfield2200C172_interpolation]; 
    
    
    return;
    
}
- (void) shortfieldC172M_2400 { // middle
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 630; cl_0_low = 1130;    gR_10_low = 680; cl_10_low = 1210;   gR_20_low = 725; cl_20_low = 1290;   gR_30_low = 780; cl_30_low = 1375;   gR_40_low = 835; cl_40_low = 1465;   
        gR_0_hig = 690; cl_0_hig = 1235;    gR_10_hig = 740; cl_10_hig = 1320;   gR_20_hig = 795; cl_20_hig = 1405;   gR_30_hig = 855; cl_30_hig = 1500;   gR_40_hig = 915; cl_40_hig = 1600;  
        
        PAlevelShortfield = 0;
        
      
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 690; cl_0_low = 1235;    gR_10_low = 740; cl_10_low = 1320;   gR_20_low = 795; cl_20_low = 1405;   gR_30_low = 855; cl_30_low = 1500;   gR_40_low = 915; cl_40_low = 1600;   
        gR_0_hig = 755; cl_0_hig = 1350;    gR_10_hig = 810; cl_10_hig = 1440;   gR_20_hig = 870; cl_20_hig = 1540;   gR_30_hig = 935; cl_30_hig = 1645;   gR_40_hig = 1000; cl_40_hig = 1755;         
        PAlevelShortfield = 1000;
        
       
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 755; cl_0_low = 1350;    gR_10_low = 810; cl_10_low = 1440;   gR_20_low = 870; cl_20_low = 1540;   gR_30_low = 935; cl_30_low = 1645;   gR_40_low = 1000; cl_40_low = 1755;   
        gR_0_hig = 830; cl_0_hig = 1475;    gR_10_hig = 890; cl_10_hig = 1580;   gR_20_hig = 955; cl_20_hig = 1690;   gR_30_hig = 1025; cl_30_hig = 1805;   gR_40_hig = 1100; cl_40_hig = 1930;  
        
        PAlevelShortfield = 2000;
        
      
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 830; cl_0_low = 1475;    gR_10_low = 890; cl_10_low = 1580;   gR_20_low = 955; cl_20_low = 1690;   gR_30_low = 1025; cl_30_low = 1805;   gR_40_low = 1100; cl_40_low = 1930;   
        gR_0_hig = 910; cl_0_hig = 1620;    gR_10_hig = 980; cl_10_hig = 1735;   gR_20_hig = 1050; cl_20_hig = 1860;   gR_30_hig = 1125; cl_30_hig = 1990;   gR_40_hig = 1210; cl_40_hig = 2130; 
        
        PAlevelShortfield = 3000;
        
          
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 910; cl_0_low = 1620;    gR_10_low = 980; cl_10_low = 1735;   gR_20_low = 1050; cl_20_low = 1860;   gR_30_low = 1125; cl_30_low = 1990;   gR_40_low = 1210; cl_40_low = 2130;   
        gR_0_hig = 1000; cl_0_hig = 1780;    gR_10_hig = 1075; cl_10_hig = 1910;   gR_20_hig = 1155; cl_20_hig = 2050;   gR_30_hig = 1240; cl_30_hig = 2195;   gR_40_hig = 1330; cl_40_hig = 2355; 
        
        PAlevelShortfield = 4000;
        
               
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1000; cl_0_low = 1780;    gR_10_low = 1075; cl_10_low = 1910;   gR_20_low = 1155; cl_20_low = 2050;   gR_30_low = 1240; cl_30_low = 2195;   gR_40_low = 1330; cl_40_low = 2355;   
        gR_0_hig = 1100; cl_0_hig = 1965;    gR_10_hig = 1185; cl_10_hig = 2115;   gR_20_hig = 1275; cl_20_hig = 2270;   gR_30_hig = 1370; cl_30_hig = 2435;   gR_40_hig = 1465; cl_40_hig = 2615; 
        
        PAlevelShortfield = 5000;
        
       
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1100; cl_0_low = 1965;    gR_10_low = 1185; cl_10_low = 2115;   gR_20_low = 1275; cl_20_low = 2270;   gR_30_low = 1370; cl_30_low = 2435;   gR_40_low = 1465; cl_40_low = 2615;   
        gR_0_hig = 1215; cl_0_hig = 2180;    gR_10_hig = 1305; cl_10_hig = 2345;   gR_20_hig = 1405; cl_20_hig = 2520;   gR_30_hig = 1510; cl_30_hig = 2715;   gR_40_hig = 1620; cl_40_hig = 2920;         
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1215; cl_0_low = 2180;    gR_10_low = 1305; cl_10_low = 2345;   gR_20_low = 1405; cl_20_low = 2520;   gR_30_low = 1510; cl_30_low = 2715;   gR_40_low = 1620; cl_40_low = 2920;   
        gR_0_hig = 1340; cl_0_hig = 2425;    gR_10_hig = 1445; cl_10_hig = 2615;   gR_20_hig = 1555; cl_20_hig = 2815;   gR_30_hig = 1675; cl_30_hig = 3040;   gR_40_hig = 1795; cl_40_hig = 3280; 
        
        PAlevelShortfield = 7000;
        
      
        
    } // end if  
    
    
    
    
    
    // interpolate ground roll
    
    [self shortfield2400C172_interpolation];      
    
    return;
    
} // end void
- (void) shortfieldC172M_2550 { // high
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 775; cl_0_low = 1380;    gR_10_low = 835; cl_10_low = 1475;   gR_20_low = 895; cl_20_low = 1575;   gR_30_low = 960; cl_30_low = 1685;   gR_40_low = 1030; cl_40_low = 1795;   
        gR_0_hig = 850; cl_0_hig = 1510;    gR_10_hig = 915; cl_10_hig = 1615;   gR_20_hig = 980; cl_20_hig = 1725;   gR_30_hig = 1050; cl_30_hig = 1845;   gR_40_hig = 1125; cl_40_hig = 1970; 
        
        PAlevelShortfield = 0;
        
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 850; cl_0_low = 1510;    gR_10_low = 915; cl_10_low = 1615;   gR_20_low = 980; cl_20_low = 1725;   gR_30_low = 1050; cl_30_low = 1845;   gR_40_low = 1125; cl_40_low = 1970;   
        gR_0_hig = 930; cl_0_hig = 1650;    gR_10_hig = 1000; cl_10_hig = 1770;   gR_20_hig = 1075; cl_20_hig = 1898;   gR_30_hig = 1155; cl_30_hig = 2030;   gR_40_hig = 1235; cl_40_hig = 2170; 
        
        PAlevelShortfield = 1000;
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 930; cl_0_low = 1650;    gR_10_low = 1000; cl_10_low = 1770;   gR_20_low = 1075; cl_20_low = 1898;   gR_30_low = 1155; cl_30_low = 2030;   gR_40_low = 1235; cl_40_low = 2170;   
        gR_0_hig = 1020; cl_0_hig = 1815;    gR_10_hig = 1100; cl_10_hig = 1945;   gR_20_hig = 1180; cl_20_hig = 2085;   gR_30_hig = 1270; cl_30_hig = 2235;   gR_40_hig = 1360; cl_40_hig = 2395; 
        
        PAlevelShortfield = 2000;
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 1020; cl_0_low = 1815;    gR_10_low = 1100; cl_10_low = 1945;   gR_20_low = 1180; cl_20_low = 2085;   gR_30_low = 1270; cl_30_low = 2235;   gR_40_low = 1360; cl_40_low = 2395;   
        gR_0_hig = 1125; cl_0_hig = 2000;    gR_10_hig = 1210; cl_10_hig = 2145;   gR_20_hig = 1300; cl_20_hig = 2305;   gR_30_hig = 1395; cl_30_hig = 2475;   gR_40_hig = 1495; cl_40_hig = 2655; 
        
        PAlevelShortfield = 3000;
        
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1125; cl_0_low = 2000;    gR_10_low = 1210; cl_10_low = 2145;   gR_20_low = 1300; cl_20_low = 2305;   gR_30_low = 1395; cl_30_low = 2475;   gR_40_low = 1495; cl_40_low = 2655;   
        gR_0_hig = 1235; cl_0_hig = 2210;    gR_10_hig = 1330; cl_10_hig = 2375;   gR_20_hig = 1430; cl_20_hig = 2555;   gR_30_hig = 1540; cl_30_hig = 2750;   gR_40_hig = 1650; cl_40_hig = 2960;   
        
        PAlevelShortfield = 4000;
        
     
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1235; cl_0_low = 2210;    gR_10_low = 1330; cl_10_low = 2375;   gR_20_low = 1430; cl_20_low = 2555;   gR_30_low = 1540; cl_30_low = 2750;   gR_40_low = 1650; cl_40_low = 2960;   
        gR_0_hig = 1365; cl_0_hig = 2450;    gR_10_hig = 1470; cl_10_hig = 2640;   gR_20_hig = 1580; cl_20_hig = 2850;   gR_30_hig = 1700; cl_30_hig = 3070;   gR_40_hig = 1800; cl_40_hig = 3170; 
        
        PAlevelShortfield = 5000;
        
      
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1365; cl_0_low = 2450;    gR_10_low = 1470; cl_10_low = 2640;   gR_20_low = 1580; cl_20_low = 2850;   gR_30_low = 1700; cl_30_low = 3070;   gR_40_low = 1800; cl_40_low = 3170;   
        gR_0_hig = 1505; cl_0_hig = 2730;    gR_10_hig = 1625; cl_10_hig = 2955;   gR_20_hig = 1750; cl_20_hig = 3190;   gR_30_hig = 1850; cl_30_hig = 3300;   gR_40_hig = 1950; cl_40_hig = 3400; 
        
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1505; cl_0_low = 2730;    gR_10_low = 1625; cl_10_low = 2955;   gR_20_low = 1750; cl_20_low = 3190;   gR_30_low = 1850; cl_30_low = 3300;   gR_40_low = 1950; cl_40_low = 3400;   
        gR_0_hig = 1665; cl_0_hig = 3065;    gR_10_hig = 1800; cl_10_hig = 3320;   gR_20_hig = 1890; cl_20_hig = 3450;   gR_30_hig = 1990; cl_30_hig = 3600;   gR_40_hig = 2090; cl_40_hig = 3700;  
        
        PAlevelShortfield = 7000;
        
      
        
        
    } // end if  
    
    
    
    [self shortfield2550C172_interpolation];
    
    
    return;
    
} // end void
- (void) shortfiedlC172MInterpolationToACWEight {
    
    
    if (ACweightLBS >= 1900 & ACweightLBS < 2100) {  // 
        GroundRolltoWeight = GrndRollShortField_interpolated + ( ( (GrndRollShortField_interpolated2400 - GrndRollShortField_interpolated)/200 ) * (ACweightLBS-1900)) ;
        
        totalToClear = ObstClearance_interpolated + ( ( (ObstClearance_interpolated2400 - ObstClearance_interpolated)/200 ) * (ACweightLBS-1900));        
        liftoffspeed = 47 +  ( 0.0125 * (ACweightLBS-1900));
        
    } 
    
    
    
    if (ACweightLBS >= 2100 & ACweightLBS <= 2300) {
        GroundRolltoWeight = GrndRollShortField_interpolated2400 + ( ( (GrndRollShortField_interpolated2550 - GrndRollShortField_interpolated2400)/200 ) * (ACweightLBS-2100))  ;
        totalToClear = ObstClearance_interpolated2400 + ( ( (ObstClearance_interpolated2550 - ObstClearance_interpolated2400)/200 ) * (ACweightLBS-2100)) ;        
        liftoffspeed = 47 +  ( 0.0125 * (ACweightLBS-1900));
    } 
    
    
}
- (void) shortfield_LandingC172M {
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_lowLD = 495; cl_0_lowLD = 1205;    gR_10_lowLD = 510; cl_10_lowLD = 1235;   gR_20_lowLD = 530; cl_20_lowLD = 1265;   gR_30_lowLD = 545; cl_30_lowLD = 1295;   gR_40_lowLD = 565; cl_40_lowLD = 1330;   gR_0_higLD = 510; cl_0_higLD = 1235;    gR_10_higLD = 530; cl_10_higLD = 1265;   gR_20_higLD = 550; cl_20_higLD = 1300;   gR_30_higLD = 565; cl_30_higLD = 1330;   gR_40_higLD = 585; cl_40_higLD = 1365;         
        
        PAlevelShortfieldLD = 0;
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_lowLD = 510; cl_0_lowLD = 1235;    gR_10_lowLD = 530; cl_10_lowLD = 1265;   gR_20_lowLD = 550; cl_20_lowLD = 1300;   gR_30_lowLD = 565; cl_30_lowLD = 1330;   gR_40_lowLD = 585; cl_40_lowLD = 1365;   gR_0_higLD = 530; cl_0_higLD = 1265;    gR_10_higLD = 550; cl_10_higLD = 1300;   gR_20_higLD = 570; cl_20_higLD = 1335;   gR_30_higLD = 590; cl_30_higLD = 1370;   gR_40_higLD = 610; cl_40_higLD = 1405;         
        PAlevelShortfieldLD = 1000;
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_lowLD = 530; cl_0_lowLD = 1265;    gR_10_lowLD = 550; cl_10_lowLD = 1300;   gR_20_lowLD = 570; cl_20_lowLD = 1335;   gR_30_lowLD = 590; cl_30_lowLD = 1370;   gR_40_lowLD = 610; cl_40_lowLD = 1405;   gR_0_higLD = 550; cl_0_higLD = 1300;    gR_10_higLD = 570; cl_10_higLD = 1335;   gR_20_higLD = 590; cl_20_higLD = 1370;   gR_30_higLD = 610; cl_30_higLD = 1405;   gR_40_higLD = 630; cl_40_higLD = 1440; 
        
        PAlevelShortfieldLD = 2000;
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_lowLD = 550; cl_0_lowLD = 1300;    gR_10_lowLD = 570; cl_10_lowLD = 1335;   gR_20_lowLD = 590; cl_20_lowLD = 1370;   gR_30_lowLD = 610; cl_30_lowLD = 1405;   gR_40_lowLD = 630; cl_40_lowLD = 1440;   gR_0_higLD = 570; cl_0_higLD = 1335;    gR_10_higLD = 590; cl_10_higLD = 1370;   gR_20_higLD = 615; cl_20_higLD = 1410;   gR_30_higLD = 635; cl_30_higLD = 1445;   gR_40_higLD = 655; cl_40_higLD = 1485; 
        
        PAlevelShortfieldLD = 3000;
       
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_lowLD = 570; cl_0_lowLD = 1335;    gR_10_lowLD = 590; cl_10_lowLD = 1370;   gR_20_lowLD = 615; cl_20_lowLD = 1410;   gR_30_lowLD = 635; cl_30_lowLD = 1445;   gR_40_lowLD = 655; cl_40_lowLD = 1485;   gR_0_higLD = 590; cl_0_higLD = 1370;    gR_10_higLD = 615; cl_10_higLD = 1415;   gR_20_higLD = 635; cl_20_higLD = 1450;   gR_30_higLD = 655; cl_30_higLD = 1485;   gR_40_higLD = 680; cl_40_higLD = 1545;   
        
        PAlevelShortfieldLD = 4000;
       
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_lowLD = 590; cl_0_lowLD = 1370;    gR_10_lowLD = 615; cl_10_lowLD = 1415;   gR_20_lowLD = 635; cl_20_lowLD = 1450;   gR_30_lowLD = 655; cl_30_lowLD = 1485;   gR_40_lowLD = 680; cl_40_lowLD = 1545;   gR_0_higLD = 615; cl_0_higLD = 1415;    gR_10_higLD = 640; cl_10_higLD = 1455;   gR_20_higLD = 660; cl_20_higLD = 1490;   gR_30_higLD = 685; cl_30_higLD = 1535;   gR_40_higLD = 705; cl_40_higLD = 1580;  
        
        PAlevelShortfieldLD = 5000;
      
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 615; cl_0_lowLD = 1415;    gR_10_lowLD = 640; cl_10_lowLD = 1455;   gR_20_lowLD = 660; cl_20_lowLD = 1490;   gR_30_lowLD = 685; cl_30_lowLD = 1535;   gR_40_lowLD = 705; cl_40_lowLD = 1580;   gR_0_higLD = 640; cl_0_higLD = 1455;    gR_10_higLD = 660; cl_10_higLD = 1495;   gR_20_higLD = 685; cl_20_higLD = 1535;   gR_30_higLD = 710; cl_30_higLD = 1575;   gR_40_higLD = 730; cl_40_higLD = 1610;  
        
        PAlevelShortfieldLD = 6000;
       
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 640; cl_0_lowLD = 1455;    gR_10_lowLD = 660; cl_10_lowLD = 1495;   gR_20_lowLD = 685; cl_20_lowLD = 1535;   gR_30_lowLD = 710; cl_30_lowLD = 1575;   gR_40_lowLD = 730; cl_40_lowLD = 1610;   gR_0_higLD = 665; cl_0_higLD = 1500;    gR_10_higLD = 690; cl_10_higLD = 1540;   gR_20_higLD = 710; cl_20_higLD = 1580;   gR_30_higLD = 735; cl_30_higLD = 1620;   gR_40_higLD = 760; cl_40_higLD = 1670;  
        
        PAlevelShortfieldLD = 7000;
        
        
        
        
    } // end if  
    
    
    
    
    
    
    
    // ausgabe
    
    
    
    
    return;
    
} 
- (void) setRPMsliderValuesC172M {
    
    
    if (PressureAltitude >= 0 & PressureAltitude < 4000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2550;
    }
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2600;
        
        
        
    }
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000 ) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2650;
        
        
        
    }
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2700;
        
        
    }
    
    if (PressureAltitude >= 10000 & PressureAltitude < 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2700;
        
        
    }
    
    if (PressureAltitude >= 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2650;
        
        
    }
    
    
    resultRPMmin = sliderRPMmin;
    resultRPMmax = sliderRPMmax;
    
    
}
- (void) calculate_ClimbC172M {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {
        
        
        climb_low2  = 78; RoC_low2   = 645; time_low2   = 0; fuel_low2   = 0;    distNM_low2   = 0;
        climb_high2 = 77; RoC_high2  = 605; time_high2  = 2; fuel_high2  = 0.3;    distNM_high2   = 2; PAlevel2 = 0;       
        
        
    }
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        climb_low2  = 77; RoC_low2   = 605; time_low2   = 2; fuel_low2   = 0.3;    distNM_low2   = 2; PAlevel2 = 1000;   
        climb_high2 = 76; RoC_high2  = 560; time_high2  = 3; fuel_high2  = 0.7;    distNM_high2   = 4; PAlevel2 = 1000;
         
    }
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        climb_low2  = 76; RoC_low2   = 560; time_low2   = 3; fuel_low2   = 0.7;    distNM_low2   = 4; PAlevel2 = 2000;   
        climb_high2 = 75; RoC_high2  = 520; time_high2  = 5; fuel_high2  = 1.1;    distNM_high2   = 7; PAlevel2 = 2000;
        
      
    }
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        climb_low2  = 75; RoC_low2   = 520; time_low2   = 5; fuel_low2   = 1.1;    distNM_low2   = 7; PAlevel2 = 3000;   
        climb_high2 = 74; RoC_high2  = 480; time_high2  = 7; fuel_high2  = 1.5;    distNM_high2   = 9; PAlevel2 = 3000;
        
     
    }
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        climb_low2  = 74; RoC_low2   = 480; time_low2   = 7; fuel_low2   = 1.5;    distNM_low2   = 9; PAlevel2 = 4000;   
        climb_high2 = 73; RoC_high2  = 435; time_high2  = 9; fuel_high2  = 1.9;    distNM_high2   = 12; PAlevel2 = 4000;
        
       
    }
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        climb_low2  = 73; RoC_low2   = 435; time_low2   = 9; fuel_low2   = 1.9;    distNM_low2   = 12; PAlevel2 = 5000;   
        climb_high2 = 72; RoC_high2  = 695; time_high2  = 12; fuel_high2  = 2.3;    distNM_high2   = 16; PAlevel2 = 5000;
        
       
    }
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        climb_low2  = 72; RoC_low2   = 695; time_low2   = 12; fuel_low2   = 2.3;    distNM_low2   = 16; PAlevel2 = 6000;   
        climb_high2 = 71; RoC_high2  = 355; time_high2  = 15; fuel_high2  = 2.8;    distNM_high2   = 19; PAlevel2 = 6000;
        
        
      
    }
    
    if (PressureAltitude >=7000 & PressureAltitude < 8000) {
        
        climb_low2  = 71; RoC_low2   = 355; time_low2   = 15; fuel_low2   = 2.8;    distNM_low2   = 19; PAlevel2 = 7000;   
        climb_high2 = 70; RoC_high2  = 315; time_high2  = 18; fuel_high2  = 3.3;    distNM_high2   = 23; PAlevel2 = 7000;
        
      
    }
    
    if (PressureAltitude >=8000 & PressureAltitude < 9000) {
        
        climb_low2  = 70; RoC_low2   = 315; time_low2   = 18; fuel_low2   = 3.3;    distNM_low2   = 23; PAlevel2 = 8000;   
        climb_high2 = 69; RoC_high2  = 270; time_high2  = 21; fuel_high2  = 3.9;    distNM_high2   = 28; PAlevel2 = 8000;
        
      
    }
    
    
    if (PressureAltitude >=9000 & PressureAltitude < 10000) {
        climb_low2  = 69; RoC_low2   = 270; time_low2   = 21; fuel_low2   = 3.9;    distNM_low2   = 28; PAlevel2 = 9000;   
        climb_high2 = 68; RoC_high2  = 230; time_high2  = 25; fuel_high2  = 4.5;    distNM_high2   = 33; PAlevel2 = 9000;
        
      
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 11000) {
        
        climb_low2  = 68; RoC_low2   = 230; time_low2   = 25; fuel_low2   = 4.5;    distNM_low2   = 33; PAlevel2 = 10000;   
        climb_high2 = 67; RoC_high2  = 185; time_high2  = 30; fuel_high2  = 5.2;    distNM_high2   = 40; PAlevel2 = 10000;
        
       
    }
    
    if (PressureAltitude >=11000 & PressureAltitude < 12000) {
        
        climb_low2  = 67; RoC_low2   = 185; time_low2   = 30; fuel_low2   = 5.2;    distNM_low2   = 40; PAlevel2 = 11000;   
        climb_high2 = 66; RoC_high2  = 145; time_high2  = 36; fuel_high2  = 6.1;    distNM_high2   = 48; PAlevel2 = 11000;        
       
    }
    
    
    if (PressureAltitude >=12000 ) {
        
        climb_low2  = 66; RoC_low2   = 145; time_low2   = 36; fuel_low2   = 6.1;    distNM_low2   = 48; PAlevel2 = 12000;   
        climb_high2 = 66; RoC_high2  = 145; time_high2  = 36; fuel_high2  = 6.1;    distNM_high2   = 48; PAlevel2 = 12000;       
       
    }
    
    
    
    [self interpolateClimbC172S];
}
- (void) InterpolateCruiseValuesC172M {
    
    
    RPM = engineRPMcruise;
    
    // define RPM  high and low
    
    
    
    
    
    
    // define RPM  high and low
    
    if (RPM >= 2100 & RPM < 2200) {
        RPM_LOW = 2100; RPM_HIGH = 2200;
    }
    
    if (RPM >= 2200 & RPM < 2300) {
        RPM_LOW = 2200; RPM_HIGH = 2300;
    }
    
    if (RPM >= 2300 & RPM < 2400) {
        RPM_LOW = 2300; RPM_HIGH = 2400;
    }
    
    if (RPM >= 2400 & RPM < 2500) {
        RPM_LOW = 2400; RPM_HIGH = 2500;
    }
    
    if (RPM >= 2500 & RPM < 2600) {
        RPM_LOW = 2500; RPM_HIGH = 2600;
    }
    
    if (RPM >= 2600 & RPM <= 2700) {
        RPM_LOW = 2600; RPM_HIGH = 2700;
    }
    
    if (RPM >= 2600 & RPM <= 2700 & PressureAltitude > 11999) {
        RPM_LOW = 2600; RPM_HIGH = 2650;
    }
    
    
    
    //NSLog (@"RPM_LOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_LOW]);    
    //NSLog (@"RPM_HIGH %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_HIGH]);
    
    
    
    // get RPM
    
    if (PressureAltitude < 2001) {
        PressureAltitude = 2001;
    }
    
    if (PressureAltitude > 11999) {
        PressureAltitude = 12000;
    }
    
    
    if (PressureAltitude >= 2000 & PressureAltitude < 4000) {
        
        PressAltAbzug = 2000;
        
        
        //NSLog (@"Hello 2000");
        
        
        if (RPM == 2600) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 113;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 113;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 80;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.8;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 8.3;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 116;  P20_GPH_UPP = 7.8; }
        if (RPM == 2550) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 113;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 113;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 80;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.8;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 8.3;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 116;  P20_GPH_UPP = 7.8; }
        if (RPM == 2500) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 8.3;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 7.8;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 111;  P20_GPH_DWN = 7.5;M20_BHP_UPP = 72;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 7.9;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 111;  STD_GPH_UPP = 7.5;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 110;  P20_GPH_UPP = 7.2; }
        if (RPM == 2400) {M20_BHP_DWN = 68;  M20_KTAS_DWN = 107;  M20_GPH_DWN = 7.5;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 107;  STD_GPH_DWN = 7.2;   P20_BHP_DWN = 61;  P20_KTAS_DWN = 106;  P20_GPH_DWN = 6.9;M20_BHP_UPP = 65;  M20_KTAS_UPP = 107;  M20_GPH_UPP = 7.3;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 106;  STD_GPH_UPP = 6.9;   P20_BHP_UPP = 58;  P20_KTAS_UPP = 104;  P20_GPH_UPP = 6.7; }
        if (RPM == 2300) {M20_BHP_DWN = 61;  M20_KTAS_DWN = 102;  M20_GPH_DWN = 6.9;   STD_BHP_DWN = 58;  STD_KTAS_DWN = 101;  STD_GPH_DWN = 6.7;   P20_BHP_DWN = 55;  P20_KTAS_DWN = 99;  P20_GPH_DWN = 6.5;M20_BHP_UPP = 58;  M20_KTAS_UPP = 101;  M20_GPH_UPP = 6.7;   STD_BHP_UPP = 55;  STD_KTAS_UPP = 100;  STD_GPH_UPP = 6.5;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 98;  P20_GPH_UPP = 6.3; }
        if (RPM == 2200) {M20_BHP_DWN = 55;  M20_KTAS_DWN = 96;  M20_GPH_DWN = 6.4;   STD_BHP_DWN = 52;  STD_KTAS_DWN = 95;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 93;  P20_GPH_DWN = 6.1;M20_BHP_UPP = 52;  M20_KTAS_UPP = 95;  M20_GPH_UPP = 6.3;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 93;  STD_GPH_UPP = 6.1;   P20_BHP_UPP = 47;  P20_KTAS_UPP = 92;  P20_GPH_UPP = 5.9; }        
        
        
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 113;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 113;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.8;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 8.3;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 116;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2550) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 113;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 113;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.8;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 8.3;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 116;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 8.3;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 7.8;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 111;  P20_GPH_DWN2 = 7.5;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 7.9;   STD_BHP_UPP2 = 68;  STD_KTAS_UPP2 = 111;  STD_GPH_UPP2 = 7.5;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 110;  P20_GPH_UPP2 = 7.2; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 68;  M20_KTAS_DWN2 = 107;  M20_GPH_DWN2 = 7.5;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 107;  STD_GPH_DWN2 = 7.2;   P20_BHP_DWN2 = 61;  P20_KTAS_DWN2 = 106;  P20_GPH_DWN2 = 6.9;M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 107;  M20_GPH_UPP2 = 7.3;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 106;  STD_GPH_UPP2 = 6.9;   P20_BHP_UPP2 = 58;  P20_KTAS_UPP2 = 104;  P20_GPH_UPP2 = 6.7; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 61;  M20_KTAS_DWN2 = 102;  M20_GPH_DWN2 = 6.9;   STD_BHP_DWN2 = 58;  STD_KTAS_DWN2 = 101;  STD_GPH_DWN2 = 6.7;   P20_BHP_DWN2 = 55;  P20_KTAS_DWN2 = 99;  P20_GPH_DWN2 = 6.5;M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 101;  M20_GPH_UPP2 = 6.7;   STD_BHP_UPP2 = 55;  STD_KTAS_UPP2 = 100;  STD_GPH_UPP2 = 6.5;   P20_BHP_UPP2 = 53;  P20_KTAS_UPP2 = 98;  P20_GPH_UPP2 = 6.3; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 55;  M20_KTAS_DWN2 = 96;  M20_GPH_DWN2 = 6.4;   STD_BHP_DWN2 = 52;  STD_KTAS_DWN2 = 95;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 93;  P20_GPH_DWN2 = 6.1;M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 95;  M20_GPH_UPP2 = 6.3;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 93;  STD_GPH_UPP2 = 6.1;   P20_BHP_UPP2 = 47;  P20_KTAS_UPP2 = 92;  P20_GPH_UPP2 = 5.9; }  
        
        
        
        
    } // end if Pressue Alt zwischen 2000 und 4000
    
    
    
    
    
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        
        PressAltAbzug = 4000;
        
        //NSLog (@"Hello 4000");
        
        if (RPM == 2650) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 116;  STD_GPH_DWN = 8.3;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 116;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 80;  M20_KTAS_UPP = 118;  M20_GPH_UPP = 8.8;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 8;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 7.8; }
        if (RPM == 2600) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 116;  STD_GPH_DWN = 8.3;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 116;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 76;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 7.9;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.5; }
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 7.9;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 7.5;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 110;  P20_GPH_DWN = 7.2;M20_BHP_UPP = 69;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 7.6;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 110;  STD_GPH_UPP = 7.2;   P20_BHP_UPP = 62;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 7; }
        if (RPM == 2400) {M20_BHP_DWN = 65;  M20_KTAS_DWN = 107;  M20_GPH_DWN = 7.3;   STD_BHP_DWN = 61;  STD_KTAS_DWN = 106;  STD_GPH_DWN = 6.9;   P20_BHP_DWN = 58;  P20_KTAS_DWN = 104;  P20_GPH_DWN = 6.7;M20_BHP_UPP = 62;  M20_KTAS_UPP = 106;  M20_GPH_UPP = 7;   STD_BHP_UPP = 59;  STD_KTAS_UPP = 104;  STD_GPH_UPP = 6.7;   P20_BHP_UPP = 56;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 6.5; }
        if (RPM == 2300) {M20_BHP_DWN = 58;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 6.7;   STD_BHP_DWN = 55;  STD_KTAS_DWN = 100;  STD_GPH_DWN = 6.5;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 98;  P20_GPH_DWN = 6.3;M20_BHP_UPP = 56;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 6.5;   STD_BHP_UPP = 53;  STD_KTAS_UPP = 98;  STD_GPH_UPP = 6.3;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 97;  P20_GPH_UPP = 6.1; }
        if (RPM == 2200) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 95;  M20_GPH_DWN = 6.3;   STD_BHP_DWN = 49;  STD_KTAS_DWN = 93;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 47;  P20_KTAS_DWN = 92;  P20_GPH_DWN = 5.9;M20_BHP_UPP = 50;  M20_KTAS_UPP = 94;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 47;  STD_KTAS_UPP = 92;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 45;  P20_KTAS_UPP = 91;  P20_GPH_UPP = 5.8; } 
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 116;  STD_GPH_DWN2 = 8.3;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 116;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 118;  M20_GPH_UPP2 = 8.8;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 8;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 116;  STD_GPH_DWN2 = 8.3;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 116;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 7.9;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.5; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 7.9;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 7.5;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 110;  P20_GPH_DWN2 = 7.2;M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 7.6;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 110;  STD_GPH_UPP2 = 7.2;   P20_BHP_UPP2 = 62;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 7; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 107;  M20_GPH_DWN2 = 7.3;   STD_BHP_DWN2 = 61;  STD_KTAS_DWN2 = 106;  STD_GPH_DWN2 = 6.9;   P20_BHP_DWN2 = 58;  P20_KTAS_DWN2 = 104;  P20_GPH_DWN2 = 6.7;M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 106;  M20_GPH_UPP2 = 7;   STD_BHP_UPP2 = 59;  STD_KTAS_UPP2 = 104;  STD_GPH_UPP2 = 6.7;   P20_BHP_UPP2 = 56;  P20_KTAS_UPP2 = 103;  P20_GPH_UPP2 = 6.5; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 6.7;   STD_BHP_DWN2 = 55;  STD_KTAS_DWN2 = 100;  STD_GPH_DWN2 = 6.5;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 98;  P20_GPH_DWN2 = 6.3;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 6.5;   STD_BHP_UPP2 = 53;  STD_KTAS_UPP2 = 98;  STD_GPH_UPP2 = 6.3;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 97;  P20_GPH_UPP2 = 6.1; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 95;  M20_GPH_DWN2 = 6.3;   STD_BHP_DWN2 = 49;  STD_KTAS_DWN2 = 93;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 47;  P20_KTAS_DWN2 = 92;  P20_GPH_DWN2 = 5.9;M20_BHP_UPP2 = 50;  M20_KTAS_UPP2 = 94;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 47;  STD_KTAS_UPP2 = 92;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 45;  P20_KTAS_UPP2 = 91;  P20_GPH_UPP2 = 5.8; }
        
        
        
    } // end if Pressue Alt zwischen 4000 und 6000
    
    
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000) {
        
        //NSLog (@"Hello 6000");
        
        PressAltAbzug = 6000;
        
        
        if (RPM == 2650) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 118;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 8;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 80;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 8.8;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 8.3;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 120;  P20_GPH_UPP = 7.8; }
        if (RPM == 2600) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.3;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 116;  STD_GPH_DWN = 7.9;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 7.5;M20_BHP_UPP = 72;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 115;  STD_GPH_UPP = 7.5;   P20_BHP_UPP = 65;  P20_KTAS_UPP = 114;  P20_GPH_UPP = 7.3; }
        if (RPM == 2500) {M20_BHP_DWN = 69;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 7.6;   STD_BHP_DWN = 65;  STD_KTAS_DWN = 110;  STD_GPH_DWN = 7.2;   P20_BHP_DWN = 62;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 7;M20_BHP_UPP = 65;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 7.3;   STD_BHP_UPP = 62;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 7;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 108;  P20_GPH_UPP = 6.8; }
        if (RPM == 2400) {M20_BHP_DWN = 62;  M20_KTAS_DWN = 106;  M20_GPH_DWN = 7;   STD_BHP_DWN = 59;  STD_KTAS_DWN = 104;  STD_GPH_DWN = 6.7;   P20_BHP_DWN = 56;  P20_KTAS_DWN = 103;  P20_GPH_DWN = 6.5;M20_BHP_UPP = 59;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 6.8;   STD_BHP_UPP = 56;  STD_KTAS_UPP = 103;  STD_GPH_UPP = 6.6;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 101;  P20_GPH_UPP = 6.3; }
        if (RPM == 2300) {M20_BHP_DWN = 56;  M20_KTAS_DWN = 100;  M20_GPH_DWN = 6.5;   STD_BHP_DWN = 53;  STD_KTAS_DWN = 98;  STD_GPH_DWN = 6.3;   P20_BHP_DWN = 50;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 6.1;M20_BHP_UPP = 54;  M20_KTAS_UPP = 99;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 97;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 48;  P20_KTAS_UPP = 96;  P20_GPH_UPP = 6; }
        if (RPM == 2200) {M20_BHP_DWN = 50;  M20_KTAS_DWN = 94;  M20_GPH_DWN = 6.1;   STD_BHP_DWN = 47;  STD_KTAS_DWN = 92;  STD_GPH_DWN = 5.9;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 91;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 48;  M20_KTAS_UPP = 93;  M20_GPH_UPP = 6;   STD_BHP_UPP = 45;  STD_KTAS_UPP = 91;  STD_GPH_UPP = 5.8;   P20_BHP_UPP = 43;  P20_KTAS_UPP = 90;  P20_GPH_UPP = 5.7; }
        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 118;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 8;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 8.8;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 8.3;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 120;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.3;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 116;  STD_GPH_DWN2 = 7.9;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 7.5;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8;   STD_BHP_UPP2 = 68;  STD_KTAS_UPP2 = 115;  STD_GPH_UPP2 = 7.5;   P20_BHP_UPP2 = 65;  P20_KTAS_UPP2 = 114;  P20_GPH_UPP2 = 7.3; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 69;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 7.6;   STD_BHP_DWN2 = 65;  STD_KTAS_DWN2 = 110;  STD_GPH_DWN2 = 7.2;   P20_BHP_DWN2 = 62;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 7;M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 7.3;   STD_BHP_UPP2 = 62;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 7;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 108;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 62;  M20_KTAS_DWN2 = 106;  M20_GPH_DWN2 = 7;   STD_BHP_DWN2 = 59;  STD_KTAS_DWN2 = 104;  STD_GPH_DWN2 = 6.7;   P20_BHP_DWN2 = 56;  P20_KTAS_DWN2 = 103;  P20_GPH_DWN2 = 6.5;M20_BHP_UPP2 = 59;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 6.8;   STD_BHP_UPP2 = 56;  STD_KTAS_UPP2 = 103;  STD_GPH_UPP2 = 6.6;   P20_BHP_UPP2 = 53;  P20_KTAS_UPP2 = 101;  P20_GPH_UPP2 = 6.3; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 56;  M20_KTAS_DWN2 = 100;  M20_GPH_DWN2 = 6.5;   STD_BHP_DWN2 = 53;  STD_KTAS_DWN2 = 98;  STD_GPH_DWN2 = 6.3;   P20_BHP_DWN2 = 50;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 6.1;M20_BHP_UPP2 = 54;  M20_KTAS_UPP2 = 99;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 97;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 48;  P20_KTAS_UPP2 = 96;  P20_GPH_UPP2 = 6; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 50;  M20_KTAS_DWN2 = 94;  M20_GPH_DWN2 = 6.1;   STD_BHP_DWN2 = 47;  STD_KTAS_DWN2 = 92;  STD_GPH_DWN2 = 5.9;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 91;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 48;  M20_KTAS_UPP2 = 93;  M20_GPH_UPP2 = 6;   STD_BHP_UPP2 = 45;  STD_KTAS_UPP2 = 91;  STD_GPH_UPP2 = 5.8;   P20_BHP_UPP2 = 43;  P20_KTAS_UPP2 = 90;  P20_GPH_UPP2 = 5.7; }
        
        
        
        
        
    } // end if Pressue Alt zwischen 6000 und 8000
    
    
    
    
    
    
    
    
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        
        //NSLog (@"Hello 8000");
        
        PressAltAbzug = 8000;
        
        
        
        
        if (RPM == 2700) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 8.3;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 120;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 76;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 8.4;   STD_BHP_UPP = 72;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 7.9;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 119;  P20_GPH_UPP = 7.6; }
        if (RPM == 2600) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 7.5;   P20_BHP_DWN = 65;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 7.3;M20_BHP_UPP = 69;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 7.6;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 7.3;   P20_BHP_UPP = 62;  P20_KTAS_UPP = 112;  P20_GPH_UPP = 7; }
        if (RPM == 2500) {M20_BHP_DWN = 65;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 7.3;   STD_BHP_DWN = 62;  STD_KTAS_DWN = 109;  STD_GPH_DWN = 7;   P20_BHP_DWN = 59;  P20_KTAS_DWN = 108;  P20_GPH_DWN = 6.8;M20_BHP_UPP = 63;  M20_KTAS_UPP = 110;  M20_GPH_UPP = 7.1;   STD_BHP_UPP = 59;  STD_KTAS_UPP = 108;  STD_GPH_UPP = 6.8;   P20_BHP_UPP = 56;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 6.6; }
        if (RPM == 2400) {M20_BHP_DWN = 59;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 6.8;   STD_BHP_DWN = 56;  STD_KTAS_DWN = 103;  STD_GPH_DWN = 6.6;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 6.3;M20_BHP_UPP = 57;  M20_KTAS_UPP = 104;  M20_GPH_UPP = 6.6;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 102;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 100;  P20_GPH_UPP = 6.2; }
        if (RPM == 2300) {M20_BHP_DWN = 54;  M20_KTAS_DWN = 99;  M20_GPH_DWN = 6.4;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 97;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 48;  P20_KTAS_DWN = 96;  P20_GPH_DWN = 6;M20_BHP_UPP = 51;  M20_KTAS_UPP = 97;  M20_GPH_UPP = 6.2;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 94;  STD_GPH_UPP = 6;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 95;  P20_GPH_UPP = 5.8; }
        if (RPM == 2200) {M20_BHP_DWN = 48;  M20_KTAS_DWN = 93;  M20_GPH_DWN = 6;   STD_BHP_DWN = 45;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 43;  P20_KTAS_DWN = 90;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 46;  M20_KTAS_UPP = 92;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 43;  STD_KTAS_UPP = 90;  STD_GPH_UPP = 5.7;   P20_BHP_UPP = 41;  P20_KTAS_UPP = 89;  P20_GPH_UPP = 5.5; }
        
        
        if (RPM_HIGH == 2700) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 8.3;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 120;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 8.4;   STD_BHP_UPP2 = 72;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 7.9;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 119;  P20_GPH_UPP2 = 7.6; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 7.5;   P20_BHP_DWN2 = 65;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 7.3;M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 7.6;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 7.3;   P20_BHP_UPP2 = 62;  P20_KTAS_UPP2 = 112;  P20_GPH_UPP2 = 7; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 7.3;   STD_BHP_DWN2 = 62;  STD_KTAS_DWN2 = 109;  STD_GPH_DWN2 = 7;   P20_BHP_DWN2 = 59;  P20_KTAS_DWN2 = 108;  P20_GPH_DWN2 = 6.8;M20_BHP_UPP2 = 63;  M20_KTAS_UPP2 = 110;  M20_GPH_UPP2 = 7.1;   STD_BHP_UPP2 = 59;  STD_KTAS_UPP2 = 108;  STD_GPH_UPP2 = 6.8;   P20_BHP_UPP2 = 56;  P20_KTAS_UPP2 = 103;  P20_GPH_UPP2 = 6.6; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 59;  M20_KTAS_DWN2 = 105;  M20_GPH_DWN2 = 6.8;   STD_BHP_DWN2 = 56;  STD_KTAS_DWN2 = 103;  STD_GPH_DWN2 = 6.6;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 6.3;M20_BHP_UPP2 = 57;  M20_KTAS_UPP2 = 104;  M20_GPH_UPP2 = 6.6;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 102;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 100;  P20_GPH_UPP2 = 6.2; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 54;  M20_KTAS_DWN2 = 99;  M20_GPH_DWN2 = 6.4;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 97;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 48;  P20_KTAS_DWN2 = 96;  P20_GPH_DWN2 = 6;M20_BHP_UPP2 = 51;  M20_KTAS_UPP2 = 97;  M20_GPH_UPP2 = 6.2;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 94;  STD_GPH_UPP2 = 6;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 95;  P20_GPH_UPP2 = 5.8; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 48;  M20_KTAS_DWN2 = 93;  M20_GPH_DWN2 = 6;   STD_BHP_DWN2 = 45;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 5.8;   P20_BHP_DWN2 = 43;  P20_KTAS_DWN2 = 90;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 46;  M20_KTAS_UPP2 = 92;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 43;  STD_KTAS_UPP2 = 90;  STD_GPH_UPP2 = 5.7;   P20_BHP_UPP2 = 41;  P20_KTAS_UPP2 = 89;  P20_GPH_UPP2 = 5.5; }      
        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    
    if (PressureAltitude >= 10000 & PressureAltitude <= 12000) {
        
        //NSLog (@"Hello 10000");
        
        PressAltAbzug = 10000;
        
        if (RPM == 2700) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 8.4;   STD_BHP_DWN = 72;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 7.9;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 119;  P20_GPH_DWN = 7.6;M20_BHP_UPP = 69;  M20_KTAS_UPP = 117;  M20_GPH_UPP = 7.6;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 7.3;   P20_BHP_UPP = 62;  P20_KTAS_UPP = 114;  P20_GPH_UPP = 7; }
        if (RPM == 2600) {M20_BHP_DWN = 69;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 7.6;   STD_BHP_DWN = 65;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 7.3;   P20_BHP_DWN = 62;  P20_KTAS_DWN = 112;  P20_GPH_DWN = 7;M20_BHP_UPP = 66;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 7.4;   STD_BHP_UPP = 62;  STD_KTAS_UPP = 113;  STD_GPH_UPP = 7;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 6.8; }
        if (RPM == 2500) {M20_BHP_DWN = 63;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 7.1;   STD_BHP_DWN = 59;  STD_KTAS_DWN = 108;  STD_GPH_DWN = 6.8;   P20_BHP_DWN = 56;  P20_KTAS_DWN = 103;  P20_GPH_DWN = 6.6;M20_BHP_UPP = 60;  M20_KTAS_UPP = 108;  M20_GPH_UPP = 6.8;   STD_BHP_UPP = 57;  STD_KTAS_UPP = 106;  STD_GPH_UPP = 6.6;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 105;  P20_GPH_UPP = 6.4; }
        if (RPM == 2400) {M20_BHP_DWN = 57;  M20_KTAS_DWN = 104;  M20_GPH_DWN = 6.6;   STD_BHP_DWN = 54;  STD_KTAS_DWN = 102;  STD_GPH_DWN = 6.4;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 100;  P20_GPH_DWN = 6.2;M20_BHP_UPP = 54;  M20_KTAS_UPP = 102;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 100;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 99;  P20_GPH_UPP = 6; }
        if (RPM == 2300) {M20_BHP_DWN = 51;  M20_KTAS_DWN = 97;  M20_GPH_DWN = 6.2;   STD_BHP_DWN = 48;  STD_KTAS_DWN = 94;  STD_GPH_DWN = 6;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 49;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 6;   STD_BHP_UPP = 46;  STD_KTAS_UPP = 95;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 43;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 5.7; }
        if (RPM == 2200) {M20_BHP_DWN = 46;  M20_KTAS_DWN = 92;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 43;  STD_KTAS_DWN = 90;  STD_GPH_DWN = 5.7;   P20_BHP_DWN = 41;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 5.5;M20_BHP_UPP = 44;  M20_KTAS_UPP = 91;  M20_GPH_UPP = 5.7;   STD_BHP_UPP = 41;  STD_KTAS_UPP = 89;  STD_GPH_UPP = 5.5;   P20_BHP_UPP = 38;  P20_KTAS_UPP = 88;  P20_GPH_UPP = 5.3; }        
        
        
        
        
        if (RPM_HIGH == 2700) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 8.4;   STD_BHP_DWN2 = 72;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 7.9;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 119;  P20_GPH_DWN2 = 7.6;M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 117;  M20_GPH_UPP2 = 7.6;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 7.3;   P20_BHP_UPP2 = 62;  P20_KTAS_UPP2 = 114;  P20_GPH_UPP2 = 7; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 69;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 7.6;   STD_BHP_DWN2 = 65;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 7.3;   P20_BHP_DWN2 = 62;  P20_KTAS_DWN2 = 112;  P20_GPH_DWN2 = 7;M20_BHP_UPP2 = 66;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 7.4;   STD_BHP_UPP2 = 62;  STD_KTAS_UPP2 = 113;  STD_GPH_UPP2 = 7;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 63;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 7.1;   STD_BHP_DWN2 = 59;  STD_KTAS_DWN2 = 108;  STD_GPH_DWN2 = 6.8;   P20_BHP_DWN2 = 56;  P20_KTAS_DWN2 = 103;  P20_GPH_DWN2 = 6.6;M20_BHP_UPP2 = 60;  M20_KTAS_UPP2 = 108;  M20_GPH_UPP2 = 6.8;   STD_BHP_UPP2 = 57;  STD_KTAS_UPP2 = 106;  STD_GPH_UPP2 = 6.6;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 105;  P20_GPH_UPP2 = 6.4; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 57;  M20_KTAS_DWN2 = 104;  M20_GPH_DWN2 = 6.6;   STD_BHP_DWN2 = 54;  STD_KTAS_DWN2 = 102;  STD_GPH_DWN2 = 6.4;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 100;  P20_GPH_DWN2 = 6.2;M20_BHP_UPP2 = 54;  M20_KTAS_UPP2 = 102;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 100;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 49;  P20_KTAS_UPP2 = 99;  P20_GPH_UPP2 = 6; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 51;  M20_KTAS_DWN2 = 97;  M20_GPH_DWN2 = 6.2;   STD_BHP_DWN2 = 48;  STD_KTAS_DWN2 = 94;  STD_GPH_DWN2 = 6;   P20_BHP_DWN2 = 46;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 6;   STD_BHP_UPP2 = 46;  STD_KTAS_UPP2 = 95;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 43;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 5.7; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 46;  M20_KTAS_DWN2 = 92;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 43;  STD_KTAS_DWN2 = 90;  STD_GPH_DWN2 = 5.7;   P20_BHP_DWN2 = 41;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 5.5;M20_BHP_UPP2 = 44;  M20_KTAS_UPP2 = 91;  M20_GPH_UPP2 = 5.7;   STD_BHP_UPP2 = 41;  STD_KTAS_UPP2 = 89;  STD_GPH_UPP2 = 5.5;   P20_BHP_UPP2 = 38;  P20_KTAS_UPP2 = 88;  P20_GPH_UPP2 = 5.3; }
        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    // interpolate RPM
    
    M20_BHP_DWN_MED = M20_BHP_DWN + ((M20_BHP_DWN2 - M20_BHP_DWN ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_BHP_UPP_MED = M20_BHP_UPP + ((M20_BHP_UPP2 - M20_BHP_UPP ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    
    
    M20_KTAS_DWN_MED = M20_KTAS_DWN + ((M20_KTAS_DWN2 - M20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_KTAS_UPP_MED = M20_KTAS_UPP + ((M20_KTAS_UPP2 - M20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    M20_GPH_DWN_MED = M20_GPH_DWN + ((M20_GPH_DWN2 - M20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_GPH_UPP_MED = M20_GPH_UPP + ((M20_GPH_UPP2 - M20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_BHP_DWN_MED = STD_BHP_DWN + ((STD_BHP_DWN2 - STD_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_BHP_UPP_MED = STD_BHP_UPP + ((STD_BHP_UPP2 - STD_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_KTAS_DWN_MED = STD_KTAS_DWN + ((STD_KTAS_DWN2 - STD_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_KTAS_UPP_MED = STD_KTAS_UPP + ((STD_KTAS_UPP2 - STD_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_GPH_DWN_MED = STD_GPH_DWN + ((STD_GPH_DWN2 - STD_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_GPH_UPP_MED = STD_GPH_UPP + ((STD_GPH_UPP2 - STD_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_BHP_DWN_MED = P20_BHP_DWN + ((P20_BHP_DWN2 - P20_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_BHP_UPP_MED = P20_BHP_UPP + ((P20_BHP_UPP2 - P20_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_KTAS_DWN_MED = P20_KTAS_DWN + ((P20_KTAS_DWN2 - P20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_KTAS_UPP_MED = P20_KTAS_UPP + ((P20_KTAS_UPP2 - P20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_GPH_DWN_MED = P20_GPH_DWN + ((P20_GPH_DWN2 - P20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_GPH_UPP_MED = P20_GPH_UPP + ((P20_GPH_UPP2 - P20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    temp = ISAdiff;
    //NSLog(@"temp = %.1f ", temp);
    
    // interpolate temperature
    
    if (temp >= 0 & temp <= 20) {
        
        low_BHP     = STD_BHP_DWN_MED      - (( (STD_BHP_DWN_MED   - P20_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED     - (( (STD_KTAS_DWN_MED  - P20_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED      - (( (STD_GPH_DWN_MED   - P20_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        high_BHP    = STD_BHP_UPP_MED     - (( (STD_BHP_UPP_MED   - P20_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS   = STD_KTAS_UPP_MED    - (( (STD_KTAS_UPP_MED  - P20_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED     - (( (STD_GPH_UPP_MED   - P20_GPH_UPP_MED)  / 20 ) * temp) ;
        
        
        
        
    }
    
    
    
    if (temp < 0 & temp >= -20) {
        
        low_BHP     = STD_BHP_DWN_MED   - (( (M20_BHP_DWN_MED   - STD_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED  - (( (M20_KTAS_DWN_MED  - STD_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED   - (( (M20_GPH_DWN_MED   - STD_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        
        high_BHP   = STD_BHP_UPP_MED    - (( (M20_BHP_UPP_MED   - STD_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS  = STD_KTAS_UPP_MED   - (( (M20_KTAS_UPP_MED  - STD_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED   - (( (M20_GPH_UPP_MED   - STD_GPH_UPP_MED)  / 20 ) * temp) ;
    }
    
    
    
    // interpolate for PRESSURE ALT    
    resultCruiseBHP =    low_BHP -  ( ((low_BHP - high_BHP) / 2000) * (PressureAltitude - PressAltAbzug) );
    resultCruiseKTAS =  low_KTAS -  ( ((low_KTAS - high_KTAS) / 2000) * (PressureAltitude - PressAltAbzug) );    
    resultCruiseFuelBurn =    low_GPH -  ( ((low_GPH - high_GPH) / 2000) * (PressureAltitude - PressAltAbzug) );
    
    //NSLog(@"RPM %f", RPM);
    //NSLog(@"resultCruiseBHP %f", resultCruiseBHP);
    
    return;
    
    
}


// C172 P **************************************************************************************************

- (void) shortfiedlC172PInterpolationToACWEight {
    
    
    if (ACweightLBS >= 2000 & ACweightLBS < 2200) {          
        
        GroundRolltoWeight = GrndRollShortField_interpolated + ( ( (GrndRollShortField_interpolated2400 - GrndRollShortField_interpolated)/200 ) * (ACweightLBS-2000))  ;
        
        totalToClear = ObstClearance_interpolated + ( ( (ObstClearance_interpolated2400 - ObstClearance_interpolated)/200 ) * (ACweightLBS-2000))  ;
        
        liftoffspeed = 44 +  ( 0.02 * (ACweightLBS-2000));
        
    } 
    
    
    
    if (ACweightLBS >= 2200 & ACweightLBS <= 2400) {
        
        GroundRolltoWeight = GrndRollShortField_interpolated2400 + ( ( (GrndRollShortField_interpolated2550 - GrndRollShortField_interpolated2400)/200 ) * (ACweightLBS-2200))  ;        
        
        totalToClear = ObstClearance_interpolated2400 + ( ( (ObstClearance_interpolated2550 - ObstClearance_interpolated2400)/200 ) * (ACweightLBS-2200))  ;        
        
        liftoffspeed = 48 +  ( 0.02 * (ACweightLBS-2200));
        
    } 
    
    
}
- (void) shortfieldC172P_2550 { // high
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 795; cl_0_low = 1460;    gR_10_low = 860; cl_10_low = 1570;   gR_20_low = 925; cl_20_low = 1685;   gR_30_low = 995; cl_30_low = 1810;   gR_40_low = 1065; cl_40_low = 1945;   
        gR_0_hig = 875; cl_0_hig = 1605;    gR_10_hig = 940; cl_10_hig = 1725;   gR_20_hig = 1015; cl_20_hig = 1880;   gR_30_hig = 1090; cl_30_hig = 2000;   gR_40_hig = 1170; cl_40_hig = 2155; 
        
        PAlevelShortfield = 0;
        
        
     
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 875; cl_0_low = 1605;    gR_10_low = 940; cl_10_low = 1725;   gR_20_low = 1015; cl_20_low = 1880;   gR_30_low = 1090; cl_30_low = 2000;   gR_40_low = 1170; cl_40_low = 2155;   
        gR_0_hig = 960; cl_0_hig = 1770;    gR_10_hig = 1035; cl_10_hig = 1910;   gR_20_hig = 1115; cl_20_hig = 2060;   gR_30_hig = 1200; cl_30_hig = 2220;   gR_40_hig = 1290; cl_40_hig = 2395; 
        
        PAlevelShortfield = 1000;
        
    
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 960; cl_0_low = 1770;    gR_10_low = 1035; cl_10_low = 1910;   gR_20_low = 1115; cl_20_low = 2060;   gR_30_low = 1200; cl_30_low = 2220;   gR_40_low = 1290; cl_40_low = 2395;   
        gR_0_hig = 1055; cl_0_hig = 1960;    gR_10_hig = 1140; cl_10_hig = 2120;   gR_20_hig = 1230; cl_20_hig = 2295;   gR_30_hig = 1325; cl_30_hig = 2480;   gR_40_hig = 1425; cl_40_hig = 2685; 
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
     
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 1055; cl_0_low = 1960;    gR_10_low = 1140; cl_10_low = 2120;   gR_20_low = 1230; cl_20_low = 2295;   gR_30_low = 1325; cl_30_low = 2480;   gR_40_low = 1425; cl_40_low = 2685;   
        gR_0_hig = 1165; cl_0_hig = 2185;    gR_10_hig = 1260; cl_10_hig = 2365;   gR_20_hig = 1355; cl_20_hig = 2570;   gR_30_hig = 1465; cl_30_hig = 2790;   gR_40_hig = 1575; cl_40_hig = 3030;  
        
        PAlevelShortfield = 3000;
        
           
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1165; cl_0_low = 2185;    gR_10_low = 1260; cl_10_low = 2365;   gR_20_low = 1355; cl_20_low = 2570;   gR_30_low = 1465; cl_30_low = 2790;   gR_40_low = 1575; cl_40_low = 3030;   
        gR_0_hig = 1285; cl_0_hig = 2445;    gR_10_hig = 1390; cl_10_hig = 2660;   gR_20_hig = 1500; cl_20_hig = 2895;   gR_30_hig = 1620; cl_30_hig = 3160;   gR_40_hig = 1745; cl_40_hig = 3455;  
        
        PAlevelShortfield = 4000;
        
            
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1285; cl_0_low = 2445;    gR_10_low = 1390; cl_10_low = 2660;   gR_20_low = 1500; cl_20_low = 2895;   gR_30_low = 1620; cl_30_low = 3160;   gR_40_low = 1745; cl_40_low = 3455;   
        gR_0_hig = 1425; cl_0_hig = 2755;    gR_10_hig = 1540; cl_10_hig = 3015;   gR_20_hig = 1665; cl_20_hig = 3300;   gR_30_hig = 1800; cl_30_hig = 3620;   gR_40_hig = 1940; cl_40_hig = 3990;         
        PAlevelShortfield = 5000;
        
     
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1425; cl_0_low = 2755;    gR_10_low = 1540; cl_10_low = 3015;   gR_20_low = 1665; cl_20_low = 3300;   gR_30_low = 1800; cl_30_low = 3620;   gR_40_low = 1940; cl_40_low = 3990;   
        gR_0_hig = 1580; cl_0_hig = 3140;    gR_10_hig = 1710; cl_10_hig = 3450;   gR_20_hig = 1850; cl_20_hig = 3805;   gR_30_hig = 2000; cl_30_hig = 4220;   gR_40_hig = 1940; cl_40_hig = 3990; 
        
        PAlevelShortfield = 6000;
        
       
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1580; cl_0_low = 3140;    gR_10_low = 1710; cl_10_low = 3450;   gR_20_low = 1850; cl_20_low = 3805;   gR_30_low = 2000; cl_30_low = 4220;   gR_40_low = 1940; cl_40_low = 3990;   
        gR_0_hig = 1756; cl_0_hig = 3615;    gR_10_hig = 1905; cl_10_hig = 4015;   gR_20_hig = 2060; cl_20_hig = 4480;   gR_30_hig = 2000; cl_30_hig = 4220;   gR_40_hig = 1940; cl_40_hig = 3990;  
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
      
        
        
    } // end if  
    
    
      [self shortfield2550C172_interpolation];   
    
    return;
    
} // end void
- (void) shortfield2550C172_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_12550 = gR_0_low + ( (gR_0_hig -  gR_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue));
        
        
        ObstClearance_12550 = cl_0_low + ( (cl_0_hig -  cl_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue));
        
        
    }  
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 20) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_12550 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue -10 ));
        
        
        ObstClearance_12550 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue -10 ));
        
        
        
    } 
    
    
    if (sliderOATvalue >= 20 & sliderOATvalue < 30) {
        
        GrndRollShortField_12550 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue -20 ));
        
        
        ObstClearance_12550 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue -20 ));
        
        
    } 
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_12550 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_40_low + ( (gR_40_hig -  gR_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_12550 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_40_low + ( (cl_40_hig -  cl_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue -30 ));
        
        
        
    } 
    
    
    
    
    return;
    
    
    
} 
- (void) shortfieldC172P_2400 { // middle
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 650; cl_0_low = 1195;    gR_10_low = 700; cl_10_low = 1280;   gR_20_low = 750; cl_20_low = 1375;   gR_30_low = 805; cl_30_low = 1470;   gR_40_low = 865; cl_40_low = 1575;   
        gR_0_hig = 710; cl_0_hig = 1310;    gR_10_hig = 765; cl_10_hig = 1405;   gR_20_hig = 825; cl_20_hig = 1510;   gR_30_hig = 885; cl_30_hig = 1615;   gR_40_hig = 950; cl_40_hig = 1735;  
        
        PAlevelShortfield = 0;
        
        
     
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 710; cl_0_low = 1310;    gR_10_low = 765; cl_10_low = 1405;   gR_20_low = 825; cl_20_low = 1510;   gR_30_low = 885; cl_30_low = 1615;   gR_40_low = 950; cl_40_low = 1735;   
        gR_0_hig = 780; cl_0_hig = 1440;    gR_10_hig = 840; cl_10_hig = 1545;   gR_20_hig = 905; cl_20_hig = 1660;   gR_30_hig = 975; cl_30_hig = 1785;   gR_40_hig = 1045; cl_40_hig = 1915;  
        
        PAlevelShortfield = 1000;
      
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 780; cl_0_low = 1440;    gR_10_low = 840; cl_10_low = 1545;   gR_20_low = 905; cl_20_low = 1660;   gR_30_low = 975; cl_30_low = 1785;   gR_40_low = 1045; cl_40_low = 1915;   
        gR_0_hig = 855; cl_0_hig = 1585;    gR_10_hig = 925; cl_10_hig = 1705;   gR_20_hig = 995; cl_20_hig = 1835;   gR_30_hig = 1070; cl_30_hig = 1975;   gR_40_hig = 1150; cl_40_hig = 2130; 
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
       
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 855; cl_0_low = 1585;    gR_10_low = 925; cl_10_low = 1705;   gR_20_low = 995; cl_20_low = 1835;   gR_30_low = 1070; cl_30_low = 1975;   gR_40_low = 1150; cl_40_low = 2130;   
        gR_0_hig = 945; cl_0_hig = 1750;    gR_10_hig = 1020; cl_10_hig = 1890;   gR_20_hig = 1100; cl_20_hig = 2040;   gR_30_hig = 1180; cl_30_hig = 2200;   gR_40_hig = 1270; cl_40_hig = 2375;  
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
           
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 945; cl_0_low = 1750;    gR_10_low = 1020; cl_10_low = 1890;   gR_20_low = 1100; cl_20_low = 2040;   gR_30_low = 1180; cl_30_low = 2200;   gR_40_low = 1270; cl_40_low = 2375;   
        gR_0_hig = 1040; cl_0_hig = 1945;    gR_10_hig = 1125; cl_10_hig = 2105;   gR_20_hig = 1210; cl_20_hig = 2275;   gR_30_hig = 1305; cl_30_hig = 2465;   gR_40_hig = 1405; cl_40_hig = 2665; 
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
           
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1040; cl_0_low = 1945;    gR_10_low = 1125; cl_10_low = 2105;   gR_20_low = 1210; cl_20_low = 2275;   gR_30_low = 1305; cl_30_low = 2465;   gR_40_low = 1405; cl_40_low = 2665;   
        gR_0_hig = 1150; cl_0_hig = 2170;    gR_10_hig = 1240; cl_10_hig = 2355;   gR_20_hig = 1340; cl_20_hig = 2555;   gR_30_hig = 1445; cl_30_hig = 2775;   gR_40_hig = 1555; cl_40_hig = 3020;  
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
  
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1150; cl_0_low = 2170;    gR_10_low = 1240; cl_10_low = 2355;   gR_20_low = 1340; cl_20_low = 2555;   gR_30_low = 1445; cl_30_low = 2775;   gR_40_low = 1555; cl_40_low = 3020;   
        gR_0_hig = 1270; cl_0_hig = 2440;    gR_10_hig = 1375; cl_10_hig = 2655;   gR_20_hig = 1485; cl_20_hig = 2890;   gR_30_hig = 1605; cl_30_hig = 3155;   gR_40_hig = 1730; cl_40_hig = 3450; 
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
        
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1270; cl_0_low = 2440;    gR_10_low = 1375; cl_10_low = 2655;   gR_20_low = 1485; cl_20_low = 2890;   gR_30_low = 1605; cl_30_low = 3155;   gR_40_low = 1730; cl_40_low = 3450;   
        gR_0_hig = 1410; cl_0_hig = 2760;    gR_10_hig = 1525; cl_10_hig = 3015;   gR_20_hig = 1650; cl_20_hig = 3305;   gR_30_hig = 1785; cl_30_hig = 3630;   gR_40_hig = 1925; cl_40_hig = 4005; 
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
       
        
        
    } // end if  
    
     [self shortfield2400C172_interpolation];  
    
    
    
    
    return;
    
} // end void
- (void) shortfield2400C172_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_12400 = gR_0_low + ( (gR_0_hig -  gR_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue));
        
        
        ObstClearance_12400 = cl_0_low + ( (cl_0_hig -  cl_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue));
        
        
    }  
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 20) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_12400 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue -10 ));
        
        
        ObstClearance_12400 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue -10 ));
        
        
        
    } 
    
    
    if (sliderOATvalue >= 20 & sliderOATvalue < 30) {
        
        GrndRollShortField_12400 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue -20 ));
        
        
        ObstClearance_12400 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue -20 ));
        
        
    } 
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_12400 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_40_low + ( (gR_40_hig -  gR_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_12400 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_40_low + ( (cl_40_hig -  cl_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue -30 ));
        
        
        
    } 
    
    
    
    
    return;
    
    
    
} // end interpol
- (void) shortfield_LandingC172P {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_lowLD = 510; cl_0_lowLD = 1235;    gR_10_lowLD = 530; cl_10_lowLD = 1265;   gR_20_lowLD = 550; cl_20_lowLD = 1295;   gR_30_lowLD = 570; cl_30_lowLD = 1325;   gR_40_lowLD = 585; cl_40_lowLD = 1350;   gR_0_higLD = 530; cl_0_higLD = 1265;    gR_10_higLD = 550; cl_10_higLD = 1295;   gR_20_higLD = 570; cl_20_higLD = 1325;   gR_30_higLD = 590; cl_30_higLD = 1360;   gR_40_higLD = 610; cl_40_higLD = 1390; 
        
        
        PAlevelShortfieldLD = 0;
  
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_lowLD = 530; cl_0_lowLD = 1265;    gR_10_lowLD = 550; cl_10_lowLD = 1295;   gR_20_lowLD = 570; cl_20_lowLD = 1325;   gR_30_lowLD = 590; cl_30_lowLD = 1360;   gR_40_lowLD = 610; cl_40_lowLD = 1390;   gR_0_higLD = 550; cl_0_higLD = 1295;    gR_10_higLD = 570; cl_10_higLD = 1330;   gR_20_higLD = 590; cl_20_higLD = 1360;   gR_30_higLD = 610; cl_30_higLD = 1390;   gR_40_higLD = 630; cl_40_higLD = 1425;  
        
        PAlevelShortfieldLD = 1000;
        
 
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_lowLD = 550; cl_0_lowLD = 1295;    gR_10_lowLD = 570; cl_10_lowLD = 1330;   gR_20_lowLD = 590; cl_20_lowLD = 1360;   gR_30_lowLD = 610; cl_30_lowLD = 1390;   gR_40_lowLD = 630; cl_40_lowLD = 1425;   gR_0_higLD = 570; cl_0_higLD = 1330;    gR_10_higLD = 590; cl_10_higLD = 1360;   gR_20_higLD = 615; cl_20_higLD = 1395;   gR_30_higLD = 635; cl_30_higLD = 1460;   gR_40_higLD = 655; cl_40_higLD = 1460; 
        
        PAlevelShortfieldLD = 2000;
      
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_lowLD = 570; cl_0_lowLD = 1330;    gR_10_lowLD = 590; cl_10_lowLD = 1360;   gR_20_lowLD = 615; cl_20_lowLD = 1395;   gR_30_lowLD = 635; cl_30_lowLD = 1460;   gR_40_lowLD = 655; cl_40_lowLD = 1460;   gR_0_higLD = 595; cl_0_higLD = 1365;    gR_10_higLD = 615; cl_10_higLD = 1400;   gR_20_higLD = 635; cl_20_higLD = 1430;   gR_30_higLD = 660; cl_30_higLD = 1470;   gR_40_higLD = 680; cl_40_higLD = 1500;        
        PAlevelShortfieldLD = 3000;

    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_lowLD = 595; cl_0_lowLD = 1365;    gR_10_lowLD = 615; cl_10_lowLD = 1400;   gR_20_lowLD = 635; cl_20_lowLD = 1430;   gR_30_lowLD = 660; cl_30_lowLD = 1470;   gR_40_lowLD = 680; cl_40_lowLD = 1500;   gR_0_higLD = 615; cl_0_higLD = 1400;    gR_10_higLD = 640; cl_10_higLD = 1435;   gR_20_higLD = 660; cl_20_higLD = 1470;   gR_30_higLD = 685; cl_30_higLD = 1510;   gR_40_higLD = 705; cl_40_higLD = 1540;  
        
        PAlevelShortfieldLD = 4000;
           
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_lowLD = 615; cl_0_lowLD = 1400;    gR_10_lowLD = 640; cl_10_lowLD = 1435;   gR_20_lowLD = 660; cl_20_lowLD = 1470;   gR_30_lowLD = 685; cl_30_lowLD = 1510;   gR_40_lowLD = 705; cl_40_lowLD = 1540;   gR_0_higLD = 640; cl_0_higLD = 1435;    gR_10_higLD = 660; cl_10_higLD = 1470;   gR_20_higLD = 685; cl_20_higLD = 1510;   gR_30_higLD = 710; cl_30_higLD = 1550;   gR_40_higLD = 730; cl_40_higLD = 1580; 
        
        PAlevelShortfieldLD = 5000;
    
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 640; cl_0_lowLD = 1435;    gR_10_lowLD = 660; cl_10_lowLD = 1470;   gR_20_lowLD = 685; cl_20_lowLD = 1510;   gR_30_lowLD = 710; cl_30_lowLD = 1550;   gR_40_lowLD = 730; cl_40_lowLD = 1580;   gR_0_higLD = 665; cl_0_higLD = 1475;    gR_10_higLD = 690; cl_10_higLD = 1515;   gR_20_higLD = 710; cl_20_higLD = 1550;   gR_30_higLD = 735; cl_30_higLD = 1590;   gR_40_higLD = 760; cl_40_higLD = 1630; 
        
        PAlevelShortfieldLD = 6000;
        
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 665; cl_0_lowLD = 1475;    gR_10_lowLD = 690; cl_10_lowLD = 1515;   gR_20_lowLD = 710; cl_20_lowLD = 1550;   gR_30_lowLD = 735; cl_30_lowLD = 1590;   gR_40_lowLD = 760; cl_40_lowLD = 1630;   gR_0_higLD = 690; cl_0_higLD = 1515;    gR_10_higLD = 715; cl_10_higLD = 1555;   gR_20_higLD = 740; cl_20_higLD = 1595;   gR_30_higLD = 765; cl_30_higLD = 1635;   gR_40_higLD = 790; cl_40_higLD = 1675; 
        
        PAlevelShortfieldLD = 7000;
        
        
        
    } // end if  
    
 
    
    
   
    
    
    return;
    
} // end void
- (void) calculate_ClimbC172P {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {
        
        climb_low2  = 76; RoC_low2   = 700; time_low2   = 0; fuel_low2   = 0;    distNM_low2   = 0; 
        climb_high2 = 76; RoC_high2  = 655; time_high2  = 1; fuel_high2  = 0.3;    distNM_high2   = 2; PAlevel2 = 0;        
        
    }
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        climb_low2  = 76; RoC_low2   = 655; time_low2   = 1; fuel_low2   = 0.3;    distNM_low2   = 2; PAlevel2 = 1000;   
        climb_high2 = 75; RoC_high2  = 610; time_high2  = 3; fuel_high2  = 0.6;    distNM_high2   = 4; PAlevel2 = 1000;
        
    }
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        climb_low2  = 75; RoC_low2   = 610; time_low2   = 3; fuel_low2   = 0.6;    distNM_low2   = 4; PAlevel2 = 2000;   
        climb_high2 = 75; RoC_high2  = 560; time_high2  = 5; fuel_high2  = 1;    distNM_high2   = 6; PAlevel2 = 2000;
        
    }
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        climb_low2  = 75; RoC_low2   = 560; time_low2   = 5; fuel_low2   = 1;    distNM_low2   = 6; PAlevel2 = 3000;   
        climb_high2 = 74; RoC_high2  = 515; time_high2  = 7; fuel_high2  = 1.4;    distNM_high2   = 9; PAlevel2 = 3000;
        
    }
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        climb_low2  = 74; RoC_low2   = 515; time_low2   = 7; fuel_low2   = 1.4;    distNM_low2   = 9; PAlevel2 = 4000;   
        climb_high2 = 74; RoC_high2  = 470; time_high2  = 9; fuel_high2  = 1.7;    distNM_high2   = 11; PAlevel2 = 4000;
        
    }
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        climb_low2  = 74; RoC_low2   = 470; time_low2   = 9; fuel_low2   = 1.7;    distNM_low2   = 11; PAlevel2 = 5000;   
        climb_high2 = 73; RoC_high2  = 425; time_high2  = 11; fuel_high2  = 2.2;    distNM_high2   = 14; PAlevel2 = 5000;
        
    }
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        climb_low2  = 73; RoC_low2   = 425; time_low2   = 11; fuel_low2   = 2.2;    distNM_low2   = 14; PAlevel2 = 6000;   
        climb_high2 = 72; RoC_high2  = 375; time_high2  = 14; fuel_high2  = 2.6;    distNM_high2   = 18; PAlevel2 = 6000;
        
    }
    
    if (PressureAltitude >=7000 & PressureAltitude < 8000) {
        
        climb_low2  = 72; RoC_low2   = 375; time_low2   = 14; fuel_low2   = 2.6;    distNM_low2   = 18; PAlevel2 = 7000;   
        climb_high2 = 72; RoC_high2  = 330; time_high2  = 17; fuel_high2  = 3.1;    distNM_high2   = 22; PAlevel2 = 7000;
        
    }
    
    if (PressureAltitude >=8000 & PressureAltitude < 9000) {
        
        climb_low2  = 72; RoC_low2   = 330; time_low2   = 17; fuel_low2   = 3.1;    distNM_low2   = 22; PAlevel2 = 8000;   
        climb_high2 = 71; RoC_high2  = 285; time_high2  = 20; fuel_high2  = 3.6;    distNM_high2   = 26; PAlevel2 = 8000;
        
    }
    
    
    if (PressureAltitude >=9000 & PressureAltitude < 10000) {
        climb_low2  = 71; RoC_low2   = 285; time_low2   = 20; fuel_low2   = 3.6;    distNM_low2   = 26; PAlevel2 = 9000;   
        climb_high2 = 71; RoC_high2  = 240; time_high2  = 24; fuel_high2  = 4.2;    distNM_high2   = 32; PAlevel2 = 9000;       
        
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 11000) {
        
        climb_low2  = 71; RoC_low2   = 240; time_low2   = 24; fuel_low2   = 4.2;    distNM_low2   = 32; PAlevel2 = 10000;   
        climb_high2 = 70; RoC_high2  = 190; time_high2  = 29; fuel_high2  = 4.9;    distNM_high2   = 38; PAlevel2 = 10000;        
        
    }
    
    if (PressureAltitude >=11000 & PressureAltitude < 12000) {
        
        climb_low2  = 70; RoC_low2   = 190; time_low2   = 29; fuel_low2   = 4.9;    distNM_low2   = 38; PAlevel2 = 11000;   
        climb_high2 = 70; RoC_high2  = 145; time_high2  = 35; fuel_high2  = 5.8;    distNM_high2   = 47; PAlevel2 = 11000;
        
    }
    
    
    if (PressureAltitude >=12000 ) {
        
        climb_low2  = 70; RoC_low2   = 145; time_low2   = 35; fuel_low2   = 5.8;    distNM_low2   = 47; PAlevel2 = 12000;   
        climb_high2 = 70; RoC_high2  = 145; time_high2  = 35; fuel_high2  = 5.8;    distNM_high2   = 47; PAlevel2 = 12000;        
        
    }
    
    [self interpolateClimbC172S];
}
- (void) InterpolateCruiseValuesC172P {
    
    
    RPM = engineRPMcruise;
    
    // define RPM  high and low
    
    if (RPM >= 2100 & RPM < 2200) {
        RPM_LOW = 2100; RPM_HIGH = 2200;
    }
    
    if (RPM >= 2200 & RPM < 2300) {
        RPM_LOW = 2200; RPM_HIGH = 2300;
    }
    
    if (RPM >= 2300 & RPM < 2400) {
        RPM_LOW = 2300; RPM_HIGH = 2400;
    }
    
    if (RPM >= 2400 & RPM < 2500) {
        RPM_LOW = 2400; RPM_HIGH = 2500;
    }
    
    if (RPM >= 2500 & RPM < 2600) {
        RPM_LOW = 2500; RPM_HIGH = 2600;
    }
    
    if (RPM >= 2600 & RPM <= 2700) {
        RPM_LOW = 2600; RPM_HIGH = 2700;
    }
    
    if (RPM >= 2600 & RPM <= 2700 & PressureAltitude > 11999) {
        RPM_LOW = 2600; RPM_HIGH = 2650;
    }
    
    
    //NSLog (@"RPM_LOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_LOW]);    
    //NSLog (@"RPM_HIGH %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_HIGH]);
    
    
    
    // get RPM
    
    if (PressureAltitude < 2001) {
        PressureAltitude = 2001;
    }
    
    if (PressureAltitude > 11999) {
        PressureAltitude = 12000;
    }
    
    
    if (PressureAltitude >= 2000 & PressureAltitude < 4000) {
        
        PressAltAbzug = 2000;
        
        
        //NSLog (@"Hello 2000");
        
        
        if (RPM == 2600) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 76;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 77;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 76;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 8.5;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 116;  P20_GPH_UPP = 8.1; }
        if (RPM == 2550) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 76;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 77;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 76;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 8.5;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 116;  P20_GPH_UPP = 8.1; }
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 76;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 77;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 73;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 8.1;   P20_BHP_UPP = 69;  P20_KTAS_UPP = 113;  P20_GPH_UPP = 7.7; }
        if (RPM == 2400) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 69;  STD_KTAS_DWN = 109;  STD_GPH_DWN = 7.7;   P20_BHP_DWN = 65;  P20_KTAS_DWN = 108;  P20_GPH_DWN = 7.3;M20_BHP_UPP = 69;  M20_KTAS_UPP = 109;  M20_GPH_UPP = 7.8;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 108;  STD_GPH_UPP = 7.3;   P20_BHP_UPP = 62;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 7; }
        if (RPM == 2300) {M20_BHP_DWN = 65;  M20_KTAS_DWN = 104;  M20_GPH_DWN = 7.3;   STD_BHP_DWN = 62;  STD_KTAS_DWN = 103;  STD_GPH_DWN = 6.9;   P20_BHP_DWN = 59;  P20_KTAS_DWN = 102;  P20_GPH_DWN = 6.6;M20_BHP_UPP = 62;  M20_KTAS_UPP = 104;  M20_GPH_UPP = 7;   STD_BHP_UPP = 59;  STD_KTAS_UPP = 102;  STD_GPH_UPP = 6.6;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 101;  P20_GPH_UPP = 6.4; }
        if (RPM == 2200) {M20_BHP_DWN = 58;  M20_KTAS_DWN = 99;  M20_GPH_DWN = 6.6;   STD_BHP_DWN = 55;  STD_KTAS_DWN = 97;  STD_GPH_DWN = 6.3;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 96;  P20_GPH_DWN = 6.1;M20_BHP_UPP = 56;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.3;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 6.1;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 5.9; }
        if (RPM == 2100) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 92;  M20_GPH_DWN = 6;   STD_BHP_DWN = 50;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 48;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 51;  M20_KTAS_UPP = 91;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 89;  STD_GPH_UPP = 5.7;   P20_BHP_UPP = 47;  P20_KTAS_UPP = 88;  P20_GPH_UPP = 5.5; }     
        
        
        
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 76;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 77;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 76;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 8.5;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 116;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2550) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 76;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 77;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 76;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 8.5;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 116;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 76;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 77;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 73;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 8.1;   P20_BHP_UPP2 = 69;  P20_KTAS_UPP2 = 113;  P20_GPH_UPP2 = 7.7; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 69;  STD_KTAS_DWN2 = 109;  STD_GPH_DWN2 = 7.7;   P20_BHP_DWN2 = 65;  P20_KTAS_DWN2 = 108;  P20_GPH_DWN2 = 7.3;M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 109;  M20_GPH_UPP2 = 7.8;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 108;  STD_GPH_UPP2 = 7.3;   P20_BHP_UPP2 = 62;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 7; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 104;  M20_GPH_DWN2 = 7.3;   STD_BHP_DWN2 = 62;  STD_KTAS_DWN2 = 103;  STD_GPH_DWN2 = 6.9;   P20_BHP_DWN2 = 59;  P20_KTAS_DWN2 = 102;  P20_GPH_DWN2 = 6.6;M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 104;  M20_GPH_UPP2 = 7;   STD_BHP_UPP2 = 59;  STD_KTAS_UPP2 = 102;  STD_GPH_UPP2 = 6.6;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 101;  P20_GPH_UPP2 = 6.4; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 99;  M20_GPH_DWN2 = 6.6;   STD_BHP_DWN2 = 55;  STD_KTAS_DWN2 = 97;  STD_GPH_DWN2 = 6.3;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 96;  P20_GPH_DWN2 = 6.1;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.3;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 6.1;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 5.9; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 92;  M20_GPH_DWN2 = 6;   STD_BHP_DWN2 = 50;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 5.8;   P20_BHP_DWN2 = 48;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 51;  M20_KTAS_UPP2 = 91;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 89;  STD_GPH_UPP2 = 5.7;   P20_BHP_UPP2 = 47;  P20_KTAS_UPP2 = 88;  P20_GPH_UPP2 = 5.5; }   
        
        
        
        
    } // end if Pressue Alt zwischen 2000 und 4000
    
    
    
    
    
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        
        PressAltAbzug = 4000;
        
        //NSLog (@"Hello 4000");
        
        if (RPM == 2600) {M20_BHP_DWN = 77;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 76;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 116;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 73;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 8.2;   STD_BHP_UPP = 77;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 8.6;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 8.1; }
        if (RPM == 2550) {M20_BHP_DWN = 77;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 76;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 116;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 73;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 8.2;   STD_BHP_UPP = 77;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 8.6;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 8.1; }
        if (RPM == 2500) {M20_BHP_DWN = 77;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 73;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 8.1;   P20_BHP_DWN = 69;  P20_KTAS_DWN = 113;  P20_GPH_DWN = 7.7;M20_BHP_UPP = 73;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 8.2;   STD_BHP_UPP = 69;  STD_KTAS_UPP = 113;  STD_GPH_UPP = 7.8;   P20_BHP_UPP = 66;  P20_KTAS_UPP = 112;  P20_GPH_UPP = 7.4; }
        if (RPM == 2400) {M20_BHP_DWN = 69;  M20_KTAS_DWN = 109;  M20_GPH_DWN = 7.8;   STD_BHP_DWN = 65;  STD_KTAS_DWN = 108;  STD_GPH_DWN = 7.3;   P20_BHP_DWN = 62;  P20_KTAS_DWN = 107;  P20_GPH_DWN = 7;M20_BHP_UPP = 66;  M20_KTAS_UPP = 108;  M20_GPH_UPP = 7.4;   STD_BHP_UPP = 63;  STD_KTAS_UPP = 107;  STD_GPH_UPP = 7;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 106;  P20_GPH_UPP = 6.7; }
        if (RPM == 2300) {M20_BHP_DWN = 62;  M20_KTAS_DWN = 104;  M20_GPH_DWN = 7;   STD_BHP_DWN = 59;  STD_KTAS_DWN = 102;  STD_GPH_DWN = 6.6;   P20_BHP_DWN = 57;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 6.4;M20_BHP_UPP = 60;  M20_KTAS_UPP = 103;  M20_GPH_UPP = 6.7;   STD_BHP_UPP = 57;  STD_KTAS_UPP = 101;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 56;  P20_KTAS_UPP = 99;  P20_GPH_UPP = 6.2; }
        if (RPM == 2200) {M20_BHP_DWN = 56;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 6.3;   STD_BHP_DWN = 54;  STD_KTAS_DWN = 96;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 94;  P20_GPH_DWN = 5.9;M20_BHP_UPP = 54;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 52;  STD_KTAS_UPP = 95;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 92;  P20_GPH_UPP = 5.8; }
        if (RPM == 2100) {M20_BHP_DWN = 51;  M20_KTAS_DWN = 91;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 48;  STD_KTAS_DWN = 89;  STD_GPH_DWN = 5.7;   P20_BHP_DWN = 47;  P20_KTAS_DWN = 88;  P20_GPH_DWN = 5.5;M20_BHP_UPP = 49;  M20_KTAS_UPP = 90;  M20_GPH_UPP = 5.7;   STD_BHP_UPP = 47;  STD_KTAS_UPP = 88;  STD_GPH_UPP = 5.5;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 86;  P20_GPH_UPP = 5.5; } 
        
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 77;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 76;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 116;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 73;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 8.2;   STD_BHP_UPP2 = 77;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 8.6;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2550) {M20_BHP_DWN2 = 77;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 76;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 116;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 73;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 8.2;   STD_BHP_UPP2 = 77;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 8.6;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 77;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 73;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 8.1;   P20_BHP_DWN2 = 69;  P20_KTAS_DWN2 = 113;  P20_GPH_DWN2 = 7.7;M20_BHP_UPP2 = 73;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 8.2;   STD_BHP_UPP2 = 69;  STD_KTAS_UPP2 = 113;  STD_GPH_UPP2 = 7.8;   P20_BHP_UPP2 = 66;  P20_KTAS_UPP2 = 112;  P20_GPH_UPP2 = 7.4; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 69;  M20_KTAS_DWN2 = 109;  M20_GPH_DWN2 = 7.8;   STD_BHP_DWN2 = 65;  STD_KTAS_DWN2 = 108;  STD_GPH_DWN2 = 7.3;   P20_BHP_DWN2 = 62;  P20_KTAS_DWN2 = 107;  P20_GPH_DWN2 = 7;M20_BHP_UPP2 = 66;  M20_KTAS_UPP2 = 108;  M20_GPH_UPP2 = 7.4;   STD_BHP_UPP2 = 63;  STD_KTAS_UPP2 = 107;  STD_GPH_UPP2 = 7;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 106;  P20_GPH_UPP2 = 6.7; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 62;  M20_KTAS_DWN2 = 104;  M20_GPH_DWN2 = 7;   STD_BHP_DWN2 = 59;  STD_KTAS_DWN2 = 102;  STD_GPH_DWN2 = 6.6;   P20_BHP_DWN2 = 57;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 6.4;M20_BHP_UPP2 = 60;  M20_KTAS_UPP2 = 103;  M20_GPH_UPP2 = 6.7;   STD_BHP_UPP2 = 57;  STD_KTAS_UPP2 = 101;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 56;  P20_KTAS_UPP2 = 99;  P20_GPH_UPP2 = 6.2; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 56;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 6.3;   STD_BHP_DWN2 = 54;  STD_KTAS_DWN2 = 96;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 94;  P20_GPH_DWN2 = 5.9;M20_BHP_UPP2 = 54;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 52;  STD_KTAS_UPP2 = 95;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 92;  P20_GPH_UPP2 = 5.8; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 51;  M20_KTAS_DWN2 = 91;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 48;  STD_KTAS_DWN2 = 89;  STD_GPH_DWN2 = 5.7;   P20_BHP_DWN2 = 47;  P20_KTAS_DWN2 = 88;  P20_GPH_DWN2 = 5.5;M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 90;  M20_GPH_UPP2 = 5.7;   STD_BHP_UPP2 = 47;  STD_KTAS_UPP2 = 88;  STD_GPH_UPP2 = 5.5;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 86;  P20_GPH_UPP2 = 5.5; }
        
        
        
    } // end if Pressue Alt zwischen 4000 und 6000
    
    
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000) {
        
        //NSLog (@"Hello 6000");
        
        PressAltAbzug = 6000;
        
        
        if (RPM == 2650) {M20_BHP_DWN = 73;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 8.2;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 119;  STD_GPH_DWN = 8.6;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 77;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 8.7;   STD_BHP_UPP = 77;  STD_KTAS_UPP = 121;  STD_GPH_UPP = 8.6;   P20_BHP_UPP = 73;  P20_KTAS_UPP = 120;  P20_GPH_UPP = 8.1; }
        if (RPM == 2600) {M20_BHP_DWN = 73;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 8.2;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 119;  STD_GPH_DWN = 8.6;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 77;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 8.7;   STD_BHP_UPP = 73;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 8.2;   P20_BHP_UPP = 69;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 7.8; }
        if (RPM == 2500) {M20_BHP_DWN = 73;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 8.2;   STD_BHP_DWN = 69;  STD_KTAS_DWN = 113;  STD_GPH_DWN = 7.8;   P20_BHP_DWN = 66;  P20_KTAS_DWN = 112;  P20_GPH_DWN = 7.4;M20_BHP_UPP = 70;  M20_KTAS_UPP = 113;  M20_GPH_UPP = 7.8;   STD_BHP_UPP = 66;  STD_KTAS_UPP = 112;  STD_GPH_UPP = 7.4;   P20_BHP_UPP = 63;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 7.1; }
        if (RPM == 2400) {M20_BHP_DWN = 66;  M20_KTAS_DWN = 108;  M20_GPH_DWN = 7.4;   STD_BHP_DWN = 63;  STD_KTAS_DWN = 107;  STD_GPH_DWN = 7;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 106;  P20_GPH_DWN = 6.7;M20_BHP_UPP = 63;  M20_KTAS_UPP = 108;  M20_GPH_UPP = 7.1;   STD_BHP_UPP = 60;  STD_KTAS_UPP = 106;  STD_GPH_UPP = 6.7;   P20_BHP_UPP = 58;  P20_KTAS_UPP = 104;  P20_GPH_UPP = 6.5; }
        if (RPM == 2300) {M20_BHP_DWN = 60;  M20_KTAS_DWN = 103;  M20_GPH_DWN = 6.7;   STD_BHP_DWN = 57;  STD_KTAS_DWN = 101;  STD_GPH_DWN = 6.4;   P20_BHP_DWN = 56;  P20_KTAS_DWN = 99;  P20_GPH_DWN = 6.2;M20_BHP_UPP = 57;  M20_KTAS_UPP = 101;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 55;  STD_KTAS_UPP = 100;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 97;  P20_GPH_UPP = 6; }
        if (RPM == 2200) {M20_BHP_DWN = 54;  M20_KTAS_DWN = 96;  M20_GPH_DWN = 6.1;   STD_BHP_DWN = 52;  STD_KTAS_DWN = 95;  STD_GPH_DWN = 5.9;   P20_BHP_DWN = 50;  P20_KTAS_DWN = 92;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 52;  M20_KTAS_UPP = 95;  M20_GPH_UPP = 6;   STD_BHP_UPP = 50;  STD_KTAS_UPP = 93;  STD_GPH_UPP = 5.8;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 91;  P20_GPH_UPP = 5.7; }
        if (RPM == 2100) {M20_BHP_DWN = 49;  M20_KTAS_DWN = 90;  M20_GPH_DWN = 5.7;   STD_BHP_DWN = 47;  STD_KTAS_DWN = 88;  STD_GPH_DWN = 5.5;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 86;  P20_GPH_DWN = 5.5;M20_BHP_UPP = 52;  M20_KTAS_UPP = 95;  M20_GPH_UPP = 6;   STD_BHP_UPP = 50;  STD_KTAS_UPP = 93;  STD_GPH_UPP = 5.8;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 91;  P20_GPH_UPP = 5.7; }
        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 73;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 8.2;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 119;  STD_GPH_DWN2 = 8.6;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 77;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 8.7;   STD_BHP_UPP2 = 77;  STD_KTAS_UPP2 = 121;  STD_GPH_UPP2 = 8.6;   P20_BHP_UPP2 = 73;  P20_KTAS_UPP2 = 120;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 73;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 8.2;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 119;  STD_GPH_DWN2 = 8.6;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 77;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 8.7;   STD_BHP_UPP2 = 73;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 8.2;   P20_BHP_UPP2 = 69;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 73;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 8.2;   STD_BHP_DWN2 = 69;  STD_KTAS_DWN2 = 113;  STD_GPH_DWN2 = 7.8;   P20_BHP_DWN2 = 66;  P20_KTAS_DWN2 = 112;  P20_GPH_DWN2 = 7.4;M20_BHP_UPP2 = 70;  M20_KTAS_UPP2 = 113;  M20_GPH_UPP2 = 7.8;   STD_BHP_UPP2 = 66;  STD_KTAS_UPP2 = 112;  STD_GPH_UPP2 = 7.4;   P20_BHP_UPP2 = 63;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 7.1; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 66;  M20_KTAS_DWN2 = 108;  M20_GPH_DWN2 = 7.4;   STD_BHP_DWN2 = 63;  STD_KTAS_DWN2 = 107;  STD_GPH_DWN2 = 7;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 106;  P20_GPH_DWN2 = 6.7;M20_BHP_UPP2 = 63;  M20_KTAS_UPP2 = 108;  M20_GPH_UPP2 = 7.1;   STD_BHP_UPP2 = 60;  STD_KTAS_UPP2 = 106;  STD_GPH_UPP2 = 6.7;   P20_BHP_UPP2 = 58;  P20_KTAS_UPP2 = 104;  P20_GPH_UPP2 = 6.5; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 60;  M20_KTAS_DWN2 = 103;  M20_GPH_DWN2 = 6.7;   STD_BHP_DWN2 = 57;  STD_KTAS_DWN2 = 101;  STD_GPH_DWN2 = 6.4;   P20_BHP_DWN2 = 56;  P20_KTAS_DWN2 = 99;  P20_GPH_DWN2 = 6.2;M20_BHP_UPP2 = 57;  M20_KTAS_UPP2 = 101;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 55;  STD_KTAS_UPP2 = 100;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 53;  P20_KTAS_UPP2 = 97;  P20_GPH_UPP2 = 6; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 54;  M20_KTAS_DWN2 = 96;  M20_GPH_DWN2 = 6.1;   STD_BHP_DWN2 = 52;  STD_KTAS_DWN2 = 95;  STD_GPH_DWN2 = 5.9;   P20_BHP_DWN2 = 50;  P20_KTAS_DWN2 = 92;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 95;  M20_GPH_UPP2 = 6;   STD_BHP_UPP2 = 50;  STD_KTAS_UPP2 = 93;  STD_GPH_UPP2 = 5.8;   P20_BHP_UPP2 = 49;  P20_KTAS_UPP2 = 91;  P20_GPH_UPP2 = 5.7; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 49;  M20_KTAS_DWN2 = 90;  M20_GPH_DWN2 = 5.7;   STD_BHP_DWN2 = 47;  STD_KTAS_DWN2 = 88;  STD_GPH_DWN2 = 5.5;   P20_BHP_DWN2 = 46;  P20_KTAS_DWN2 = 86;  P20_GPH_DWN2 = 5.5;M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 95;  M20_GPH_UPP2 = 6;   STD_BHP_UPP2 = 50;  STD_KTAS_UPP2 = 93;  STD_GPH_UPP2 = 5.8;   P20_BHP_UPP2 = 49;  P20_KTAS_UPP2 = 91;  P20_GPH_UPP2 = 5.7; }
        
        
        
        
    } // end if Pressue Alt zwischen 6000 und 8000
    
    
    
    
    
    
    
    
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        
        //NSLog (@"Hello 8000");
        
        PressAltAbzug = 8000;
        
        
        
        
        if (RPM == 2650) {M20_BHP_DWN = 77;  M20_KTAS_DWN = 119;  M20_GPH_DWN = 8.7;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 121;  STD_GPH_DWN = 8.6;   P20_BHP_DWN = 73;  P20_KTAS_DWN = 120;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 74;  M20_KTAS_UPP = 118;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 70;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 7.8;   P20_BHP_UPP = 66;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.4; }
        if (RPM == 2600) {M20_BHP_DWN = 77;  M20_KTAS_DWN = 119;  M20_GPH_DWN = 8.7;   STD_BHP_DWN = 73;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 69;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 74;  M20_KTAS_UPP = 118;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 70;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 7.8;   P20_BHP_UPP = 66;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.4; }
        if (RPM == 2500) {M20_BHP_DWN = 70;  M20_KTAS_DWN = 113;  M20_GPH_DWN = 7.8;   STD_BHP_DWN = 66;  STD_KTAS_DWN = 112;  STD_GPH_DWN = 7.4;   P20_BHP_DWN = 63;  P20_KTAS_DWN = 111;  P20_GPH_DWN = 7.1;M20_BHP_UPP = 67;  M20_KTAS_UPP = 112;  M20_GPH_UPP = 7.5;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 111;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 6.8; }
        if (RPM == 2400) {M20_BHP_DWN = 63;  M20_KTAS_DWN = 108;  M20_GPH_DWN = 7.1;   STD_BHP_DWN = 60;  STD_KTAS_DWN = 106;  STD_GPH_DWN = 6.7;   P20_BHP_DWN = 58;  P20_KTAS_DWN = 104;  P20_GPH_DWN = 6.5;M20_BHP_UPP = 61;  M20_KTAS_UPP = 106;  M20_GPH_UPP = 6.8;   STD_BHP_UPP = 58;  STD_KTAS_UPP = 105;  STD_GPH_UPP = 6.5;   P20_BHP_UPP = 56;  P20_KTAS_UPP = 102;  P20_GPH_UPP = 6.3; }
        if (RPM == 2300) {M20_BHP_DWN = 57;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 6.4;   STD_BHP_DWN = 55;  STD_KTAS_DWN = 100;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 6;M20_BHP_UPP = 55;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 6.3;   STD_BHP_UPP = 53;  STD_KTAS_UPP = 98;  STD_GPH_UPP = 6;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 96;  P20_GPH_UPP = 5.9; }
        if (RPM == 2200) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 95;  M20_GPH_DWN = 6;   STD_BHP_DWN = 50;  STD_KTAS_DWN = 93;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 91;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 50;  M20_KTAS_UPP = 93;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 91;  STD_GPH_UPP = 5.7;   P20_BHP_UPP = 47;  P20_KTAS_UPP = 89;  P20_GPH_UPP = 5.6; }
        if (RPM == 2100) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 95;  M20_GPH_DWN = 6;   STD_BHP_DWN = 50;  STD_KTAS_DWN = 93;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 91;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 50;  M20_KTAS_UPP = 93;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 91;  STD_GPH_UPP = 5.7;   P20_BHP_UPP = 47;  P20_KTAS_UPP = 89;  P20_GPH_UPP = 5.6; }
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 77;  M20_KTAS_DWN2 = 119;  M20_GPH_DWN2 = 8.7;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 121;  STD_GPH_DWN2 = 8.6;   P20_BHP_DWN2 = 73;  P20_KTAS_DWN2 = 120;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 74;  M20_KTAS_UPP2 = 118;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 70;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 7.8;   P20_BHP_UPP2 = 66;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.4; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 77;  M20_KTAS_DWN2 = 119;  M20_GPH_DWN2 = 8.7;   STD_BHP_DWN2 = 73;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 69;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 74;  M20_KTAS_UPP2 = 118;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 70;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 7.8;   P20_BHP_UPP2 = 66;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.4; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 70;  M20_KTAS_DWN2 = 113;  M20_GPH_DWN2 = 7.8;   STD_BHP_DWN2 = 66;  STD_KTAS_DWN2 = 112;  STD_GPH_DWN2 = 7.4;   P20_BHP_DWN2 = 63;  P20_KTAS_DWN2 = 111;  P20_GPH_DWN2 = 7.1;M20_BHP_UPP2 = 67;  M20_KTAS_UPP2 = 112;  M20_GPH_UPP2 = 7.5;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 111;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 63;  M20_KTAS_DWN2 = 108;  M20_GPH_DWN2 = 7.1;   STD_BHP_DWN2 = 60;  STD_KTAS_DWN2 = 106;  STD_GPH_DWN2 = 6.7;   P20_BHP_DWN2 = 58;  P20_KTAS_DWN2 = 104;  P20_GPH_DWN2 = 6.5;M20_BHP_UPP2 = 61;  M20_KTAS_UPP2 = 106;  M20_GPH_UPP2 = 6.8;   STD_BHP_UPP2 = 58;  STD_KTAS_UPP2 = 105;  STD_GPH_UPP2 = 6.5;   P20_BHP_UPP2 = 56;  P20_KTAS_UPP2 = 102;  P20_GPH_UPP2 = 6.3; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 57;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 6.4;   STD_BHP_DWN2 = 55;  STD_KTAS_DWN2 = 100;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 6;M20_BHP_UPP2 = 55;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 6.3;   STD_BHP_UPP2 = 53;  STD_KTAS_UPP2 = 98;  STD_GPH_UPP2 = 6;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 96;  P20_GPH_UPP2 = 5.9; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 95;  M20_GPH_DWN2 = 6;   STD_BHP_DWN2 = 50;  STD_KTAS_DWN2 = 93;  STD_GPH_DWN2 = 5.8;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 91;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 50;  M20_KTAS_UPP2 = 93;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 91;  STD_GPH_UPP2 = 5.7;   P20_BHP_UPP2 = 47;  P20_KTAS_UPP2 = 89;  P20_GPH_UPP2 = 5.6; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 95;  M20_GPH_DWN2 = 6;   STD_BHP_DWN2 = 50;  STD_KTAS_DWN2 = 93;  STD_GPH_DWN2 = 5.8;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 91;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 50;  M20_KTAS_UPP2 = 93;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 91;  STD_GPH_UPP2 = 5.7;   P20_BHP_UPP2 = 47;  P20_KTAS_UPP2 = 89;  P20_GPH_UPP2 = 5.6; }        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    
    if (PressureAltitude >= 10000 & PressureAltitude <= 12000) {
        
        //NSLog (@"Hello 10000");
        
        PressAltAbzug = 10000;
        
        if (RPM == 2650) {M20_BHP_DWN = 74;  M20_KTAS_DWN = 118;  M20_GPH_DWN = 8.3;   STD_BHP_DWN = 70;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 7.8;   P20_BHP_DWN = 66;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 7.4;M20_BHP_UPP = 67;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 7.5;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 112;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 6.9; }
        if (RPM == 2600) {M20_BHP_DWN = 74;  M20_KTAS_DWN = 118;  M20_GPH_DWN = 8.3;   STD_BHP_DWN = 70;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 7.8;   P20_BHP_DWN = 66;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 7.4;M20_BHP_UPP = 67;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 7.5;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 112;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 6.9; }
        if (RPM == 2500) {M20_BHP_DWN = 67;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 7.5;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 7.1;   P20_BHP_DWN = 61;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 6.8;M20_BHP_UPP = 64;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 7.2;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 6.8;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 6.6; }
        if (RPM == 2400) {M20_BHP_DWN = 61;  M20_KTAS_DWN = 106;  M20_GPH_DWN = 6.8;   STD_BHP_DWN = 58;  STD_KTAS_DWN = 105;  STD_GPH_DWN = 6.5;   P20_BHP_DWN = 56;  P20_KTAS_DWN = 102;  P20_GPH_DWN = 6.3;M20_BHP_UPP = 59;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 6.6;   STD_BHP_UPP = 56;  STD_KTAS_UPP = 103;  STD_GPH_UPP = 6.3;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 100;  P20_GPH_UPP = 6.1; }
        if (RPM == 2300) {M20_BHP_DWN = 55;  M20_KTAS_DWN = 100;  M20_GPH_DWN = 6.3;   STD_BHP_DWN = 53;  STD_KTAS_DWN = 98;  STD_GPH_DWN = 6;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 96;  P20_GPH_DWN = 5.9;M20_BHP_UPP = 53;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 5.8; }
        if (RPM == 2200) {M20_BHP_DWN = 50;  M20_KTAS_DWN = 93;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 49;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 5.7;   P20_BHP_DWN = 47;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 5.6;M20_BHP_UPP = 53;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 5.8; }
        if (RPM == 2100) {M20_BHP_DWN = 50;  M20_KTAS_DWN = 93;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 49;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 5.7;   P20_BHP_DWN = 47;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 5.6;M20_BHP_UPP = 53;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 5.8; }        
        
        
        
        
        if (RPM_HIGH == 2650) {M20_BHP_DWN2 = 74;  M20_KTAS_DWN2 = 118;  M20_GPH_DWN2 = 8.3;   STD_BHP_DWN2 = 70;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 7.8;   P20_BHP_DWN2 = 66;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 7.4;M20_BHP_UPP2 = 67;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 7.5;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 112;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 6.9; }
        if (RPM_HIGH == 2600) {M20_BHP_DWN2 = 74;  M20_KTAS_DWN2 = 118;  M20_GPH_DWN2 = 8.3;   STD_BHP_DWN2 = 70;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 7.8;   P20_BHP_DWN2 = 66;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 7.4;M20_BHP_UPP2 = 67;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 7.5;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 112;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 6.9; }
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 67;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 7.5;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 7.1;   P20_BHP_DWN2 = 61;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 6.8;M20_BHP_UPP2 = 64;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 7.2;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 6.8;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 6.6; }
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 61;  M20_KTAS_DWN2 = 106;  M20_GPH_DWN2 = 6.8;   STD_BHP_DWN2 = 58;  STD_KTAS_DWN2 = 105;  STD_GPH_DWN2 = 6.5;   P20_BHP_DWN2 = 56;  P20_KTAS_DWN2 = 102;  P20_GPH_DWN2 = 6.3;M20_BHP_UPP2 = 59;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 6.6;   STD_BHP_UPP2 = 56;  STD_KTAS_UPP2 = 103;  STD_GPH_UPP2 = 6.3;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 100;  P20_GPH_UPP2 = 6.1; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 55;  M20_KTAS_DWN2 = 100;  M20_GPH_DWN2 = 6.3;   STD_BHP_DWN2 = 53;  STD_KTAS_DWN2 = 98;  STD_GPH_DWN2 = 6;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 96;  P20_GPH_DWN2 = 5.9;M20_BHP_UPP2 = 53;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 5.8; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 50;  M20_KTAS_DWN2 = 93;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 49;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 5.7;   P20_BHP_DWN2 = 47;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 5.6;M20_BHP_UPP2 = 53;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 5.8; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 50;  M20_KTAS_DWN2 = 93;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 49;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 5.7;   P20_BHP_DWN2 = 47;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 5.6;M20_BHP_UPP2 = 53;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 5.8; }
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    // interpolate RPM
    
    M20_BHP_DWN_MED = M20_BHP_DWN + ((M20_BHP_DWN2 - M20_BHP_DWN ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_BHP_UPP_MED = M20_BHP_UPP + ((M20_BHP_UPP2 - M20_BHP_UPP ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    
    
    M20_KTAS_DWN_MED = M20_KTAS_DWN + ((M20_KTAS_DWN2 - M20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_KTAS_UPP_MED = M20_KTAS_UPP + ((M20_KTAS_UPP2 - M20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    M20_GPH_DWN_MED = M20_GPH_DWN + ((M20_GPH_DWN2 - M20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_GPH_UPP_MED = M20_GPH_UPP + ((M20_GPH_UPP2 - M20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_BHP_DWN_MED = STD_BHP_DWN + ((STD_BHP_DWN2 - STD_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_BHP_UPP_MED = STD_BHP_UPP + ((STD_BHP_UPP2 - STD_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_KTAS_DWN_MED = STD_KTAS_DWN + ((STD_KTAS_DWN2 - STD_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_KTAS_UPP_MED = STD_KTAS_UPP + ((STD_KTAS_UPP2 - STD_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_GPH_DWN_MED = STD_GPH_DWN + ((STD_GPH_DWN2 - STD_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_GPH_UPP_MED = STD_GPH_UPP + ((STD_GPH_UPP2 - STD_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_BHP_DWN_MED = P20_BHP_DWN + ((P20_BHP_DWN2 - P20_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_BHP_UPP_MED = P20_BHP_UPP + ((P20_BHP_UPP2 - P20_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_KTAS_DWN_MED = P20_KTAS_DWN + ((P20_KTAS_DWN2 - P20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_KTAS_UPP_MED = P20_KTAS_UPP + ((P20_KTAS_UPP2 - P20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_GPH_DWN_MED = P20_GPH_DWN + ((P20_GPH_DWN2 - P20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_GPH_UPP_MED = P20_GPH_UPP + ((P20_GPH_UPP2 - P20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    temp = ISAdiff;
    //NSLog(@"temp = %.1f ", temp);
    
    // interpolate temperature
    
    if (temp >= 0 & temp <= 20) {
        
        low_BHP     = STD_BHP_DWN_MED      - (( (STD_BHP_DWN_MED   - P20_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED     - (( (STD_KTAS_DWN_MED  - P20_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED      - (( (STD_GPH_DWN_MED   - P20_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        high_BHP    = STD_BHP_UPP_MED     - (( (STD_BHP_UPP_MED   - P20_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS   = STD_KTAS_UPP_MED    - (( (STD_KTAS_UPP_MED  - P20_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED     - (( (STD_GPH_UPP_MED   - P20_GPH_UPP_MED)  / 20 ) * temp) ;
        
        
        
        
    }
    
    
    
    if (temp < 0 & temp >= -20) {
        
        low_BHP     = STD_BHP_DWN_MED   - (( (M20_BHP_DWN_MED   - STD_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED  - (( (M20_KTAS_DWN_MED  - STD_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED   - (( (M20_GPH_DWN_MED   - STD_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        
        high_BHP   = STD_BHP_UPP_MED    - (( (M20_BHP_UPP_MED   - STD_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS  = STD_KTAS_UPP_MED   - (( (M20_KTAS_UPP_MED  - STD_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED   - (( (M20_GPH_UPP_MED   - STD_GPH_UPP_MED)  / 20 ) * temp) ;
    }
    
    
    
    // interpolate for PRESSURE ALT    
    resultCruiseBHP =    low_BHP -  ( ((low_BHP - high_BHP) / 2000) * (PressureAltitude - PressAltAbzug) );
    resultCruiseKTAS =  low_KTAS -  ( ((low_KTAS - high_KTAS) / 2000) * (PressureAltitude - PressAltAbzug) );    
    resultCruiseFuelBurn =    low_GPH -  ( ((low_GPH - high_GPH) / 2000) * (PressureAltitude - PressAltAbzug) );
    
    //NSLog(@"RPM %f", RPM);
    //NSLog(@"resultCruiseBHP %f", resultCruiseBHP);
    
    return;
    
    
}

// C172 R **************************************************************************************************

- (void) shortfieldC172P_2200 {  // leichteste
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
        gR_0_low = 525; cl_0_low = 970;    gR_10_low = 565; cl_10_low = 1035;   gR_20_low = 605; cl_20_low = 1110;   gR_30_low = 650; cl_30_low = 1185;   gR_40_low = 695; cl_40_low = 1265;    
        gR_0_hig = 570; cl_0_hig = 1060;    gR_10_hig = 615; cl_10_hig = 1135;   gR_20_hig = 665; cl_20_hig = 1215;   gR_30_hig = 710; cl_30_hig = 1295;   gR_40_hig = 765; cl_40_hig = 1385; 
        
        PAlevelShortfield = 0;
        
        
        // interpolate ground roll
        
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 570; cl_0_low = 1060;    gR_10_low = 615; cl_10_low = 1135;   gR_20_low = 665; cl_20_low = 1215;   gR_30_low = 710; cl_30_low = 1295;   gR_40_low = 765; cl_40_low = 1385;    
        gR_0_hig = 625; cl_0_hig = 1160;    gR_10_hig = 675; cl_10_hig = 1240;   gR_20_hig = 725; cl_20_hig = 1330;   gR_30_hig = 780; cl_30_hig = 1425;   gR_40_hig = 840; cl_40_hig = 1525; 
        
        PAlevelShortfield = 1000;
        
        
      
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 625; cl_0_low = 1160;    gR_10_low = 675; cl_10_low = 1240;   gR_20_low = 725; cl_20_low = 1330;   gR_30_low = 780; cl_30_low = 1425;   gR_40_low = 840; cl_40_low = 1525;    
        gR_0_hig = 690; cl_0_hig = 1270;    gR_10_hig = 740; cl_10_hig = 1365;   gR_20_hig = 800; cl_20_hig = 1465;   gR_30_hig = 860; cl_30_hig = 1570;   gR_40_hig = 920; cl_40_hig = 1685;
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
        
     
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 690; cl_0_low = 1270;    gR_10_low = 740; cl_10_low = 1365;   gR_20_low = 800; cl_20_low = 1465;   gR_30_low = 860; cl_30_low = 1570;   gR_40_low = 920; cl_40_low = 1685;    
        gR_0_hig = 755; cl_0_hig = 1400;    gR_10_hig = 815; cl_10_hig = 1500;   gR_20_hig = 880; cl_20_hig = 1615;   gR_30_hig = 945; cl_30_hig = 1735;   gR_40_hig = 1015; cl_40_hig = 1865; 
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
        
           
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 755; cl_0_low = 1400;    gR_10_low = 815; cl_10_low = 1500;   gR_20_low = 880; cl_20_low = 1615;   gR_30_low = 945; cl_30_low = 1735;   gR_40_low = 1015; cl_40_low = 1865;    
        gR_0_hig = 830; cl_0_hig = 1545;    gR_10_hig = 900; cl_10_hig = 1660;   gR_20_hig = 970; cl_20_hig = 1790;   gR_30_hig = 1040; cl_30_hig = 1925;   gR_40_hig = 1120; cl_40_hig = 2070;  
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
        
       
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 830; cl_0_low = 1545;    gR_10_low = 900; cl_10_low = 1660;   gR_20_low = 970; cl_20_low = 1790;   gR_30_low = 1040; cl_30_low = 1925;   gR_40_low = 1120; cl_40_low = 2070;    
        gR_0_hig = 920; cl_0_hig = 1710;    gR_10_hig = 990; cl_10_hig = 1845;   gR_20_hig = 1070; cl_20_hig = 1990;   gR_30_hig = 1150; cl_30_hig = 2145;   gR_40_hig = 1235; cl_40_hig = 2315; 
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
        
      
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 920; cl_0_low = 1710;    gR_10_low = 990; cl_10_low = 1845;   gR_20_low = 1070; cl_20_low = 1990;   gR_30_low = 1150; cl_30_low = 2145;   gR_40_low = 1235; cl_40_low = 2315;    
        gR_0_hig = 1015; cl_0_hig = 1900;    gR_10_hig = 1095; cl_10_hig = 2055;   gR_20_hig = 1180; cl_20_hig = 2225;   gR_30_hig = 1275; cl_30_hig = 2405;   gR_40_hig = 1370; cl_40_hig = 2605; 
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
        
     
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1015; cl_0_low = 1900;    gR_10_low = 1095; cl_10_low = 2055;   gR_20_low = 1180; cl_20_low = 2225;   gR_30_low = 1275; cl_30_low = 2405;   gR_40_low = 1370; cl_40_low = 2605;    
        gR_0_hig = 1125; cl_0_hig = 2125;    gR_10_hig = 1215; cl_10_hig = 2305;   gR_20_hig = 1310; cl_20_hig = 2500;   gR_30_hig = 1410; cl_30_hig = 2716;   gR_40_hig = 1520; cl_40_hig = 2950; 
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
       
        
        
    } // end if  
    
    
    
     [self shortfield2200C172_interpolation];  
    
    
    
    return;
    
} 

- (void) shortfield_LandingC172R {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_lowLD = 525; cl_0_lowLD = 1250;    gR_10_lowLD = 540; cl_10_lowLD = 1280;   gR_20_lowLD = 560; cl_20_lowLD = 1310;   gR_30_lowLD = 580; cl_30_lowLD = 1340;   gR_40_lowLD = 600; cl_40_lowLD = 1370;   gR_0_higLD = 545; cl_0_higLD = 1280;    gR_10_higLD = 560; cl_10_higLD = 1310;   gR_20_higLD = 580; cl_20_higLD = 1345;   gR_30_higLD = 600; cl_30_higLD = 1375;   gR_40_higLD = 620; cl_40_higLD = 1405; 
        
        
        PAlevelShortfieldLD = 0;
       
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_lowLD = 545; cl_0_lowLD = 1280;    gR_10_lowLD = 560; cl_10_lowLD = 1310;   gR_20_lowLD = 580; cl_20_lowLD = 1345;   gR_30_lowLD = 600; cl_30_lowLD = 1375;   gR_40_lowLD = 620; cl_40_lowLD = 1405;   gR_0_higLD = 565; cl_0_higLD = 1310;    gR_10_higLD = 585; cl_10_higLD = 1345;   gR_20_higLD = 605; cl_20_higLD = 1375;   gR_30_higLD = 525; cl_30_higLD = 1410;   gR_40_higLD = 645; cl_40_higLD = 1440;
        
        
        PAlevelShortfieldLD = 1000;
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_lowLD = 565; cl_0_lowLD = 1310;    gR_10_lowLD = 585; cl_10_lowLD = 1345;   gR_20_lowLD = 605; cl_20_lowLD = 1375;   gR_30_lowLD = 525; cl_30_lowLD = 1410;   gR_40_lowLD = 645; cl_40_lowLD = 1440;   gR_0_higLD = 585; cl_0_higLD = 1345;    gR_10_higLD = 605; cl_10_higLD = 1380;   gR_20_higLD = 625; cl_20_higLD = 1415;   gR_30_higLD = 650; cl_30_higLD = 1445;   gR_40_higLD = 670; cl_40_higLD = 1480; 
        
        PAlevelShortfieldLD = 2000;
        
      
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_lowLD = 585; cl_0_lowLD = 1345;    gR_10_lowLD = 605; cl_10_lowLD = 1380;   gR_20_lowLD = 625; cl_20_lowLD = 1415;   gR_30_lowLD = 650; cl_30_lowLD = 1445;   gR_40_lowLD = 670; cl_40_lowLD = 1480;   gR_0_higLD = 605; cl_0_higLD = 1380;    gR_10_higLD = 630; cl_10_higLD = 1415;   gR_20_higLD = 650; cl_20_higLD = 1450;   gR_30_higLD = 670; cl_30_higLD = 1485;   gR_40_higLD = 695; cl_40_higLD = 1520;
        
        PAlevelShortfieldLD = 3000;
              
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_lowLD = 605; cl_0_lowLD = 1380;    gR_10_lowLD = 630; cl_10_lowLD = 1415;   gR_20_lowLD = 650; cl_20_lowLD = 1450;   gR_30_lowLD = 670; cl_30_lowLD = 1485;   gR_40_lowLD = 695; cl_40_lowLD = 1520;   gR_0_higLD = 630; cl_0_higLD = 1415;    gR_10_higLD = 650; cl_10_higLD = 1455;   gR_20_higLD = 675; cl_20_higLD = 1490;   gR_30_higLD = 700; cl_30_higLD = 1525;   gR_40_higLD = 720; cl_40_higLD = 1560; 
        
        PAlevelShortfieldLD = 4000;
        
  
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_lowLD = 630; cl_0_lowLD = 1415;    gR_10_lowLD = 650; cl_10_lowLD = 1455;   gR_20_lowLD = 675; cl_20_lowLD = 1490;   gR_30_lowLD = 700; cl_30_lowLD = 1525;   gR_40_lowLD = 720; cl_40_lowLD = 1560;   gR_0_higLD = 655; cl_0_higLD = 1455;    gR_10_higLD = 675; cl_10_higLD = 1490;   gR_20_higLD = 700; cl_20_higLD = 1530;   gR_30_higLD = 725; cl_30_higLD = 1565;   gR_40_higLD = 750; cl_40_higLD = 1605;  
        
        PAlevelShortfieldLD = 5000;
        
    
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 655; cl_0_lowLD = 1455;    gR_10_lowLD = 675; cl_10_lowLD = 1490;   gR_20_lowLD = 700; cl_20_lowLD = 1530;   gR_30_lowLD = 725; cl_30_lowLD = 1565;   gR_40_lowLD = 750; cl_40_lowLD = 1605;   gR_0_higLD = 680; cl_0_higLD = 1495;    gR_10_higLD = 705; cl_10_higLD = 1535;   gR_20_higLD = 730; cl_20_higLD = 1570;   gR_30_higLD = 755; cl_30_higLD = 1610;   gR_40_higLD = 775; cl_40_higLD = 1650;  
        
        PAlevelShortfieldLD = 6000;
        
  
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 680; cl_0_lowLD = 1495;    gR_10_lowLD = 705; cl_10_lowLD = 1535;   gR_20_lowLD = 730; cl_20_lowLD = 1570;   gR_30_lowLD = 755; cl_30_lowLD = 1610;   gR_40_lowLD = 775; cl_40_lowLD = 1650;   gR_0_higLD = 705; cl_0_higLD = 1535;    gR_10_higLD = 730; cl_10_higLD = 1575;   gR_20_higLD = 755; cl_20_higLD = 1615;   gR_30_higLD = 780; cl_30_higLD = 1655;   gR_40_higLD = 810; cl_40_higLD = 1695; 
        
        PAlevelShortfieldLD = 7000;
        
      
        
        
    } // end if  
    
    
    
    
    
    
    
    return;
    
} // end void
- (void) shortfiedC172RlInterpolationToACWEightC172R {
    
    
    
    
    
    GroundRolltoWeight = GrndRollShortField_interpolated ;
    
    
    
    
    
    totalToClear = ObstClearance_interpolated;
    
    
    
    liftoffspeed = 51;
    
    resultTODistancefeet = totalToClear;
    
    resultTOGroundRollfeet = GroundRolltoWeight;
    
    
    
    
    
    
    
    
    
    
}

- (void) shortfield_2450_C172R {  // leichteste
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        
        
        gR_0_low = 845; cl_0_low = 1510;    gR_10_low = 910; cl_10_low = 1625;   gR_20_low = 980; cl_20_low = 1745;   gR_30_low = 1055; cl_30_low = 1875;   gR_40_low = 1135; cl_40_low = 2015;   gR_0_hig = 925; cl_0_hig = 1660;    gR_10_hig = 1000; cl_10_hig = 1790;   gR_20_hig = 1075; cl_20_hig = 1925;   gR_30_hig = 1160; cl_30_hig = 2070;   gR_40_hig = 1245; cl_40_hig = 2220; 
        
        PAlevelShortfield = 0;
        
        
        // interpolate ground roll
      
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 925; cl_0_low = 1660;    gR_10_low = 1000; cl_10_low = 1790;   gR_20_low = 1075; cl_20_low = 1925;   gR_30_low = 1160; cl_30_low = 2070;   gR_40_low = 1245; cl_40_low = 2220;   gR_0_hig = 1015; cl_0_hig = 1830;    gR_10_hig = 1095; cl_10_hig = 1970;   gR_20_hig = 1185; cl_20_hig = 2125;   gR_30_hig = 1275; cl_30_hig = 2290;   gR_40_hig = 1365; cl_40_hig = 2455;  
        
        PAlevelShortfield = 1000;
        
     
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 1015; cl_0_low = 1830;    gR_10_low = 1095; cl_10_low = 1970;   gR_20_low = 1185; cl_20_low = 2125;   gR_30_low = 1275; cl_30_low = 2290;   gR_40_low = 1365; cl_40_low = 2455;   gR_0_hig = 1115; cl_0_hig = 2020;    gR_10_hig = 1205; cl_10_hig = 2185;   gR_20_hig = 1305; cl_20_hig = 2360;   gR_30_hig = 1400; cl_30_hig = 2540;   gR_40_hig = 1505; cl_40_hig = 2730;  
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
        
      
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 1115; cl_0_low = 2020;    gR_10_low = 1205; cl_10_low = 2185;   gR_20_low = 1305; cl_20_low = 2360;   gR_30_low = 1400; cl_30_low = 2540;   gR_40_low = 1505; cl_40_low = 2730;   gR_0_hig = 1230; cl_0_hig = 2245;    gR_10_hig = 1330; cl_10_hig = 2430;   gR_20_hig = 1435; cl_20_hig = 2630;   gR_30_hig = 1545; cl_30_hig = 2830;   gR_40_hig = 1655; cl_40_hig = 3045; 
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
        
       
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1230; cl_0_low = 2245;    gR_10_low = 1330; cl_10_low = 2430;   gR_20_low = 1435; cl_20_low = 2630;   gR_30_low = 1545; cl_30_low = 2830;   gR_40_low = 1655; cl_40_low = 3045;   gR_0_hig = 1355; cl_0_hig = 2500;    gR_10_hig = 1470; cl_10_hig = 2715;   gR_20_hig = 1585; cl_20_hig = 2945;   gR_30_hig = 1705; cl_30_hig = 3175;   gR_40_hig = 1830; cl_40_hig = 3430;
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
               
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1355; cl_0_low = 2500;    gR_10_low = 1470; cl_10_low = 2715;   gR_20_low = 1585; cl_20_low = 2945;   gR_30_low = 1705; cl_30_low = 3175;   gR_40_low = 1830; cl_40_low = 3430;   gR_0_hig = 1500; cl_0_hig = 2805;    gR_10_hig = 1625; cl_10_hig = 3060;   gR_20_hig = 1750; cl_20_hig = 3315;   gR_30_hig = 1880; cl_30_hig = 3590;   gR_40_hig = 2020; cl_40_hig = 3895;  
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
    
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1500; cl_0_low = 2805;    gR_10_low = 1625; cl_10_low = 3060;   gR_20_low = 1750; cl_20_low = 3315;   gR_30_low = 1880; cl_30_low = 3590;   gR_40_low = 2020; cl_40_low = 3895;   gR_0_hig = 1660; cl_0_hig = 3170;    gR_10_hig = 1795; cl_10_hig = 3470;   gR_20_hig = 1935; cl_20_hig = 3770;   gR_30_hig = 2085; cl_30_hig = 4105;   gR_40_hig = 2240; cl_40_hig = 4485;  
        
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1660; cl_0_low = 3170;    gR_10_low = 1795; cl_10_low = 3470;   gR_20_low = 1935; cl_20_low = 3770;   gR_30_low = 2085; cl_30_low = 4105;   gR_40_low = 2240; cl_40_low = 4485;   gR_0_hig = 1840; cl_0_hig = 3620;    gR_10_hig = 1995; cl_10_hig = 3975;   gR_20_hig = 2150; cl_20_hig = 4345;   gR_30_hig = 2315; cl_30_hig = 4775;   gR_40_hig = 3000; cl_40_hig = 6000;
        
        PAlevelShortfield = 7000;
        
       
        
        
    } // end if  
    
    
    
    [self shortfield2200C172_interpolation];
    
    
    // ausgabe
    
    //labelGrndRollSF1.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_1];
    
    //labelGrndRollSF2.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_2];
    
    //labelGrndRollShortField.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_interpolated];  
    
    
    
    //labelClear1.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_1];
    //labelClear2.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_2];
    
    //labelTotalToClear50ftShortField.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_interpolated];
    
    return;
    
} // end void
- (void) calculate_ClimbC172R {
    if (PressureAltitude >=0 & PressureAltitude < 1000) {
        
        climb_low2  = 79; RoC_low2   = 720; time_low2   = 0; fuel_low2   = 0;    distNM_low2   = 0; climb_high2 = 78; RoC_high2  = 670; time_high2  = 1; fuel_high2  = 0.4;    distNM_high2   = 2; PAlevel2 = 0;        
        
    }
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        climb_low2  = 78; RoC_low2   = 670; time_low2   = 1; fuel_low2   = 0.4;    distNM_low2   = 2; PAlevel2 = 1000;   climb_high2 = 77; RoC_high2  = 625; time_high2  = 3; fuel_high2  = 0.7;    distNM_high2   = 4; PAlevel2 = 1000;        
        
    }
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        climb_low2  = 77; RoC_low2   = 625; time_low2   = 3; fuel_low2   = 0.7;    distNM_low2   = 4; PAlevel2 = 2000;   climb_high2 = 76; RoC_high2  = 757; time_high2  = 5; fuel_high2  = 1.2;    distNM_high2   = 6; PAlevel2 = 2000;      
        
    }
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        climb_low2  = 76; RoC_low2   = 757; time_low2   = 5; fuel_low2   = 1.2;    distNM_low2   = 6; PAlevel2 = 3000;   climb_high2 = 76; RoC_high2  = 560; time_high2  = 6; fuel_high2  = 1.5;    distNM_high2   = 8; PAlevel2 = 3000;
        
    }
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        climb_low2  = 76; RoC_low2   = 560; time_low2   = 6; fuel_low2   = 1.5;    distNM_low2   = 8; PAlevel2 = 4000;   climb_high2 = 75; RoC_high2  = 515; time_high2  = 8; fuel_high2  = 1.8;    distNM_high2   = 11; PAlevel2 = 4000;
        
    }
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        climb_low2  = 75; RoC_low2   = 515; time_low2   = 8; fuel_low2   = 1.8;    distNM_low2   = 11; PAlevel2 = 5000;   climb_high2 = 74; RoC_high2  = 465; time_high2  = 10; fuel_high2  = 2.1;    distNM_high2   = 14; PAlevel2 = 5000;
        
    }
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        climb_low2  = 74; RoC_low2   = 465; time_low2   = 10; fuel_low2   = 2.1;    distNM_low2   = 14; PAlevel2 = 6000;   climb_high2 = 73; RoC_high2  = 415; time_high2  = 13; fuel_high2  = 2.5;    distNM_high2   = 17; PAlevel2 = 6000;
        
    }
    
    if (PressureAltitude >=7000 & PressureAltitude < 8000) {
        
        climb_low2  = 73; RoC_low2   = 415; time_low2   = 13; fuel_low2   = 2.5;    distNM_low2   = 17; PAlevel2 = 7000;   climb_high2 = 72; RoC_high2  = 365; time_high2  = 15; fuel_high2  = 3;    distNM_high2   = 21; PAlevel2 = 7000;
        
    }
    
    if (PressureAltitude >=8000 & PressureAltitude < 9000) {
        
        climb_low2  = 72; RoC_low2   = 365; time_low2   = 15; fuel_low2   = 3;    distNM_low2   = 21; PAlevel2 = 8000;   climb_high2 = 72; RoC_high2  = 315; time_high2  = 18; fuel_high2  = 3.4;    distNM_high2   = 25; PAlevel2 = 8000;        
        
    }
    
    
    if (PressureAltitude >=9000 & PressureAltitude < 10000) {
        
        climb_low2  = 72; RoC_low2   = 315; time_low2   = 18; fuel_low2   = 3.4;    distNM_low2   = 25; PAlevel2 = 9000;   climb_high2 = 71; RoC_high2  = 270; time_high2  = 22; fuel_high2  = 4;    distNM_high2   = 29; PAlevel2 = 9000;        
        
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 11000) {
        
        climb_low2  = 71; RoC_low2   = 270; time_low2   = 22; fuel_low2   = 4;    distNM_low2   = 29; PAlevel2 = 10000;   climb_high2 = 70; RoC_high2  = 220; time_high2  = 26; fuel_high2  = 4.6;    distNM_high2   = 35; PAlevel2 = 10000;        
        
    }
    
    if (PressureAltitude >=11000 & PressureAltitude < 12000) {
        
        climb_low2  = 70; RoC_low2   = 220; time_low2   = 26; fuel_low2   = 4.6;    distNM_low2   = 35; PAlevel2 = 11000;   climb_high2 = 69; RoC_high2  = 170; time_high2  = 31; fuel_high2  = 5.4;    distNM_high2   = 43; PAlevel2 = 11000;
        
    }
    
    
    if (PressureAltitude >=12000 ) {
        
        climb_low2  = 69; RoC_low2   = 170; time_low2   = 31; fuel_low2   = 5.4;    distNM_low2   = 43; PAlevel2 = 12000;   climb_high2 = 69; RoC_high2  = 170; time_high2  = 31; fuel_high2  = 5.4;    distNM_high2   = 43; PAlevel2 = 12000;
        
    }
    
    [self interpolateClimbC172S];
}
- (void) InterpolateCruiseValuesC172R {
    
    
    RPM = engineRPMcruise;
    
    // define RPM  high and low
    
    if (RPM >= 1900 & RPM < 2000) {
        RPM_LOW = 1900; RPM_HIGH = 2000;
    }
    
    
    if (RPM >= 2000 & RPM < 2100) {
        RPM_LOW = 2000; RPM_HIGH = 2100;
    }
    
    
    
    if (RPM >= 2100 & RPM < 2200) {
        RPM_LOW = 2100; RPM_HIGH = 2200;
    }
    
    if (RPM >= 2200 & RPM < 2300) {
        RPM_LOW = 2200; RPM_HIGH = 2300;
    }
    
    if (RPM >= 2300 & RPM < 2400) {
        RPM_LOW = 2300; RPM_HIGH = 2400;
    }
    
    if (RPM >= 2400 & RPM < 2500) {
        RPM_LOW = 2400; RPM_HIGH = 2500;
    }
    
    if (RPM >= 2500 & RPM < 2600) {
        RPM_LOW = 2500; RPM_HIGH = 2600;
    }
    
    if (RPM >= 2600 & RPM <= 2700) {
        RPM_LOW = 2600; RPM_HIGH = 2700;
    }
    
    if (RPM >= 2600 & RPM <= 2700 & PressureAltitude > 11999) {
        RPM_LOW = 2600; RPM_HIGH = 2650;
    }
    
    
    //NSLog (@"RPM_LOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_LOW]);
    
    //NSLog (@"RPM_HIGH %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_HIGH]);
    
    
    
    // get RPM
    
    if (PressureAltitude < 2001) {
        PressureAltitude = 2001;
    }
    
    if (PressureAltitude > 11999) {
        PressureAltitude = 12000;
    }
    
    
    if (PressureAltitude >= 2000 & PressureAltitude < 4000) {
        
        PressAltAbzug = 2000;
        
        
        //NSLog (@"Hello 2000");
        
        
        if (RPM == 2350) {M20_BHP_DWN = 79;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 9.1;   STD_BHP_DWN = 79;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 9;   P20_BHP_DWN = 79;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 9;M20_BHP_UPP = 80;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 9.2;   STD_BHP_UPP = 79;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 9.1;   P20_BHP_UPP = 75;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 8.6; }
        if (RPM == 2300) {M20_BHP_DWN = 79;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 9.1;   STD_BHP_DWN = 79;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 9;   P20_BHP_DWN = 79;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 9;M20_BHP_UPP = 80;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 9.2;   STD_BHP_UPP = 79;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 9.1;   P20_BHP_UPP = 75;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 8.6; }
        if (RPM == 2250) {M20_BHP_DWN = 79;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 9.1;   STD_BHP_DWN = 79;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 9;   P20_BHP_DWN = 74;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 8.5;M20_BHP_UPP = 80;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 9.2;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 8.6;   P20_BHP_UPP = 70;  P20_KTAS_UPP = 114;  P20_GPH_UPP = 8.1; }
        if (RPM == 2200) {M20_BHP_DWN = 79;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 9.1;   STD_BHP_DWN = 74;  STD_KTAS_DWN = 112;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 70;  P20_KTAS_DWN = 111;  P20_GPH_DWN = 8;M20_BHP_UPP = 75;  M20_KTAS_UPP = 112;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 70;  STD_KTAS_UPP = 111;  STD_GPH_UPP = 8.1;   P20_BHP_UPP = 66;  P20_KTAS_UPP = 110;  P20_GPH_UPP = 7.6; }
        if (RPM == 2100) {M20_BHP_DWN = 69;  M20_KTAS_DWN = 107;  M20_GPH_DWN = 7.9;   STD_BHP_DWN = 65;  STD_KTAS_DWN = 106;  STD_GPH_DWN = 7.5;   P20_BHP_DWN = 62;  P20_KTAS_DWN = 105;  P20_GPH_DWN = 7.1;M20_BHP_UPP = 66;  M20_KTAS_UPP = 106;  M20_GPH_UPP = 7.6;   STD_BHP_UPP = 62;  STD_KTAS_UPP = 105;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 6.8; }
        if (RPM == 2000) {M20_BHP_DWN = 61;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 7;   STD_BHP_DWN = 58;  STD_KTAS_DWN = 99;  STD_GPH_DWN = 6.6;   P20_BHP_DWN = 55;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 6.4;M20_BHP_UPP = 58;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 6.7;   STD_BHP_UPP = 55;  STD_KTAS_UPP = 98;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 95;  P20_GPH_UPP = 6.2; }
        if (RPM == 1900) {M20_BHP_DWN = 54;  M20_KTAS_DWN = 94;  M20_GPH_DWN = 6.2;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 5.9;   P20_BHP_DWN = 50;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 52;  M20_KTAS_UPP = 92;  M20_GPH_UPP = 6;   STD_BHP_UPP = 50;  STD_KTAS_UPP = 90;  STD_GPH_UPP = 5.8;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 87;  P20_GPH_UPP = 5.6; }
        
        
        if (RPM_HIGH == 2350) {M20_BHP_DWN2 = 79;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 9.1;   STD_BHP_DWN2 = 79;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 9;   P20_BHP_DWN2 = 79;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 9;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 9.2;   STD_BHP_UPP2 = 79;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 9.1;   P20_BHP_UPP2 = 75;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 8.6; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 79;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 9.1;   STD_BHP_DWN2 = 79;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 9;   P20_BHP_DWN2 = 79;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 9;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 9.2;   STD_BHP_UPP2 = 79;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 9.1;   P20_BHP_UPP2 = 75;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 8.6; }
        if (RPM_HIGH == 2250) {M20_BHP_DWN2 = 79;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 9.1;   STD_BHP_DWN2 = 79;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 9;   P20_BHP_DWN2 = 74;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 8.5;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 9.2;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 8.6;   P20_BHP_UPP2 = 70;  P20_KTAS_UPP2 = 114;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 79;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 9.1;   STD_BHP_DWN2 = 74;  STD_KTAS_DWN2 = 112;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 70;  P20_KTAS_DWN2 = 111;  P20_GPH_DWN2 = 8;M20_BHP_UPP2 = 75;  M20_KTAS_UPP2 = 112;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 70;  STD_KTAS_UPP2 = 111;  STD_GPH_UPP2 = 8.1;   P20_BHP_UPP2 = 66;  P20_KTAS_UPP2 = 110;  P20_GPH_UPP2 = 7.6; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 69;  M20_KTAS_DWN2 = 107;  M20_GPH_DWN2 = 7.9;   STD_BHP_DWN2 = 65;  STD_KTAS_DWN2 = 106;  STD_GPH_DWN2 = 7.5;   P20_BHP_DWN2 = 62;  P20_KTAS_DWN2 = 105;  P20_GPH_DWN2 = 7.1;M20_BHP_UPP2 = 66;  M20_KTAS_UPP2 = 106;  M20_GPH_UPP2 = 7.6;   STD_BHP_UPP2 = 62;  STD_KTAS_UPP2 = 105;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 103;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 61;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 7;   STD_BHP_DWN2 = 58;  STD_KTAS_DWN2 = 99;  STD_GPH_DWN2 = 6.6;   P20_BHP_DWN2 = 55;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 6.4;M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 6.7;   STD_BHP_UPP2 = 55;  STD_KTAS_UPP2 = 98;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 53;  P20_KTAS_UPP2 = 95;  P20_GPH_UPP2 = 6.2; }
        if (RPM_HIGH == 1900) {M20_BHP_DWN2 = 54;  M20_KTAS_DWN2 = 94;  M20_GPH_DWN2 = 6.2;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 5.9;   P20_BHP_DWN2 = 50;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 92;  M20_GPH_UPP2 = 6;   STD_BHP_UPP2 = 50;  STD_KTAS_UPP2 = 90;  STD_GPH_UPP2 = 5.8;   P20_BHP_UPP2 = 49;  P20_KTAS_UPP2 = 87;  P20_GPH_UPP2 = 5.6; }
        
        
        
        
    } // end if Pressue Alt zwischen 2000 und 4000
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        
        PressAltAbzug = 4000;
        
        //NSLog (@"Hello 4000");
        
        
        if (RPM == 2350) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 9.2;   STD_BHP_DWN = 79;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 9.1;   P20_BHP_DWN = 75;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 8.6;M20_BHP_UPP = 80;  M20_KTAS_UPP = 117;  M20_GPH_UPP = 9.2;   STD_BHP_UPP = 80;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 9.2;   P20_BHP_UPP = 75;  P20_KTAS_UPP = 119;  P20_GPH_UPP = 8.6; }
        if (RPM == 2300) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 9.2;   STD_BHP_DWN = 79;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 9.1;   P20_BHP_DWN = 75;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 8.6;M20_BHP_UPP = 80;  M20_KTAS_UPP = 117;  M20_GPH_UPP = 9.2;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 8.6;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 116;  P20_GPH_UPP = 8.1; }
        if (RPM == 2250) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 9.2;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 8.6;   P20_BHP_DWN = 70;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 76;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 8.7;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 8.1;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 113;  P20_GPH_UPP = 7.7; }
        if (RPM == 2200) {M20_BHP_DWN = 75;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 70;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 8.1;   P20_BHP_DWN = 66;  P20_KTAS_DWN = 110;  P20_GPH_DWN = 7.6;M20_BHP_UPP = 71;  M20_KTAS_UPP = 112;  M20_GPH_UPP = 8.1;   STD_BHP_UPP = 67;  STD_KTAS_UPP = 111;  STD_GPH_UPP = 7.7;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 7.3; }
        if (RPM == 2100) {M20_BHP_DWN = 66;  M20_KTAS_DWN = 106;  M20_GPH_DWN = 7.6;   STD_BHP_DWN = 62;  STD_KTAS_DWN = 105;  STD_GPH_DWN = 7.1;   P20_BHP_DWN = 59;  P20_KTAS_DWN = 103;  P20_GPH_DWN = 6.8;M20_BHP_UPP = 63;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 7.2;   STD_BHP_UPP = 60;  STD_KTAS_UPP = 104;  STD_GPH_UPP = 6.9;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 101;  P20_GPH_UPP = 6.6; }
        if (RPM == 2000) {M20_BHP_DWN = 58;  M20_KTAS_DWN = 100;  M20_GPH_DWN = 6.7;   STD_BHP_DWN = 55;  STD_KTAS_DWN = 98;  STD_GPH_DWN = 6.4;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 6.2;M20_BHP_UPP = 56;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 53;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 52;  P20_KTAS_UPP = 93;  P20_GPH_UPP = 6; }
        if (RPM == 1900) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 92;  M20_GPH_DWN = 6;   STD_BHP_DWN = 50;  STD_KTAS_DWN = 90;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 87;  P20_GPH_DWN = 5.6;M20_BHP_UPP = 56;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 53;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 52;  P20_KTAS_UPP = 93;  P20_GPH_UPP = 6; }
        
        
        
        if (RPM_HIGH == 2350) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 9.2;   STD_BHP_DWN2 = 79;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 9.1;   P20_BHP_DWN2 = 75;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 8.6;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 117;  M20_GPH_UPP2 = 9.2;   STD_BHP_UPP2 = 80;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 9.2;   P20_BHP_UPP2 = 75;  P20_KTAS_UPP2 = 119;  P20_GPH_UPP2 = 8.6; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 9.2;   STD_BHP_DWN2 = 79;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 9.1;   P20_BHP_DWN2 = 75;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 8.6;M20_BHP_UPP2 = 80;  M20_KTAS_UPP2 = 117;  M20_GPH_UPP2 = 9.2;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 8.6;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 116;  P20_GPH_UPP2 = 8.1; }
        if (RPM_HIGH == 2250) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 9.2;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 8.6;   P20_BHP_DWN2 = 70;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 8.7;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 8.1;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 113;  P20_GPH_UPP2 = 7.7; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 75;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 70;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 8.1;   P20_BHP_DWN2 = 66;  P20_KTAS_DWN2 = 110;  P20_GPH_DWN2 = 7.6;M20_BHP_UPP2 = 71;  M20_KTAS_UPP2 = 112;  M20_GPH_UPP2 = 8.1;   STD_BHP_UPP2 = 67;  STD_KTAS_UPP2 = 111;  STD_GPH_UPP2 = 7.7;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 7.3; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 66;  M20_KTAS_DWN2 = 106;  M20_GPH_DWN2 = 7.6;   STD_BHP_DWN2 = 62;  STD_KTAS_DWN2 = 105;  STD_GPH_DWN2 = 7.1;   P20_BHP_DWN2 = 59;  P20_KTAS_DWN2 = 103;  P20_GPH_DWN2 = 6.8;M20_BHP_UPP2 = 63;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 7.2;   STD_BHP_UPP2 = 60;  STD_KTAS_UPP2 = 104;  STD_GPH_UPP2 = 6.9;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 101;  P20_GPH_UPP2 = 6.6; }
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 100;  M20_GPH_DWN2 = 6.7;   STD_BHP_DWN2 = 55;  STD_KTAS_DWN2 = 98;  STD_GPH_DWN2 = 6.4;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 6.2;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 53;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 52;  P20_KTAS_UPP2 = 93;  P20_GPH_UPP2 = 6; }
        if (RPM_HIGH == 1900) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 92;  M20_GPH_DWN2 = 6;   STD_BHP_DWN2 = 50;  STD_KTAS_DWN2 = 90;  STD_GPH_DWN2 = 5.8;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 87;  P20_GPH_DWN2 = 5.6;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 53;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 52;  P20_KTAS_UPP2 = 93;  P20_GPH_UPP2 = 6; }
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 4000 und 6000
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000) {
        
        //NSLog (@"Hello 6000");
        
        PressAltAbzug = 6000;
        
        
        if (RPM == 2350) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 117;  M20_GPH_DWN = 9.2;   STD_BHP_DWN = 80;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 9.2;   P20_BHP_DWN = 75;  P20_KTAS_DWN = 119;  P20_GPH_DWN = 8.6;M20_BHP_UPP = 81;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 9.3;   STD_BHP_UPP = 80;  STD_KTAS_UPP = 122;  STD_GPH_UPP = 9.2;   P20_BHP_UPP = 76;  P20_KTAS_UPP = 121;  P20_GPH_UPP = 8.7; }
        if (RPM == 2300) {M20_BHP_DWN = 80;  M20_KTAS_DWN = 117;  M20_GPH_DWN = 9.2;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 8.6;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 116;  P20_GPH_DWN = 8.1;M20_BHP_UPP = 81;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 9.3;   STD_BHP_UPP = 76;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 8.7;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 8.2; }
        if (RPM == 2250) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 8.7;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 8.1;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 113;  P20_GPH_DWN = 7.7;M20_BHP_UPP = 76;  M20_KTAS_UPP = 117;  M20_GPH_UPP = 8.7;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 8.2;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.8; }
        if (RPM == 2200) {M20_BHP_DWN = 71;  M20_KTAS_DWN = 112;  M20_GPH_DWN = 8.1;   STD_BHP_DWN = 67;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 7.7;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 7.3;M20_BHP_UPP = 72;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 8.2;   STD_BHP_UPP = 67.5;  STD_KTAS_UPP = 113;  STD_GPH_UPP = 7.75;   P20_BHP_UPP = 64.5;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 7.4; }
        if (RPM == 2100) {M20_BHP_DWN = 63;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 7.2;   STD_BHP_DWN = 60;  STD_KTAS_DWN = 104;  STD_GPH_DWN = 6.9;   P20_BHP_DWN = 57;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 6.6;M20_BHP_UPP = 68;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 7.7;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 110;  STD_GPH_UPP = 7.3;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 7; }
        if (RPM == 2000) {M20_BHP_DWN = 56;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 6.4;   STD_BHP_DWN = 53;  STD_KTAS_DWN = 96;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 52;  P20_KTAS_DWN = 93;  P20_GPH_DWN = 6;M20_BHP_UPP = 60;  M20_KTAS_UPP = 104;  M20_GPH_UPP = 6.9;   STD_BHP_UPP = 57;  STD_KTAS_UPP = 102;  STD_GPH_UPP = 6.6;   P20_BHP_UPP = 55;  P20_KTAS_UPP = 99;  P20_GPH_UPP = 6.4; }
        if (RPM == 1900) {M20_BHP_DWN = 56;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 6.4;   STD_BHP_DWN = 53;  STD_KTAS_DWN = 96;  STD_GPH_DWN = 6.2;   P20_BHP_DWN = 52;  P20_KTAS_DWN = 93;  P20_GPH_DWN = 6;M20_BHP_UPP = 54;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 6.2;   STD_BHP_UPP = 52;  STD_KTAS_UPP = 94;  STD_GPH_UPP = 6;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 91;  P20_GPH_UPP = 5.9; }
        
        
        
        
        if (RPM_HIGH == 2350) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 117;  M20_GPH_DWN2 = 9.2;   STD_BHP_DWN2 = 80;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 9.2;   P20_BHP_DWN2 = 75;  P20_KTAS_DWN2 = 119;  P20_GPH_DWN2 = 8.6;M20_BHP_UPP2 = 81;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 9.3;   STD_BHP_UPP2 = 80;  STD_KTAS_UPP2 = 122;  STD_GPH_UPP2 = 9.2;   P20_BHP_UPP2 = 76;  P20_KTAS_UPP2 = 121;  P20_GPH_UPP2 = 8.7; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 80;  M20_KTAS_DWN2 = 117;  M20_GPH_DWN2 = 9.2;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 8.6;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 116;  P20_GPH_DWN2 = 8.1;M20_BHP_UPP2 = 81;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 9.3;   STD_BHP_UPP2 = 76;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 8.7;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 8.2; }
        if (RPM_HIGH == 2250) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 8.7;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 8.1;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 113;  P20_GPH_DWN2 = 7.7;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 117;  M20_GPH_UPP2 = 8.7;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 8.2;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 71;  M20_KTAS_DWN2 = 112;  M20_GPH_DWN2 = 8.1;   STD_BHP_DWN2 = 67;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 7.7;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 7.3;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 8.2;   STD_BHP_UPP2 = 67.5;  STD_KTAS_UPP2 = 113;  STD_GPH_UPP2 = 7.75;   P20_BHP_UPP2 = 64.5;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 7.4; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 63;  M20_KTAS_DWN2 = 105;  M20_GPH_DWN2 = 7.2;   STD_BHP_DWN2 = 60;  STD_KTAS_DWN2 = 104;  STD_GPH_DWN2 = 6.9;   P20_BHP_DWN2 = 57;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 6.6;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 7.7;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 110;  STD_GPH_UPP2 = 7.3;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 7; }
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 56;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 6.4;   STD_BHP_DWN2 = 53;  STD_KTAS_DWN2 = 96;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 52;  P20_KTAS_DWN2 = 93;  P20_GPH_DWN2 = 6;M20_BHP_UPP2 = 60;  M20_KTAS_UPP2 = 104;  M20_GPH_UPP2 = 6.9;   STD_BHP_UPP2 = 57;  STD_KTAS_UPP2 = 102;  STD_GPH_UPP2 = 6.6;   P20_BHP_UPP2 = 55;  P20_KTAS_UPP2 = 99;  P20_GPH_UPP2 = 6.4; }
        if (RPM_HIGH == 1900) {M20_BHP_DWN2 = 56;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 6.4;   STD_BHP_DWN2 = 53;  STD_KTAS_DWN2 = 96;  STD_GPH_DWN2 = 6.2;   P20_BHP_DWN2 = 52;  P20_KTAS_DWN2 = 93;  P20_GPH_DWN2 = 6;M20_BHP_UPP2 = 54;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 6.2;   STD_BHP_UPP2 = 52;  STD_KTAS_UPP2 = 94;  STD_GPH_UPP2 = 6;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 91;  P20_GPH_UPP2 = 5.9; }
        
        
        
        
    } // end if Pressue Alt zwischen 6000 und 8000
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        
        //NSLog (@"Hello 8000");
        
        PressAltAbzug = 8000;
        
        
        
        
        if (RPM == 2400) {M20_BHP_DWN = 81;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 9.3;   STD_BHP_DWN = 80;  STD_KTAS_DWN = 122;  STD_GPH_DWN = 9.2;   P20_BHP_DWN = 76;  P20_KTAS_DWN = 121;  P20_GPH_DWN = 8.7;M20_BHP_UPP = 76;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 8.8;   STD_BHP_UPP = 72;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 8.2;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 7.8; }
        if (RPM == 2350) {M20_BHP_DWN = 81;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 9.3;   STD_BHP_DWN = 76;  STD_KTAS_DWN = 119;  STD_GPH_DWN = 8.7;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 8.2;M20_BHP_UPP = 76;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 8.8;   STD_BHP_UPP = 72;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 8.2;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 7.8; }
        if (RPM == 2300) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 117;  M20_GPH_DWN = 8.7;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 116;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 72;  M20_KTAS_UPP = 116;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 115;  STD_GPH_UPP = 7.8;   P20_BHP_UPP = 65;  P20_KTAS_UPP = 113;  P20_GPH_UPP = 7.4; }
        if (RPM == 2250) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 8.2;   STD_BHP_DWN = 67.5;  STD_KTAS_DWN = 113;  STD_GPH_DWN = 7.75;   P20_BHP_DWN = 64.5;  P20_KTAS_DWN = 111;  P20_GPH_DWN = 7.4;M20_BHP_UPP = 68;  M20_KTAS_UPP = 113;  M20_GPH_UPP = 7.8;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 112;  STD_GPH_UPP = 7.4;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 7.1; }
        if (RPM == 2200) {M20_BHP_DWN = 68;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 7.7;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 110;  STD_GPH_DWN = 7.3;   P20_BHP_DWN = 61;  P20_KTAS_DWN = 107;  P20_GPH_DWN = 7;M20_BHP_UPP = 65;  M20_KTAS_UPP = 110;  M20_GPH_UPP = 7.4;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 108;  STD_GPH_UPP = 7;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 105;  P20_GPH_UPP = 6.7; }
        if (RPM == 2100) {M20_BHP_DWN = 60;  M20_KTAS_DWN = 104;  M20_GPH_DWN = 6.9;   STD_BHP_DWN = 57;  STD_KTAS_DWN = 102;  STD_GPH_DWN = 6.6;   P20_BHP_DWN = 55;  P20_KTAS_DWN = 99;  P20_GPH_DWN = 6.4;M20_BHP_UPP = 58;  M20_KTAS_UPP = 102;  M20_GPH_UPP = 6.6;   STD_BHP_UPP = 55;  STD_KTAS_UPP = 100;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 97;  P20_GPH_UPP = 6.2; }
        if (RPM == 2000) {M20_BHP_DWN = 54;  M20_KTAS_DWN = 96;  M20_GPH_DWN = 6.2;   STD_BHP_DWN = 52;  STD_KTAS_DWN = 94;  STD_GPH_DWN = 6;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 91;  P20_GPH_DWN = 5.9;M20_BHP_UPP = 52;  M20_KTAS_UPP = 94;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 91;  STD_GPH_UPP = 5.9;   P20_BHP_UPP = 50;  P20_KTAS_UPP = 88;  P20_GPH_UPP = 5.8; }
        
        
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 81;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 9.3;   STD_BHP_DWN2 = 80;  STD_KTAS_DWN2 = 122;  STD_GPH_DWN2 = 9.2;   P20_BHP_DWN2 = 76;  P20_KTAS_DWN2 = 121;  P20_GPH_DWN2 = 8.7;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 8.8;   STD_BHP_UPP2 = 72;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 8.2;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2350) {M20_BHP_DWN2 = 81;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 9.3;   STD_BHP_DWN2 = 76;  STD_KTAS_DWN2 = 119;  STD_GPH_DWN2 = 8.7;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 8.2;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 8.8;   STD_BHP_UPP2 = 72;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 8.2;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 7.8; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 117;  M20_GPH_DWN2 = 8.7;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 116;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 116;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 68;  STD_KTAS_UPP2 = 115;  STD_GPH_UPP2 = 7.8;   P20_BHP_UPP2 = 65;  P20_KTAS_UPP2 = 113;  P20_GPH_UPP2 = 7.4; }
        if (RPM_HIGH == 2250) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 8.2;   STD_BHP_DWN2 = 67.5;  STD_KTAS_DWN2 = 113;  STD_GPH_DWN2 = 7.75;   P20_BHP_DWN2 = 64.5;  P20_KTAS_DWN2 = 111;  P20_GPH_DWN2 = 7.4;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 113;  M20_GPH_UPP2 = 7.8;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 112;  STD_GPH_UPP2 = 7.4;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 7.1; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 68;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 7.7;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 110;  STD_GPH_DWN2 = 7.3;   P20_BHP_DWN2 = 61;  P20_KTAS_DWN2 = 107;  P20_GPH_DWN2 = 7;M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 110;  M20_GPH_UPP2 = 7.4;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 108;  STD_GPH_UPP2 = 7;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 105;  P20_GPH_UPP2 = 6.7; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 60;  M20_KTAS_DWN2 = 104;  M20_GPH_DWN2 = 6.9;   STD_BHP_DWN2 = 57;  STD_KTAS_DWN2 = 102;  STD_GPH_DWN2 = 6.6;   P20_BHP_DWN2 = 55;  P20_KTAS_DWN2 = 99;  P20_GPH_DWN2 = 6.4;M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 102;  M20_GPH_UPP2 = 6.6;   STD_BHP_UPP2 = 55;  STD_KTAS_UPP2 = 100;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 97;  P20_GPH_UPP2 = 6.2; }
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 54;  M20_KTAS_DWN2 = 96;  M20_GPH_DWN2 = 6.2;   STD_BHP_DWN2 = 52;  STD_KTAS_DWN2 = 94;  STD_GPH_DWN2 = 6;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 91;  P20_GPH_DWN2 = 5.9;M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 94;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 91;  STD_GPH_UPP2 = 5.9;   P20_BHP_UPP2 = 50;  P20_KTAS_UPP2 = 88;  P20_GPH_UPP2 = 5.8; }
        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    if (PressureAltitude >= 10000 & PressureAltitude <= 12000) {
        
        //NSLog (@"Hello 10000");
        
        PressAltAbzug = 10000;
        
        if (RPM == 2400) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 119;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 72;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 73;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 69;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 7.9;   P20_BHP_UPP = 65;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.5; }
        if (RPM == 2350) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 119;  M20_GPH_DWN = 8.8;   STD_BHP_DWN = 72;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 7.8;M20_BHP_UPP = 73;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 69;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 7.9;   P20_BHP_UPP = 65;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 7.5; }
        if (RPM == 2300) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 116;  M20_GPH_DWN = 8.3;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 7.8;   P20_BHP_DWN = 65;  P20_KTAS_DWN = 113;  P20_GPH_DWN = 7.4;M20_BHP_UPP = 69;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 7.9;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 113;  STD_GPH_UPP = 7.5;   P20_BHP_UPP = 62;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 7.1; }
        if (RPM == 2250) {M20_BHP_DWN = 68;  M20_KTAS_DWN = 113;  M20_GPH_DWN = 7.8;   STD_BHP_DWN = 65;  STD_KTAS_DWN = 112;  STD_GPH_DWN = 7.4;   P20_BHP_DWN = 61;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 7.1;M20_BHP_UPP = 65;  M20_KTAS_UPP = 112;  M20_GPH_UPP = 7.5;   STD_BHP_UPP = 62;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 6.8; }
        if (RPM == 2200) {M20_BHP_DWN = 65;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 7.4;   STD_BHP_DWN = 61;  STD_KTAS_DWN = 108;  STD_GPH_DWN = 7;   P20_BHP_DWN = 59;  P20_KTAS_DWN = 105;  P20_GPH_DWN = 6.7;M20_BHP_UPP = 62;  M20_KTAS_UPP = 108;  M20_GPH_UPP = 7.1;   STD_BHP_UPP = 59;  STD_KTAS_UPP = 105;  STD_GPH_UPP = 6.8;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 6.6; }
        if (RPM == 2100) {M20_BHP_DWN = 58;  M20_KTAS_DWN = 102;  M20_GPH_DWN = 6.6;   STD_BHP_DWN = 55;  STD_KTAS_DWN = 100;  STD_GPH_DWN = 6.4;   P20_BHP_DWN = 54;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 6.2;M20_BHP_UPP = 56;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 97;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 6.1; }
        if (RPM == 2000) {M20_BHP_DWN = 52;  M20_KTAS_DWN = 94;  M20_GPH_DWN = 6.1;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 5.9;   P20_BHP_DWN = 50;  P20_KTAS_DWN = 88;  P20_GPH_DWN = 5.8;M20_BHP_UPP = 56;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 6.4;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 97;  STD_GPH_UPP = 6.2;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 6.1; }
        
        
        
        
        
        
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 119;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 72;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 73;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 69;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 7.9;   P20_BHP_UPP2 = 65;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.5; }
        if (RPM_HIGH == 2350) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 119;  M20_GPH_DWN2 = 8.8;   STD_BHP_DWN2 = 72;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 7.8;M20_BHP_UPP2 = 73;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 69;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 7.9;   P20_BHP_UPP2 = 65;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 7.5; }
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 116;  M20_GPH_DWN2 = 8.3;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 7.8;   P20_BHP_DWN2 = 65;  P20_KTAS_DWN2 = 113;  P20_GPH_DWN2 = 7.4;M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 7.9;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 113;  STD_GPH_UPP2 = 7.5;   P20_BHP_UPP2 = 62;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 7.1; }
        if (RPM_HIGH == 2250) {M20_BHP_DWN2 = 68;  M20_KTAS_DWN2 = 113;  M20_GPH_DWN2 = 7.8;   STD_BHP_DWN2 = 65;  STD_KTAS_DWN2 = 112;  STD_GPH_DWN2 = 7.4;   P20_BHP_DWN2 = 61;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 7.1;M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 112;  M20_GPH_UPP2 = 7.5;   STD_BHP_UPP2 = 62;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 6.8; }
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 7.4;   STD_BHP_DWN2 = 61;  STD_KTAS_DWN2 = 108;  STD_GPH_DWN2 = 7;   P20_BHP_DWN2 = 59;  P20_KTAS_DWN2 = 105;  P20_GPH_DWN2 = 6.7;M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 108;  M20_GPH_UPP2 = 7.1;   STD_BHP_UPP2 = 59;  STD_KTAS_UPP2 = 105;  STD_GPH_UPP2 = 6.8;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 103;  P20_GPH_UPP2 = 6.6; }
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 102;  M20_GPH_DWN2 = 6.6;   STD_BHP_DWN2 = 55;  STD_KTAS_DWN2 = 100;  STD_GPH_DWN2 = 6.4;   P20_BHP_DWN2 = 54;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 6.2;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 97;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 53;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 6.1; }
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 94;  M20_GPH_DWN2 = 6.1;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 5.9;   P20_BHP_DWN2 = 50;  P20_KTAS_DWN2 = 88;  P20_GPH_DWN2 = 5.8;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 6.4;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 97;  STD_GPH_UPP2 = 6.2;   P20_BHP_UPP2 = 53;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 6.1; }
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    // interpolate RPM
    
    M20_BHP_DWN_MED = M20_BHP_DWN + ((M20_BHP_DWN2 - M20_BHP_DWN ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_BHP_UPP_MED = M20_BHP_UPP + ((M20_BHP_UPP2 - M20_BHP_UPP ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    
    
    M20_KTAS_DWN_MED = M20_KTAS_DWN + ((M20_KTAS_DWN2 - M20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_KTAS_UPP_MED = M20_KTAS_UPP + ((M20_KTAS_UPP2 - M20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    M20_GPH_DWN_MED = M20_GPH_DWN + ((M20_GPH_DWN2 - M20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_GPH_UPP_MED = M20_GPH_UPP + ((M20_GPH_UPP2 - M20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_BHP_DWN_MED = STD_BHP_DWN + ((STD_BHP_DWN2 - STD_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_BHP_UPP_MED = STD_BHP_UPP + ((STD_BHP_UPP2 - STD_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_KTAS_DWN_MED = STD_KTAS_DWN + ((STD_KTAS_DWN2 - STD_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_KTAS_UPP_MED = STD_KTAS_UPP + ((STD_KTAS_UPP2 - STD_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_GPH_DWN_MED = STD_GPH_DWN + ((STD_GPH_DWN2 - STD_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_GPH_UPP_MED = STD_GPH_UPP + ((STD_GPH_UPP2 - STD_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_BHP_DWN_MED = P20_BHP_DWN + ((P20_BHP_DWN2 - P20_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_BHP_UPP_MED = P20_BHP_UPP + ((P20_BHP_UPP2 - P20_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_KTAS_DWN_MED = P20_KTAS_DWN + ((P20_KTAS_DWN2 - P20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_KTAS_UPP_MED = P20_KTAS_UPP + ((P20_KTAS_UPP2 - P20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_GPH_DWN_MED = P20_GPH_DWN + ((P20_GPH_DWN2 - P20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_GPH_UPP_MED = P20_GPH_UPP + ((P20_GPH_UPP2 - P20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    temp = ISAdiff;
    //NSLog(@"temp = %.1f ", temp);
    
    // interpolate temperature
    
    if (temp >= 0 & temp <= 20) {
        
        low_BHP     = STD_BHP_DWN_MED      - (( (STD_BHP_DWN_MED   - P20_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED     - (( (STD_KTAS_DWN_MED  - P20_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED      - (( (STD_GPH_DWN_MED   - P20_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        high_BHP    = STD_BHP_UPP_MED     - (( (STD_BHP_UPP_MED   - P20_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS   = STD_KTAS_UPP_MED    - (( (STD_KTAS_UPP_MED  - P20_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED     - (( (STD_GPH_UPP_MED   - P20_GPH_UPP_MED)  / 20 ) * temp) ;
        
        
        
        
    }
    
    
    
    if (temp < 0 & temp >= -20) {
        
        low_BHP     = STD_BHP_DWN_MED   - (( (M20_BHP_DWN_MED   - STD_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED  - (( (M20_KTAS_DWN_MED  - STD_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED   - (( (M20_GPH_DWN_MED   - STD_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        
        high_BHP   = STD_BHP_UPP_MED    - (( (M20_BHP_UPP_MED   - STD_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS  = STD_KTAS_UPP_MED   - (( (M20_KTAS_UPP_MED  - STD_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED   - (( (M20_GPH_UPP_MED   - STD_GPH_UPP_MED)  / 20 ) * temp) ;
    }
    
    
    
    // interpolate for PRESSURE ALT    
    resultCruiseBHP =    low_BHP -  ( ((low_BHP - high_BHP) / 2000) * (PressureAltitude - PressAltAbzug) );
    resultCruiseKTAS =  low_KTAS -  ( ((low_KTAS - high_KTAS) / 2000) * (PressureAltitude - PressAltAbzug) );    
    resultCruiseFuelBurn =    low_GPH -  ( ((low_GPH - high_GPH) / 2000) * (PressureAltitude - PressAltAbzug) );
    
    //NSLog(@"RPM %f", RPM);
    //NSLog(@"resultCruiseBHP %f", resultCruiseBHP);
    
    return;
    
    
}

// C172 S **************************************************************************************************

- (void) shortfield_LandingC172S {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_lowLD = 545; cl_0_lowLD = 1290;    gR_10_lowLD = 565;  cl_10_lowLD = 1320;   gR_20_lowLD =  585; cl_20_lowLD = 1350;   gR_30_lowLD = 605; cl_30_lowLD = 1380;   gR_40_lowLD = 625; cl_40_lowLD = 1415;
        gR_0_higLD = 565; cl_0_higLD = 1320;    gR_10_higLD = 585;  cl_10_higLD = 1350;   gR_20_higLD =  605; cl_20_higLD = 1385;   gR_30_higLD = 625; cl_30_higLD = 1420;   gR_40_higLD = 650; cl_40_higLD = 1450;
        
        PAlevelShortfieldLD = 0;
        
        
      
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_lowLD = 565;  cl_0_lowLD = 1320;    gR_10_lowLD = 585; cl_10_lowLD = 1350;   gR_20_lowLD = 605; cl_20_lowLD = 1385;   gR_30_lowLD = 625; cl_30_lowLD = 1420;   gR_40_lowLD = 650; cl_40_lowLD = 1450;
        gR_0_higLD = 585;  cl_0_higLD = 1355;    gR_10_higLD = 610; cl_10_higLD = 1385;   gR_20_higLD = 630; cl_20_higLD = 1420;   gR_30_higLD = 650; cl_30_higLD = 1455;   gR_40_higLD = 670; cl_40_higLD = 1490;
        
        PAlevelShortfieldLD = 1000;
       
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_lowLD = 585; cl_0_lowLD = 1355;    gR_10_lowLD = 610;  cl_10_lowLD = 1385;   gR_20_lowLD = 630; cl_20_lowLD = 1420;   gR_30_lowLD = 650; cl_30_lowLD = 1455;   gR_40_lowLD = 670; cl_40_lowLD = 1490;
        gR_0_higLD = 610; cl_0_higLD = 1385;    gR_10_higLD = 630;  cl_10_higLD = 1425;   gR_20_higLD = 655; cl_20_higLD = 1460;   gR_30_higLD = 675; cl_30_higLD = 1495;   gR_40_higLD = 695; cl_40_higLD = 1530;
        
        PAlevelShortfieldLD = 2000;
        
       
        
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_lowLD = 610; cl_0_lowLD = 1385;    gR_10_lowLD = 630; cl_10_lowLD = 1425;   gR_20_lowLD = 655;  cl_20_lowLD = 1460;   gR_30_lowLD = 675; cl_30_lowLD = 1495;   gR_40_lowLD = 695; cl_40_lowLD = 1530;
        gR_0_higLD = 630; cl_0_higLD = 1425;    gR_10_higLD = 655; cl_10_higLD = 1460;   gR_20_higLD = 675;  cl_20_higLD = 1495;   gR_30_higLD = 700; cl_30_higLD = 1535;   gR_40_higLD = 725; cl_40_higLD = 1570;
        
        PAlevelShortfieldLD = 3000;
        
       
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_lowLD = 630; cl_0_lowLD = 1425;    gR_10_lowLD = 655;  cl_10_lowLD = 1460;   gR_20_lowLD = 675; cl_20_lowLD = 1495;   gR_30_lowLD = 700; cl_30_lowLD = 1535;   gR_40_lowLD = 725; cl_40_lowLD = 1570;
        gR_0_higLD = 655; cl_0_higLD = 1460;    gR_10_higLD = 680;  cl_10_higLD = 1500;   gR_20_higLD = 705; cl_20_higLD = 1535;   gR_30_higLD = 725; cl_30_higLD = 1575;   gR_40_higLD = 750; cl_40_higLD = 1615;
        
        PAlevelShortfieldLD = 4000;
        
      
        
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_lowLD = 655; cl_0_lowLD = 1460;    gR_10_lowLD = 680; cl_10_lowLD = 1500;   gR_20_lowLD = 705; cl_20_lowLD = 1535;   gR_30_lowLD = 725; cl_30_lowLD = 1575;   gR_40_lowLD = 750; cl_40_lowLD = 1615;
        gR_0_higLD = 680; cl_0_higLD = 1500;    gR_10_higLD = 705; cl_10_higLD = 1540;   gR_20_higLD = 730; cl_20_higLD = 1580;   gR_30_higLD = 755; cl_30_higLD = 1620;   gR_40_higLD = 780; cl_40_higLD = 1660;
        
        PAlevelShortfieldLD = 5000;
        
       
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 680; cl_0_lowLD = 1500;    gR_10_lowLD = 705; cl_10_lowLD = 1540;   gR_20_lowLD = 730; cl_20_lowLD = 1580;   gR_30_lowLD = 755; cl_30_lowLD = 1620;   gR_40_lowLD = 780; cl_40_lowLD = 1660;
        gR_0_higLD = 705; cl_0_higLD = 1545;    gR_10_higLD = 730; cl_10_higLD = 1585;   gR_20_higLD = 760; cl_20_higLD = 1625;   gR_30_higLD = 785; cl_30_higLD = 1665;   gR_40_higLD = 810; cl_40_higLD = 1705;
        
        PAlevelShortfieldLD = 6000;
        
      
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 705; cl_0_lowLD = 1545;    gR_10_lowLD = 730; cl_10_lowLD = 1585;   gR_20_lowLD = 760; cl_20_lowLD = 1625;   gR_30_lowLD = 785; cl_30_lowLD = 1665;   gR_40_lowLD = 810; cl_40_lowLD = 1705;
        gR_0_higLD = 735; cl_0_higLD = 1585;    gR_10_higLD = 760; cl_10_higLD = 1630;   gR_20_higLD = 790; cl_20_higLD = 1670;   gR_30_higLD = 815; cl_30_higLD = 1715;   gR_40_higLD = 840; cl_40_higLD = 1755;
        
        PAlevelShortfieldLD = 7000;
        
       
        
    } // end if
    
    
   
    
    return;
    
} // end void

- (void) shortfieldC172S_2200 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 610; cl_0_low = 1055;    gR_10_low = 655; cl_10_low = 1130;   gR_20_low = 705; cl_20_low = 1205;   gR_30_low = 760; cl_30_low = 1290;   gR_40_low = 815; cl_40_low = 1380;
        gR_0_hig = 665; cl_0_hig = 1145;    gR_10_hig = 720; cl_10_hig = 1230;   gR_20_hig = 770; cl_20_hig = 1315;   gR_30_hig = 830; cl_30_hig = 1410;   gR_40_hig = 890; cl_40_hig = 1505;
        
        PAlevelShortfield = 0;
        
        
      
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 665; cl_0_low = 1145;    gR_10_low = 720; cl_10_low = 1230;   gR_20_low = 770; cl_20_low = 1315;   gR_30_low = 830; cl_30_low = 1410;   gR_40_low = 890; cl_40_low = 1505;
        gR_0_hig = 725; cl_0_hig = 1250;    gR_10_hig = 785; cl_10_hig = 1340;   gR_20_hig = 845; cl_20_hig = 1435;   gR_30_hig = 905; cl_30_hig = 1540;   gR_40_hig = 975; cl_40_hig = 1650;
        
        PAlevelShortfield = 1000;
       
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 725; cl_0_low = 1250;    gR_10_low = 785; cl_10_low = 1340;   gR_20_low = 845; cl_20_low = 1435;   gR_30_low = 905; cl_30_low = 1540;   gR_40_low = 975; cl_40_low = 1650;
        gR_0_hig = 795; cl_0_hig = 1365;    gR_10_hig = 860; cl_10_hig = 1465;   gR_20_hig = 925; cl_20_hig = 1570;   gR_30_hig = 995; cl_30_hig = 1685;   gR_40_hig = 1065; cl_40_hig = 1805;
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
     
        
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 795; cl_0_low = 1365;    gR_10_low = 860; cl_10_low = 1465;   gR_20_low = 925;  cl_20_low = 1570;   gR_30_low = 995;  cl_30_low = 1685;   gR_40_low = 1065; cl_40_low = 1805;
        gR_0_hig = 870; cl_0_hig = 1490;    gR_10_hig = 940; cl_10_hig = 1605;   gR_20_hig = 1010; cl_20_hig = 1725;   gR_30_hig = 1090; cl_30_hig = 1855;   gR_40_hig = 1165; cl_40_hig = 1975;
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
      
        
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 870; cl_0_low = 1490;    gR_10_low = 940;  cl_10_low = 1605;   gR_20_low = 1010; cl_20_low = 1725;   gR_30_low = 1090; cl_30_low = 1855;   gR_40_low = 1165; cl_40_low = 1975;
        gR_0_hig = 955; cl_0_hig = 1635;    gR_10_hig = 1030; cl_10_hig = 1765;   gR_20_hig = 1110; cl_20_hig = 1900;   gR_30_hig = 1195; cl_30_hig = 2035;   gR_40_hig = 1275; cl_40_hig = 2175;
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
     
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 955;  cl_0_low = 1635;    gR_10_low = 1030; cl_10_low = 1765;   gR_20_low = 1110; cl_20_low = 1900;   gR_30_low = 1195; cl_30_low = 2035;   gR_40_low = 1275; cl_40_low = 2175;
        gR_0_hig = 1050; cl_0_hig = 1800;    gR_10_hig = 1130; cl_10_hig = 1940;   gR_20_hig = 1220; cl_20_hig = 2090;   gR_30_hig = 1310; cl_30_hig = 2240;   gR_40_hig = 1400; cl_40_hig = 2395;
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
        
       
        
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1050; cl_0_low = 1800;    gR_10_low = 1130; cl_10_low = 1940;   gR_20_low = 1220; cl_20_low = 2090;   gR_30_low = 1310; cl_30_low = 2240;   gR_40_low = 1400; cl_40_low = 2395;
        gR_0_hig = 1150; cl_0_hig = 1985;    gR_10_hig = 1245; cl_10_hig = 2145;   gR_20_hig = 1340; cl_20_hig = 2305;   gR_30_hig = 1435; cl_30_hig = 2475;   gR_40_hig = 1540; cl_40_hig = 2650;
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
        
     
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1150; cl_0_low = 1985;    gR_10_low = 1245; cl_10_low = 2145;   gR_20_low = 1340; cl_20_low = 2305;   gR_30_low = 1435; cl_30_low = 2475;   gR_40_low = 1540; cl_40_low = 2650;
        gR_0_hig = 1270; cl_0_hig = 2195;    gR_10_hig = 1370; cl_10_hig = 2375;   gR_20_hig = 1475; cl_20_hig = 2555;   gR_30_hig = 1580; cl_30_hig = 2745;   gR_40_hig = 1695; cl_40_hig = 2950;
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
      
        
        
    } // end if
    
    
    [self shortfield2200C172_interpolation];
    
    
    
    // ausgabe
    
    
    //labelClear1.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_1];
    //labelClear2.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_2];
    
    //labelTotalToClear50ftShortField.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_interpolated];
    
    return;
    
}
- (void) shortfield2200C172_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_1 = gR_0_low + ( (gR_0_hig -  gR_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_2 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated =  GrndRollShortField_1 + (((GrndRollShortField_2 -  GrndRollShortField_1) / 10) * (sliderOATvalue));
        
        
        ObstClearance_1 = cl_0_low + ( (cl_0_hig -  cl_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_2 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated = ObstClearance_1 + (((ObstClearance_2 -  ObstClearance_1) / 10) * (sliderOATvalue));
        
        
    }
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 20) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_1 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_2 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated =  GrndRollShortField_1 + (((GrndRollShortField_2 -  GrndRollShortField_1) / 10) * (sliderOATvalue -10 ));
        
        
        ObstClearance_1 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_2 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated = ObstClearance_1 + (((ObstClearance_2 -  ObstClearance_1) / 10) * (sliderOATvalue -10 ));
        
        
        
    }
    
    
    if (sliderOATvalue >= 20 & sliderOATvalue < 30) {
        
        GrndRollShortField_1 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_2 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated =  GrndRollShortField_1 + (((GrndRollShortField_2 -  GrndRollShortField_1) / 10) * (sliderOATvalue -20 ));
        
        
        ObstClearance_1 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_2 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated = ObstClearance_1 + (((ObstClearance_2 -  ObstClearance_1) / 10) * (sliderOATvalue -20 ));
        
        
    }
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_1 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_2 = gR_40_low + ( (gR_40_hig -  gR_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated =  GrndRollShortField_1 + (((GrndRollShortField_2 -  GrndRollShortField_1) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_1 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_2 = cl_40_low + ( (cl_40_hig -  cl_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated = ObstClearance_1 + (((ObstClearance_2 -  ObstClearance_1) / 10) * (sliderOATvalue -30 ));
        
        
        
    }
    
    
    
    
    return;
    
    
    
}
- (void) shortfieldC172S_2400 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 745; cl_0_low = 1275;    gR_10_low = 800; cl_10_low = 1370;   gR_20_low = 860; cl_20_low = 1470;   gR_30_low = 925; cl_30_low = 1570;   gR_40_low = 995; cl_40_low = 1685;
        gR_0_hig = 810; cl_0_hig = 1390;    gR_10_hig = 875; cl_10_hig = 1495;   gR_20_hig = 940; cl_20_hig = 1605;   gR_30_hig = 1010; cl_30_hig = 1720;   gR_40_hig = 1085; cl_40_hig = 1845;
        
        PAlevelShortfield = 0;
        
        
        // interpolate ground roll
       
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 810; cl_0_low = 1390;    gR_10_low = 875; cl_10_low = 1495;   gR_20_low = 940; cl_20_low = 1605;    gR_30_low = 1010; cl_30_low = 1720;   gR_40_low = 1085; cl_40_low = 1845;
        gR_0_hig = 885; cl_0_hig = 1520;    gR_10_hig = 955; cl_10_hig = 1635;   gR_20_hig = 1030; cl_20_hig = 1760;   gR_30_hig = 1110; cl_30_hig = 1890;   gR_40_hig = 1190; cl_40_hig = 2030;
        
        PAlevelShortfield = 1000;
        
        
     
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 885; cl_0_low = 1520;    gR_10_low = 955;  cl_10_low = 1635;   gR_20_low = 1030; cl_20_low = 1760;   gR_30_low = 1110; cl_30_low = 1890;   gR_40_low = 1190; cl_40_low = 2030;
        gR_0_hig = 970; cl_0_hig = 1665;    gR_10_hig = 1050; cl_10_hig = 1795;   gR_20_hig = 1130; cl_20_hig = 1930;   gR_30_hig = 1215; cl_30_hig = 2080;   gR_40_hig = 1305; cl_40_hig = 2230;
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
        
     
        
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 970;  cl_0_low = 1665;    gR_10_low = 1050; cl_10_low = 1795;   gR_20_low = 1130;  cl_20_low = 1930;   gR_30_low = 1215; cl_30_low = 2080;   gR_40_low = 1305; cl_40_low = 2230;
        gR_0_hig = 1065; cl_0_hig = 1830;    gR_10_hig = 1150; cl_10_hig = 1975;   gR_20_hig = 1240;  cl_20_hig = 2130;   gR_30_hig = 1335; cl_30_hig = 2295;   gR_40_hig = 1430; cl_40_hig = 2455;
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
        
       
        
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1065; cl_0_low = 1830;    gR_10_low = 1150;  cl_10_low = 1975;   gR_20_low = 1240; cl_20_low = 2130;   gR_30_low = 1335; cl_30_low = 2295;   gR_40_low = 1430; cl_40_low = 2455;
        gR_0_hig = 1170; cl_0_hig = 2015;    gR_10_hig = 1265;  cl_10_hig = 2180;   gR_20_hig = 1360; cl_20_hig = 2355;   gR_30_hig = 1465; cl_30_hig = 2530;   gR_40_hig = 1570; cl_40_hig = 2715;
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
        
       
        
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1170; cl_0_low = 2015;    gR_10_low = 1265; cl_10_low = 2180;   gR_20_low = 1360; cl_20_low = 2355;   gR_30_low = 1465; cl_30_low = 2530;   gR_40_low = 1570; cl_40_low = 2715;
        gR_0_hig = 1285; cl_0_hig = 2230;    gR_10_hig = 1390; cl_10_hig = 2410;   gR_20_hig = 1500; cl_20_hig = 2610;   gR_30_hig = 1610; cl_30_hig = 2805;   gR_40_hig = 1725; cl_40_hig = 3015;
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
        
      
        
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1285; cl_0_low = 2230;    gR_10_low = 1390; cl_10_low = 2410;   gR_20_low = 1500; cl_20_low = 2610;   gR_30_low = 1610; cl_30_low = 2805;   gR_40_low = 1725; cl_40_low = 3015;
        gR_0_hig = 1415; cl_0_hig = 2470;    gR_10_hig = 1530; cl_10_hig = 2685;   gR_20_hig = 1650; cl_20_hig = 2900;   gR_30_hig = 1770; cl_30_hig = 3125;   gR_40_hig = 1900; cl_40_hig = 3370;
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
        
      
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1415; cl_0_low = 2470;    gR_10_low = 1530; cl_10_low = 2685;   gR_20_low = 1650; cl_20_low = 2900;   gR_30_low = 1770; cl_30_low = 3125;   gR_40_low = 1900; cl_40_low = 3370;
        gR_0_hig = 1560; cl_0_hig = 2755;    gR_10_hig = 1690; cl_10_hig = 3000;   gR_20_hig = 1815; cl_20_hig = 3240;   gR_30_hig = 1950; cl_30_hig = 3500;   gR_40_hig = 2095; cl_40_hig = 3790;
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
      
        
        
    } // end if
    
    
      [self shortfield2400C172_interpolation];
    
    
    
    // ausgabe
    
    //labelGrndRollSF12400.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_12400];
    
    //labelGrndRollSF22400.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_22400];
    
    //labelGrndRollShortField2400.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_interpolated2400];
    
    
    
    //labelClear12400.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_12400];
    //labelClear22400.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_22400];
    
    //labelTotalToClear50ftShortField2400.text =  [ [NSString alloc] initWithFormat:@"%.0f", ObstClearance_interpolated2400];
    
    return;
    
}
- (void) shortfield2400C172S_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_12400 = gR_0_low + ( (gR_0_hig -  gR_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue));
        
        
        ObstClearance_12400 = cl_0_low + ( (cl_0_hig -  cl_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue));
        
        
    }
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 20) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_12400 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue -10 ));
        
        
        ObstClearance_12400 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue -10 ));
        
        
        
    }
    
    
    if (sliderOATvalue >= 20 & sliderOATvalue < 30) {
        
        GrndRollShortField_12400 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue -20 ));
        
        
        ObstClearance_12400 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue -20 ));
        
        
    }
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_12400 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22400 = gR_40_low + ( (gR_40_hig -  gR_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2400 =  GrndRollShortField_12400 + (((GrndRollShortField_22400 -  GrndRollShortField_12400) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_12400 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22400 = cl_40_low + ( (cl_40_hig -  cl_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2400 = ObstClearance_12400 + (((ObstClearance_22400 -  ObstClearance_12400) / 10) * (sliderOATvalue -30 ));
        
        
        
    }
    
    
    
    
    return;
    
    
    
}
- (void) shortfieldC172S_2550 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 860; cl_0_low = 1465;    gR_10_low = 925;  cl_10_low = 1575;   gR_20_low =  995; cl_20_low = 1690;   gR_30_low = 1070; cl_30_low = 1810;   gR_40_low = 1150; cl_40_low = 1945;
        gR_0_hig = 940; cl_0_hig = 1600;    gR_10_hig = 1010; cl_10_hig = 1720;   gR_20_hig = 1090; cl_20_hig = 1850;   gR_30_hig = 1170; cl_30_hig = 1990;   gR_40_hig = 1260; cl_40_hig = 2135;
        
        PAlevelShortfield = 0;
        
        
        // interpolate ground roll
        [self shortfield2550C172S_interpolation];
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 940;  cl_0_low = 1600;    gR_10_low = 1010; cl_10_low = 1720;   gR_20_low = 1090; cl_20_low = 1850;   gR_30_low = 1170; cl_30_low = 1990;   gR_40_low = 1260; cl_40_low = 2135;
        gR_0_hig = 1025; cl_0_hig = 1755;    gR_10_hig = 1110; cl_10_hig = 1890;   gR_20_hig = 1195; cl_20_hig = 2035;   gR_30_hig = 1285; cl_30_hig = 2190;   gR_40_hig = 1380; cl_40_hig = 2355;
        
        PAlevelShortfield = 1000;
        
        
      
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 1025; cl_0_low = 1755;    gR_10_low = 1110;  cl_10_low = 1890;   gR_20_low = 1195; cl_20_low = 2035;   gR_30_low = 1285; cl_30_low = 2190;   gR_40_low = 1380; cl_40_low = 2355;
        gR_0_hig = 1125; cl_0_hig = 1925;    gR_10_hig = 1215;  cl_10_hig = 2080;   gR_20_hig = 1310; cl_20_hig = 2240;   gR_30_hig = 1410; cl_30_hig = 2420;   gR_40_hig = 1515; cl_40_hig = 2605;
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
        
 
        
        
    } // end if 2000 - 3000
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 1125; cl_0_low = 1925;    gR_10_low = 1215; cl_10_low = 2080;   gR_20_low = 1310;  cl_20_low = 2240;   gR_30_low = 1410; cl_30_low = 2420;   gR_40_low = 1515; cl_40_low = 2605;
        gR_0_hig = 1235; cl_0_hig = 2120;    gR_10_hig = 1335; cl_10_hig = 2295;   gR_20_hig = 1440;  cl_20_hig = 2480;   gR_30_hig = 1550; cl_30_hig = 2685;   gR_40_hig = 1660; cl_40_hig = 2880;
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
        
      
        
    } // end if
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1235; cl_0_low = 2120;    gR_10_low = 1335;  cl_10_low = 2295;   gR_20_low = 1440; cl_20_low = 2480;   gR_30_low = 1550; cl_30_low = 2685;   gR_40_low = 1660; cl_40_low = 2880;
        gR_0_hig = 1355; cl_0_hig = 2345;    gR_10_hig = 1465;  cl_10_hig = 2545;   gR_20_hig = 1585; cl_20_hig = 2755;   gR_30_hig = 1705; cl_30_hig = 2975;   gR_40_hig = 1825; cl_40_hig = 3205;
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
        
       
        
    } // end if
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1355; cl_0_low = 2345;    gR_10_low = 1465; cl_10_low = 2545;   gR_20_low = 1585; cl_20_low = 2755;   gR_30_low = 1705; cl_30_low = 2975;   gR_40_low = 1825; cl_40_low = 3205;
        gR_0_hig = 1495; cl_0_hig = 2605;    gR_10_hig = 1615; cl_10_hig = 2830;   gR_20_hig = 1745; cl_20_hig = 3075;   gR_30_hig = 1875; cl_30_hig = 3320;   gR_40_hig = 2010; cl_40_hig = 3585;
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
        
      
        
    } // end if
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1495; cl_0_low = 2605;    gR_10_low = 1615; cl_10_low = 2830;   gR_20_low = 1745; cl_20_low = 3075;   gR_30_low = 1875; cl_30_low = 3320;   gR_40_low = 2010; cl_40_low = 3585;
        gR_0_hig = 1645; cl_0_hig = 2910;    gR_10_hig = 1785; cl_10_hig = 3170;   gR_20_hig = 1920; cl_20_hig = 3440;   gR_30_hig = 2065; cl_30_hig = 3730;   gR_40_hig = 2215; cl_40_hig = 4045;
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
        
       
        
        
    } // end if
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1645; cl_0_low = 2910;    gR_10_low = 1785; cl_10_low = 3170;   gR_20_low = 1920; cl_20_low = 3440;   gR_30_low = 2065; cl_30_low = 3730;   gR_40_low = 2215; cl_40_low = 4045;
        gR_0_hig = 1820; cl_0_hig = 3265;    gR_10_hig = 1970; cl_10_hig = 3575;   gR_20_hig = 2120; cl_20_hig = 3880;   gR_30_hig = 2280; cl_30_hig = 4225;   gR_40_hig = 2450; cl_40_hig = 4615;
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
       
        
        
    } // end if
    
    
     [self shortfield2550C172_interpolation];
    
    
    
    
    return;
    
}
- (void) shortfield2550C172S_interpolation {
    
    
    
    // press alt 0 - 1000
    
    if (sliderOATvalue >= 0 & sliderOATvalue < 10) {
        
        
        
        GrndRollShortField_12550 = gR_0_low + ( (gR_0_hig -  gR_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue));
        
        
        ObstClearance_12550 = cl_0_low + ( (cl_0_hig -  cl_0_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue));
        
        
    }
    
    
    
    if (sliderOATvalue >= 10 & sliderOATvalue < 20) {
        
        //NSLog(@"hier 1000 interpol");
        
        GrndRollShortField_12550 = gR_10_low + ( (gR_10_hig -  gR_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue -10 ));
        
        
        ObstClearance_12550 = cl_10_low + ( (cl_10_hig -  cl_10_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue -10 ));
        
        
        
    }
    
    
    if (sliderOATvalue >= 20 & sliderOATvalue < 30) {
        
        GrndRollShortField_12550 = gR_20_low + ( (gR_20_hig -  gR_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue -20 ));
        
        
        ObstClearance_12550 = cl_20_low + ( (cl_20_hig -  cl_20_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue -20 ));
        
        
    }
    
    
    if (sliderOATvalue >= 30 & sliderOATvalue <= 40) {
        
        GrndRollShortField_12550 = gR_30_low + ( (gR_30_hig -  gR_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_22550 = gR_40_low + ( (gR_40_hig -  gR_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        GrndRollShortField_interpolated2550 =  GrndRollShortField_12550 + (((GrndRollShortField_22550 -  GrndRollShortField_12550) / 10) * (sliderOATvalue -30 ));
        
        
        ObstClearance_12550 = cl_30_low + ( (cl_30_hig -  cl_30_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_22550 = cl_40_low + ( (cl_40_hig -  cl_40_low) / 1000 ) * (PressureAltitude - PAlevelShortfield);
        
        ObstClearance_interpolated2550 = ObstClearance_12550 + (((ObstClearance_22550 -  ObstClearance_12550) / 10) * (sliderOATvalue -30 ));
        
        
        
    }
    
    
    
    
    return;
    
    
    
}
- (void) shortfiedC172SlInterpolationToACWEight {
    
    
    if (ACweightLBS >= 2200 & ACweightLBS < 2400) {
        
        
        
        GroundRolltoWeight = GrndRollShortField_interpolated + ( ( (GrndRollShortField_interpolated2400 - GrndRollShortField_interpolated)/200 ) * (ACweightLBS-2200))  ;
        
        //labelInterpolatedShortFieldGroundRoll.text  = [ [NSString alloc] initWithFormat:@"%.0f'", GroundRolltoWeight];
        //metersGroundRoll.text                       = [ [NSString alloc] initWithFormat:@"%.0fm", GroundRolltoWeight * 0.3048 ]; // kink
        
        
        
        totalToClear = ObstClearance_interpolated + ( ( (ObstClearance_interpolated2400 - ObstClearance_interpolated)/200 ) * (ACweightLBS-2200))  ;
        
        //labelInterpolatedTotalToClear.text  = [ [NSString alloc] initWithFormat:@"%.0f'", totalToClear];
        //meterToClear.text                   = [ [NSString alloc] initWithFormat:@"%.0fm", totalToClear * 0.3048 ]; // kink
        
        
        liftoffspeed = 44 +  ( 0.02 * (ACweightLBS-2200));
        
        //labelLiftOffKIAS.text =  [ [NSString alloc] initWithFormat:@"%.1f KIAS", liftoffspeed];
        
        
        
    }
    
    
    
    if (ACweightLBS >= 2400 & ACweightLBS <= 2550) {
        
        
        
        GroundRolltoWeight = GrndRollShortField_interpolated2400 + ( ( (GrndRollShortField_interpolated2550 - GrndRollShortField_interpolated2400)/150 ) * (ACweightLBS-2400))  ;
        
        //labelInterpolatedShortFieldGroundRoll.text = [ [NSString alloc] initWithFormat:@"%.0f'", GroundRolltoWeight];
        //metersGroundRoll.text                       = [ [NSString alloc] initWithFormat:@"%.0fm", GroundRolltoWeight * 0.3048 ]; // kink2
        
        
        
        totalToClear = ObstClearance_interpolated2400 + ( ( (ObstClearance_interpolated2550 - ObstClearance_interpolated2400)/150 ) * (ACweightLBS-2400))  ;
        
        //labelInterpolatedTotalToClear.text = [ [NSString alloc] initWithFormat:@"%.0f'", totalToClear];
        
        //meterToClear.text                   = [ [NSString alloc] initWithFormat:@"%.0fm", totalToClear * 0.3048 ]; // kink
        
        liftoffspeed = 48 +  ( 0.02 * (ACweightLBS-2400));
        
        //labelLiftOffKIAS.text =  [ [NSString alloc] initWithFormat:@"%.1f KIAS", liftoffspeed];
        
        
        
        
    }
    
    resultTODistancefeet = totalToClear;
    
    resultTOGroundRollfeet = GroundRolltoWeight;
    
    
    
}
- (void) calculate_ClimbC172S {
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  
        climb_low2  = 74; RoC_low2  = 730; time_low2  = 0; fuel_low2  = 0;    distNM_low2   = 0;
        climb_high2 = 73; RoC_high2 = 695; time_high2 = 1; fuel_high2  = 0.4;  distNM_high2  = 2; PAlevel2 = 0;        
        
    }
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        climb_low2  = 73; RoC_low2  = 695; time_low2  = 1; fuel_low2  = 0.4;    distNM_low2   = 2;
        climb_high2 = 73; RoC_high2 = 655; time_high2 = 3; fuel_high2  = 0.8;    distNM_high2  = 4; PAlevel2 = 1000;        
        
    }
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        climb_low2  = 73; RoC_low2  = 655; time_low2  = 3; fuel_low2  = 0.8;    distNM_low2   = 4;
        climb_high2 = 73; RoC_high2 = 620; time_high2 = 4; fuel_high2  = 1.2;    distNM_high2  = 6; PAlevel2 = 2000;        
        
    }
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        climb_low2  = 73; RoC_low2  = 620; time_low2  = 4; fuel_low2  = 1.2;    distNM_low2   = 6;
        climb_high2 = 73; RoC_high2 = 600; time_high2 = 6; fuel_high2  = 1.5;    distNM_high2  = 8; PAlevel2 = 3000;        
        
    }
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        climb_low2  = 73; RoC_low2  = 600; time_low2  = 6; fuel_low2  = 1.5;    distNM_low2   = 8;
        climb_high2 = 73; RoC_high2 = 550; time_high2 = 8; fuel_high2  = 1.9;    distNM_high2  = 10; PAlevel2 = 4000;
        
        
    }
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        climb_low2  = 73; RoC_low2  = 550; time_low2  = 8;  fuel_low2  = 1.9;    distNM_low2   = 10;
        climb_high2 = 73; RoC_high2 = 505; time_high2 = 10; fuel_high2  = 2.2;    distNM_high2  = 13; PAlevel2 = 5000;
        
        
    }
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        climb_low2  = 73; RoC_low2  = 505; time_low2  = 10;  fuel_low2  = 2.2;    distNM_low2   = 13;
        climb_high2 = 73; RoC_high2 = 455; time_high2 = 12;  fuel_high2  = 2.6;    distNM_high2  = 16; PAlevel2 = 6000;
        
    }
    
    if (PressureAltitude >=7000 & PressureAltitude < 8000) {
        
        climb_low2  = 73; RoC_low2  = 455; time_low2  = 12;  fuel_low2  = 2.6;    distNM_low2   = 16;
        climb_high2 = 72; RoC_high2 = 410; time_high2 = 14;  fuel_high2  = 3.0;    distNM_high2  = 19; PAlevel2 = 7000;
        
        
    }
    
    if (PressureAltitude >=8000 & PressureAltitude < 9000) {
        
        climb_low2  = 72; RoC_low2  = 410; time_low2  = 14;  fuel_low2  = 3.0;    distNM_low2   = 19;
        climb_high2 = 72; RoC_high2 = 360; time_high2 = 17;  fuel_high2  = 3.4;    distNM_high2  = 22; PAlevel2 = 8000;
        
        
    }
    
    
    if (PressureAltitude >=9000 & PressureAltitude < 10000) {
        
        climb_low2  = 72; RoC_low2  = 360; time_low2  = 17;  fuel_low2  = 3.4;    distNM_low2   = 22;
        climb_high2 = 72; RoC_high2 = 315; time_high2 = 20;  fuel_high2  = 3.9;    distNM_high2  = 27; PAlevel2 = 9000;
        
        
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 11000) {
        
        climb_low2  = 72; RoC_low2  = 315; time_low2  = 20;  fuel_low2  = 3.9;    distNM_low2   = 27;
        climb_high2 = 72; RoC_high2 = 265; time_high2 = 24;  fuel_high2  = 4.4;    distNM_high2  = 32; PAlevel2 = 10000;
        
        
    }
    
    if (PressureAltitude >=11000 & PressureAltitude < 12000) {
        
        climb_low2  = 72; RoC_low2  = 265; time_low2  = 24;  fuel_low2  = 4.4;    distNM_low2   = 32;
        climb_high2 = 72; RoC_high2 = 220; time_high2 = 28;  fuel_high2  = 5.0;    distNM_high2  = 38; PAlevel2 = 11000;
        
        
    }
    
    
    if (PressureAltitude >=12000 ) {
        
        climb_low2  = 72; RoC_low2  = 220; time_low2  = 28;  fuel_low2  = 5.0;    distNM_low2   = 38;
        climb_high2 = 72; RoC_high2 = 220; time_high2 = 28;  fuel_high2  = 5.0;    distNM_high2  = 38; PAlevel2 = 12000;
        
        
        
        
    }
    
    [self interpolateClimbC172S];
    
}
- (void) interpolateClimbC172S {
    
    // interpolate Climb Speed
    resultClimbSpeed = climb_low2 - (((climb_low2 - climb_high2)/1000) *  (PressureAltitude - PAlevel2));  
    
    // interpolate ROC
    resultClimbRoC = RoC_low2 - (((RoC_low2 - RoC_high2)/1000) *  (PressureAltitude - PAlevel2)); 
    
    // interpolate Time in Minutes
    resultClimbTime = time_low2 - (((time_low2 - time_high2)/1000) *  (PressureAltitude - PAlevel2));    
    
    // interpolate Fuel used
    resultClimbFuel = fuel_low2 - (((fuel_low2 - fuel_high2 )/1000) *  (PressureAltitude - PAlevel2));
    
    // interpolate Distance
    resultClimbDistance = distNM_low2 - (((distNM_low2 - distNM_high2)/1000) *  (PressureAltitude - PAlevel2));
    
    //NSLog(@"**************************");
    //NSLog(@"resultClimbSpeed %f", resultClimbSpeed);
    //NSLog(@"resultClimbRoC %f", resultClimbRoC);
    //NSLog(@"resultClimbTime %f", resultClimbTime);
    //NSLog(@"resultClimbFuel %f", resultClimbFuel);
    //NSLog(@"resultClimbDistance %f", resultClimbDistance);
    
    
}
- (void) InterpolateCruiseValuesC172S {
    
    
    RPM = engineRPMcruise;
    
    // define RPM  high and low
    
    if (RPM >= 2100 & RPM < 2200) {
        RPM_LOW = 2100; RPM_HIGH = 2200;
    }
    
    if (RPM >= 2200 & RPM < 2300) {
        RPM_LOW = 2200; RPM_HIGH = 2300;
    }
    
    if (RPM >= 2300 & RPM < 2400) {
        RPM_LOW = 2300; RPM_HIGH = 2400;
    }
    
    if (RPM >= 2400 & RPM < 2500) {
        RPM_LOW = 2400; RPM_HIGH = 2500;
    }
    
    if (RPM >= 2500 & RPM < 2600) {
        RPM_LOW = 2500; RPM_HIGH = 2600;
    }
    
    if (RPM >= 2600 & RPM <= 2700) {
        RPM_LOW = 2600; RPM_HIGH = 2700;
    }
    
    if (RPM >= 2600 & RPM <= 2700 & PressureAltitude > 11999) {
        RPM_LOW = 2600; RPM_HIGH = 2650;
    }
    
    
    //NSLog (@"RPM_LOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_LOW]);
    
    //NSLog (@"RPM_HIGH %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_HIGH]);
    
    
    
    // get RPM
    
    if (PressureAltitude < 2001) {
        PressureAltitude = 2001;
    }
    
    if (PressureAltitude > 11999) {
        PressureAltitude = 12000;
    }
    
    
    
    if (PressureAltitude >= 2000 & PressureAltitude < 4000) {
        
        PressAltAbzug = 2000;
        
        
        //NSLog (@"Hello 2000");
        
        
        if (RPM == 2600) {
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 117;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 10.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 9.9;
            
            M20_BHP_UPP = 83;  M20_KTAS_UPP = 117;  M20_GPH_UPP = 11.1;   STD_BHP_UPP = 77;  STD_KTAS_UPP = 118;  STD_GPH_UPP = 10.5;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 9.9; 
            
        }
        
        if (RPM == 2550) {
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 117;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 118;  STD_GPH_DWN = 10.5;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 9.9;
            
            M20_BHP_UPP = 79;  M20_KTAS_UPP = 118;  M20_GPH_UPP = 10.6;   STD_BHP_UPP = 73;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 9.9;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 9.4; 
            
        }
        
        
        if (RPM == 2500) {
            
            M20_BHP_DWN = 78;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 10.6;   STD_BHP_DWN = 73;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 9.9;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 9.4;
            
            M20_BHP_UPP = 74;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 10.1;   STD_BHP_UPP = 69;  STD_KTAS_UPP = 115;  STD_GPH_UPP = 9.5;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 114;  P20_GPH_UPP = 9.9; 
            
        }
        
        if (RPM == 2400) {
            
            M20_BHP_DWN = 69;  M20_KTAS_DWN = 111;  M20_GPH_DWN = 9.6;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 110;  STD_GPH_DWN = 9.0;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 8.5;
            
            M20_BHP_UPP = 65;  M20_KTAS_UPP = 110;  M20_GPH_UPP = 9.1;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 8.5;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 8.1; 
            
        }
        
        if (RPM == 2300) {
            
            M20_BHP_DWN = 61;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 57;  STD_KTAS_DWN = 104;  STD_GPH_DWN = 8.1;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 102;  P20_GPH_DWN = 7.7;
            
            M20_BHP_UPP = 58;  M20_KTAS_UPP = 104;  M20_GPH_UPP = 8.2;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 102;  STD_GPH_UPP = 7.7;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 101;  P20_GPH_UPP = 7.3; 
            
        }
        
        
        if (RPM == 2200) {
            
            M20_BHP_DWN = 53;  M20_KTAS_DWN = 99;  M20_GPH_DWN = 7.7;   STD_BHP_DWN = 50;  STD_KTAS_DWN = 97;  STD_GPH_DWN = 7.3;   P20_BHP_DWN = 47;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 6.9;
            
            M20_BHP_UPP = 51;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 7.4;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 96;  STD_GPH_UPP = 7.0;   P20_BHP_UPP = 45;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 6.7; 
            
        }
        
        if (RPM == 2100) {
            
            M20_BHP_DWN = 47;  M20_KTAS_DWN = 92;  M20_GPH_DWN = 6.9;   STD_BHP_DWN = 44;  STD_KTAS_DWN = 90;  STD_GPH_DWN = 6.6;   P20_BHP_DWN = 42;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 6.3;
            
            M20_BHP_UPP = 45;  M20_KTAS_UPP = 91;  M20_GPH_UPP = 6.6;   STD_BHP_UPP = 42;  STD_KTAS_UPP = 89;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 40;  P20_KTAS_UPP = 87;  P20_GPH_UPP = 6.1; 
            
        }
        
        
        
        
        
        if (RPM_HIGH == 2600) {
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 117;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 10.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 9.9;
            
            M20_BHP_UPP2 = 83;  M20_KTAS_UPP2 = 117;  M20_GPH_UPP2 = 11.1;   STD_BHP_UPP2 = 77;  STD_KTAS_UPP2 = 118;  STD_GPH_UPP2 = 10.5;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 9.9; 
            
        }
        
        if (RPM_HIGH == 2550) {
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 117;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 118;  STD_GPH_DWN2 = 10.5;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 9.9;
            
            M20_BHP_UPP2 = 79;  M20_KTAS_UPP2 = 118;  M20_GPH_UPP2 = 10.6;   STD_BHP_UPP2 = 73;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 9.9;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 9.4; 
            
        }
        
        
        if (RPM_HIGH == 2500) {
            
            M20_BHP_DWN2 = 78;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 10.6;   STD_BHP_DWN2 = 73;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 9.9;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 9.4;
            
            M20_BHP_UPP2 = 74;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 10.1;   STD_BHP_UPP2 = 69;  STD_KTAS_UPP2 = 115;  STD_GPH_UPP2 = 9.5;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 114;  P20_GPH_UPP2 = 9.9; 
            
        }
        
        if (RPM_HIGH == 2400) {
            
            M20_BHP_DWN2 = 69;  M20_KTAS_DWN2 = 111;  M20_GPH_DWN2 = 9.6;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 110;  STD_GPH_DWN2 = 9.0;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 8.5;
            
            M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 110;  M20_GPH_UPP2 = 9.1;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 8.5;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 8.1; 
            
        }
        
        if (RPM_HIGH == 2300) {
            
            M20_BHP_DWN2 = 61;  M20_KTAS_DWN2 = 105;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 57;  STD_KTAS_DWN2 = 104;  STD_GPH_DWN2 = 8.1;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 102;  P20_GPH_DWN2 = 7.7;
            
            M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 104;  M20_GPH_UPP2 = 8.2;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 102;  STD_GPH_UPP2 = 7.7;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 101;  P20_GPH_UPP2 = 7.3; 
            
        }
        
        
        if (RPM_HIGH == 2200) {
            
            M20_BHP_DWN2 = 53;  M20_KTAS_DWN2 = 99;  M20_GPH_DWN2 = 7.7;   STD_BHP_DWN2 = 50;  STD_KTAS_DWN2 = 97;  STD_GPH_DWN2 = 7.3;   P20_BHP_DWN2 = 47;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 6.9;
            
            M20_BHP_UPP2 = 51;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 7.4;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 96;  STD_GPH_UPP2 = 7.0;   P20_BHP_UPP2 = 45;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 6.7; 
            
        }
        
        if (RPM_HIGH == 2100) {
            
            M20_BHP_DWN2 = 47;  M20_KTAS_DWN2 = 92;  M20_GPH_DWN2 = 6.9;   STD_BHP_DWN2 = 44;  STD_KTAS_DWN2 = 90;  STD_GPH_DWN2 = 6.6;   P20_BHP_DWN2 = 42;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 6.3;
            
            M20_BHP_UPP2 = 45;  M20_KTAS_UPP2 = 91;  M20_GPH_UPP2 = 6.6;   STD_BHP_UPP2 = 42;  STD_KTAS_UPP2 = 89;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 40;  P20_KTAS_UPP2 = 87;  P20_GPH_UPP2 = 6.1; 
            
        }
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 2000 und 4000
    
    
    
    
    
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        
        PressAltAbzug = 4000;
        
        //NSLog (@"Hello 4000");
        
        if (RPM == 2650) {
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 10.4;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 119;  P20_GPH_DWN = 9.8; 
            
            M20_BHP_UPP = 83;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 11.1;   STD_BHP_UPP = 77;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 10.4;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 119;  P20_GPH_UPP = 9.8;        
            
        }
        
        
        if (RPM == 2600) {
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 10.4;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 119;  P20_GPH_DWN = 9.8; 
            
            M20_BHP_UPP = 78;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 10.6;   STD_BHP_UPP = 73;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 9.9;   P20_BHP_UPP = 68;  P20_KTAS_UPP = 118;  P20_GPH_UPP = 9.4;
            
        }
        
        if (RPM == 2550) {
            
            M20_BHP_DWN = 79;  M20_KTAS_DWN = 118;  M20_GPH_DWN = 10.6;   STD_BHP_DWN = 73;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 9.9;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 9.4; 
            
            
            // berechnet von hand interpoliert aus tabelle 6000
            M20_BHP_UPP = 74;  M20_KTAS_UPP = 117;  M20_GPH_UPP = 10.1;   STD_BHP_UPP = 69;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 9.4;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 8.9;
            
        }
        
        
        
        
        if (RPM == 2500) {
            
            M20_BHP_DWN = 74;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 10.1;   STD_BHP_DWN = 69;  STD_KTAS_DWN = 115;  STD_GPH_DWN = 9.5;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 114;  P20_GPH_DWN = 9.9; 
            
            M20_BHP_UPP = 70;  M20_KTAS_UPP = 115;  M20_GPH_UPP = 9.6;   STD_BHP_UPP = 65;  STD_KTAS_UPP = 114;  STD_GPH_UPP = 9.0;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 112;  P20_GPH_UPP = 8.5;
            
        }
        
        if (RPM == 2400) {
            
            M20_BHP_DWN = 65;  M20_KTAS_DWN = 110;  M20_GPH_DWN = 9.1;   STD_BHP_DWN = 61;  STD_KTAS_DWN = 109;  STD_GPH_DWN = 8.5;   P20_BHP_DWN = 57;  P20_KTAS_DWN = 107;  P20_GPH_DWN = 8.1; 
            
            M20_BHP_UPP = 62;  M20_KTAS_UPP = 109;  M20_GPH_UPP = 8.6;   STD_BHP_UPP = 57;  STD_KTAS_UPP = 108;  STD_GPH_UPP = 8.2;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 106;  P20_GPH_UPP = 7.7;
            
        }
        
        if (RPM == 2300) {
            
            M20_BHP_DWN = 58;  M20_KTAS_DWN = 104;  M20_GPH_DWN = 8.2;   STD_BHP_DWN = 54;  STD_KTAS_DWN = 102;  STD_GPH_DWN = 7.7;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 7.3; 
            
            
            M20_BHP_UPP = 54;  M20_KTAS_UPP = 103;  M20_GPH_UPP = 7.8;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 101;  STD_GPH_UPP = 7.4;   P20_BHP_UPP = 48;  P20_KTAS_UPP = 99;  P20_GPH_UPP = 7.0;
            
            
        }
        
        
        if (RPM == 2200) {
            
            M20_BHP_DWN = 51;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 7.4;   STD_BHP_DWN = 48;  STD_KTAS_DWN = 96;  STD_GPH_DWN = 7.0;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 94;  P20_GPH_DWN = 6.7; 
            
            M20_BHP_UPP = 48;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 7.1;   STD_BHP_UPP = 45;  STD_KTAS_UPP = 94;  STD_GPH_UPP = 6.7;   P20_BHP_UPP = 43;  P20_KTAS_UPP = 92;  P20_GPH_UPP = 6.4;
            
            
        }
        
        if (RPM == 2100) {
            
            M20_BHP_DWN = 45;  M20_KTAS_DWN = 91;  M20_GPH_DWN = 6.6;   STD_BHP_DWN = 42;  STD_KTAS_DWN = 89;  STD_GPH_DWN = 6.4;   P20_BHP_DWN = 40;  P20_KTAS_DWN = 87;  P20_GPH_DWN = 6.1; 
            
            M20_BHP_UPP = 45;  M20_KTAS_UPP = 91;  M20_GPH_UPP = 6.6;   STD_BHP_UPP = 42;  STD_KTAS_UPP = 89;  STD_GPH_UPP = 6.4;   P20_BHP_UPP = 40;  P20_KTAS_UPP = 87;  P20_GPH_UPP = 6.1;
            
        }
        
        
        
        
        if (RPM_HIGH == 2650) {
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 10.4;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 119;  P20_GPH_DWN2 = 9.8; 
            
            M20_BHP_UPP2 = 83;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 11.1;   STD_BHP_UPP2 = 77;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 10.4;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 119;  P20_GPH_UPP2 = 9.8;        
            
        }
        
        
        if (RPM_HIGH == 2600) {
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 10.4;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 119;  P20_GPH_DWN2 = 9.8; 
            
            M20_BHP_UPP2 = 78;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 10.6;   STD_BHP_UPP2 = 73;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 9.9;   P20_BHP_UPP2 = 68;  P20_KTAS_UPP2 = 118;  P20_GPH_UPP2 = 9.4;
            
        }
        
        if (RPM_HIGH == 2550) {
            
            M20_BHP_DWN2 = 79;  M20_KTAS_DWN2 = 118;  M20_GPH_DWN2 = 10.6;   STD_BHP_DWN2 = 73;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 9.9;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 9.4; 
            
            
            // berechnet von hand interpoliert aus tabelle 6000
            M20_BHP_UPP2 = 74;  M20_KTAS_UPP2 = 117;  M20_GPH_UPP2 = 10.1;   STD_BHP_UPP2 = 69;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 9.4;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 8.9;
            
        }
        
        
        
        
        if (RPM_HIGH == 2500) {
            
            M20_BHP_DWN2 = 74;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 10.1;   STD_BHP_DWN2 = 69;  STD_KTAS_DWN2 = 115;  STD_GPH_DWN2 = 9.5;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 114;  P20_GPH_DWN2 = 9.9; 
            
            M20_BHP_UPP2 = 70;  M20_KTAS_UPP2 = 115;  M20_GPH_UPP2 = 9.6;   STD_BHP_UPP2 = 65;  STD_KTAS_UPP2 = 114;  STD_GPH_UPP2 = 9.0;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 112;  P20_GPH_UPP2 = 8.5;
            
        }
        
        if (RPM_HIGH == 2400) {
            
            M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 110;  M20_GPH_DWN2 = 9.1;   STD_BHP_DWN2 = 61;  STD_KTAS_DWN2 = 109;  STD_GPH_DWN2 = 8.5;   P20_BHP_DWN2 = 57;  P20_KTAS_DWN2 = 107;  P20_GPH_DWN2 = 8.1; 
            
            M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 109;  M20_GPH_UPP2 = 8.6;   STD_BHP_UPP2 = 57;  STD_KTAS_UPP2 = 108;  STD_GPH_UPP2 = 8.2;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 106;  P20_GPH_UPP2 = 7.7;
            
        }
        
        if (RPM_HIGH == 2300) {
            
            M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 104;  M20_GPH_DWN2 = 8.2;   STD_BHP_DWN2 = 54;  STD_KTAS_DWN2 = 102;  STD_GPH_DWN2 = 7.7;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 7.3; 
            
            
            M20_BHP_UPP2 = 54;  M20_KTAS_UPP2 = 103;  M20_GPH_UPP2 = 7.8;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 101;  STD_GPH_UPP2 = 7.4;   P20_BHP_UPP2 = 48;  P20_KTAS_UPP2 = 99;  P20_GPH_UPP2 = 7.0;
            
            
        }
        
        
        if (RPM_HIGH == 2200) {
            
            M20_BHP_DWN2 = 51;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 7.4;   STD_BHP_DWN2 = 48;  STD_KTAS_DWN2 = 96;  STD_GPH_DWN2 = 7.0;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 94;  P20_GPH_DWN2 = 6.7; 
            
            M20_BHP_UPP2 = 48;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 7.1;   STD_BHP_UPP2 = 45;  STD_KTAS_UPP2 = 94;  STD_GPH_UPP2 = 6.7;   P20_BHP_UPP2 = 43;  P20_KTAS_UPP2 = 92;  P20_GPH_UPP2 = 6.4;
            
            
        }
        
        if (RPM_HIGH == 2100) {
            
            M20_BHP_DWN2 = 45;  M20_KTAS_DWN2 = 91;  M20_GPH_DWN2 = 6.6;   STD_BHP_DWN2 = 42;  STD_KTAS_DWN2 = 89;  STD_GPH_DWN2 = 6.4;   P20_BHP_DWN2 = 40;  P20_KTAS_DWN2 = 87;  P20_GPH_DWN2 = 6.1; 
            
            M20_BHP_UPP2 = 45;  M20_KTAS_UPP2 = 91;  M20_GPH_UPP2 = 6.6;   STD_BHP_UPP2 = 42;  STD_KTAS_UPP2 = 89;  STD_GPH_UPP2 = 6.4;   P20_BHP_UPP2 = 40;  P20_KTAS_UPP2 = 87;  P20_GPH_UPP2 = 6.1;
            
        }
        
        
        
        
    } // end if Pressue Alt zwischen 4000 und 6000
    
    
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000) {
        
        
        
        PressAltAbzug = 6000;
        
        
        if (RPM == 2700) {
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 122;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 122;  STD_GPH_DWN = 10.4;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 121;  P20_GPH_DWN = 9.8; 
            
            M20_BHP_UPP = 83;  M20_KTAS_UPP = 122;  M20_GPH_UPP = 11.1;   STD_BHP_UPP = 77;  STD_KTAS_UPP = 122;  STD_GPH_UPP = 10.4;   P20_BHP_UPP = 72;  P20_KTAS_UPP = 121;  P20_GPH_UPP = 9.8; 
            
        }
        
        if (RPM == 2650) {
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 122;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 122;  STD_GPH_DWN = 10.4;   P20_BHP_DWN = 72;  P20_KTAS_DWN = 121;  P20_GPH_DWN = 9.8;        
            
            M20_BHP_UPP = 78;  M20_KTAS_UPP = 122;  M20_GPH_UPP = 10.5;   STD_BHP_UPP = 72;  STD_KTAS_UPP = 122;  STD_GPH_UPP = 9.9;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 120;  P20_GPH_UPP = 9.3;
            
        }
        
        
        if (RPM == 2600) {
            
            M20_BHP_DWN = 78;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 10.6;   STD_BHP_DWN = 73;  STD_KTAS_DWN = 119;  STD_GPH_DWN = 9.9;   P20_BHP_DWN = 68;  P20_KTAS_DWN = 118;  P20_GPH_DWN = 9.4;
            
            M20_BHP_UPP = 74;  M20_KTAS_UPP = 120;  M20_GPH_UPP = 10.0;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 9.4;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 8.9;
            
        }
        
        
        if (RPM == 2500) {
            
            M20_BHP_DWN = 70;  M20_KTAS_DWN = 115;  M20_GPH_DWN = 9.6;   STD_BHP_DWN = 65;  STD_KTAS_DWN = 114;  STD_GPH_DWN = 9.0;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 112;  P20_GPH_DWN = 8.5;
            
            M20_BHP_UPP = 65;  M20_KTAS_UPP = 114;  M20_GPH_UPP = 9.1;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 112;  STD_GPH_UPP = 8.6;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 111;  P20_GPH_UPP = 8.1;
            
        }
        
        if (RPM == 2400) {
            
            M20_BHP_DWN = 62;  M20_KTAS_DWN = 109;  M20_GPH_DWN = 8.6;   STD_BHP_DWN = 57;  STD_KTAS_DWN = 108;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 54;  P20_KTAS_DWN = 106;  P20_GPH_DWN = 7.7;
            
            M20_BHP_UPP = 58;  M20_KTAS_UPP = 108;  M20_GPH_UPP = 8.2;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 106;  STD_GPH_UPP = 7.8;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 104;  P20_GPH_UPP = 7.4;
            
        }
        
        if (RPM == 2300) {
            
            
            M20_BHP_DWN = 54;  M20_KTAS_DWN = 103;  M20_GPH_DWN = 7.8;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 101;  STD_GPH_DWN = 7.4;   P20_BHP_DWN = 48;  P20_KTAS_DWN = 99;  P20_GPH_DWN = 7.0;
            M20_BHP_UPP = 52;  M20_KTAS_UPP = 101;  M20_GPH_UPP = 7.5;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 99;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 97;  P20_GPH_UPP = 6.8;
            
        }
        
        
        if (RPM == 2200) {
            
            M20_BHP_DWN = 48;  M20_KTAS_DWN = 96;  M20_GPH_DWN = 7.1;   STD_BHP_DWN = 45;  STD_KTAS_DWN = 94;  STD_GPH_DWN = 6.7;   P20_BHP_DWN = 43;  P20_KTAS_DWN = 92;  P20_GPH_DWN = 6.4;
            
            M20_BHP_UPP = 46;  M20_KTAS_UPP = 94;  M20_GPH_UPP = 6.8;   STD_BHP_UPP = 43;  STD_KTAS_UPP = 92;  STD_GPH_UPP = 6.5;   P20_BHP_UPP = 41;  P20_KTAS_UPP = 90;  P20_GPH_UPP = 6.2;
            
            
        }
        
        
        
        
        
        
        if (RPM_HIGH == 2700) {
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 122;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 122;  STD_GPH_DWN2 = 10.4;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 121;  P20_GPH_DWN2 = 9.8; 
            
            M20_BHP_UPP2 = 83;  M20_KTAS_UPP2 = 122;  M20_GPH_UPP2 = 11.1;   STD_BHP_UPP2 = 77;  STD_KTAS_UPP2 = 122;  STD_GPH_UPP2 = 10.4;   P20_BHP_UPP2 = 72;  P20_KTAS_UPP2 = 121;  P20_GPH_UPP2 = 9.8; 
            
        }
        
        if (RPM_HIGH == 2650) {
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 122;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 122;  STD_GPH_DWN2 = 10.4;   P20_BHP_DWN2 = 72;  P20_KTAS_DWN2 = 121;  P20_GPH_DWN2 = 9.8;        
            
            M20_BHP_UPP2 = 78;  M20_KTAS_UPP2 = 122;  M20_GPH_UPP2 = 10.5;   STD_BHP_UPP2 = 72;  STD_KTAS_UPP2 = 122;  STD_GPH_UPP2 = 9.9;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 120;  P20_GPH_UPP2 = 9.3;
            
        }
        
        
        if (RPM_HIGH == 2600) {
            
            M20_BHP_DWN2 = 78;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 10.6;   STD_BHP_DWN2 = 73;  STD_KTAS_DWN2 = 119;  STD_GPH_DWN2 = 9.9;   P20_BHP_DWN2 = 68;  P20_KTAS_DWN2 = 118;  P20_GPH_DWN2 = 9.4;
            
            M20_BHP_UPP2 = 74;  M20_KTAS_UPP2 = 120;  M20_GPH_UPP2 = 10.0;   STD_BHP_UPP2 = 68;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 9.4;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 8.9;
            
        }
        
        
        if (RPM_HIGH == 2500) {
            
            M20_BHP_DWN2 = 70;  M20_KTAS_DWN2 = 115;  M20_GPH_DWN2 = 9.6;   STD_BHP_DWN2 = 65;  STD_KTAS_DWN2 = 114;  STD_GPH_DWN2 = 9.0;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 112;  P20_GPH_DWN2 = 8.5;
            
            M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 114;  M20_GPH_UPP2 = 9.1;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 112;  STD_GPH_UPP2 = 8.6;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 111;  P20_GPH_UPP2 = 8.1;
            
        }
        
        if (RPM_HIGH == 2400) {
            
            M20_BHP_DWN2 = 62;  M20_KTAS_DWN2 = 109;  M20_GPH_DWN2 = 8.6;   STD_BHP_DWN2 = 57;  STD_KTAS_DWN2 = 108;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 54;  P20_KTAS_DWN2 = 106;  P20_GPH_DWN2 = 7.7;
            
            M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 108;  M20_GPH_UPP2 = 8.2;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 106;  STD_GPH_UPP2 = 7.8;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 104;  P20_GPH_UPP2 = 7.4;
            
        }
        
        if (RPM_HIGH == 2300) {
            
            
            M20_BHP_DWN2 = 54;  M20_KTAS_DWN2 = 103;  M20_GPH_DWN2 = 7.8;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 101;  STD_GPH_DWN2 = 7.4;   P20_BHP_DWN2 = 48;  P20_KTAS_DWN2 = 99;  P20_GPH_DWN2 = 7.0;
            M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 101;  M20_GPH_UPP2 = 7.5;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 99;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 97;  P20_GPH_UPP2 = 6.8;
            
        }
        
        
        if (RPM_HIGH == 2200) {
            
            M20_BHP_DWN2 = 48;  M20_KTAS_DWN2 = 96;  M20_GPH_DWN2 = 7.1;   STD_BHP_DWN2 = 45;  STD_KTAS_DWN2 = 94;  STD_GPH_DWN2 = 6.7;   P20_BHP_DWN2 = 43;  P20_KTAS_DWN2 = 92;  P20_GPH_DWN2 = 6.4;
            
            M20_BHP_UPP2 = 46;  M20_KTAS_UPP2 = 94;  M20_GPH_UPP2 = 6.8;   STD_BHP_UPP2 = 43;  STD_KTAS_UPP2 = 92;  STD_GPH_UPP2 = 6.5;   P20_BHP_UPP2 = 41;  P20_KTAS_UPP2 = 90;  P20_GPH_UPP2 = 6.2;
            
            
        }
        
        
        
        
        
    } // end if Pressue Alt zwischen 6000 und 8000
    
    
    
    
    
    
    
    
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        
        //NSLog (@"Hello 8000");
        
        PressAltAbzug = 8000;
        
        
        
        
        if (RPM_LOW == 2700) {
            
            
            M20_BHP_DWN = 83;  M20_KTAS_DWN = 125;  M20_GPH_DWN = 11.1;   STD_BHP_DWN = 77;  STD_KTAS_DWN = 124;  STD_GPH_DWN = 10.4;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 123;  P20_GPH_DWN = 9.7;
            
            M20_BHP_UPP = 78;  M20_KTAS_UPP = 124;  M20_GPH_UPP = 10.5;   STD_BHP_UPP = 72;  STD_KTAS_UPP = 123;  STD_GPH_UPP = 9.8;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 122;  P20_GPH_UPP = 9.3;
            
        }
        
        if (RPM_LOW == 2650) {
            
            
            M20_BHP_DWN = 78;  M20_KTAS_DWN = 122;  M20_GPH_DWN = 10.5;   STD_BHP_DWN = 72;  STD_KTAS_DWN = 122;  STD_GPH_DWN = 9.9;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 120;  P20_GPH_DWN = 9.3;
            
            M20_BHP_UPP = 73;  M20_KTAS_UPP = 122;  M20_GPH_UPP = 10.0;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 120;  STD_GPH_UPP = 9.4;   P20_BHP_UPP = 63;  P20_KTAS_UPP = 119;  P20_GPH_UPP = 8.9;
            
        }
        
        
        if (RPM_LOW == 2600) {
            
            
            
            M20_BHP_DWN = 74;  M20_KTAS_DWN = 120;  M20_GPH_DWN = 10.0;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 119;  STD_GPH_DWN = 9.4;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 117;  P20_GPH_DWN = 8.9;
            
            M20_BHP_UPP = 69;  M20_KTAS_UPP = 119;  M20_GPH_UPP = 9.5;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 117;  STD_GPH_UPP = 9.0;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 115;  P20_GPH_UPP = 8.5;
            
        }
        
        
        if (RPM_LOW == 2500) {
            
            
            M20_BHP_DWN = 65;  M20_KTAS_DWN = 114;  M20_GPH_DWN = 9.1;   STD_BHP_DWN = 61;  STD_KTAS_DWN = 112;  STD_GPH_DWN = 8.6;   P20_BHP_DWN = 57;  P20_KTAS_DWN = 111;  P20_GPH_DWN = 8.1;
            
            M20_BHP_UPP = 62;  M20_KTAS_UPP = 113;  M20_GPH_UPP = 8.7;   STD_BHP_UPP = 57;  STD_KTAS_UPP = 111;  STD_GPH_UPP = 8.2;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 109;  P20_GPH_UPP = 7.8;
            
        }
        
        if (RPM_LOW == 2400) {
            
            
            M20_BHP_DWN = 58;  M20_KTAS_DWN = 108;  M20_GPH_DWN = 8.2;   STD_BHP_DWN = 54;  STD_KTAS_DWN = 106;  STD_GPH_DWN = 7.8;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 104;  P20_GPH_DWN = 7.4;
            
            M20_BHP_UPP = 55;  M20_KTAS_UPP = 106;  M20_GPH_UPP = 7.9;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 104;  STD_GPH_UPP = 7.5;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 102;  P20_GPH_UPP = 7.1;
            
        }
        
        if (RPM_LOW == 2300) {
            
            
            M20_BHP_DWN = 52;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 7.5;   STD_BHP_DWN = 48;  STD_KTAS_DWN = 99;  STD_GPH_DWN = 7.1;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 6.8;
            
            M20_BHP_UPP = 49;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 7.2;   STD_BHP_UPP = 46;  STD_KTAS_UPP = 97;  STD_GPH_UPP = 6.8;   P20_BHP_UPP = 44;  P20_KTAS_UPP = 95;  P20_GPH_UPP = 6.5;
            
        }
        
        
        if (RPM_LOW == 2200) {
            
            
            M20_BHP_DWN = 46;  M20_KTAS_DWN = 94;  M20_GPH_DWN = 6.8;   STD_BHP_DWN = 43;  STD_KTAS_DWN = 92;  STD_GPH_DWN = 6.5;   P20_BHP_DWN = 41;  P20_KTAS_DWN = 90;  P20_GPH_DWN = 6.2;
            
            M20_BHP_UPP = 49;  M20_KTAS_UPP = 94;  M20_GPH_UPP = 6.8;   STD_BHP_UPP = 43;  STD_KTAS_UPP = 92;  STD_GPH_UPP = 6.5;   P20_BHP_UPP = 41;  P20_KTAS_UPP = 90;  P20_GPH_UPP = 6.2;
            
        }
        
        
        
        
        if (RPM_HIGH == 2700) {
            
            
            M20_BHP_DWN2 = 83;  M20_KTAS_DWN2 = 125;  M20_GPH_DWN2 = 11.1;   STD_BHP_DWN2 = 77;  STD_KTAS_DWN2 = 124;  STD_GPH_DWN2 = 10.4;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 123;  P20_GPH_DWN2 = 9.7;
            
            M20_BHP_UPP2 = 78;  M20_KTAS_UPP2 = 124;  M20_GPH_UPP2 = 10.5;   STD_BHP_UPP2 = 72;  STD_KTAS_UPP2 = 123;  STD_GPH_UPP2 = 9.8;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 122;  P20_GPH_UPP2 = 9.3;
            
        }
        
        if (RPM_HIGH == 2650) {
            
            
            M20_BHP_DWN2 = 78;  M20_KTAS_DWN2 = 122;  M20_GPH_DWN2 = 10.5;   STD_BHP_DWN2 = 72;  STD_KTAS_DWN2 = 122;  STD_GPH_DWN2 = 9.9;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 120;  P20_GPH_DWN2 = 9.3;
            
            M20_BHP_UPP2 = 73;  M20_KTAS_UPP2 = 122;  M20_GPH_UPP2 = 10.0;   STD_BHP_UPP2 = 68;  STD_KTAS_UPP2 = 120;  STD_GPH_UPP2 = 9.4;   P20_BHP_UPP2 = 63;  P20_KTAS_UPP2 = 119;  P20_GPH_UPP2 = 8.9;
            
        }
        
        
        if (RPM_HIGH == 2600) {
            
            
            
            M20_BHP_DWN2 = 74;  M20_KTAS_DWN2 = 120;  M20_GPH_DWN2 = 10.0;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 119;  STD_GPH_DWN2 = 9.4;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 117;  P20_GPH_DWN2 = 8.9;
            
            M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 119;  M20_GPH_UPP2 = 9.5;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 117;  STD_GPH_UPP2 = 9.0;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 115;  P20_GPH_UPP2 = 8.5;
            
        }
        
        
        if (RPM_HIGH == 2500) {
            
            
            
            M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 114;  M20_GPH_DWN2 = 9.1;   STD_BHP_DWN2 = 61;  STD_KTAS_DWN2 = 112;  STD_GPH_DWN2 = 8.6;   P20_BHP_DWN2 = 57;  P20_KTAS_DWN2 = 111;  P20_GPH_DWN2 = 8.1;
            
            M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 113;  M20_GPH_UPP2 = 8.7;   STD_BHP_UPP2 = 57;  STD_KTAS_UPP2 = 111;  STD_GPH_UPP2 = 8.2;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 109;  P20_GPH_UPP2 = 7.8;
            
        }
        
        if (RPM_HIGH == 2400) {
            
            
            M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 108;  M20_GPH_DWN2 = 8.2;   STD_BHP_DWN2 = 54;  STD_KTAS_DWN2 = 106;  STD_GPH_DWN2 = 7.8;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 104;  P20_GPH_DWN2 = 7.4;
            
            M20_BHP_UPP2 = 55;  M20_KTAS_UPP2 = 106;  M20_GPH_UPP2 = 7.9;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 104;  STD_GPH_UPP2 = 7.5;   P20_BHP_UPP2 = 49;  P20_KTAS_UPP2 = 102;  P20_GPH_UPP2 = 7.1;
            
        }
        
        if (RPM_HIGH == 2300) {
            
            
            M20_BHP_DWN2 = 52;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 7.5;   STD_BHP_DWN2 = 48;  STD_KTAS_DWN2 = 99;  STD_GPH_DWN2 = 7.1;   P20_BHP_DWN2 = 46;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 6.8;
            
            M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 7.2;   STD_BHP_UPP2 = 46;  STD_KTAS_UPP2 = 97;  STD_GPH_UPP2 = 6.8;   P20_BHP_UPP2 = 44;  P20_KTAS_UPP2 = 95;  P20_GPH_UPP2 = 6.5;
            
        }
        
        
        if (RPM_HIGH == 2200) {
            
            
            M20_BHP_DWN2 = 46;  M20_KTAS_DWN2 = 94;  M20_GPH_DWN2 = 6.8;   STD_BHP_DWN2 = 43;  STD_KTAS_DWN2 = 92;  STD_GPH_DWN2 = 6.5;   P20_BHP_DWN2 = 41;  P20_KTAS_DWN2 = 90;  P20_GPH_DWN2 = 6.2;
            
            M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 94;  M20_GPH_UPP2 = 6.8;   STD_BHP_UPP2 = 43;  STD_KTAS_UPP2 = 92;  STD_GPH_UPP2 = 6.5;   P20_BHP_UPP2 = 41;  P20_KTAS_UPP2 = 90;  P20_GPH_UPP2 = 6.2;
            
        }
        
        
        //NSLog (@"M20_BHP_DWN %@ ", [ [NSString alloc] initWithFormat:@"%.0f", M20_BHP_DWN]);
        
        //NSLog (@"M20_BHP_DWN2 %@ ", [ [NSString alloc] initWithFormat:@"%.0f", M20_BHP_DWN2]);
        
        
        
        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    
    if (PressureAltitude >= 10000 & PressureAltitude <= 12000) {
        
        //NSLog (@"Hello 10000");
        
        PressAltAbzug = 10000;
        
        
        if (RPM == 2700) {
            
            
            
            M20_BHP_DWN = 78;  M20_KTAS_DWN = 124;  M20_GPH_DWN = 10.5;   STD_BHP_DWN = 72;  STD_KTAS_DWN = 123;  STD_GPH_DWN = 9.8;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 122;  P20_GPH_DWN = 9.3;
            
            M20_BHP_UPP = 78;  M20_KTAS_UPP = 124;  M20_GPH_UPP = 10.5;   STD_BHP_UPP = 72;  STD_KTAS_UPP = 123;  STD_GPH_UPP = 9.8;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 122;  P20_GPH_UPP = 9.3;
            
        }
        
        if (RPM == 2650) {
            
            
            
            M20_BHP_DWN = 73;  M20_KTAS_DWN = 122;  M20_GPH_DWN = 10.0;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 120;  STD_GPH_DWN = 9.4;   P20_BHP_DWN = 63;  P20_KTAS_DWN = 119;  P20_GPH_DWN = 8.9;
            
            M20_BHP_UPP = 69;  M20_KTAS_UPP = 121;  M20_GPH_UPP = 9.5;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 119;  STD_GPH_UPP = 8.9;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 117;  P20_GPH_UPP = 8.5;
            
        }
        
        
        if (RPM == 2600) {
            
            
            
            
            M20_BHP_DWN = 69;  M20_KTAS_DWN = 119;  M20_GPH_DWN = 9.5;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 117;  STD_GPH_DWN = 9.0;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 115;  P20_GPH_DWN = 8.5;
            
            M20_BHP_UPP = 65;  M20_KTAS_UPP = 118;  M20_GPH_UPP = 9.1;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 116;  STD_GPH_UPP = 8.5;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 114;  P20_GPH_UPP =8.1;
            
        }
        
        
        if (RPM == 2500) {
            
            
            
            
            M20_BHP_DWN = 62;  M20_KTAS_DWN = 113;  M20_GPH_DWN = 8.7;   STD_BHP_DWN = 57;  STD_KTAS_DWN = 111;  STD_GPH_DWN = 8.2;   P20_BHP_DWN = 54;  P20_KTAS_DWN = 109;  P20_GPH_DWN = 7.8;
            
            M20_BHP_UPP = 58;  M20_KTAS_UPP = 111;  M20_GPH_UPP = 8.3;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 109;  STD_GPH_UPP = 7.8;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 107;  P20_GPH_UPP = 7.4;
            
        }
        
        if (RPM == 2400) {
            
            
            
            
            M20_BHP_DWN = 55;  M20_KTAS_DWN = 106;  M20_GPH_DWN = 7.9;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 104;  STD_GPH_DWN = 7.5;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 102;  P20_GPH_DWN = 7.1;
            
            M20_BHP_UPP = 52;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 7.5;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 102;  STD_GPH_UPP = 7.1;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 100;  P20_GPH_UPP = 6.8;
            
        }
        
        if (RPM == 2300) {
            
            
            
            
            M20_BHP_DWN = 49;  M20_KTAS_DWN = 100;  M20_GPH_DWN = 7.2;   STD_BHP_DWN = 46;  STD_KTAS_DWN = 97;  STD_GPH_DWN = 6.8;   P20_BHP_DWN = 44;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 6.5;
            
            M20_BHP_UPP = 47;  M20_KTAS_UPP = 98;  M20_GPH_UPP = 6.9;   STD_BHP_UPP = 44;  STD_KTAS_UPP = 95;  STD_GPH_UPP = 6.6;   P20_BHP_UPP = 41;  P20_KTAS_UPP = 92;  P20_GPH_UPP = 6.3;
            
        }
        
        
        
        
        
        
        
        if (RPM_HIGH == 2700) {
            
            
            
            M20_BHP_DWN2 = 78;  M20_KTAS_DWN2 = 124;  M20_GPH_DWN2 = 10.5;   STD_BHP_DWN2 = 72;  STD_KTAS_DWN2 = 123;  STD_GPH_DWN2 = 9.8;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 122;  P20_GPH_DWN2 = 9.3;
            
            M20_BHP_UPP2 = 78;  M20_KTAS_UPP2 = 124;  M20_GPH_UPP2 = 10.5;   STD_BHP_UPP2 = 72;  STD_KTAS_UPP2 = 123;  STD_GPH_UPP2 = 9.8;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 122;  P20_GPH_UPP2 = 9.3;
            
        }
        
        if (RPM_HIGH == 2650) {
            
            
            
            M20_BHP_DWN2 = 73;  M20_KTAS_DWN2 = 122;  M20_GPH_DWN2 = 10.0;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 120;  STD_GPH_DWN2 = 9.4;   P20_BHP_DWN2 = 63;  P20_KTAS_DWN2 = 119;  P20_GPH_DWN2 = 8.9;
            
            M20_BHP_UPP2 = 69;  M20_KTAS_UPP2 = 121;  M20_GPH_UPP2 = 9.5;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 119;  STD_GPH_UPP2 = 8.9;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 117;  P20_GPH_UPP2 = 8.5;
            
        }
        
        
        if (RPM_HIGH == 2600) {
            
            
            
            
            M20_BHP_DWN2 = 69;  M20_KTAS_DWN2 = 119;  M20_GPH_DWN2 = 9.5;   STD_BHP_DWN2 = 64;  STD_KTAS_DWN2 = 117;  STD_GPH_DWN2 = 9.0;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 115;  P20_GPH_DWN2 = 8.5;
            
            M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 118;  M20_GPH_UPP2 = 9.1;   STD_BHP_UPP2 = 61;  STD_KTAS_UPP2 = 116;  STD_GPH_UPP2 = 8.5;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 114;  P20_GPH_UPP2 =8.1;
            
        }
        
        
        if (RPM_HIGH == 2500) {
            
            
            
            
            M20_BHP_DWN2 = 62;  M20_KTAS_DWN2 = 113;  M20_GPH_DWN2 = 8.7;   STD_BHP_DWN2 = 57;  STD_KTAS_DWN2 = 111;  STD_GPH_DWN2 = 8.2;   P20_BHP_DWN2 = 54;  P20_KTAS_DWN2 = 109;  P20_GPH_DWN2 = 7.8;
            
            M20_BHP_UPP2 = 58;  M20_KTAS_UPP2 = 111;  M20_GPH_UPP2 = 8.3;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 109;  STD_GPH_UPP2 = 7.8;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 107;  P20_GPH_UPP2 = 7.4;
            
        }
        
        if (RPM_HIGH == 2400) {
            
            
            
            
            M20_BHP_DWN2 = 55;  M20_KTAS_DWN2 = 106;  M20_GPH_DWN2 = 7.9;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 104;  STD_GPH_DWN2 = 7.5;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 102;  P20_GPH_DWN2 = 7.1;
            
            M20_BHP_UPP2 = 52;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 7.5;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 102;  STD_GPH_UPP2 = 7.1;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 100;  P20_GPH_UPP2 = 6.8;
            
        }
        
        if (RPM_HIGH == 2300) {
            
            
            
            
            M20_BHP_DWN2 = 49;  M20_KTAS_DWN2 = 100;  M20_GPH_DWN2 = 7.2;   STD_BHP_DWN2 = 46;  STD_KTAS_DWN2 = 97;  STD_GPH_DWN2 = 6.8;   P20_BHP_DWN2 = 44;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 6.5;
            
            M20_BHP_UPP2 = 47;  M20_KTAS_UPP2 = 98;  M20_GPH_UPP2 = 6.9;   STD_BHP_UPP2 = 44;  STD_KTAS_UPP2 = 95;  STD_GPH_UPP2 = 6.6;   P20_BHP_UPP2 = 41;  P20_KTAS_UPP2 = 92;  P20_GPH_UPP2 = 6.3;
            
        }
        
        
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    // interpolate RPM
    
    M20_BHP_DWN_MED = M20_BHP_DWN + ((M20_BHP_DWN2 - M20_BHP_DWN ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_BHP_UPP_MED = M20_BHP_UPP + ((M20_BHP_UPP2 - M20_BHP_UPP ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    
    
    M20_KTAS_DWN_MED = M20_KTAS_DWN + ((M20_KTAS_DWN2 - M20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_KTAS_UPP_MED = M20_KTAS_UPP + ((M20_KTAS_UPP2 - M20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    M20_GPH_DWN_MED = M20_GPH_DWN + ((M20_GPH_DWN2 - M20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_GPH_UPP_MED = M20_GPH_UPP + ((M20_GPH_UPP2 - M20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_BHP_DWN_MED = STD_BHP_DWN + ((STD_BHP_DWN2 - STD_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_BHP_UPP_MED = STD_BHP_UPP + ((STD_BHP_UPP2 - STD_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_KTAS_DWN_MED = STD_KTAS_DWN + ((STD_KTAS_DWN2 - STD_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_KTAS_UPP_MED = STD_KTAS_UPP + ((STD_KTAS_UPP2 - STD_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_GPH_DWN_MED = STD_GPH_DWN + ((STD_GPH_DWN2 - STD_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_GPH_UPP_MED = STD_GPH_UPP + ((STD_GPH_UPP2 - STD_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_BHP_DWN_MED = P20_BHP_DWN + ((P20_BHP_DWN2 - P20_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_BHP_UPP_MED = P20_BHP_UPP + ((P20_BHP_UPP2 - P20_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_KTAS_DWN_MED = P20_KTAS_DWN + ((P20_KTAS_DWN2 - P20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_KTAS_UPP_MED = P20_KTAS_UPP + ((P20_KTAS_UPP2 - P20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_GPH_DWN_MED = P20_GPH_DWN + ((P20_GPH_DWN2 - P20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_GPH_UPP_MED = P20_GPH_UPP + ((P20_GPH_UPP2 - P20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    temp = ISAdiff;
    //NSLog(@"temp = %.1f ", temp);
    
    // interpolate temperature
    
    if (temp >= 0 & temp <= 20) {
        
        low_BHP     = STD_BHP_DWN_MED      - (( (STD_BHP_DWN_MED   - P20_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED     - (( (STD_KTAS_DWN_MED  - P20_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED      - (( (STD_GPH_DWN_MED   - P20_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        high_BHP    = STD_BHP_UPP_MED     - (( (STD_BHP_UPP_MED   - P20_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS   = STD_KTAS_UPP_MED    - (( (STD_KTAS_UPP_MED  - P20_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED     - (( (STD_GPH_UPP_MED   - P20_GPH_UPP_MED)  / 20 ) * temp) ;
        
        
        
        
    }
    
    
    
    if (temp < 0 & temp >= -20) {
        
        low_BHP     = STD_BHP_DWN_MED   - (( (M20_BHP_DWN_MED   - STD_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED  - (( (M20_KTAS_DWN_MED  - STD_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED   - (( (M20_GPH_DWN_MED   - STD_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        
        high_BHP   = STD_BHP_UPP_MED    - (( (M20_BHP_UPP_MED   - STD_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS  = STD_KTAS_UPP_MED   - (( (M20_KTAS_UPP_MED  - STD_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED   - (( (M20_GPH_UPP_MED   - STD_GPH_UPP_MED)  / 20 ) * temp) ;
    }
    
    
    
    // interpolate for PRESSURE ALT    
    resultCruiseBHP =    low_BHP -  ( ((low_BHP - high_BHP) / 2000) * (PressureAltitude - PressAltAbzug) );
    resultCruiseKTAS =  low_KTAS -  ( ((low_KTAS - high_KTAS) / 2000) * (PressureAltitude - PressAltAbzug) );    
    resultCruiseFuelBurn =    low_GPH -  ( ((low_GPH - high_GPH) / 2000) * (PressureAltitude - PressAltAbzug) );
    
    //NSLog(@"RPM %f", RPM);
    //NSLog(@"resultCruiseBHP %f", resultCruiseBHP);
    
    return;
    
    
}
- (void) setRPMsliderValuesC172S {
    
        
    if (PressureAltitude >= 0 & PressureAltitude < 4000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2550;       
    }
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2600;
    }
    
   
    if (PressureAltitude >= 6000 & PressureAltitude < 8000 ) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2650;        
       
    }
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2700;
       
    }
    
    if (PressureAltitude >= 10000 & PressureAltitude < 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2700;        
      
    }
    
    if (PressureAltitude >= 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2650;
    }
    
    resultRPMmin = sliderRPMmin;
    resultRPMmax = sliderRPMmax;
    
    
}


// PA28 Archer II **************************************************************************************************

- (void) takeoff_PA28ArcherIIFlaps25 {
    
    
    float indexOAT = sliderOATvalue;
    float MaxPA_1 = 0, MaxPA_2 = 0;
    float index1 = 0;
    float indexWeight = 0;
    float Hp = PressureAltitude;
    float OAT = sliderOATvalue;
    float indexWind = 0;
    
   
    
    
    
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 1000) {
        MaxPA_1 = (0.00011904761904762 * powf(OAT, 2) )   + ( 0.379761904761905  * OAT ) + 6   ; MaxPA_2 = (0.00011904761904762 * powf(OAT, 2) )   + ( 0.379761904761905  * OAT ) + 10   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp )  );
    }
    
    if (Hp >= 1000 & Hp < 2000) {
        
        MaxPA_1 = (0.00011904761904762 * powf(OAT, 2) )   + ( 0.379761904761905  * OAT ) + 10   ; MaxPA_2 = (0.000428571428571427 * powf(OAT, 2) )   + ( 0.397142857142857  * OAT ) + 14.2   ;        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 1000)  );
    }
    
    
    
    if (Hp >= 2000 & Hp < 3000) {        
        
        MaxPA_1 = (0.000428571428571427 * powf(OAT, 2) )   + ( 0.397142857142857  * OAT ) + 14.2   ; MaxPA_2 = (0.000595238095238095 * powf(OAT, 2) )   + ( 0.398809523809524  * OAT ) + 18   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 2000)  );
        
    }
    
    
    if (Hp >= 3000 & Hp < 5000) {        
        
        MaxPA_1 = (0.000595238095238095 * powf(OAT, 2) )   + ( 0.398809523809524  * OAT ) + 18   ; MaxPA_2 = (0.000714285714285712 * powf(OAT, 2) )   + ( 0.428571428571429  * OAT ) + 27   ;        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 3000)  );
        
    }
    
    
    if (Hp >= 5000 & Hp <= 8000) {        
        
        MaxPA_1 = (0.000714285714285712 * powf(OAT, 2) )   + ( 0.428571428571429  * OAT ) + 27   ; MaxPA_2 = (0.00254761904761905 * powf(OAT, 2) )   + ( 0.546904761904762  * OAT ) + 35.8   ;
                indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 5000)  );
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 10  & indexOAT < 20) { float y1 = 10;   float y2 = 20;
        MaxPA_1 =  (-1.76406926406923E-08 * powf(index1, 3) )  + (0.000125178571428569 * powf(index1, 2) )   + ( -0.280687229437224  * index1 ) + 204.285714285711 ;  MaxPA_2 =  (-1.90476190476188E-08 * powf(index1, 3) )  + (0.000135714285714284 * powf(index1, 2) )   + ( -0.30030952380952  * index1 ) + 219.142857142854;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    
    
    if (indexOAT >= 20  & indexOAT < 25) { float y1 = 20;   float y2 = 25;
        MaxPA_1 =  (-1.90476190476188E-08 * powf(index1, 3) )  + (0.000135714285714284 * powf(index1, 2) )   + ( -0.30030952380952  * index1 ) + 219.142857142854 ;  MaxPA_2 =  (2.16450216450211E-08 * powf(index1, 3) )  + (-0.000142857142857139 * powf(index1, 2) )   + ( 0.335919913419906  * index1 ) + -261.571428571423;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    
    
    if (indexOAT >= 25  & indexOAT < 30) { float y1 = 25;   float y2 = 30;
        MaxPA_1 =  (2.16450216450211E-08 * powf(index1, 3) )  + (-0.000142857142857139 * powf(index1, 2) )   + ( 0.335919913419906  * index1 ) + -261.571428571423 ;  MaxPA_2 =  (-2.21861471861469E-08 * powf(index1, 3) )  + (0.000157678571428569 * powf(index1, 2) )   + ( -0.344005411255407  * index1 ) + 249.785714285711;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    
    
    if (indexOAT >= 30  & indexOAT < 40) { float y1 = 30;   float y2 = 40;
        MaxPA_1 =  (-2.21861471861469E-08 * powf(index1, 3) )  + (0.000157678571428569 * powf(index1, 2) )   + ( -0.344005411255407  * index1 ) + 249.785714285711 ;  MaxPA_2 =  (-2.70562770562763E-08 * powf(index1, 3) )  + (0.000191071428571424 * powf(index1, 2) )   + ( -0.411774891774882  * index1 ) + 296.214285714278;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    
    
    if (indexOAT >= 40  & indexOAT < 45) { float y1 = 40;   float y2 = 45;
        MaxPA_1 =  (-2.70562770562763E-08 * powf(index1, 3) )  + (0.000191071428571424 * powf(index1, 2) )   + ( -0.411774891774882  * index1 ) + 296.214285714278 ;  MaxPA_2 =  (1.89393939393935E-08 * powf(index1, 3) )  + (-0.000118749999999997 * powf(index1, 2) )   + ( 0.282992424242418  * index1 ) + -218.499999999995;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    
    
    if (indexOAT >= 45  & indexOAT <= 50) { float y1 = 45;   float y2 = 50;
        MaxPA_1 =  (1.89393939393935E-08 * powf(index1, 3) )  + (-0.000118749999999997 * powf(index1, 2) )   + ( 0.282992424242418  * index1 ) + -218.499999999995 ;  MaxPA_2 =  (1.62337662337662E-08 * powf(index1, 3) )  + (-9.46428571428572E-05 * powf(index1, 2) )   + ( 0.220064935064935  * index1 ) + -164.928571428572;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    if (indexWeight < 0) {
        indexWeight = 0;
    }
    
    if (indexWeight > 44) {
        indexWeight = 44;
    }
    
   

    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= -6  & indexWeight < 5) {  float y1 = -6;   float y2 = 5;
            MaxPA_1 = -0.267 * index1 + -6 ;   MaxPA_2 = -0.387 *index1 + 5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );              
        }
        
        if (indexWeight >= 5  & indexWeight < 15) {  float y1 = 5;   float y2 = 15;
            MaxPA_1 = -0.453 * index1 + 5 ;   MaxPA_2 = -0.52 *index1 + 15 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 15  & indexWeight < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1 = -0.453 * index1 + 15 ;   MaxPA_2 = -0.587 *index1 + 25 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );             
        }
        if (indexWeight >= 15  & indexWeight < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1 = -0.6 * index1 + 25 ;   MaxPA_2 = -0.767 *index1 + 35.5 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 25  & indexWeight < 35.5) {  float y1 = 25;   float y2 = 35.5;
            MaxPA_1 = -0.6 * index1 + 25 ;   MaxPA_2 = -0.767 *index1 + 35.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 35.5  & indexWeight < 50.5) {  float y1 = 35.5;   float y2 = 50.5;
            MaxPA_1 = -0.767 * index1 + 35.5 ;   MaxPA_2 = -0.953 *index1 + 50.5 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
    }else{
     //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= -5  & indexWeight < 5) {  float y1 = -5;   float y2 = 5;
            MaxPA_1 = 1 * index1 + -5 ;   MaxPA_2 = 1 *index1 + 5 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );            
        }
        
        if (indexWeight >= 5  & indexWeight < 15) {  float y1 = 5;   float y2 = 15;
            MaxPA_1 = 1 * index1 + 5 ;   MaxPA_2 = 1.333 *index1 + 15 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        if (indexWeight >= 15  & indexWeight < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1 = 1.333 * index1 + 15 ;   MaxPA_2 = 1.667 *index1 + 25 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        if (indexWeight >= 25  & indexWeight < 30) {  float y1 = 25;   float y2 = 30;
            MaxPA_1 = 1.667 * index1 + 25 ;   MaxPA_2 = 2 *index1 + 30 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 30  & indexWeight < 51) {  float y1 = 30;   float y2 = 50;
            MaxPA_1 = 2 * index1 + 30 ;   MaxPA_2 = 2.667 *index1 + 50 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
    }// end head/tailwind
    
     //NSLog(@"2 indexWind %.2f", indexWind);
        
    if (indexWind < 0) {
        indexWind = 0;
    }
    
    if (indexWind > 70) {
        indexWind = 70;
    }
    
    
    float resultWithWind =  400 + (   ( (2400-400) / 50 ) * indexWind );
    resultGroundRoll =  400 + (   ( (2400-400) / 50 ) * indexWeight );      
    resultWindDifferenceGR_TO = resultWithWind - resultGroundRoll;
       
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 1000) {
        MaxPA_1 = (0.000595238095238095 * powf(OAT, 2) )   + ( 0.548809523809524  * OAT ) + 8   ; MaxPA_2 = (0.000595238095238098 * powf(OAT, 2) )   + ( 0.648809523809524  * OAT ) + 14   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp )  );
        
    }
    
    if (Hp >= 1000 & Hp < 2000) {
        MaxPA_1 = (0.000595238095238098 * powf(OAT, 2) )   + ( 0.648809523809524  * OAT ) + 14   ; MaxPA_2 = (0.00104761904761904 * powf(OAT, 2) )   + ( 0.691904761904762  * OAT ) + 20   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 1000)  );
        
    }
    
    
    
    if (Hp >= 2000 & Hp < 3000) {
        MaxPA_1 = (0.00104761904761904 * powf(OAT, 2) )   + ( 0.691904761904762  * OAT ) + 20   ; MaxPA_2 = (0.00205952380952381 * powf(OAT, 2) )   + ( 0.794880952380952  * OAT ) + 28   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 2000)  );
       
    }
    
    
    if (Hp >= 3000 & Hp < 5000) {
        
        MaxPA_1 = (0.00220238095238095 * powf(OAT, 2) )   + ( 0.800595238095238  * OAT ) + 28   ; MaxPA_2 = (0.00220238095238095 * powf(OAT, 2) )   + ( 0.900595238095238  * OAT ) + 45   ;
                indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 3000)  );
    }
    
    
    if (Hp >= 5000 & Hp <= 8000) {
        MaxPA_1 = (0.00220238095238095 * powf(OAT, 2) )   + ( 0.900595238095238  * OAT ) + 45   ; MaxPA_2 = (0.00613095238095238 * powf(OAT, 2) )   + ( 1.2827380952381  * OAT ) + 67   ;        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 5000)  );
        
        
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
     index1 = ACweightLBS;
    
    if (indexOAT >= 11.5  & indexOAT < 21.5) { float y1 = 11.5;   float y2 = 21.5;
        MaxPA_1 =  (-1.98051948051945E-08 * powf(index1, 3) )  + (0.000144464285714284 * powf(index1, 2) )   + ( -0.321029220779217  * index1 ) + 219.142857142855 ;  MaxPA_2 =  (-1.0822510822512E-09 * powf(index1, 3) )  + (1.96428571428579E-05 * powf(index1, 2) )   + ( -0.0406709956709975  * index1 ) + 15.4285714285728;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 21.5  & indexOAT < 33) { float y1 = 21.5;   float y2 = 33;
        MaxPA_1 =  (-1.0822510822512E-09 * powf(index1, 3) )  + (1.96428571428579E-05 * powf(index1, 2) )   + ( -0.0406709956709975  * index1 ) + 15.4285714285728 ;  MaxPA_2 =  (5.41125541125918E-10 * powf(index1, 3) )  + (1.51785714285689E-05 * powf(index1, 2) )   + ( -0.0384145021644966  * index1 ) + 23.2857142857101;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 33  & indexOAT < 39) { float y1 = 33;   float y2 = 39;
        MaxPA_1 =  (5.41125541125918E-10 * powf(index1, 3) )  + (1.51785714285689E-05 * powf(index1, 2) )   + ( -0.0384145021644966  * index1 ) + 23.2857142857101 ;  MaxPA_2 =  (-2.54329004329E-08 * powf(index1, 3) )  + (0.00018660714285714 * powf(index1, 2) )   + ( -0.409518398268392  * index1 ) + 291.571428571424;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 39  & indexOAT < 48) { float y1 = 39;   float y2 = 48;
        MaxPA_1 =  (-2.54329004329E-08 * powf(index1, 3) )  + (0.00018660714285714 * powf(index1, 2) )   + ( -0.409518398268392  * index1 ) + 291.571428571424 ;  MaxPA_2 =  (6.25541125541116E-08 * powf(index1, 3) )  + (-0.000395357142857137 * powf(index1, 2) )   + ( 0.873783549783537  * index1 ) + -646.571428571419;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 48  & indexOAT < 57) { float y1 = 48;   float y2 = 57;
        MaxPA_1 =  (6.25541125541116E-08 * powf(index1, 3) )  + (-0.000395357142857137 * powf(index1, 2) )   + ( 0.873783549783537  * index1 ) + -646.571428571419 ;  MaxPA_2 =  (3.38744588744584E-08 * powf(index1, 3) )  + (-0.000199821428571425 * powf(index1, 2) )   + ( 0.439752164502157  * index1 ) + -326.71428571428;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 57  & indexOAT < 67) { float y1 = 57;   float y2 = 67;
        MaxPA_1 =  (3.38744588744584E-08 * powf(index1, 3) )  + (-0.000199821428571425 * powf(index1, 2) )   + ( 0.439752164502157  * index1 ) + -326.71428571428 ;  MaxPA_2 =  (8.90692640692624E-08 * powf(index1, 3) )  + (-0.000551607142857133 * powf(index1, 2) )   + ( 1.18647294372292  * index1 ) + -848.571428571413;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
         }
    
    
    if (indexWeight < 0) {
        indexWeight = 0;
    }
    
    if (indexWeight > 44) {
        indexWeight = 44;
    }
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= -5  & indexWeight < 6) {  float y1 = -5;   float y2 = 6;
            MaxPA_1 = -0.267 * index1 + -5 ;   MaxPA_2 = -0.5 *index1 + 6 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 6  & indexWeight < 14.5) {  float y1 = 6;   float y2 = 14.5;
            MaxPA_1 = -0.5 * index1 + 6 ;   MaxPA_2 = -0.547 *index1 + 14.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        } 
        if (indexWeight >= 14.5  & indexWeight < 22.5) {  float y1 = 14.5;   float y2 = 22.5;
            MaxPA_1 = -0.52 * index1 + 14.5 ;   MaxPA_2 = -0.567 *index1 + 22.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 22.5  & indexWeight < 30.5) {  float y1 = 22.5;   float y2 = 30.5;
            MaxPA_1 = -0.667 * index1 + 22.5 ;   MaxPA_2 = -0.733 *index1 + 30.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 30.5  & indexWeight < 60.5) {  float y1 = 30.5;   float y2 = 60.5;
            MaxPA_1 = -0.733 * index1 + 30.5 ;   MaxPA_2 = -1 *index1 + 60.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= -5  & indexWeight < 6) {  float y1 = -5;   float y2 = 6;
            MaxPA_1 = -0.267 * index1 + -5 ;   MaxPA_2 = 1.533 *index1 + 6 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 6  & indexWeight < 14.5) {  float y1 = 6;   float y2 = 14.5;
            MaxPA_1 = 1.533 * index1 + 6 ;   MaxPA_2 = 1.467 *index1 + 14.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 14.5  & indexWeight < 22.5) {  float y1 = 14.5;   float y2 = 22.5;
            MaxPA_1 = 1.467 * index1 + 14.5 ;   MaxPA_2 = 2.2 *index1 + 22.5 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
    }// end head/tailwind
    
     //NSLog(@"indexWind %.2f", indexWind);
    
    if (indexWind < 0) {
        indexWind = 0;
    }
    
    if (indexWind > 70) {
        indexWind = 70;
    }
    
    
  
    
    resultWithWind = 1000 + (   ( (3400-1000) / 60 ) * indexWind );
    resultDistanceOverObstacle = 1000 + (   ( (3400-1000) / 60 ) * indexWeight );
    resultWindDifference50ft_TO = resultWithWind - resultDistanceOverObstacle;
    
    
    
    
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultGroundRoll %.0f", resultGroundRoll);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}
- (void) landing_PA28ArcherIIFlaps25 {
    
    float Hp_LD = PressureAltitude;
    float MaxPA_1_LD = 0, MaxPA_2_LD = 0;
    float indexOAT_LD = 0;
    float OAT_LD = sliderOATvalue;
    float indexWeight_LD = 0;
    float indexWind_LD = 0;
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 1000) {        
        
        MaxPA_1_LD = (0.000119047619047617 * powf(OAT_LD, 2) )   + ( 0.329761904761905  * OAT_LD ) + 27   ; MaxPA_2_LD = (1.19047619047603E-05 * powf(OAT_LD, 2) )   + ( 0.33297619047619  * OAT_LD ) + 30.3   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD )  );  
    }
    
    if (Hp_LD >= 1000 & Hp_LD < 2000) {
        MaxPA_1_LD = (1.19047619047603E-05 * powf(OAT_LD, 2) )   + ( 0.33297619047619  * OAT_LD ) + 30.3   ; MaxPA_2_LD = (1.19047619047587E-05 * powf(OAT_LD, 2) )   + ( 0.33297619047619  * OAT_LD ) + 33.1   ;
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 1000)  );        
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 3000) {
        
        MaxPA_1_LD = (1.19047619047587E-05 * powf(OAT_LD, 2) )   + ( 0.33297619047619  * OAT_LD ) + 33.1   ; MaxPA_2_LD = (0.000309523809523805 * powf(OAT_LD, 2) )   + ( 0.357380952380952  * OAT_LD ) + 35.6   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 2000)  );
    }
    
    
    if (Hp_LD >= 3000 & Hp_LD < 5000) {
        
        MaxPA_1_LD = (0.000309523809523805 * powf(OAT_LD, 2) )   + ( 0.357380952380952  * OAT_LD ) + 35.6   ; MaxPA_2_LD = (0.000214285714285712 * powf(OAT_LD, 2) )   + ( 0.403571428571428  * OAT_LD ) + 43.1   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 3000)  ); 
    }
    
    if (Hp_LD >= 5000 & Hp_LD <= 8000) {
        MaxPA_1_LD = (0.000214285714285712 * powf(OAT_LD, 2) )   + ( 0.403571428571428  * OAT_LD ) + 43.1   ; MaxPA_2_LD = (0.000095238095238084 * powf(OAT_LD, 2) )   + ( 0.423809523809524  * OAT_LD ) + 52.6   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 5000)  );
    }
    
    if (indexOAT_LD > 60) {
        indexOAT_LD = 60;
    }    
    if (indexOAT_LD < 27) {
        indexOAT_LD = 27;
    }
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    float index1_LD = ACweightLBS;
    
    if (indexOAT_LD >= 26  & indexOAT_LD < 32.4) { float y1 = 26;   float y2 = 32.4;
        MaxPA_1_LD =  (-8.65800865800857E-09 * powf(index1_LD, 3) )  + (5.71428571428566E-05 * powf(index1_LD, 2) )   + ( -0.0903679653679642  * index1_LD ) + 28.4285714285706 ;  MaxPA_2_LD =  (-1.46103896103898E-08 * powf(index1_LD, 3) )  + (0.000100178571428573 * powf(index1_LD, 2) )   + ( -0.193308441558444  * index1_LD ) + 116.185714285717;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
         }
    
    
    
    if (indexOAT_LD >= 32.4  & indexOAT_LD < 39.4) { float y1 = 32.4;   float y2 = 39.4;
        MaxPA_1_LD =  (-1.46103896103898E-08 * powf(index1_LD, 3) )  + (0.000100178571428573 * powf(index1_LD, 2) )   + ( -0.193308441558444  * index1_LD ) + 116.185714285717 ;  MaxPA_2_LD =  (-1.00649350649347E-08 * powf(index1_LD, 3) )  + (6.76785714285691E-05 * powf(index1_LD, 2) )   + ( -0.115990259740255  * index1_LD ) + 61.9857142857104;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        }
    
    
    
    if (indexOAT_LD >= 39.4  & indexOAT_LD < 46.6) { float y1 = 39.4;   float y2 = 46.6;
        MaxPA_1_LD =  (-1.00649350649347E-08 * powf(index1_LD, 3) )  + (6.76785714285691E-05 * powf(index1_LD, 2) )   + ( -0.115990259740255  * index1_LD ) + 61.9857142857104 ;  MaxPA_2_LD =  (-9.1991341991335E-09 * powf(index1_LD, 3) )  + (6.19642857142811E-05 * powf(index1_LD, 2) )   + ( -0.100953463203453  * index1_LD ) + 53.6428571428496;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        }
    
    
    
    if (indexOAT_LD >= 46.6  & indexOAT_LD < 53.6) { float y1 = 46.6;   float y2 = 53.6;
        MaxPA_1_LD =  (-9.1991341991335E-09 * powf(index1_LD, 3) )  + (6.19642857142811E-05 * powf(index1_LD, 2) )   + ( -0.100953463203453  * index1_LD ) + 53.6428571428496 ;  MaxPA_2_LD =  (-3.2467532467527E-09 * powf(index1_LD, 3) )  + (1.89285714285677E-05 * powf(index1_LD, 2) )   + ( 0.00398701298702126  * index1_LD ) + -25.8142857142919;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
         }
    
    
    
    if (indexOAT_LD >= 53.6  & indexOAT_LD < 61.1) { float y1 = 53.6;   float y2 = 61.1;
        MaxPA_1_LD =  (-3.2467532467527E-09 * powf(index1_LD, 3) )  + (1.89285714285677E-05 * powf(index1_LD, 2) )   + ( 0.00398701298702126  * index1_LD ) + -25.8142857142919 ;  MaxPA_2_LD =  (5.73593073593115E-09 * powf(index1_LD, 3) )  + (-3.91071428571457E-05 * powf(index1_LD, 2) )   + ( 0.130806277056284  * index1_LD ) + -113.271428571433;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
         }
    
    if (indexWeight_LD < 7) {
        indexWeight_LD = 7;
    }
    
    //NSLog(@"index1_LD %.2f", index1_LD);
    //NSLog(@"indexWeight_LD %.2f", indexWeight_LD);
  
    //NSLog(@"1 indexWeight %.1f", indexWeight);    
    //NSLog(@"2 headWindKts %.0f", headWindKts);
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = -1.2 * index1_LD + 0 ;   MaxPA_2_LD = -1.267 *index1_LD + 10 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD = -1.267 * index1_LD + 10 ;   MaxPA_2_LD = -1.4 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30.2) {  float y1 = 20;   float y2 = 30.2;
            MaxPA_1_LD = -1.4 * index1_LD + 20 ;   MaxPA_2_LD = -1.48 *index1_LD + 30.2 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 30.2  & indexWeight_LD < 40.2) {  float y1 = 30.2;   float y2 = 40.2;
            MaxPA_1_LD = -1.48 * index1_LD + 30.2 ;   MaxPA_2_LD = -1.58 *index1_LD + 40.2 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }        
        
        if (indexWeight_LD >= 40.2  & indexWeight_LD <= 60) {  float y1 = 40.2;   float y2 = 60;
            MaxPA_1_LD = -1.58 * index1_LD + 40.2 ;   MaxPA_2_LD = -1.7 *index1_LD + 60 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
      
        
    }else{
        //Tailwind           
        index1_LD = headWindKts * -1;        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = 3.667 * index1_LD + 0 ;   MaxPA_2_LD = 4.133 *index1_LD + 10 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );            
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 30) {  float y1 = 10;   float y2 = 30;
            MaxPA_1_LD = 4.133 * index1_LD + 10 ;   MaxPA_2_LD = 5 *index1_LD + 30 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        if (indexWeight_LD >= 30  & indexWeight_LD <= 60) {  float y1 = 30;   float y2 = 60;
            MaxPA_1_LD = 5 * index1_LD + 30 ;   MaxPA_2_LD = 4.667 *index1_LD + 60 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
    }// end head/tailwind
    
   
    
    if (indexWind_LD < 0) {
        indexWind_LD = 0;
    }
    
    if (indexWind_LD > 60) {
        indexWind_LD = 60;
    }
    
    float resultWithWind = ( ( (1200 - 600) / 60 ) * indexWind_LD ) + 600;
    resultGroundRoll = ( ( (1200 - 600) / 60 ) * indexWeight_LD ) + 600;    
    resultWindDifferenceGR_LD = resultWithWind - resultGroundRoll;
    
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 1000) {
        MaxPA_1_LD = (0.000773809523809524 * powf(OAT_LD, 2) )   + ( 0.293452380952381  * OAT_LD ) + 15.5   ; MaxPA_2_LD = (0.000666666666666665 * powf(OAT_LD, 2) )   + ( 0.296666666666667  * OAT_LD ) + 18.8   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD )  );
    }
    
    if (Hp_LD >= 1000 & Hp_LD < 2000) {
        MaxPA_1_LD = (0.000666666666666665 * powf(OAT_LD, 2) )   + ( 0.296666666666667  * OAT_LD ) + 18.8   ; MaxPA_2_LD = (0.000738095238095235 * powf(OAT_LD, 2) )   + ( 0.294523809523809  * OAT_LD ) + 21.4   ;
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 1000)  );
    }
    
    
    
    if (Hp_LD >= 2000 & Hp_LD < 3000) {
        MaxPA_1_LD = (0.000738095238095235 * powf(OAT_LD, 2) )   + ( 0.294523809523809  * OAT_LD ) + 21.4   ; MaxPA_2_LD = (0.00103571428571428 * powf(OAT_LD, 2) )   + ( 0.318928571428571  * OAT_LD ) + 23.9   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 2000)  );
    }
    
    
    if (Hp_LD >= 3000 & Hp_LD <= 5000) {
        MaxPA_1_LD = (0.00103571428571428 * powf(OAT_LD, 2) )   + ( 0.318928571428571  * OAT_LD ) + 23.9   ; MaxPA_2_LD = (0.00133333333333333 * powf(OAT_LD, 2) )   + ( 0.343333333333333  * OAT_LD ) + 28.2   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 3000)  );
    }
    
    
    if (Hp_LD >= 5000 & Hp_LD <= 8000) {
        MaxPA_1_LD = (0.00133333333333333 * powf(OAT_LD, 2) )   + ( 0.343333333333333  * OAT_LD ) + 28.2   ; MaxPA_2_LD = (0.00130952380952381 * powf(OAT_LD, 2) )   + ( 0.427380952380952  * OAT_LD ) + 40.1   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 5000)  );
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1_LD = ACweightLBS;
    
    if (indexOAT_LD >= 10  & indexOAT_LD < 20) { float y1 = 10;   float y2 = 20;
        MaxPA_1_LD =  (8.87445887445861E-09 * powf(index1_LD, 3) )  + (-6.10714285714269E-05 * powf(index1_LD, 2) )   + ( 0.164502164502161  * index1_LD ) + -159.514285714283 ;  MaxPA_2_LD =  (3.13852813852813E-09 * powf(index1_LD, 3) )  + (-2.19642857142857E-05 * powf(index1_LD, 2) )   + ( 0.0796958874458875  * index1_LD ) + -92.4428571428573;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
       }
    if (indexOAT_LD >= 20  & indexOAT_LD < 30) { float y1 = 20;   float y2 = 30;
        MaxPA_1_LD =  (3.13852813852813E-09 * powf(index1_LD, 3) )  + (-2.19642857142857E-05 * powf(index1_LD, 2) )   + ( 0.0796958874458875  * index1_LD ) + -92.4428571428573 ;  MaxPA_2_LD =  (-2.59740259740259E-09 * powf(index1_LD, 3) )  + (1.71428571428571E-05 * powf(index1_LD, 2) )   + ( -0.00511038961038951  * index1_LD ) + -25.3714285714287;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        }
    if (indexOAT_LD >= 30  & indexOAT_LD < 40.2) { float y1 = 30;   float y2 = 40.2;
        MaxPA_1_LD =  (-2.59740259740259E-09 * powf(index1_LD, 3) )  + (1.71428571428571E-05 * powf(index1_LD, 2) )   + ( -0.00511038961038951  * index1_LD ) + -25.3714285714287 ;  MaxPA_2_LD =  (-1.0281385281385E-08 * powf(index1_LD, 3) )  + (7.16071428571409E-05 * powf(index1_LD, 2) )   + ( -0.128124458874455  * index1_LD ) + 71.7714285714255;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
       }
    if (indexOAT_LD >= 40.2  & indexOAT_LD < 49) { float y1 = 40.2;   float y2 = 49;
        MaxPA_1_LD =  (-1.0281385281385E-08 * powf(index1_LD, 3) )  + (7.16071428571409E-05 * powf(index1_LD, 2) )   + ( -0.128124458874455  * index1_LD ) + 71.7714285714255 ;  MaxPA_2_LD =  (-1.61255411255417E-08 * powf(index1_LD, 3) )  + (0.000107678571428575 * powf(index1_LD, 2) )   + ( -0.199247835497844  * index1_LD ) + 124.285714285721;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
         }
    if (indexOAT_LD >= 49  & indexOAT_LD <= 60) { float y1 = 49;   float y2 = 60;
        MaxPA_1_LD =  (-1.61255411255417E-08 * powf(index1_LD, 3) )  + (0.000107678571428575 * powf(index1_LD, 2) )   + ( -0.199247835497844  * index1_LD ) + 124.285714285721 ;  MaxPA_2_LD =  (4.00432900432805E-09 * powf(index1_LD, 3) )  + (-2.76785714285651E-05 * powf(index1_LD, 2) )   + ( 0.11073268398267  * index1_LD ) + -108.785714285704;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
       }
    if (indexWeight_LD < 7) {
        indexWeight_LD = 7;
    }
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = -1.667 * index1_LD + 0 ;   MaxPA_2_LD = -1.867 *index1_LD + 10 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD = -1.867 * index1_LD + 10 ;   MaxPA_2_LD = -1.867 *index1_LD + 20 ; 
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        if (indexWeight_LD >= 20  & indexWeight_LD < 30.2) {  float y1 = 20;   float y2 = 30.2;
            MaxPA_1_LD = -1.867 * index1_LD + 20 ;   MaxPA_2_LD = -1.813 *index1_LD + 30.2 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        if (indexWeight_LD >= 30.2  & indexWeight_LD < 40.2) {  float y1 = 30.2;   float y2 = 40.2;
            MaxPA_1_LD = -1.813 * index1_LD + 30.2 ;   MaxPA_2_LD = -1.947 *index1_LD + 40.2 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        if (indexWeight_LD >= 40.2  & indexWeight_LD <= 60) {  float y1 = 40.2;   float y2 = 60;
            MaxPA_1_LD = -1.947 * index1_LD + 40.2 ;   MaxPA_2_LD = -2.067 *index1_LD + 60 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
    }else{
        //Tailwind   
        
        index1_LD = headWindKts * -1;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 20) {  float y1 = 0;   float y2 = 20;
            MaxPA_1_LD = 5.667 * index1_LD + 0 ;   MaxPA_2_LD = 6 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 40) {  float y1 = 20;   float y2 = 40;
            MaxPA_1_LD = 6 * index1_LD + 20 ;   MaxPA_2_LD = 7.333 *index1_LD + 40 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        if (indexWeight_LD >= 40  & indexWeight_LD <= 60) {  float y1 = 40;   float y2 = 60;
            MaxPA_1_LD = 7.333 * index1_LD + 40 ;   MaxPA_2_LD = 7.333 *index1_LD + 60 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
    }// end head/tailwind
    
    if (indexWind_LD < 0) {
        indexWind_LD = 0;
    }
    
    if (indexWind_LD > 60) {
        indexWind_LD = 60;
    }
    
    resultWithWind = ( ( (1800 - 1200) / 60 ) * indexWind_LD ) + 1200;
    resultDistanceOverObstacle = ( ( (1800 - 1200) / 60 ) * indexWeight_LD ) + 1200;   
    resultWindDifference50ft_LD = resultWithWind - resultDistanceOverObstacle;
    
   
    
    
    //NSLog(@"landing_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}
- (void) calculate_PA28ArcherIIClimb {
        
    
    float climbHp = PressureAltitude;    
    float climbMaxPA_1 = 0, climbMaxPA_2 = 0;    
    float climbIndexOAT = 0;
    
    //float  calcisa = 15 - (1.98 * (sliderHp.value/1000));
    
    float climbOAT = ((15.0 - (PressureAltitude / 1000) * 1.98) + ISAdiff); 
    
     
    
    
    // climb index OAT
    
    if (climbHp >= -1000 & climbHp < 1000) {
        
        climbMaxPA_1 = (0 * powf(climbOAT, 2) )   + ( 0  * climbOAT ) + 0   ; climbMaxPA_2 = (0.000194444444444445 * powf(climbOAT, 2) )   + ( 0.03125  * climbOAT ) + 4.43888888888889   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp )  );        
    }
    
    if (climbHp >= 1000 & climbHp < 2000) {
        climbMaxPA_1 = (0.000194444444444445 * powf(climbOAT, 2) )   + ( 0.03125  * climbOAT ) + 4.43888888888889   ; climbMaxPA_2 = (0.000420634920634922 * powf(climbOAT, 2) )   + ( 0.0925  * climbOAT ) + 8.92698412698413   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 1000 )  );        
    }
    if (climbHp >= 2000 & climbHp < 3000) {
        climbMaxPA_1 = (0.000420634920634922 * powf(climbOAT, 2) )   + ( 0.0925  * climbOAT ) + 8.92698412698413   ; climbMaxPA_2 = (0.000464285714285716 * powf(climbOAT, 2) )   + ( 0.13625  * climbOAT ) + 13.9071428571429   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 2000 )  );        
    }
    
    
    if (climbHp >= 3000 & climbHp < 4000) {
        climbMaxPA_1 = (0.000464285714285716 * powf(climbOAT, 2) )   + ( 0.13625  * climbOAT ) + 13.9071428571429   ; climbMaxPA_2 = (0.00060714285714286 * powf(climbOAT, 2) )   + ( 0.20125  * climbOAT ) + 18.7785714285714   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 3000 )  );        
    }
    
    if (climbHp >= 4000 & climbHp < 5000) {
        climbMaxPA_1 = (0.00060714285714286 * powf(climbOAT, 2) )   + ( 0.20125  * climbOAT ) + 18.7785714285714   ; climbMaxPA_2 = (0.00111507936507937 * powf(climbOAT, 2) )   + ( 0.26125  * climbOAT ) + 23.665873015873   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 4000 )  );        
    }    
    if (climbHp >= 5000 & climbHp < 6000) {
        climbMaxPA_1 = (0.00111507936507937 * powf(climbOAT, 2) )   + ( 0.26125  * climbOAT ) + 23.665873015873   ; climbMaxPA_2 = (0.0011468253968254 * powf(climbOAT, 2) )   + ( 0.29125  * climbOAT ) + 28.8150793650794   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 5000 )  );
    }
    
    
    if (climbHp >= 6000 & climbHp < 7000) {
        climbMaxPA_1 = (0.0011468253968254 * powf(climbOAT, 2) )   + ( 0.29125  * climbOAT ) + 28.8150793650794   ; climbMaxPA_2 = (0.00169047619047619 * powf(climbOAT, 2) )   + ( 0.3525  * climbOAT ) + 34.4952380952381   ;
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 6000 )  );        
    }
    
    if (climbHp >= 7000 & climbHp < 8000) {
        climbMaxPA_1 = (0.00169047619047619 * powf(climbOAT, 2) )   + ( 0.3525  * climbOAT ) + 34.4952380952381   ; climbMaxPA_2 = (0.00208333333333334 * powf(climbOAT, 2) )   + ( 0.42625  * climbOAT ) + 40.9166666666667   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 7000 )  );
    }
        
    if (climbHp >= 8000 & climbHp < 9000) {
        climbMaxPA_1 = (0.00208333333333334 * powf(climbOAT, 2) )   + ( 0.42625  * climbOAT ) + 40.9166666666667   ; climbMaxPA_2 = (0.00213095238095239 * powf(climbOAT, 2) )   + ( 0.48125  * climbOAT ) + 47.1404761904762   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 8000 )  );        
    }
    
    if (climbHp >= 9000 & climbHp < 10000) {
        climbMaxPA_1 = (0.00213095238095239 * powf(climbOAT, 2) )   + ( 0.48125  * climbOAT ) + 47.1404761904762   ; climbMaxPA_2 = (0.00225396825396826 * powf(climbOAT, 2) )   + ( 0.53  * climbOAT ) + 52.9936507936508   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 9000 )  );
    }
    
    if (climbHp >= 10000 & climbHp < 11000) {
        climbMaxPA_1 = (0.00225396825396826 * powf(climbOAT, 2) )   + ( 0.53  * climbOAT ) + 52.9936507936508   ; climbMaxPA_2 = (0.00223015873015873 * powf(climbOAT, 2) )   + ( 0.5825  * climbOAT ) + 59.431746031746   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp -10000 )  );        
    }
    
    if (climbHp >= 11000 & climbHp <= 14000) {
        climbMaxPA_1 = (0.00223015873015873 * powf(climbOAT, 2) )   + ( 0.5825  * climbOAT ) + 59.431746031746   ; climbMaxPA_2 = (0.00272619047619047 * powf(climbOAT, 2) )   + ( 0.68875  * climbOAT ) + 66.3880952380952   ; 
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 11000 )  );
    }
    
    if (climbIndexOAT > 62) {
        climbIndexOAT = 62;
    }
    
    
    // climb time *******************************************************************************
    
    float climbMinutes = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 48) {
        climbMinutes =  (5.78703703703704E-05 * powf(climbIndexOAT, 3) )  + (0.000115740740740739 * powf(climbIndexOAT, 2) )   + ( 0.277777777777778  *climbIndexOAT ) + 1.33226762955019E-15 ;
    }
    if (climbIndexOAT >= 48 & climbIndexOAT <= 70) {
        
        climbMinutes =  (0.000437061646363977 * powf(climbIndexOAT, 3) )  + (-0.0633266888150618 * powf(climbIndexOAT, 2) )   + ( 3.79497379106687  * climbIndexOAT ) + -64.5895725359923 ;   
    }
    
     // climb fuel *******************************************************************************
    
    float climbFuel = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 44) {
        climbFuel =  (1.35281385281385E-05 * powf(climbIndexOAT, 3) )  + (-0.000892857142857138 * powf(climbIndexOAT, 2) )   + ( 0.0812770562770562  *climbIndexOAT ) + -5.55111512312578E-17 ;
    }
    if (climbIndexOAT >= 44 & climbIndexOAT <= 70) {
        climbFuel =  (3.75968117903606E-05 * powf(climbIndexOAT, 3) )  + (-0.00418577837932684 * powf(climbIndexOAT, 2) )   + ( 0.251058976865433  *climbIndexOAT ) + -3.14557485525237 ;
    }
    
    // climb distance *******************************************************************************
    
    float climbDistance = 0;
    
        if (climbIndexOAT >= 0 & climbIndexOAT < 38.5) {
        climbDistance =  (8.46953597198157E-05 * powf(climbIndexOAT, 3) )  + (0.000255616718190509 * powf(climbIndexOAT, 2) )   + ( 0.384099578885488  * climbIndexOAT ) + -4.44089209850063E-16 ;
    }    
    if (climbIndexOAT >= 38.5 & climbIndexOAT <= 70) {
        climbDistance =  (0.00103558809900619 * powf(climbIndexOAT, 3) )  + (-0.13504914938344 * powf(climbIndexOAT, 2) )   + ( 6.70393713997141  * climbIndexOAT ) + -97.0224959157448 ;
    }
    
    resultClimbTime = climbMinutes; 
    resultClimbFuel = climbFuel;
    resultClimbDistance = climbDistance;
    resultClimbSpeed = climbDistance / (climbMinutes/60); 
    resultClimbRoC = PressureAltitude / climbMinutes; // this is feet per minute
    
    //NSLog(@"-------");    
    //NSLog(@"climbHp %.1f", climbHp);
    //NSLog(@"climbOAT %.1f", climbOAT);    
    //NSLog(@"ISAdiff %.1f", ISAdiff);
    //NSLog(@"resultClimbTime %.1f", resultClimbTime);
    //NSLog(@"resultClimbFuel %.1f", resultClimbFuel);
    //NSLog(@"resultClimbDistance %.1f", resultClimbDistance);
    //NSLog(@"resultClimbSpeed %.1f", resultClimbSpeed); 
    //NSLog(@"resultClimbRoC %.1f", resultClimbRoC);
    
    
    
}
- (void) calculate_PA28ArcherIICruise {
    
    float OATcruise = 0, OATindex =0, KTAS55 =0, KTAS65 = 0, KTAS75 = 0, fuelFlow55 = 0, fuelFlow65 = 0, fuelFlow75 = 0, RPM55 = 0, RPM65 = 0, RPM75 = 0;

    float polyA1 = 0, polyB1 = 0;    
    float resultX = 0;    
    float lineIn = PressureAltitude;    
    float yIn = OATcruise;
    
    // set RPM / Power Slider
    resultRPMmin = 55;
    resultRPMmax = 75;
    
    if (lineIn >= 0 & lineIn <2000      ) {
        polyA1 = (0.00010714285714286 * powf(yIn, 2) )   + (0.606785714285714  * yIn ) +-8.9   ; polyB1 = (-0.00090476190476191 * powf(yIn, 2) )   + (0.603809523809524  * yIn ) + 3.6   ;
        resultX   = polyA1 +   (  (polyB1 - polyA1) / 2000  * ( lineIn - 0 )  );
        }    
    if (lineIn >= 2000 & lineIn <4000      ) {
        polyA1 = (-0.00090476190476191 * powf(yIn, 2) )   + (0.603809523809524  * yIn ) +3.6   ; polyB1 = (-0.00102380952380952 * powf(yIn, 2) )   + (0.624047619047619  * yIn ) + 15.6   ;
        resultX   = polyA1 +   (  (polyB1 - polyA1) / 2000  * ( lineIn - 2000 )  );
        }    
    if (lineIn >= 4000 & lineIn <6000      ) {
        polyA1 = (-0.00102380952380952 * powf(yIn, 2) )   + (0.624047619047619  * yIn ) +15.6   ; polyB1 = (-0.00121428571428571 * powf(yIn, 2) )   + (0.626428571428571  * yIn ) + 27.8   ;
        resultX   = polyA1 +   (  (polyB1 - polyA1) / 2000  * ( lineIn - 4000 )  );
       }
    if (lineIn >= 6000 & lineIn <8000      ) {
        polyA1 = (-0.00121428571428571 * powf(yIn, 2) )   + (0.626428571428571  * yIn ) +27.8   ; polyB1 = (-0.0015 * powf(yIn, 2) )   + (0.635  * yIn ) + 40.6   ;
        resultX   = polyA1 +   (  (polyB1 - polyA1) / 2000  * ( lineIn - 6000 )  );
        }
    if (lineIn >= 8000 & lineIn <10000      ) {
        polyA1 = (-0.0015 * powf(yIn, 2) )   + (0.635  * yIn ) +40.6   ; polyB1 = (-0.000821428571428575 * powf(yIn, 2) )   + (0.624642857142857  * yIn ) + 53.1   ;
        resultX   = polyA1 +   (  (polyB1 - polyA1) / 2000  * ( lineIn - 8000 )  );
        }
    if (lineIn >= 10000 & lineIn <=12000      ) {
        polyA1 = (-0.000821428571428575 * powf(yIn, 2) )   + (0.624642857142857  * yIn ) +53.1   ; polyB1 = (-0.000738095238095242 * powf(yIn, 2) )   + (0.61547619047619  * yIn ) + 66.1   ;
        resultX   = polyA1 +   (  (polyB1 - polyA1) / 2000  * ( lineIn - 10000 )  );
        }
    
    OATindex =  resultX;
    
    
    
    fuelFlow55 = 7.8, fuelFlow65 = 9.0, fuelFlow75 = 10.5;    
    
    RPM55 = (OATindex - -488.276595744681) / 0.225531914893617 ;    
    RPM65 = (OATindex - -527.272727272727) / 0.227272727272727 ;    
    RPM75 = (OATindex - -517.894736842105) / 0.210526315789474 ;
    
    KTAS55 = (OATindex - -367.973684210526) / 3.88157894736842 ;    
    KTAS65 = (OATindex - -357) / 3.33333333333333 ;    
    KTAS75 = (OATindex - -366.315789473684) / 3.15789473684211 ;
    
    
    RPM = engineRPMcruise;
    
    if (RPM >= 55 & RPM < 65 ) {        
        KTAS = KTAS55 + ( ((KTAS65 - KTAS55) / 10) * (RPM - 55) );        
        GPH = fuelFlow55 + ( ((fuelFlow65 - fuelFlow55) / 10) * (RPM - 55) );         
        RPM = RPM55 + ( ((RPM65 - RPM55) / 10) * (RPM - 55) );
    }    
    
    if (RPM >= 65 & RPM <= 75 ) {        
        KTAS = KTAS65 + ( ((KTAS75 - KTAS65) / 10) * (RPM - 65) );        
        GPH = fuelFlow65 + ( ((fuelFlow75 - fuelFlow65) / 10) * (RPM - 65) );        
        RPM = RPM65 + ( ((RPM75 - RPM65) / 10) * (RPM - 65) );
    }
    
    
    resultCruiseBHP =    engineRPMcruise;
    resultCruiseKTAS =  KTAS;    
    resultCruiseFuelBurn =    GPH;
    
    //NSLog(@"resultCruiseKTAS %.1f", resultCruiseKTAS);
    //NSLog(@"resultCruiseFuelBurn %.1f", resultCruiseFuelBurn);
    
    
    
}

// PA28 Archer III **************************************************************************************************

- (void) takeoff_PA28ArcherIIIFlaps25 {
    
    
    float indexOAT = sliderOATvalue;
    float MaxPA_1 = 0, MaxPA_2 = 0;
    float index1 = 0;
    float indexWeight = 0;
    float Hp = PressureAltitude;
    float OAT = sliderOATvalue;
    float indexWind = 0;
    
    
    
    
    
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 2000) {
        
        
        MaxPA_1 = (0.000476190476190477 * powf(OAT, 2) )   + ( 0.22  * OAT ) + 7.30952380952381   ; MaxPA_2 = (0.000464285714285717 * powf(OAT, 2) )   + ( 0.2675  * OAT ) + 10.9642857142857   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        
       
        
    }
    
    if (Hp >= 2000 & Hp < 4000) {
        
        
        MaxPA_1 = (0.000464285714285717 * powf(OAT, 2) )   + ( 0.2675  * OAT ) + 10.9642857142857   ; MaxPA_2 = (0.000642857142857145 * powf(OAT, 2) )   + ( 0.305  * OAT ) + 15.6428571428571   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000)  );
        
       
    }
    
    
    
    if (Hp >= 4000 & Hp < 6000) {
        
        
        MaxPA_1 = (0.000642857142857145 * powf(OAT, 2) )   + ( 0.305  * OAT ) + 15.6428571428571   ; MaxPA_2 = (0.0011904761904762 * powf(OAT, 2) )   + ( 0.35  * OAT ) + 21.0238095238095   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000)  );
        
      
    }
    
    
    if (Hp >= 6000 & Hp <= 9000) {
        
        
        MaxPA_1 = (0.0011904761904762 * powf(OAT, 2) )   + ( 0.35  * OAT ) + 21.0238095238095   ; MaxPA_2 = (0.00130952380952381 * powf(OAT, 2) )   + ( 0.425  * OAT ) + 27.4761904761905   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 6000)  );
        
       
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 3.2  & indexOAT < 12.2) { float y1 = 3.2;   float y2 = 12.2;
        MaxPA_1 =  (6.4826839826839E-08 * powf(index1, 3) )  + (-0.000431607142857138 * powf(index1, 2) )   + ( 0.96544264069263  * index1 ) + -727.07142857142 ;  MaxPA_2 =  (2.47835497835497E-08 * powf(index1, 3) )  + (-0.000154821428571428 * powf(index1, 2) )   + ( 0.3381158008658  * index1 ) + -254.214285714285;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 12.2  & indexOAT < 20.2) { float y1 = 12.2;   float y2 = 20.2;
        MaxPA_1 =  (2.47835497835497E-08 * powf(index1, 3) )  + (-0.000154821428571428 * powf(index1, 2) )   + ( 0.3381158008658  * index1 ) + -254.214285714285 ;  MaxPA_2 =  (1.22294372294373E-08 * powf(index1, 3) )  + (-6.69642857142864E-05 * powf(index1, 2) )   + ( 0.141332251082253  * index1 ) + -107.542857142858;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 20.2  & indexOAT < 28.2) { float y1 = 20.2;   float y2 = 28.2;
        MaxPA_1 =  (1.22294372294373E-08 * powf(index1, 3) )  + (-6.69642857142864E-05 * powf(index1, 2) )   + ( 0.141332251082253  * index1 ) + -107.542857142858 ;  MaxPA_2 =  (2.72727272727272E-08 * powf(index1, 3) )  + (-0.000165 * powf(index1, 2) )   + ( 0.35940909090909  * index1 ) + -267.6;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 28.2  & indexOAT < 36.2) { float y1 = 28.2;   float y2 = 36.2;
        MaxPA_1 =  (2.72727272727272E-08 * powf(index1, 3) )  + (-0.000165 * powf(index1, 2) )   + ( 0.35940909090909  * index1 ) + -267.6 ;  MaxPA_2 =  (4.00432900432899E-08 * powf(index1, 3) )  + (-0.000246785714285714 * powf(index1, 2) )   + ( 0.538826839826839  * index1 ) + -397.057142857143;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    
    
    
    if (indexOAT >= 36.2  & indexOAT < 44.2) { float y1 = 36.2;   float y2 = 44.2;
        MaxPA_1 =  (4.00432900432899E-08 * powf(index1, 3) )  + (-0.000246785714285714 * powf(index1, 2) )   + ( 0.538826839826839  * index1 ) + -397.057142857143 ;  MaxPA_2 =  (5.28138528138521E-08 * powf(index1, 3) )  + (-0.000328571428571424 * powf(index1, 2) )   + ( 0.718244588744579  * index1 ) + -526.514285714279;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
       }
    
    
    
    if (indexOAT >= 44.2  & indexOAT < 50) { float y1 = 44.2;   float y2 = 50;
        MaxPA_1 =  (5.28138528138521E-08 * powf(index1, 3) )  + (-0.000328571428571424 * powf(index1, 2) )   + ( 0.718244588744579  * index1 ) + -526.514285714279 ;  MaxPA_2 =  (3.88528138528136E-08 * powf(index1, 3) )  + (-0.00023017857142857 * powf(index1, 2) )   + ( 0.489838744588742  * index1 ) + -346.585714285713;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
       }
    
    
    
   
    
    if (indexWeight < 0) {
        indexWeight = 0;
    }
    
   
    
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= 0  & indexWeight < 8) {  float y1 = 0;   float y2 = 8;
            MaxPA_1 = -0.133 * index1 + 0 ;   MaxPA_2 = -0.28 *index1 + 8 ;
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
            
        }
        
        
        
        if (indexWeight >= 8  & indexWeight < 16) {  float y1 = 8;   float y2 = 16;
            MaxPA_1 = -0.28 * index1 + 8 ;   MaxPA_2 = -0.413 *index1 + 16 ;
            
            
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 16  & indexWeight < 24) {  float y1 = 16;   float y2 = 24;
            MaxPA_1 = -0.413 * index1 + 16 ;   MaxPA_2 = -0.513 *index1 + 24 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
          
        }
        
        
        
        if (indexWeight >= 24  & indexWeight < 32) {  float y1 = 24;   float y2 = 32;
            MaxPA_1 = -0.513 * index1 + 24 ;   MaxPA_2 = -0.627 *index1 + 32 ;
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           
        }
        
        
        if (indexWeight >= 32  & indexWeight < 44) {  float y1 = 32;   float y2 = 44;
            MaxPA_1 = -0.627 * index1 + 32 ;   MaxPA_2 = -0.787 *index1 + 44 ;
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= 0  & indexWeight < 8) {  float y1 = 0;   float y2 = 8;
            MaxPA_1 = 0.6 * index1 + 0 ;   MaxPA_2 = 0.933 *index1 + 8 ;
                       
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 8  & indexWeight < 16) {  float y1 = 8;   float y2 = 16;
            MaxPA_1 = 0.933 * index1 + 8 ;   MaxPA_2 = 1.3 *index1 + 16 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
          
        }
        
        
        
        if (indexWeight >= 16  & indexWeight < 24) {  float y1 = 16;   float y2 = 24;
            MaxPA_1 = 1.3 * index1 + 16 ;   MaxPA_2 = 1.667 *index1 + 24 ;
                       
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 24  & indexWeight < 32) {  float y1 = 24;   float y2 = 32;
            MaxPA_1 = 1.667 * index1 + 24 ;   MaxPA_2 = 2.033 *index1 + 32 ;
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        if (indexWeight >= 32  & indexWeight < 44) {  float y1 = 32;   float y2 = 44;
            MaxPA_1 = 2.033 * index1 + 32 ;   MaxPA_2 = 1.873 *index1 + 44 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           
            
            
        }
        
    }// end head/tailwind
    
    //NSLog(@"2 indexWind %.2f", indexWind);
    
    if (indexWind < 0) {
        indexWind = 0;
    }
    
    if (indexWind > 70) {
        indexWind = 70;
    }
    
    
    float resultWithWind =  600 + (   ( (3000-600) / 48 ) * indexWind );
    resultGroundRoll =  600 + (   ( (3000-600) / 48 ) * indexWeight );     
    resultWindDifferenceGR_TO = resultWithWind - resultGroundRoll;
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 2000) {
        
        
        MaxPA_1 = (0.000285714285714289 * powf(OAT, 2) )   + ( 0.16  * OAT ) + 8.58571428571429   ; MaxPA_2 = (0.000559523809523809 * powf(OAT, 2) )   + ( 0.1775  * OAT ) + 11.3261904761905   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        
        
    }
    
    if (Hp >= 2000 & Hp < 4000) {
        
        
        MaxPA_1 = (0.000559523809523809 * powf(OAT, 2) )   + ( 0.1775  * OAT ) + 11.3261904761905   ; MaxPA_2 = (0.000476190476190476 * powf(OAT, 2) )   + ( 0.21  * OAT ) + 14.5095238095238   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000)  );
        
    }
    
    
    
    if (Hp >= 4000 & Hp < 6000) {
        
        
        MaxPA_1 = (0.000476190476190476 * powf(OAT, 2) )   + ( 0.21  * OAT ) + 14.5095238095238   ; MaxPA_2 = (0.000892857142857143 * powf(OAT, 2) )   + ( 0.2375  * OAT ) + 18.0928571428571   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000)  );
       
        
    }
    
    
    if (Hp >= 6000 & Hp <= 9000) {
        
        
        MaxPA_1 = (0.000892857142857143 * powf(OAT, 2) )   + ( 0.2375  * OAT ) + 18.0928571428571   ; MaxPA_2 = (0.000797619047619048 * powf(OAT, 2) )   + ( 0.2875  * OAT ) + 22.8309523809524   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 6000)  );
        
        
    }
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 0  & indexOAT < 5) { float y1 = 0;   float y2 = 5;
        MaxPA_1 =  (1.40692640692633E-09 * powf(index1, 3) )  + (-1.05357142857138E-05 * powf(index1, 2) )   + ( 0.0296222943722933  * index1 ) + -30.3571428571421 ;  MaxPA_2 =  (-4.32900432900435E-09 * powf(index1, 3) )  + (2.85714285714287E-05 * powf(index1, 2) )   + ( -0.0551839826839831  * index1 ) + 31.714285714286;
        
       indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    if (indexOAT >= 5  & indexOAT < 10) { float y1 = 5;   float y2 = 10;
        MaxPA_1 =  (-4.32900432900435E-09 * powf(index1, 3) )  + (2.85714285714287E-05 * powf(index1, 2) )   + ( -0.0551839826839831  * index1 ) + 31.714285714286 ;  MaxPA_2 =  (-1.00649350649348E-08 * powf(index1, 3) )  + (0.00006767857142857 * powf(index1, 2) )   + ( -0.139990259740257  * index1 ) + 93.785714285712;
                
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
                
    }
    
    
    if (indexOAT >= 10  & indexOAT < 15) { float y1 = 10;   float y2 = 15;
        MaxPA_1 =  (-1.00649350649348E-08 * powf(index1, 3) )  + (0.00006767857142857 * powf(index1, 2) )   + ( -0.139990259740257  * index1 ) + 93.785714285712 ;  MaxPA_2 =  (-1.58008658008655E-08 * powf(index1, 3) )  + (0.000106785714285712 * powf(index1, 2) )   + ( -0.224796536796532  * index1 ) + 155.857142857139;
        
         
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    
    
    if (indexOAT >= 15  & indexOAT < 25) { float y1 = 15;   float y2 = 25;
        MaxPA_1 =  (-1.58008658008655E-08 * powf(index1, 3) )  + (0.000106785714285712 * powf(index1, 2) )   + ( -0.224796536796532  * index1 ) + 155.857142857139 ;  MaxPA_2 =  (-4.44805194805187E-08 * powf(index1, 3) )  + (0.000302321428571424 * powf(index1, 2) )   + ( -0.658827922077912  * index1 ) + 476.714285714279;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    
    
    if (indexOAT >= 25  & indexOAT < 35) { float y1 = 25;   float y2 = 35;
        MaxPA_1 =  (-4.44805194805187E-08 * powf(index1, 3) )  + (0.000302321428571424 * powf(index1, 2) )   + ( -0.658827922077912  * index1 ) + 476.714285714279 ;  MaxPA_2 =  (-4.88095238095231E-08 * powf(index1, 3) )  + (0.000330892857142853 * powf(index1, 2) )   + ( -0.714011904761895  * index1 ) + 513.428571428565;
        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
    }
    
    
    
    
    
    if (indexOAT >= 35  & indexOAT < 45) { float y1 = 35;   float y2 = 45;
        MaxPA_1 =  (-4.88095238095231E-08 * powf(index1, 3) )  + (0.000330892857142853 * powf(index1, 2) )   + ( -0.714011904761895  * index1 ) + 513.428571428565 ;  MaxPA_2 =  (-5.31385281385273E-08 * powf(index1, 3) )  + (0.00035946428571428 * powf(index1, 2) )   + ( -0.769195887445876  * index1 ) + 550.142857142849;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }

    
    
    if (indexWeight <= 7) {
        indexWeight = 7;
    }
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= 0  & indexWeight < 5) {  float y1 = 0;   float y2 = 5;
            MaxPA_1 = -0.133 * index1 + 0 ;   MaxPA_2 = -0.133 *index1 + 5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        if (indexWeight >= 5  & indexWeight < 10) {  float y1 = 5;   float y2 = 10;
            MaxPA_1 = -0.133 * index1 + 5 ;   MaxPA_2 = -0.2 *index1 + 10 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        if (indexWeight >= 10  & indexWeight < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1 = -0.2 * index1 + 10 ;   MaxPA_2 = -0.3 *index1 + 20 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        if (indexWeight >= 20  & indexWeight < 30) {  float y1 = 20;   float y2 = 30;
            MaxPA_1 = -0.3 * index1 + 20 ;   MaxPA_2 = -0.4 *index1 + 30 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );            
        }
        
        if (indexWeight >= 30  & indexWeight < 40) {  float y1 = 30;   float y2 = 40;
            MaxPA_1 = -0.4 * index1 + 30 ;   MaxPA_2 = -0.513 *index1 + 40 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= 0  & indexWeight < 5) {  float y1 = 0;   float y2 = 5;
            MaxPA_1 = 0.267 * index1 + 0 ;   MaxPA_2 = 0.433 *index1 + 5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 5  & indexWeight < 15) {  float y1 = 5;   float y2 = 15;
            MaxPA_1 = 0.433 * index1 + 5 ;   MaxPA_2 = 0.767 *index1 + 15 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        if (indexWeight >= 15  & indexWeight < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1 = 0.767 * index1 + 15 ;   MaxPA_2 = 1.1 *index1 + 25 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        if (indexWeight >= 25  & indexWeight < 37) {  float y1 = 25;   float y2 = 37;
            MaxPA_1 = 1.1 * index1 + 25 ;   MaxPA_2 = 1.433 *index1 + 37 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        if (indexWeight >= 37  & indexWeight < 49) {  float y1 = 37;   float y2 = 49;
            MaxPA_1 = 1.433 * index1 + 37 ;   MaxPA_2 = 1.273 *index1 + 49 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
    }// end head/tailwind
    
    //NSLog(@"indexWind %.2f", indexWind);
    /*
    if (indexWind < 0) {
        indexWind = 0;
    }
    
    if (indexWind > 70) {
        indexWind = 70;
    }
     
     */
    
    
    
    
    resultWithWind = 500 + (   ( (4500-500) / 40 ) * indexWind );
    resultDistanceOverObstacle = 500 + (   ( (4500-500) / 40 ) * indexWeight );
    resultWindDifference50ft_TO = resultWithWind - resultDistanceOverObstacle;
    
    
    
    
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultGroundRoll %.0f", resultGroundRoll);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}
- (void) landing_PA28ArcherIIIFlaps25 {
    
    float Hp_LD = PressureAltitude;
    float MaxPA_1_LD = 0, MaxPA_2_LD = 0;
    float indexOAT_LD = 0;
    float OAT_LD = sliderOATvalue;
    float indexWeight_LD = 0;
    float indexWind_LD = 0;
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 2000) {
        MaxPA_1_LD = (0.000333333333333335 * powf(OAT_LD, 2) )   + ( 0.15  * OAT_LD ) + 13.3666666666667   ; MaxPA_2_LD = (0.000166666666666669 * powf(OAT_LD, 2) )   + ( 0.155  * OAT_LD ) + 16.5333333333333   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD )  );
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 4000) {
        MaxPA_1_LD = (0.000166666666666669 * powf(OAT_LD, 2) )   + ( 0.155  * OAT_LD ) + 16.5333333333333   ; MaxPA_2_LD = (2.38095238095267E-05 * powf(OAT_LD, 2) )   + ( 0.185  * OAT_LD ) + 19.6904761904762   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 2000)  );
    }
    
    
    
    if (Hp_LD >= 4000 & Hp_LD < 6000) {
        
        MaxPA_1_LD = (2.38095238095267E-05 * powf(OAT_LD, 2) )   + ( 0.185  * OAT_LD ) + 19.6904761904762   ; MaxPA_2_LD = (0.000142857142857144 * powf(OAT_LD, 2) )   + ( 0.2  * OAT_LD ) + 23.6428571428571   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 4000)  );
    }
    
    
    if (Hp_LD >= 6000 & Hp_LD <= 7000) {
        
        MaxPA_1_LD = (0.000142857142857144 * powf(OAT_LD, 2) )   + ( 0.2  * OAT_LD ) + 23.6428571428571   ; MaxPA_2_LD = (0.000071428571428575 * powf(OAT_LD, 2) )   + ( 0.205  * OAT_LD ) + 26.0714285714286   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 6000)  );
    }
    
    /*
    if (indexOAT_LD > 60) {
        indexOAT_LD = 60;
    }    
    if (indexOAT_LD < 27) {
        indexOAT_LD = 27;
    }
     */
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    float index1_LD = ACweightLBS;
    
    if (indexOAT_LD >= 6  & indexOAT_LD < 13) { float y1 = 6;   float y2 = 13;
        MaxPA_1_LD =  (-7.25108225108225E-09 * powf(index1_LD, 3) )  + (4.66071428571429E-05 * powf(index1_LD, 2) )   + ( -0.0827456709956711  * index1_LD ) + 34.1714285714287 ;  MaxPA_2_LD =  (1.00649350649348E-08 * powf(index1_LD, 3) )  + (-6.76785714285699E-05 * powf(index1_LD, 2) )   + ( 0.167990259740256  * index1_LD ) + -142.185714285712; 
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
    }
    
    if (indexOAT_LD >= 13  & indexOAT_LD < 19.8) { float y1 = 13;   float y2 = 19.8;
        MaxPA_1_LD =  (1.00649350649348E-08 * powf(index1_LD, 3) )  + (-6.76785714285699E-05 * powf(index1_LD, 2) )   + ( 0.167990259740256  * index1_LD ) + -142.185714285712 ;  MaxPA_2_LD =  (-4.54545454545456E-09 * powf(index1_LD, 3) )  + (3.25000000000002E-05 * powf(index1_LD, 2) )   + ( -0.0593181818181822  * index1_LD ) + 35.1000000000003;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
    }
    
    
    if (indexOAT_LD >= 19.8  & indexOAT_LD < 26.8) { float y1 = 19.8;   float y2 = 26.8;
        MaxPA_1_LD =  (-4.54545454545456E-09 * powf(index1_LD, 3) )  + (3.25000000000002E-05 * powf(index1_LD, 2) )   + ( -0.0593181818181822  * index1_LD ) + 35.1000000000003 ;  MaxPA_2_LD =  (-9.19913419913402E-09 * powf(index1_LD, 3) )  + (6.19642857142846E-05 * powf(index1_LD, 2) )   + ( -0.118953463203461  * index1_LD ) + 79.7428571428555;        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
    }
    
    
    
    if (indexOAT_LD >= 26.8  & indexOAT_LD < 30.3) { float y1 = 26.8;   float y2 = 30.3;
        MaxPA_1_LD =  (-9.19913419913402E-09 * powf(index1_LD, 3) )  + (6.19642857142846E-05 * powf(index1_LD, 2) )   + ( -0.118953463203461  * index1_LD ) + 79.7428571428555 ;  MaxPA_2_LD =  (-1.68831168831165E-08 * powf(index1_LD, 3) )  + (0.000116428571428569 * powf(index1_LD, 2) )   + ( -0.245967532467528  * index1_LD ) + 180.385714285711;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
    }
    if (indexOAT_LD >= 30.3  & indexOAT_LD < 35.8) { float y1 = 30.3;   float y2 = 35.8;
        MaxPA_1_LD =  (-1.68831168831165E-08 * powf(index1_LD, 3) )  + (0.000116428571428569 * powf(index1_LD, 2) )   + ( -0.245967532467528  * index1_LD ) + 180.385714285711 ;  MaxPA_2_LD =  (-1.01731601731603E-08 * powf(index1_LD, 3) )  + (7.46428571428578E-05 * powf(index1_LD, 2) )   + ( -0.157807359307361  * index1_LD ) + 121.528571428573;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
    }
    
    if (indexWeight_LD < 7) {
        indexWeight_LD = 7;
    }
    
    //NSLog(@"index1_LD %.2f", index1_LD);
    //NSLog(@"indexWeight_LD %.2f", indexWeight_LD);
    
    //NSLog(@"1 indexWeight %.1f", indexWeight);    
    //NSLog(@"2 headWindKts %.0f", headWindKts);
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = -0.7 * index1_LD + 0 ;   MaxPA_2_LD = -0.7 *index1_LD + 10 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 15) {  float y1 = 10;   float y2 = 15;
            MaxPA_1_LD = -0.7 * index1_LD + 10 ;   MaxPA_2_LD = -0.733 *index1_LD + 15 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1_LD = -0.733 * index1_LD + 15 ;   MaxPA_2_LD = -0.8 *index1_LD + 25 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        if (indexWeight_LD >= 25  & indexWeight_LD <= 35) {  float y1 = 25;   float y2 = 35;
            MaxPA_1_LD = -0.8 * index1_LD + 25 ;   MaxPA_2_LD = -0.9 *index1_LD + 35 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
    }else{
        //Tailwind           
        index1_LD = headWindKts * -1;  
        
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 5) {  float y1 = 0;   float y2 = 5;
            MaxPA_1_LD = 1.867 * index1_LD + 0 ;   MaxPA_2_LD = 2 *index1_LD + 5 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 5  & indexWeight_LD < 15) {  float y1 = 5;   float y2 = 15;
            MaxPA_1_LD = 2 * index1_LD + 5 ;   MaxPA_2_LD = 2.2 *index1_LD + 15 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1_LD = 2.2 * index1_LD + 15 ;   MaxPA_2_LD = 2.667 *index1_LD + 25 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
        if (indexWeight_LD >= 25  & indexWeight_LD < 35) {  float y1 = 25;   float y2 = 35;
            MaxPA_1_LD = 2.667 * index1_LD + 25 ;   MaxPA_2_LD = 3.067 *index1_LD + 35 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
    }// end head/tailwind
    
    
    /*
    if (indexWind_LD < 0) {
        indexWind_LD = 0;
    }
    
    if (indexWind_LD > 60) {
        indexWind_LD = 60;
    }
     */
    
    float resultWithWind = ( ( (1300 - 600) / 35 ) * indexWind_LD ) + 600;
    resultGroundRoll = ( ( (1300 - 600) / 35 ) * indexWeight_LD ) + 600;   
    resultWindDifferenceGR_LD = resultWithWind - resultGroundRoll;
    
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 2000) {
        
        MaxPA_1_LD = (0.00023809523809524 * powf(OAT_LD, 2) )   + ( 0.15  * OAT_LD ) + 7.9047619047619   ; MaxPA_2_LD = (0.00048809523809524 * powf(OAT_LD, 2) )   + ( 0.1425  * OAT_LD ) + 10.6547619047619   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD )  );
        
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 4000) {
        
        MaxPA_1_LD = (0.00048809523809524 * powf(OAT_LD, 2) )   + ( 0.1425  * OAT_LD ) + 10.6547619047619   ; MaxPA_2_LD = (0.000523809523809525 * powf(OAT_LD, 2) )   + ( 0.17  * OAT_LD ) + 14.1904761904762   ;
                
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 2000)  );
        
    }
    
    
    
    if (Hp_LD >= 4000 & Hp_LD < 6000) {        
        
        MaxPA_1_LD = (0.000523809523809525 * powf(OAT_LD, 2) )   + ( 0.17  * OAT_LD ) + 14.1904761904762   ; MaxPA_2_LD = (0.000809523809523811 * powf(OAT_LD, 2) )   + ( 0.2  * OAT_LD ) + 17.9761904761905   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 4000)  );
    }
    
    
    if (Hp_LD >= 6000 & Hp_LD <= 7000) {        
        
        MaxPA_1_LD = (0.000809523809523811 * powf(OAT_LD, 2) )   + ( 0.2  * OAT_LD ) + 17.9761904761905   ; MaxPA_2_LD = (0.000452380952380953 * powf(OAT_LD, 2) )   + ( 0.215  * OAT_LD ) + 20.1190476190476   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 6000)  );
        
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1_LD = ACweightLBS;
    
    //NSLog(@"indexOAT_LD %.2f", indexOAT_LD);
    
    if (indexOAT_LD >= 3  & indexOAT_LD < 10) { float y1 = 3;   float y2 = 10;
        MaxPA_1_LD =  (-8.11688311688305E-09 * powf(index1_LD, 3) )  + (5.23214285714282E-05 * powf(index1_LD, 2) )   + ( -0.0977824675324667  * index1_LD ) + 46.7142857142851 ;  MaxPA_2_LD =  (9.19913419913392E-09 * powf(index1_LD, 3) )  + (-6.19642857142839E-05 * powf(index1_LD, 2) )   + ( 0.152953463203459  * index1_LD ) + -129.642857142854;    
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
    }
    
    if (indexOAT_LD >= 10  & indexOAT_LD < 15) { float y1 = 10;   float y2 = 15;
        MaxPA_1_LD =  (9.19913419913392E-09 * powf(index1_LD, 3) )  + (-6.19642857142839E-05 * powf(index1_LD, 2) )   + ( 0.152953463203459  * index1_LD ) + -129.642857142854 ;  MaxPA_2_LD =  (-1.40692640692644E-09 * powf(index1_LD, 3) )  + (1.05357142857145E-05 * powf(index1_LD, 2) )   + ( -0.00962229437229489  * index1_LD ) + -5.64285714285674;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    if (indexOAT_LD >= 15  & indexOAT_LD < 20) { float y1 = 15;   float y2 = 20;
        MaxPA_1_LD =  (-1.40692640692644E-09 * powf(index1_LD, 3) )  + (1.05357142857145E-05 * powf(index1_LD, 2) )   + ( -0.00962229437229489  * index1_LD ) + -5.64285714285674 ;  MaxPA_2_LD =  (-1.20129870129869E-08 * powf(index1_LD, 3) )  + (8.30357142857134E-05 * powf(index1_LD, 2) )   + ( -0.17219805194805  * index1_LD ) + 118.357142857142;
                
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    if (indexOAT_LD >= 20  & indexOAT_LD < 24.5) { float y1 = 20;   float y2 = 24.5;
        MaxPA_1_LD =  (-1.20129870129869E-08 * powf(index1_LD, 3) )  + (8.30357142857134E-05 * powf(index1_LD, 2) )   + ( -0.17219805194805  * index1_LD ) + 118.357142857142 ;  MaxPA_2_LD =  (-9.1991341991343E-09 * powf(index1_LD, 3) )  + (6.19642857142865E-05 * powf(index1_LD, 2) )   + ( -0.118953463203465  * index1_LD ) + 77.4428571428586;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    if (indexOAT_LD >= 24.5  & indexOAT_LD < 30) { float y1 = 24.5;   float y2 = 30;
        MaxPA_1_LD =  (-9.1991341991343E-09 * powf(index1_LD, 3) )  + (6.19642857142865E-05 * powf(index1_LD, 2) )   + ( -0.118953463203465  * index1_LD ) + 77.4428571428586 ;  MaxPA_2_LD =  (-2.48917748917768E-09 * powf(index1_LD, 3) )  + (2.01785714285728E-05 * powf(index1_LD, 2) )   + ( -0.0307932900432931  * index1_LD ) + 18.5857142857166;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    /*
    if (indexWeight_LD < 0) {
        indexWeight_LD = 0;
    }
     */
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = -0.967 * index1_LD + 0 ;   MaxPA_2_LD = -0.967 *index1_LD + 10 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 15) {  float y1 = 10;   float y2 = 15;
            MaxPA_1_LD = -0.967 * index1_LD + 10 ;   MaxPA_2_LD = -0.9 *index1_LD + 15 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1_LD = -0.9 * index1_LD + 15 ;   MaxPA_2_LD = -1.013 *index1_LD + 25 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 25  & indexWeight_LD < 30) {  float y1 = 25;   float y2 = 30;
            MaxPA_1_LD = -1.013 * index1_LD + 25 ;   MaxPA_2_LD = -1.047 *index1_LD + 30 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 60) {  float y1 = 30;   float y2 = 60;
            MaxPA_1_LD = -1.047 * index1_LD + 30 ;   MaxPA_2_LD = -1.333 *index1_LD + 60 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
    }else{
        //Tailwind   
        
        index1_LD = headWindKts * -1;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = 2.8 * index1_LD + 0 ;   MaxPA_2_LD = 2.8 *index1_LD + 10 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD = 2.8 * index1_LD + 10 ;   MaxPA_2_LD = 3 *index1_LD + 20 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 20  & indexWeight_LD <= 30) {  float y1 = 20;   float y2 = 30;
            MaxPA_1_LD = 3 * index1_LD + 20 ;   MaxPA_2_LD = 3.2 *index1_LD + 30 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
    }// end head/tailwind
    
    /*
    if (indexWind_LD < 0) {
        indexWind_LD = 0;
    }
    
    if (indexWind_LD > 60) {
        indexWind_LD = 60;
    }
     */
    
    resultWithWind = ( ( (1800 - 1200) / 30 ) * indexWind_LD ) + 1200;
    resultDistanceOverObstacle = ( ( (1800 - 1200) / 30 ) * indexWeight_LD ) + 1200;
    resultWindDifference50ft_LD = resultWithWind - resultDistanceOverObstacle;
    
    
    
    
    //NSLog(@"landing_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}
- (void) calculate_PA28ArcherIIIClimb {
    
    
    float climbHp = PressureAltitude;    
    float climbMaxPA_1 = 0, climbMaxPA_2 = 0;    
    float climbIndexOAT = 0;
    
    //float  calcisa = 15 - (1.98 * (sliderHp.value/1000));
    
    float climbOAT = ((15.0 - (PressureAltitude / 1000) * 1.98) + ISAdiff); 
    
    
    
    
    // climb index OAT
    
    if (climbHp >= 0 & climbHp < 1000) {
        
        climbMaxPA_1 = (0 * powf(climbOAT, 2) )   + ( 0  * climbOAT ) + 0   ; climbMaxPA_2 = (0.000309523809523809 * powf(climbOAT, 2) )   + ( 0.0295238095238095  * climbOAT ) + 3.54464285714286   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp )  );
        
    }
    
    
    
    if (climbHp >= 1000 & climbHp < 2000) {
        
        
        climbMaxPA_1 = (0.000309523809523809 * powf(climbOAT, 2) )   + ( 0.0295238095238095  * climbOAT ) + 3.54464285714286   ; climbMaxPA_2 = (0.000535714285714285 * powf(climbOAT, 2) )   + ( 0.0607142857142857  * climbOAT ) + 7.18303571428571   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 1000 )  );
        
    }
    
    
    
    if (climbHp >= 2000 & climbHp < 3000) {
        
        
        climbMaxPA_1 = (0.000535714285714285 * powf(climbOAT, 2) )   + ( 0.0607142857142857  * climbOAT ) + 7.18303571428571   ; climbMaxPA_2 = (0.000416666666666667 * powf(climbOAT, 2) )   + ( 0.0916666666666667  * climbOAT ) + 11.03125   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 2000 )  );
        
    }
    
    
    if (climbHp >= 3000 & climbHp < 4000) {
        
        
        climbMaxPA_1 = (0.000416666666666667 * powf(climbOAT, 2) )   + ( 0.0916666666666667  * climbOAT ) + 11.03125   ; climbMaxPA_2 = (0.000238095238095238 * powf(climbOAT, 2) )   + ( 0.138095238095238  * climbOAT ) + 14.8035714285714   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 3000 )  );
        
    }
    
    if (climbHp >= 4000 & climbHp < 5000) {
        
        
        climbMaxPA_1 = (0.000238095238095238 * powf(climbOAT, 2) )   + ( 0.138095238095238  * climbOAT ) + 14.8035714285714   ; climbMaxPA_2 = (0.000285714285714286 * powf(climbOAT, 2) )   + ( 0.165714285714286  * climbOAT ) + 18.9642857142857   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 4000 )  );
        
    }
    
    if (climbHp >= 5000 & climbHp < 6000) {
        
        
        climbMaxPA_1 = (0.000285714285714286 * powf(climbOAT, 2) )   + ( 0.165714285714286  * climbOAT ) + 18.9642857142857   ; climbMaxPA_2 = (0.000595238095238095 * powf(climbOAT, 2) )   + ( 0.195238095238095  * climbOAT ) + 23.0089285714286   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 5000 )  );
        
    }
    
    
    if (climbHp >= 6000 & climbHp < 7000) {
        
        
        climbMaxPA_1 = (0.000595238095238095 * powf(climbOAT, 2) )   + ( 0.195238095238095  * climbOAT ) + 23.0089285714286   ; climbMaxPA_2 = (0.000654761904761903 * powf(climbOAT, 2) )   + ( 0.229761904761905  * climbOAT ) + 27.3348214285714   ;
        
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 6000 )  );
        
    }
    
    
    
    if (climbHp >= 7000 & climbHp < 8000) {
        
        
        climbMaxPA_1 = (0.000654761904761903 * powf(climbOAT, 2) )   + ( 0.229761904761905  * climbOAT ) + 27.3348214285714   ; climbMaxPA_2 = (0.000714285714285713 * powf(climbOAT, 2) )   + ( 0.264285714285714  * climbOAT ) + 31.6607142857143   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 7000 )  );
        
    }
    
    
    if (climbHp >= 8000 & climbHp < 9000) {
        
        
        climbMaxPA_1 = (0.000714285714285713 * powf(climbOAT, 2) )   + ( 0.264285714285714  * climbOAT ) + 31.6607142857143   ; climbMaxPA_2 = (0.00170238095238095 * powf(climbOAT, 2) )   + ( 0.277380952380952  * climbOAT ) + 36.0705357142857   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 8000 )  );
        
    }
    
    
    if (climbHp >= 9000 & climbHp < 10000) {
        
        
        climbMaxPA_1 = (0.00170238095238095 * powf(climbOAT, 2) )   + ( 0.277380952380952  * climbOAT ) + 36.0705357142857   ; climbMaxPA_2 = (0.00148809523809523 * powf(climbOAT, 2) )   + ( 0.313095238095238  * climbOAT ) + 40.8973214285714   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 9000 )  );
        
    }
    
    
    if (climbHp >= 10000 & climbHp < 11000) {
        
        
        climbMaxPA_1 = (0.00148809523809523 * powf(climbOAT, 2) )   + ( 0.313095238095238  * climbOAT ) + 40.8973214285714   ; climbMaxPA_2 = (0.00225 * powf(climbOAT, 2) )   + ( 0.355  * climbOAT ) + 45.46875   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp -10000 )  );
        
    }
    
    if (climbHp >= 11000 & climbHp <= 14000) {
        
        
        climbMaxPA_1 = (0.00225 * powf(climbOAT, 2) )   + ( 0.355  * climbOAT ) + 45.46875   ; climbMaxPA_2 = (0.00185714285714286 * powf(climbOAT, 2) )   + ( 0.405714285714286  * climbOAT ) + 50.9821428571429   ;
        
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 11000 )  );
        
    }
    
    
    
    if (climbIndexOAT > 62) {
        climbIndexOAT = 62;
    }
    
    
    
    // climb time *******************************************************************************
    
    float climbMinutes = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 52.5) {
        climbMinutes =  (0.000358824848620769 * powf(climbIndexOAT, 3) )  + (-0.0205128205128207 * powf(climbIndexOAT, 2) )   + ( 0.849816849816855  *climbIndexOAT ) + 0 ; 
        
    }
    
    if (climbIndexOAT >= 52.5 & climbIndexOAT <= 62) {
        climbMinutes =  (0.0100250626566413 * powf(climbIndexOAT, 3) )  + (-1.4837092731829 * powf(climbIndexOAT, 2) )   + ( 75.2957393483674  * climbIndexOAT ) + -1274.21052631572 ; 
    }
    
    // climb fuel *******************************************************************************
    
    float climbFuel = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 54) {
        climbFuel =  (8.26719576719579E-05 * powf(climbIndexOAT, 3) )  + (-0.00370370370370372 * powf(climbIndexOAT, 2) )   + ( 0.153373015873016  *climbIndexOAT ) + 1.5 ;         
        }
    if (climbIndexOAT >= 54 & climbIndexOAT <= 62) {
        climbFuel =  (0.0366390366390229 * powf(climbIndexOAT, 3) )  + (-6.2510030510007 * powf(climbIndexOAT, 2) )   + ( 356.015728865596  *climbIndexOAT ) + -6754.25372735121 ;  
                
    }
    
    // climb distance *******************************************************************************
    
    float climbDistance = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 52.5) {
        climbDistance =  (0.000458313836998644 * powf(climbIndexOAT, 3) )  + (-0.0194015525081284 * powf(climbIndexOAT, 2) )   + ( 0.898211136306372  * climbIndexOAT ) + -3.5527136788005E-15 ; 
    }
    if (climbIndexOAT >= 52.5 & climbIndexOAT <= 62) {
        climbDistance =  (0.0320802005012573 * powf(climbIndexOAT, 3) )  + (-5.10676691729398 * powf(climbIndexOAT, 2) )   + ( 274.882205513829  * climbIndexOAT ) + -4937.89473684298 ;                  
    }
    
    resultClimbTime = climbMinutes; 
    resultClimbFuel = climbFuel;
    resultClimbDistance = climbDistance;
    resultClimbSpeed = climbDistance / (climbMinutes/60); 
    resultClimbRoC = PressureAltitude / climbMinutes; // this is feet per minute
    
    //NSLog(@"-------");    
    //NSLog(@"climbHp %.1f", climbHp);
    //NSLog(@"climbOAT %.1f", climbOAT);    
    //NSLog(@"ISAdiff %.1f", ISAdiff);
    //NSLog(@"resultClimbTime %.1f", resultClimbTime);
    //NSLog(@"resultClimbFuel %.1f", resultClimbFuel);
    //NSLog(@"resultClimbDistance %.1f", resultClimbDistance);
    //NSLog(@"resultClimbSpeed %.1f", resultClimbSpeed); 
    //NSLog(@"resultClimbRoC %.1f", resultClimbRoC);
    
    
    
}
- (void) calculate_PA28ArcherIIICruise {
    
    float  OATindex =0, KTAS55 =0, KTAS65 = 0, KTAS75 = 0, fuelFlow55 = 0, fuelFlow65 = 0, fuelFlow75 = 0, RPM55 = 0, RPM65 = 0, RPM75 = 0;
    
    
    
    // set RPM / Power Slider
    resultRPMmin = 55;
    resultRPMmax = 75;
    
    OATindex =  PressureAltitude;    
    OATindex = OATindex + (sliderOATvalue * 50 );  // OAT IDEX CORRECTION !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    
    
    
    fuelFlow55 = 8.2, fuelFlow65 = 9.5, fuelFlow75 = 11.0;
    RPM55 = (OATindex - -238421.052631579) / 105.263157894737 ;    
    RPM65 = (OATindex - -223148.148148148) / 92.5925925925926 ;    
    RPM75 = (OATindex - -160382.165605096) / 63.6942675159236 ;
    
    KTAS55 = (OATindex - -460000.0) / 4347.82608695653 ;    
    KTAS65 = (OATindex - -232653.06122449) / 2040.81632653061 ;    
    KTAS75 = (OATindex - -126842.105263158) / 1052.63157894737 ;
    
    
    RPM = engineRPMcruise;
    
    if (RPM >= 55 & RPM < 65 ) {        
        KTAS = KTAS55 + ( ((KTAS65 - KTAS55) / 10) * (RPM - 55) );        
        GPH = fuelFlow55 + ( ((fuelFlow65 - fuelFlow55) / 10) * (RPM - 55) );         
        RPM = RPM55 + ( ((RPM65 - RPM55) / 10) * (RPM - 55) );
    }    
    
    if (RPM >= 65 & RPM <= 75 ) {        
        KTAS = KTAS65 + ( ((KTAS75 - KTAS65) / 10) * (RPM - 65) );        
        GPH = fuelFlow65 + ( ((fuelFlow75 - fuelFlow65) / 10) * (RPM - 65) );        
        RPM = RPM65 + ( ((RPM75 - RPM65) / 10) * (RPM - 65) );
    }
    
    
    resultCruiseBHP =    engineRPMcruise;
    resultCruiseKTAS =  KTAS;    
    resultCruiseFuelBurn =    GPH;
    
    //NSLog(@"resultCruiseKTAS %.1f", resultCruiseKTAS);
    //NSLog(@"resultCruiseFuelBurn %.1f", resultCruiseFuelBurn);
    
    
    
}

// PA28 Warrior III **************************************************************************************************

- (void) takeoff_PA28WarriorIII {
    
    
    float indexOAT = sliderOATvalue;
    float MaxPA_1 = 0, MaxPA_2 = 0;
    float index1 = 0;
    float indexWeight = 0;
    float Hp = PressureAltitude;
    float OAT = sliderOATvalue;
    float indexWind = 0;
    
    
    
    
    
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 2000) {
        
        
        MaxPA_1 = (0 * powf(OAT, 2) )   + ( 0.275  * OAT ) + 17   ; MaxPA_2 = (-0.0003125 * powf(OAT, 2) )   + ( 0.2875  * OAT ) + 24   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        
      
        
    }
    
    if (Hp >= 2000 & Hp < 4000) {
        
        
        MaxPA_1 = (-0.0003125 * powf(OAT, 2) )   + ( 0.2875  * OAT ) + 24   ; MaxPA_2 = (-0.000468749999999999 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 31.5   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000)  );
    
    }
    
    
    
    if (Hp >= 4000 & Hp < 6000) {
        
        
        MaxPA_1 = (-0.000468749999999999 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 31.5   ; MaxPA_2 = (0.000375000000000001 * powf(OAT, 2) )   + ( 0.315  * OAT ) + 38.5   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000)  );
     
    }
    
    
    if (Hp >= 6000 & Hp <= 9000) {
        
        
        MaxPA_1 = (0.000375000000000001 * powf(OAT, 2) )   + ( 0.315  * OAT ) + 38.5   ; MaxPA_2 = (0.000218749999999999 * powf(OAT, 2) )   + ( 0.32375  * OAT ) + 42.7   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 6000)  );
     
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 19  & indexOAT < 28.7) {
        
        float y1 = 19;   float y2 = 28.7;
        
        //float percentPlus =  ( 100 / (y2 - y1) )  * ( indexOAT - y1);
        
        MaxPA_1 =  (-6.3803299097413E-09 * powf(index1, 3) )  + (4.23965141612178E-05 * powf(index1, 2) )   + ( -0.0789582944288782  * index1 ) + 51.9320261437879 ;  MaxPA_2 =  (4.97976968565172E-10 * powf(index1, 3) )  + (8.77995642701718E-07 * powf(index1, 2) )   + ( 0.00800731403672541  * index1 ) + -3.29908496732;        
        
        //indexWeight   =   MaxPA_1 + (  (MaxPA_2 - MaxPA_1) * (percentPlus/100) );
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
       
        
        
    }
    
    
    
    if (indexOAT >= 28.7  & indexOAT < 37.0) {
        
        float y1 = 28.7;   float y2 = 37.0;
        
        //float percentPlus =  ( 100 / (y2 - y1) )  * ( indexOAT - y1);
        
        
        MaxPA_1 =  (4.97976968565172E-10 * powf(index1, 3) )  + (8.77995642701718E-07 * powf(index1, 2) )   + ( 0.00800731403672541  * index1 ) + -3.29908496732 ;  MaxPA_2 =  (-2.48988484282589E-09 * powf(index1, 3) )  + (2.06100217864916E-05 * powf(index1, 2) )   + ( -0.0285365701836274  * index1 ) + 20.0954248366002;
        
        
        //indexWeight   =   MaxPA_1 + (  (MaxPA_2 - MaxPA_1) * (percentPlus/100) );
        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
       
        
    }
    
    
    
    if (indexOAT >= 37.0  & indexOAT < 45.0) {
        
        float y1 = 37.0;   float y2 = 45.0;
        
        
        MaxPA_1 =  (-2.48988484282589E-09 * powf(index1, 3) )  + (2.06100217864916E-05 * powf(index1, 2) )   + ( -0.0285365701836274  * index1 ) + 20.0954248366002 ;  MaxPA_2 =  (-6.71750181554057E-09 * powf(index1, 3) )  + (0.000047618010167027 * powf(index1, 2) )   + ( -0.0797948438634657  * index1 ) + 53.7845315904103;        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
     
        
    }
    
    
    
    if (indexOAT >= 45.0  & indexOAT <= 53.0) {
        
        float y1 = 45.0;    float y2 =  53.0;
        
        
        MaxPA_1 =  (-6.71750181554057E-09 * powf(index1, 3) )  + (0.000047618010167027 * powf(index1, 2) )   + ( -0.0797948438634657  * index1 ) + 53.7845315904103 ;  MaxPA_2 =  (-7.87944807552597E-09 * powf(index1, 3) )  + (5.94582425562785E-05 * powf(index1, 2) )   + ( -0.108200798838047  * index1 ) + 77.4823965141569;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
       
        
    }
    
    
    
    
    if (indexWeight <= 10) {
        indexWeight = 10;
    }
    
    
    
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= 8  & indexWeight < 12.0) {
            
            float y1 = 8;   float y2 = 12.0;
            
            MaxPA_1= -0.2 * index1 + 8 ;   MaxPA_2 = -0.2 *index1 + 12 ;       
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 12.0  & indexWeight < 20.0) {
            
            float y1 = 12.0;   float y2 = 20.0;
            
            
            MaxPA_1= -0.2 * index1 + 12 ;   MaxPA_2 = -0.3 *index1 + 20 ; 
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 20.0  & indexWeight < 28.0) {
            
            float y1 = 20.0;   float y2 = 28.0;
            
            
            MaxPA_1= -0.3 * index1 + 20 ;   MaxPA_2 = -0.4 *index1 + 28 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 28.0  & indexWeight < 36.0) {
            
            float y1 = 28.0;    float y2 =  36.0;
            
            
            MaxPA_1= -0.4 * index1 + 28 ;   MaxPA_2 = -0.5 *index1 + 36 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        if (indexWeight >= 36.0  & indexWeight < 48.0) {
            
            float y1 = 36.0;    float y2 =  48.0;
            
            
            MaxPA_1= -0.5 * index1 + 36 ;   MaxPA_2 = -0.6 *index1 + 48 ;
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= 8  & indexWeight < 12.0) {
            
            float y1 = 8;   float y2 = 12.0;
            
            
            MaxPA_1= 0.733 * index1 + 8 ;   MaxPA_2 = 0.8 *index1 + 12 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 12.0  & indexWeight < 20.0) {
            
            float y1 = 12.0;   float y2 = 20.0;
            
            
            MaxPA_1= 0.8 * index1 + 12 ;   MaxPA_2 = 1.267 *index1 + 20 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 20.0  & indexWeight < 28.0) {
            
            float y1 = 20.0;   float y2 = 28.0;
            
            
            MaxPA_1= 1.267 * index1 + 20 ;   MaxPA_2 = 1.333 *index1 + 28 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 28.0  & indexWeight < 36.0) {
            
            float y1 = 28.0;    float y2 =  36.0;
            
            
            MaxPA_1= 1.333 * index1 + 28 ;   MaxPA_2 = 1.6 *index1 + 36 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        if (indexWeight >= 36.0  & indexWeight < 48.0) {
            
            float y1 = 36.0;    float y2 =  48.0;
            
            
            MaxPA_1= 1.6 * index1 + 36 ;   MaxPA_2 = 2.467 *index1 + 48 ; 
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
          
            
            
        }
        
    }// end head/tailwind
    
    //NSLog(@"2 indexWind %.2f", indexWind);
    
    /*
    if (indexWind < 0) {
        indexWind = 0;
    }
    
    if (indexWind > 70) {
        indexWind = 70;
    }
     */
    
    
    float resultWithWind = (2500/50) * indexWind;
    resultGroundRoll = (2500/50) * indexWeight;    
    resultWindDifferenceGR_TO = resultWithWind - resultGroundRoll;
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 2000) {
        MaxPA_1 = (0.0003125 * powf(OAT, 2) )   + ( 0.2375  * OAT ) + 13   ; MaxPA_2 = (0.00025 * powf(OAT, 2) )   + ( 0.2475  * OAT ) + 18   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        
        
    }
    
    if (Hp >= 2000 & Hp < 4000) {
                
        MaxPA_1 = (0.00025 * powf(OAT, 2) )   + ( 0.2475  * OAT ) + 18   ; MaxPA_2 = (0.000343750000000002 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 23.4   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000)  );
       
        
    }
    
    
    
    if (Hp >= 4000 & Hp < 6000) {
                
        MaxPA_1 = (0.000343750000000002 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 23.4   ; MaxPA_2 = (0.0003125 * powf(OAT, 2) )   + ( 0.3375  * OAT ) + 30.5   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000)  );
        
    }
    
    
    if (Hp >= 6000 & Hp <= 9000) {
                
        MaxPA_1 = (0.0003125 * powf(OAT, 2) )   + ( 0.3375  * OAT ) + 30.5   ; MaxPA_2 = (0.0003125 * powf(OAT, 2) )   + ( 0.3375  * OAT ) + 34   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 6000)  );
        
        
    }
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 4.8  & indexOAT < 14.8) {
        
        float y1 = 4.8;   float y2 = 14.8;
        
        MaxPA_1 =  (3.19535221495993E-09 * powf(index1, 3) )  + (-1.58939724037755E-05 * powf(index1, 2) )   + ( 0.0361997095134334  * index1 ) + -35.319128540304 ;  MaxPA_2 =  (3.19535221495993E-09 * powf(index1, 3) )  + (-1.58939724037755E-05 * powf(index1, 2) )   + ( 0.0361997095134334  * index1 ) + -25.319128540304;
        
        //indexWeight   =   MaxPA_1 + (  (MaxPA_2 - MaxPA_1) * (percentPlus/100) );
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    
    
    
    
    
    
    if (indexOAT >= 14.8  & indexOAT < 22.0) {
        
        float y1 = 14.8;   float y2 = 22.0;
        MaxPA_1 =  (3.19535221495993E-09 * powf(index1, 3) )  + (-1.58939724037755E-05 * powf(index1, 2) )   + ( 0.0361997095134334  * index1 ) + -25.319128540304 ;  MaxPA_2 =  (-1.37462392364339E-09 * powf(index1, 3) )  + (1.10312273057363E-05 * powf(index1, 2) )   + ( -0.0126156758999879  * index1 ) + 7.07559912853922;
               
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    
    
    if (indexOAT >= 22.0  & indexOAT < 27.8) {
        
        float y1 = 22.0;   float y2 = 27.8;
        
       
        MaxPA_1 =  (-1.37462392364339E-09 * powf(index1, 3) )  + (1.10312273057363E-05 * powf(index1, 2) )   + ( -0.0126156758999879  * index1 ) + 7.07559912853922 ;  MaxPA_2 =  (5.47255939412774E-09 * powf(index1, 3) )  + (-2.89796659404485E-05 * powf(index1, 2) )   + ( 0.0676932254383201  * index1 ) + -44.336819172111;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    
    
    if (indexOAT >= 27.8  & indexOAT < 33.2) {
        
        float y1 = 27.8;   float y2 = 33.2;
                
        MaxPA_1 =  (5.47255939412774E-09 * powf(index1, 3) )  + (-2.89796659404485E-05 * powf(index1, 2) )   + ( 0.0676932254383201  * index1 ) + -44.336819172111 ;  MaxPA_2 =  (2.4691358024691E-09 * powf(index1, 3) )  + (-8.49382716049361E-06 * powf(index1, 2) )   + ( 0.0253209876543205  * index1 ) + -13.8829629629627;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
        
    
    if (indexOAT >= 33.2  & indexOAT <= 39.0) {
        
        float y1 = 33.2;    float y2 =  39.0;
        
        
        MaxPA_1 =  (2.4691358024691E-09 * powf(index1, 3) )  + (-8.49382716049361E-06 * powf(index1, 2) )   + ( 0.0253209876543205  * index1 ) + -13.8829629629627 ;  MaxPA_2 =  (7.23622782446283E-09 * powf(index1, 3) )  + (-0.000033856209150325 * powf(index1, 2) )   + ( 0.0725177404295016  * index1 ) + -41.4960784313702;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
        
    }
    
    if (indexOAT >= 39.0  & indexOAT <= 43.0) {
        
        float y1 = 39.0;    float y2 =  43.0;
        
        
        MaxPA_1 =  (7.23622782446283E-09 * powf(index1, 3) )  + (-0.000033856209150325 * powf(index1, 2) )   + ( 0.0725177404295016  * index1 ) + -41.4960784313702 ;  MaxPA_2 =  (7.23622782446283E-09 * powf(index1, 3) )  + (-0.000033856209150325 * powf(index1, 2) )   + ( 0.0725177404295016  * index1 ) + -37.4960784313702;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
       
    }
    
    
    
    if (indexWeight <= 7) {
        indexWeight = 7;
    }
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= -2  & indexWeight < 10) {   float y1 =-2;     float y2 = 10;
            MaxPA_1= -0.2 * index1 + -2 ;   MaxPA_2 = -0.167 *index1 + 10 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        
        
        if (indexWeight >= 10.0  & indexWeight < 20.0) {            
            float y1 = 10.0;   float y2 = 20.0; 
            MaxPA_1= -0.167 * index1 + 10 ;   MaxPA_2 = -0.233 *index1 + 20 ; ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        } 
        
        
        
        if (indexWeight >= 20.0  & indexWeight < 30.0) {      
            
            float y1 = 20.0;   float y2 = 30.0;          
            MaxPA_1= -0.233 * index1 + 20 ;   MaxPA_2 = -0.4 *index1 + 30 ;            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        
        
        if (indexWeight >= 30.0  & indexWeight <= 40.0) {
            
            float y1 = 28.0;    float y2 =  36.0;
            
            MaxPA_1= -0.4 * index1 + 30 ;   MaxPA_2 = -0.467 *index1 + 40 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= 5  & indexWeight < 10.0) {
            
            float y1 = 5;   float y2 = 10.0;
            
            MaxPA_1= 0.4 * index1 + 5 ;   MaxPA_2 = 0.467 *index1 + 10 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
          
        }
        
        
        
        if (indexWeight >= 10.0  & indexWeight < 15.0) {
            
            float y1 = 10.0;   float y2 = 15.0;
            
            MaxPA_1= 0.467 * index1 + 10 ;   MaxPA_2 = 0.533 *index1 + 15 ; 
           
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 15.0  & indexWeight < 20.0) {
            
            float y1 = 15.0;   float y2 = 20.0;
                        
            MaxPA_1= 0.533 * index1 + 15 ;   MaxPA_2 = 0.8 *index1 + 20 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           
            
            
        }
        
        
        
        if (indexWeight >= 20.0  & indexWeight < 30.0) {
            
            float y1 = 20.0;    float y2 =  30.0;
            
                        MaxPA_1= 0.8 * index1 + 20 ;   MaxPA_2 = 1.333 *index1 + 30 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
          
            
        }
        
        
        if (indexWeight >= 30.0  & indexWeight < 48.0) {
            
            float y1 = 30.0;    float y2 =  48.0;
                        
            MaxPA_1= 1.333 * index1 + 30 ;   MaxPA_2 = 2.467 *index1 + 48 ; 
                        
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           
            
        }
        
    }// end head/tailwind
    
    //NSLog(@"indexWind %.2f", indexWind);
    /*
     if (indexWind < 0) {
     indexWind = 0;
     }
     
     if (indexWind > 70) {
     indexWind = 70;
     }
     
     */
    
    
    
    
    resultWithWind = (4000/40) * indexWind;
    resultDistanceOverObstacle = (4000/40) * indexWeight;
    resultWindDifference50ft_TO = resultWithWind - resultDistanceOverObstacle;
    
    
    
    
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultGroundRoll %.0f", resultGroundRoll);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}

- (void) takeoff_DA40180 {
  
    
 
    
    
    float Hp = PressureAltitude;
    float OAT= sliderOATvalue;
    float MaxPA_1 = 0, MaxPA_2 = 0;
    float indexOAT = 0;
    float indexWeight = 0;
    float indexWind = 0;
    
   
    
    if (Hp >= 0 & Hp < 2000 & OAT <=  20 ) {
        MaxPA_1 = (0.00025 * powf(OAT, 2) )   + ( 0.03  * OAT ) + 1.6   ; MaxPA_2 = (0.000125 * powf(OAT, 2) )   + ( 0.0325  * OAT ) + 2.3   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
         }
    
    if (Hp >= 0 & Hp < 2000 & OAT <=  20 ) {
        MaxPA_1 = (0.00025 * powf(OAT, 2) )   + ( 0.03  * OAT ) + 1.6   ; MaxPA_2 = (0.000125 * powf(OAT, 2) )   + ( 0.0325  * OAT ) + 2.3   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        }
    
    if (Hp >= 0 & Hp < 2000 & OAT >  20 ) {
        MaxPA_1 = (0.000166666666666665 * powf(OAT, 2) )   + ( 0.0250000000000001  * OAT ) + 1.73333333333333   ; MaxPA_2 = (0.000222222222222221 * powf(OAT, 2) )   + ( 0.0344444444444445  * OAT ) + 2.22222222222222   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        }
    
    if (Hp >= 2000 & Hp < 4000 & OAT <=  20 ) {
        MaxPA_1 = (0.000125 * powf(OAT, 2) )   + ( 0.0325  * OAT ) + 2.3   ; MaxPA_2 = (0.000166666666666667 * powf(OAT, 2) )   + ( 0.0383333333333333  * OAT ) + 3.1   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000 )  );
       }
    
    if (Hp >= 2000 & Hp < 4000 & OAT >  20 ) {
        MaxPA_1 = (0.000222222222222221 * powf(OAT, 2) )   + ( 0.0344444444444445  * OAT ) + 2.22222222222222   ; MaxPA_2 = (0.000124999999999999 * powf(OAT, 2) )   + ( 0.0550000000000001  * OAT ) + 2.9375   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000 )  );
     }
    
    if (Hp >= 4000 & Hp < 6000 & OAT <=  10 ) {
        MaxPA_1 = (0.000166666666666667 * powf(OAT, 2) )   + ( 0.0383333333333333  * OAT ) + 3.1   ; MaxPA_2 = (0.000666666666666669 * powf(OAT, 2) )   + ( 0.0633333333333334  * OAT ) + 4.1   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000 )  );
         }
    
    if (Hp >= 4000 & Hp < 6000 & OAT >  10 ) {
        MaxPA_1 = (0.000124999999999999 * powf(OAT, 2) )   + ( 0.0550000000000001  * OAT ) + 2.9375   ; MaxPA_2 = (0.000714285714285716 * powf(OAT, 2) )   + ( 0.0478571428571427  * OAT ) + 4.32142857142857   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000 )  );
        }    
    
    if (Hp >= 6000 & Hp < 8000 & OAT <=  15 ) {
        MaxPA_1 = (0.000666666666666669 * powf(OAT, 2) )   + ( 0.0633333333333334  * OAT ) + 4.1   ; MaxPA_2 = (0.000566666666666665 * powf(OAT, 2) )   + ( 0.0963333333333333  * OAT ) + 5.8   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 6000 )  );
         }
    
    if (Hp >= 6000 & Hp < 8000 & OAT >  15 ) {
        MaxPA_1 = (0.000714285714285716 * powf(OAT, 2) )   + ( 0.0478571428571427  * OAT ) + 4.32142857142857   ; MaxPA_2 = (0.00399999999999999 * powf(OAT, 2) )   + ( -0.0799999999999991  * OAT ) + 7.99999999999998   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 6000 )  );
         }
    if (Hp >= 8000 & Hp < 10000 & OAT <=  30 ) {
        MaxPA_1 = (0.000566666666666665 * powf(OAT, 2) )   + ( 0.0963333333333333  * OAT ) + 5.8   ; MaxPA_2 = (0.000888888888888889 * powf(OAT, 2) )   + ( 0.122222222222222  * OAT ) + 7.88888888888889   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 8000 )  );
       }
    if (Hp >= 8000 & Hp < 10000 & OAT >  30 ) {
        MaxPA_1 = (0.00399999999999999 * powf(OAT, 2) )   + ( -0.0799999999999991  * OAT ) + 7.99999999999998   ; MaxPA_2 = (0.00316666666666667 * powf(OAT, 2) )   + ( 0.105  * OAT ) + 7.83333333333333   ;
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 8000 )  );
         }
    
 
    // now calc index weight
    
    float index1 = ACweightLBS ;
    
    if (index1 < 850) {
        index1 = 850;
    }
    if (index1 > 1200) {
        index1 = 1200;
    } 
    
    if (indexOAT >= 0.3  & indexOAT < 3.8 & index1 >= 1000 ) {  float y1 = 2.3;   float y2 = 3.8;
        MaxPA_1 = 0.0055 * index1 + -4.3 ;   MaxPA_2 = 0.009 *index1 + -7 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }    
    if (indexOAT >= 0.3  & indexOAT < 3.8 & index1 < 1000 ) {  float y1 = 2.3;   float y2 = 3.8;
        MaxPA_1 = 0.005 * index1 + -3.8 ;   MaxPA_2 = 0.004 *index1 + -2 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    if (indexOAT >= 3.8  & indexOAT < 5.8 & index1 >= 1000 ) {  float y1 = 3.8;   float y2 = 5.8;
        MaxPA_1 = 0.009 * index1 + -7 ;   MaxPA_2 = 0.013 *index1 + -9.8 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    if (indexOAT >= 3.8  & indexOAT < 5.8 & index1 < 1000 ) {  float y1 = 3.8;   float y2 = 5.8;
        MaxPA_1 = 0.004 * index1 + -2 ;   MaxPA_2 = 0.00733333 *index1 + -4.13333333 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    if (indexOAT >= 5.8  & indexOAT < 9.7 & index1 >= 1000 ) {  float y1 = 5.8;   float y2 = 9.7;
        MaxPA_1 = 0.013 * index1 + -9.8 ;   MaxPA_2 = 0.0235 *index1 + -18.5 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    if (indexOAT >= 5.8  & indexOAT < 9.7 & index1 < 1000 ) {  float y1 = 5.8;   float y2 = 9.7;
        MaxPA_1 = 0.00733333 * index1 + -4.13333333 ;   MaxPA_2 = 0.01066667 *index1 + -5.66666667 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    if (indexOAT >= 9.7  & indexOAT < 12 & index1 >= 1000 ) {  float y1 = 9.7;   float y2 = 12;
        MaxPA_1 = 0.0235 * index1 + -18.5 ;   MaxPA_2 = 0.025 *index1 + -18 ;
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        }
    if (indexOAT >= 9.7  & indexOAT < 12 & index1 < 1000 ) {  float y1 = 9.7;   float y2 = 12;
        MaxPA_1 = 0.01066667 * index1 + -5.66666667 ;   MaxPA_2 = 0.01 *index1 + -3 ; 
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
       }
    
     
    // now calc wind
    if (headWindKts >= 0) {
         index1 = headWindKts; 
        if (indexWeight >= 0.1  & indexWeight < 0.6) {  float y1 = 0.1;   float y2 = 0.6;
            MaxPA_1 = -0.09 * index1 + 0.1 ;   MaxPA_2 = -0.065 *index1 + 0.6 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 0.6  & indexWeight < 1.1) {  float y1 = 0.6;   float y2 = 1.1;
            MaxPA_1 = -0.065 * index1 + 0.6 ;   MaxPA_2 = -0.055 *index1 + 1.1 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
          }
        if (indexWeight >= 1.1  & indexWeight < 2.1) {  float y1 = 1.1;   float y2 = 2.1;
            MaxPA_1 = -0.055 * index1 + 1.1 ;   MaxPA_2 = -0.0825 *index1 + 2.1 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           }
        if (indexWeight >= 2.1  & indexWeight < 3.3) {  float y1 = 2.1;   float y2 = 3.3;
            MaxPA_1 = -0.0825 * index1 + 2.1 ;   MaxPA_2 = -0.12 *index1 + 3.3 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 3.3  & indexWeight < 5) {  float y1 = 3.3;   float y2 = 5;
            MaxPA_1 = -0.12 * index1 + 3.3 ;   MaxPA_2 = -0.1425 *index1 + 5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 5  & indexWeight < 8.3) {  float y1 = 5;   float y2 = 8.3;
            MaxPA_1 = -0.1425 * index1 + 5 ;   MaxPA_2 = -0.2025 *index1 + 8.3 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 8.3  & indexWeight < 11) {  float y1 = 8.3;   float y2 = 11;
            MaxPA_1 = -0.2025 * index1 + 8.3 ;   MaxPA_2 = -0.225 *index1 + 11 ; 
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           }
    }else{
        index1 = headWindKts * -1; 
        if (indexWeight >= 0.1  & indexWeight < 0.55) {  float y1 = 0.1;   float y2 = 0.55;
            MaxPA_1 = 0.1 * index1 + 0.1 ;   MaxPA_2 = 0.0975 *index1 + 0.55 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 0.55  & indexWeight < 1.1) {  float y1 = 0.55;   float y2 = 1.1;
            MaxPA_1 = 0.0975 * index1 + 0.55 ;   MaxPA_2 = 0.115 *index1 + 1.1 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 1.1  & indexWeight < 2.1) {  float y1 = 1.1;   float y2 = 2.1;
            MaxPA_1 = 0.115 * index1 + 1.1 ;   MaxPA_2 = 0.11 *index1 + 2.1 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 2.1  & indexWeight < 3.3) {  float y1 = 2.1;   float y2 = 3.3;
            MaxPA_1 = 0.11 * index1 + 2.1 ;   MaxPA_2 = 0.185 *index1 + 3.3 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 3.3  & indexWeight < 5) {  float y1 = 3.3;   float y2 = 5;
            MaxPA_1 = 0.185 * index1 + 3.3 ;   MaxPA_2 = 0.175 *index1 + 5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 5  & indexWeight < 8.5) {  float y1 = 5;   float y2 = 8.5;
            MaxPA_1 = 0.175 * index1 + 5 ;   MaxPA_2 = 0.225 *index1 + 8.5 ;
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            }
        if (indexWeight >= 8.5  & indexWeight < 11) {  float y1 = 8.5;   float y2 = 11;
            MaxPA_1 = 0.225 * index1 + 8.5 ;   MaxPA_2 = 0.25 *index1 + 11 ; 
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
           }
    }
    
   
    float resultWithWind = 328 + (   ( (5249.3-328) / 15 ) * indexWind );
    resultGroundRoll = 328 + (   ( (5249.3-328) / 15 ) * indexWeight );  
    resultWindDifferenceGR_TO = resultWithWind - resultGroundRoll;
    

    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    index1 = 15; 
    float indexTO =0;
    
    if (indexWind >= 0  & indexWind < 0.5) {  float y1 = 0;   float y2 = 0.5;
        MaxPA_1 = 0.07333333 * index1 + 0 ;   MaxPA_2 = 0.08 *index1 + 0.5 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }    
    if (indexWind >= 0  & indexWind < 0.5) {  float y1 = 0;   float y2 = 0.5;
        MaxPA_1 = 0.07333333 * index1 + 0 ;   MaxPA_2 = 0.08 *index1 + 0.5 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }
    if (indexWind >= 0.5  & indexWind < 2.1) {  float y1 = 0.5;   float y2 = 2.1;
        MaxPA_1 = 0.08 * index1 + 0.5 ;   MaxPA_2 = 0.09333333 *index1 + 2.1 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }
    if (indexWind >= 2.1  & indexWind < 3) {  float y1 = 2.1;   float y2 = 3;
        MaxPA_1 = 0.09333333 * index1 + 2.1 ;   MaxPA_2 = 0.12 *index1 + 3 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }
    if (indexWind >= 3  & indexWind < 5.2) {  float y1 = 3;   float y2 = 5.2;
        MaxPA_1 = 0.12 * index1 + 3 ;   MaxPA_2 = 0.18666667 *index1 + 5.2 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
       }
    if (indexWind >= 5.2  & indexWind < 8.5) {  float y1 = 5.2;   float y2 = 8.5;
        MaxPA_1 = 0.18666667 * index1 + 5.2 ;   MaxPA_2 = 0.25333333 *index1 + 8.5 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }
    if (indexWind >= 8.5  & indexWind < 11) {  float y1 = 8.5;   float y2 = 11;
        MaxPA_1 = 0.25333333 * index1 + 8.5 ;   MaxPA_2 = 0.26666667 *index1 + 11 ;
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }
    if (indexWind >= 11  & indexWind < 18) {  float y1 = 11;   float y2 = 18;
        MaxPA_1 = 0.26666667 * index1 + 11 ;   MaxPA_2 = 0.66666667 *index1 + 18 ; 
        indexTO   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWind - y1 )  );
        }
    
      
    resultDistanceOverObstacle = (328 + (   ( (5249.3-328) / 15 ) * indexTO )) - resultWindDifference50ft_TO;
    resultWindDifference50ft_TO = resultWindDifferenceGR_TO;

 
    
    
}
- (void) landing_DA40180 {
    

 
    float Hp_L = PressureAltitude;
    float OAT_L= sliderOATvalue;
    float MaxPA_1L = 0, MaxPA_2L = 0;
    float indexOAT_L = 0;
    float indexWeight_L = 0;
    float indexWind_L = 0;
    
   
    
    if (Hp_L >= -1000 & Hp_L < 2000 & OAT_L <=  10 ) {
        MaxPA_1L = (1.97813056240725E-19 * powf(OAT_L, 2) )   + ( 0.02  * OAT_L ) + 5.1   ; MaxPA_2L = (0.000111111111111109 * powf(OAT_L, 2) )   + ( 0.0227777777777778  * OAT_L ) + 5.51111111111111   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 0 )  );
        }
    if (Hp_L >= 0 & Hp_L < 2000 & OAT_L >  10 ) {
        MaxPA_1L = (8.33333333333346E-05 * powf(OAT_L, 2) )   + ( 0.0162499999999999  * OAT_L ) + 5.12916666666667   ; MaxPA_2L = (0.000116666666666667 * powf(OAT_L, 2) )   + ( 0.01675  * OAT_L ) + 5.57083333333333   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 0 )  );
         }
    if (Hp_L >= 2000 & Hp_L < 4000 & OAT_L <=  10 ) {
        MaxPA_1L = (0.000111111111111109 * powf(OAT_L, 2) )   + ( 0.0227777777777778  * OAT_L ) + 5.51111111111111   ; MaxPA_2L = (-0.000111111111111109 * powf(OAT_L, 2) )   + ( 0.0272222222222222  * OAT_L ) + 5.98888888888889   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 2000 )  );
        }
    if (Hp_L >= 2000 & Hp_L < 4000 & OAT_L >  10 ) {
        MaxPA_1L = (0.000116666666666667 * powf(OAT_L, 2) )   + ( 0.01675  * OAT_L ) + 5.57083333333333   ; MaxPA_2L = (0.000150000000000001 * powf(OAT_L, 2) )   + ( 0.01725  * OAT_L ) + 6.0625   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 2000 )  );
        }
    if (Hp_L >= 4000 & Hp_L < 6000 & OAT_L <=  10 ) {
        MaxPA_1L = (-0.000111111111111109 * powf(OAT_L, 2) )   + ( 0.0272222222222222  * OAT_L ) + 5.98888888888889   ; MaxPA_2L = (-1.97813056240725E-18 * powf(OAT_L, 2) )   + ( 0.0266666666666666  * OAT_L ) + 6.53333333333333   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 4000 )  );
         }
    if (Hp_L >= 4000 & Hp_L < 6000 & OAT_L >  10 ) {
        MaxPA_1L = (0.000150000000000001 * powf(OAT_L, 2) )   + ( 0.01725  * OAT_L ) + 6.0625   ; MaxPA_2L = (0.0001 * powf(OAT_L, 2) )   + ( 0.0215  * OAT_L ) + 6.575   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 4000 )  );
         }
    if (Hp_L >= 6000 & Hp_L < 8000 & OAT_L <=  10 ) {
        MaxPA_1L = (-1.97813056240725E-18 * powf(OAT_L, 2) )   + ( 0.0266666666666666  * OAT_L ) + 6.53333333333333   ; MaxPA_2L = (-0.000222222222222221 * powf(OAT_L, 2) )   + ( 0.0277777777777778  * OAT_L ) + 7.14444444444444   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 6000 )  );
         }
    if (Hp_L >= 6000 & Hp_L < 8000 & OAT_L >  10 ) {
        MaxPA_1L = (0.0001 * powf(OAT_L, 2) )   + ( 0.0215  * OAT_L ) + 6.575   ; MaxPA_2L = (0.000333333333333332 * powf(OAT_L, 2) )   + ( 0.0250000000000001  * OAT_L ) + 7.11666666666667   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 6000 )  );
         }
    if (Hp_L >= 8000 & Hp_L <= 10000 & OAT_L <=  10 ) {
        MaxPA_1L = (-0.000222222222222221 * powf(OAT_L, 2) )   + ( 0.0277777777777778  * OAT_L ) + 7.14444444444444   ; MaxPA_2L = (4.44444444444441E-05 * powf(OAT_L, 2) )   + ( 0.0371111111111111  * OAT_L ) + 7.72444444444444   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 8000 )  );
        }
    if (Hp_L >= 8000 & Hp_L <= 10000 & OAT_L >  10 ) {
        MaxPA_1L = (0.000333333333333332 * powf(OAT_L, 2) )   + ( 0.0250000000000001  * OAT_L ) + 7.11666666666667   ; MaxPA_2L = (0.000533333333333332 * powf(OAT_L, 2) )   + ( 0.0280000000000001  * OAT_L ) + 7.76666666666667   ;
        indexOAT_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / 2000  * ( Hp_L - 8000 )  );
         }    
    
    
    
    
    // now calc index weight
    
  
    float index1L = ACweightLBS;
    if (index1L < 850) {
        index1L = 850;
    }
    if (index1L > 1200) {
        index1L = 1200;
    } 
    
 
    
    if (indexOAT_L >= 5  & indexOAT_L < 5.7) {  float y1L = 5;   float y2L = 5.7;
        MaxPA_1L = 0.00571429 * index1L + -1.85714286 ;   MaxPA_2L = 0.00571429 *index1L + -1.15714286 ;
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
       }
    if (indexOAT_L >= 5.7  & indexOAT_L < 6.05) {  float y1L = 5.7;   float y2L = 6.05;
        MaxPA_1L = 0.00571429 * index1L + -1.15714286 ;   MaxPA_2L = 0.00571429 *index1L + -0.80714286 ;
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
        }
    if (indexOAT_L >= 6.05  & indexOAT_L < 6.6) {  float y1L = 6.05;   float y2L = 6.6;
        MaxPA_1L = 0.00571429 * index1L + -0.80714286 ;   MaxPA_2L = 0.00628571 *index1L + -0.94285714 ;
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
       }
    if (indexOAT_L >= 6.6  & indexOAT_L < 7.25) {  float y1L = 6.6;   float y2L = 7.25;
        MaxPA_1L = 0.00628571 * index1L + -0.94285714 ;   MaxPA_2L = 0.00685714 *index1L + -0.97857143 ;
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
        }
    if (indexOAT_L >= 7.25  & indexOAT_L < 7.8) {  float y1L = 7.25;   float y2L = 7.8;
        MaxPA_1L = 0.00685714 * index1L + -0.97857143 ;   MaxPA_2L = 0.007 *index1L + -0.6 ;
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
        }
    if (indexOAT_L >= 7.8  & indexOAT_L < 8.8) {  float y1L = 7.8;   float y2L = 8.8;
        MaxPA_1L = 0.007 * index1L + -0.6 ;   MaxPA_2L = 0.00842857 *index1L + -1.31428571 ;
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
        }
    if (indexOAT_L >= 8.8  & indexOAT_L < 10) {  float y1L = 8.8;   float y2L = 10;
        MaxPA_1L = 0.00842857 * index1L + -1.31428571 ;   MaxPA_2L = 0.00857143 *index1L + -0.28571429 ; 
        indexWeight_L  = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexOAT_L - y1L )  );
        }
  
    if (headWindKts < 0) {
        headWindKts = 0;
    }
    // now calc wind
    if (headWindKts >= 0) {
        index1L = headWindKts; 
        
        if (indexWeight_L >= 3  & indexWeight_L < 3.7) {  float y1L = 3;   float y2L = 3.7;
            MaxPA_1L = -0.125 * index1L + 3 ;   MaxPA_2L = -0.125 *index1L + 3.7 ;
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
            }
        if (indexWeight_L >= 3.7  & indexWeight_L < 4.62) {  float y1L = 3.7;   float y2L = 4.62;
            MaxPA_1L = -0.125 * index1L + 3.7 ;   MaxPA_2L = -0.1435 *index1L + 4.62 ;
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
            }
        if (indexWeight_L >= 4.62  & indexWeight_L < 5.3) {  float y1L = 4.62;   float y2L = 5.3;
            MaxPA_1L = -0.1435 * index1L + 4.62 ;   MaxPA_2L = -0.145 *index1L + 5.3 ;
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
           }
        if (indexWeight_L >= 5.3  & indexWeight_L < 6.3) {  float y1L = 5.3;   float y2L = 6.3;
            MaxPA_1L = -0.145 * index1L + 5.3 ;   MaxPA_2L = -0.165 *index1L + 6.3 ;
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
            }
        if (indexWeight_L >= 6.3  & indexWeight_L < 7) {  float y1L = 6.3;   float y2L = 7;
            MaxPA_1L = -0.165 * index1L + 6.3 ;   MaxPA_2L = -0.175 *index1L + 7 ;
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
            }
        if (indexWeight_L >= 7  & indexWeight_L < 8.2) {  float y1L = 7;   float y2L = 8.2;
            MaxPA_1L = -0.175 * index1L + 7 ;   MaxPA_2L = -0.185 *index1L + 8.2 ;
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
            }
        if (indexWeight_L >= 8.2  & indexWeight_L < 9) {  float y1L = 8.2;   float y2L = 9;
            MaxPA_1L = -0.185 * index1L + 8.2 ;   MaxPA_2L = -0.18 *index1L + 9 ; 
            indexWind_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWeight_L - y1L )  );
            }
        
    }
    
  
    // now calc landing distance
    
    
    index1L = 0;
    float indexTO_L = 0;
    
    if (indexWind_L >= 1.1  & indexWind_L < 1.7) {  float y1L = 1.1;   float y2L = 1.7;
        MaxPA_1L = 0.06666667 * index1L + 0.1 ;   MaxPA_2L = 0.09333333 *index1L + 0.3 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
        }
    if (indexWind_L >= 1.7  & indexWind_L < 2.2) {  float y1L = 1.7;   float y2L = 2.2;
        MaxPA_1L = 0.09333333 * index1L + 0.3 ;   MaxPA_2L = 0.11333333 *index1L + 0.5 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
       }
    if (indexWind_L >= 2.2  & indexWind_L < 3.1) {  float y1L = 2.2;   float y2L = 3.1;
        MaxPA_1L = 0.11333333 * index1L + 0.5 ;   MaxPA_2L = 0.14666667 *index1L + 0.9 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
        }
    if (indexWind_L >= 3.1  & indexWind_L < 4.5) {  float y1L = 3.1;   float y2L = 4.5;        
        MaxPA_1L = 0.14666667 * index1L + 0.9 ;   MaxPA_2L = 0.19333333 *index1L + 1.6 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
        }
    if (indexWind_L >= 4.5  & indexWind_L < 5.3) {  float y1L = 4.5;   float y2L = 5.3;
        MaxPA_1L = 0.19333333 * index1L + 1.6 ;   MaxPA_2L = 0.22 *index1L + 2 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
        }
    if (indexWind_L >= 5.3  & indexWind_L < 6.3) {  float y1L = 5.3;   float y2L = 6.3;
        MaxPA_1L = 0.22 * index1L + 2 ;   MaxPA_2L = 0.24 *index1L + 2.7 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
        }
    if (indexWind_L >= 6.3  & indexWind_L < 8.3) {  float y1L = 6.3;   float y2L = 8.3;
        MaxPA_1L = 0.24 * index1L + 2.7 ;   MaxPA_2L = 0.32666667 *index1L + 3.4 ; 
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
        }
    
     float resultWithWind = (100 + (indexWind_L * 100)) * 3.28084;  
     resultDistanceOverObstacle = (((100 + (indexWeight_L * 100))) * 3.28084) ;   
     resultWindDifference50ft_LD = resultWithWind -  resultDistanceOverObstacle; 
     float groundRollWithWind = (((100 + (indexTO_L * 100))) * 3.28084) ;
    
    
    indexWind_L = indexWeight_L;
    
    if (indexWind_L >= 1.1  & indexWind_L < 1.7) {  float y1L = 1.1;   float y2L = 1.7;
        MaxPA_1L = 0.06666667 * index1L + 0.1 ;   MaxPA_2L = 0.09333333 *index1L + 0.3 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    if (indexWind_L >= 1.7  & indexWind_L < 2.2) {  float y1L = 1.7;   float y2L = 2.2;
        MaxPA_1L = 0.09333333 * index1L + 0.3 ;   MaxPA_2L = 0.11333333 *index1L + 0.5 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    if (indexWind_L >= 2.2  & indexWind_L < 3.1) {  float y1L = 2.2;   float y2L = 3.1;
        MaxPA_1L = 0.11333333 * index1L + 0.5 ;   MaxPA_2L = 0.14666667 *index1L + 0.9 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    if (indexWind_L >= 3.1  & indexWind_L < 4.5) {  float y1L = 3.1;   float y2L = 4.5;        
        MaxPA_1L = 0.14666667 * index1L + 0.9 ;   MaxPA_2L = 0.19333333 *index1L + 1.6 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    if (indexWind_L >= 4.5  & indexWind_L < 5.3) {  float y1L = 4.5;   float y2L = 5.3;
        MaxPA_1L = 0.19333333 * index1L + 1.6 ;   MaxPA_2L = 0.22 *index1L + 2 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    if (indexWind_L >= 5.3  & indexWind_L < 6.3) {  float y1L = 5.3;   float y2L = 6.3;
        MaxPA_1L = 0.22 * index1L + 2 ;   MaxPA_2L = 0.24 *index1L + 2.7 ;
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    if (indexWind_L >= 6.3  & indexWind_L < 8.3) {  float y1L = 6.3;   float y2L = 8.3;
        MaxPA_1L = 0.24 * index1L + 2.7 ;   MaxPA_2L = 0.32666667 *index1L + 3.4 ; 
        indexTO_L   = MaxPA_1L +   (  (MaxPA_2L - MaxPA_1L) / (y2L - y1L)  * ( indexWind_L - y1L )  );
    }
    
    float groundRollWithOUTwind = ((100 + (indexTO_L * 100)) * 3.28084) ; 
    resultGroundRoll = groundRollWithOUTwind ;  
    resultWindDifferenceGR_LD = groundRollWithWind - groundRollWithOUTwind ;
   
    
    
    
    
}

- (void) climb_DA40180 {
    
    float climbHp = PressureAltitude;
    float climbOAT = sliderOATvalue;
    float climbMaxPA_2 = 0, climbMaxPA_1 = 0;
    float climbIndexOAT = 0;
    float TOWclimb = ACweightLBS;
    
    
    
    //NSLog(@"----------");
    
    //NSLog(@"climbHp %.0f", climbHp);
    //NSLog(@"climbOAT %.0f", climbOAT);
    //NSLog(@"TOWclimb %.0f", TOWclimb);
    
    
    if (climbHp > 16000) {
        climbHp = 16000;
    }
    
    if (climbHp >= 0 & climbHp < 2000 & climbOAT <=  15 ) {
        climbMaxPA_1 = (0.000190476190476189 * powf(climbOAT, 2) )   + ( 0.0638095238095238  * climbOAT ) + 7.2   ; climbMaxPA_2 = (4.76190476190482E-05 * powf(climbOAT, 2) )   + ( 0.065952380952381  * climbOAT ) + 8.5   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 0 )  );
       }
    
    if (climbHp >= 0 & climbHp < 2000 & climbOAT <=  50 ) {
        climbMaxPA_1 = (0.000166666666666667 * powf(climbOAT, 2) )   + ( 0.0491666666666667  * climbOAT ) + 7.425   ; climbMaxPA_2 = (0.000166666666666667 * powf(climbOAT, 2) )   + ( 0.0491666666666667  * climbOAT ) + 8.725   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 0 )  );
         }
    
    
    
    if (climbHp >= 2000 & climbHp < 4000 & climbOAT <=  15 ) {
        climbMaxPA_1 = (4.76190476190482E-05 * powf(climbOAT, 2) )   + ( 0.065952380952381  * climbOAT ) + 8.5   ; climbMaxPA_2 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 9.8   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 2000 )  );
         }
    
    
    
    if (climbHp >= 2000 & climbHp < 4000 & climbOAT <=  50 ) {
        climbMaxPA_1 = (0.000166666666666667 * powf(climbOAT, 2) )   + ( 0.0491666666666667  * climbOAT ) + 8.725   ; climbMaxPA_2 = (0.000166666666666668 * powf(climbOAT, 2) )   + ( 0.0491666666666667  * climbOAT ) + 9.925   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 2000 )  );
        }
    
    
    
    if (climbHp >= 4000 & climbHp < 6000 & climbOAT <=  15 ) {
        climbMaxPA_1 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 9.8   ; climbMaxPA_2 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 11   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 4000 )  );
         }
    
    
    
    if (climbHp >= 4000 & climbHp < 6000 & climbOAT <=  50 ) {
        climbMaxPA_1 = (0.000166666666666668 * powf(climbOAT, 2) )   + ( 0.0491666666666667  * climbOAT ) + 9.925   ; climbMaxPA_2 = (0.000214285714285712 * powf(climbOAT, 2) )   + ( 0.0517857142857145  * climbOAT ) + 11.075   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 4000 )  );
         }
    
    
    
    if (climbHp >= 6000 & climbHp < 8000 & climbOAT <=  15 ) {
        climbMaxPA_1 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 11   ; climbMaxPA_2 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 12.2   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 6000 )  );
         }
    
    
    
    if (climbHp >= 6000 & climbHp < 8000 & climbOAT <=  50 ) {
        climbMaxPA_1 = (0.000214285714285712 * powf(climbOAT, 2) )   + ( 0.0517857142857145  * climbOAT ) + 11.075   ; climbMaxPA_2 = (0.000214285714285712 * powf(climbOAT, 2) )   + ( 0.0517857142857145  * climbOAT ) + 12.275   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 6000 )  );
        }
    
    
    
    if (climbHp >= 8000 & climbHp < 10000 & climbOAT <=  15 ) {
        climbMaxPA_1 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 12.2   ; climbMaxPA_2 = (-0.000142857142857148 * powf(climbOAT, 2) )   + ( 0.0621428571428571  * climbOAT ) + 13.4   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 8000 )  );
        }
    
    
    
    if (climbHp >= 8000 & climbHp < 16000 & climbOAT <=  50 ) {
        climbMaxPA_1 = (0.000214285714285712 * powf(climbOAT, 2) )   + ( 0.0517857142857145  * climbOAT ) + 12.275   ; climbMaxPA_2 = (-0.00021428571428572 * powf(climbOAT, 2) )   + ( 0.0882142857142861  * climbOAT ) + 13.025   ;
        climbIndexOAT  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 2000  * ( climbHp - 8000 )  );
       }
    
    //NSLog(@"climbIndexOAT %.2F", climbIndexOAT);
    
    
    
     // climb time ***********************************
    
    float y1c = 0, y2c =0, rateOfClimb1 = 0;
   
    
    //NSLog(@"TOWclimb %.2F", TOWclimb);
    
    if (climbIndexOAT >= 5  & climbIndexOAT < 8.05) {  y1c = 5;   y2c = 8.05;
        climbMaxPA_1 =  (-2.66666666666669E-05 * powf(TOWclimb, 2) )   + ( 0.0733333333333338  * TOWclimb ) + -44.6000000000002 ;  climbMaxPA_2 =  (-4.66666666666669E-06 * powf(TOWclimb, 2) )   + ( 0.0238333333333334  *TOWclimb ) + -13.83;
        rateOfClimb1  = climbMaxPA_1 +   (  (climbMaxPA_2 -climbMaxPA_1) / (y2c-y1c)  * ( climbIndexOAT - y1c )  );
        }
    
    if (climbIndexOAT >= 8.05  & climbIndexOAT < 10.05) {  y1c = 8.05;   y2c = 10.05;
        climbMaxPA_1 =  (-4.66666666666669E-06 * powf(TOWclimb, 2) )   + ( 0.0238333333333334  * TOWclimb ) + -13.83 ;  climbMaxPA_2 =  (-7.33333333333345E-06 * powf(TOWclimb, 2) )   + ( 0.0259666666666669  *TOWclimb ) + -10.5500000000001;
        rateOfClimb1  = climbMaxPA_1 +   (  (climbMaxPA_2 -climbMaxPA_1) / (y2c-y1c)  * ( climbIndexOAT - y1c )  );
        }
    if (climbIndexOAT >= 10.05  & climbIndexOAT < 12.05) {  y1c = 10.05;   y2c = 12.05;
        climbMaxPA_1 =  (-7.33333333333345E-06 * powf(TOWclimb, 2) )   + ( 0.0259666666666669  * TOWclimb ) + -10.5500000000001 ;  climbMaxPA_2 =  (-6.66666666666715E-07 * powf(TOWclimb, 2) )   + ( 0.00763333333333344  *TOWclimb ) + 3.84999999999994;
        rateOfClimb1  = climbMaxPA_1 +   (  (climbMaxPA_2 -climbMaxPA_1) / (y2c-y1c)  * ( climbIndexOAT - y1c )  );
        }
    if (climbIndexOAT >= 12.05  & climbIndexOAT < 14) {  y1c = 12.05;   y2c = 14;
        climbMaxPA_1 =  (-6.66666666666715E-07 * powf(TOWclimb, 2) )   + ( 0.00763333333333344  * TOWclimb ) + 3.84999999999994 ;  climbMaxPA_2 =  (-5.33333333333338E-06 * powf(TOWclimb, 2) )   + ( 0.0146666666666668  *TOWclimb ) + 4.07999999999994;
        rateOfClimb1  = climbMaxPA_1 +   (  (climbMaxPA_2 -climbMaxPA_1) / (y2c-y1c)  * ( climbIndexOAT - y1c )  );
        }
    if (climbIndexOAT >= 14  & climbIndexOAT < 20) {  y1c = 14;   y2c = 20;
        climbMaxPA_1 =  (-5.33333333333338E-06 * powf(TOWclimb, 2) )   + ( 0.0146666666666668  * TOWclimb ) + 4.07999999999994 ;  climbMaxPA_2 =  (-2.66666666666675E-06 * powf(TOWclimb, 2) )   + ( 0.00733333333333351  *TOWclimb ) + 11.0399999999999;
        rateOfClimb1  = climbMaxPA_1 +   (  (climbMaxPA_2 -climbMaxPA_1) / (y2c-y1c)  * ( climbIndexOAT - y1c )  );
        }
    
    resultClimbRoC = 1600 -  (rateOfClimb1 * 100); // this is feet per minute
    
    
 
   
    
    
    //NSLog(@"resultClimbRoC %.2F", resultClimbRoC);
    
    
    
}







- (void) calculate_PA28WarriorIIClimb {
    
    
    float climbHp = PressureAltitude;    
    float climbMaxPA_1 = 0, climbMaxPA_2 = 0;    
    float climbIndexOAT = 0;
    
    //float  calcisa = 15 - (1.98 * (sliderHp.value/1000));
    
    float climbOAT = ((15.0 - (PressureAltitude / 1000) * 1.98) + ISAdiff); 
    
    
    
    
    // climb index OAT
    
    if (climbHp >= 0 & climbHp < 1000) {
        
        
        climbMaxPA_1 = (0 * powf(climbOAT, 2) )   + ( 0  * climbOAT ) + 0   ; climbMaxPA_2 = (0.00040625 * powf(climbOAT, 2) )   + ( 0.02125  * climbOAT ) + 4.9   ;
        
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp )  );
        
    }
    
    
    
    if (climbHp >= 1000 & climbHp < 2000) {
        
        
        climbMaxPA_1 = (0.00040625 * powf(climbOAT, 2) )   + ( 0.02125  * climbOAT ) + 4.9   ; climbMaxPA_2 = (0.000843749999999999 * powf(climbOAT, 2) )   + ( 0.05625  * climbOAT ) + 9.6   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 1000 )  );
        
    }
    
    
    
    if (climbHp >= 2000 & climbHp < 3000) {
        
        
        climbMaxPA_1 = (0.000843749999999999 * powf(climbOAT, 2) )   + ( 0.05625  * climbOAT ) + 9.6   ; climbMaxPA_2 = (0.00128125 * powf(climbOAT, 2) )   + ( 0.09375  * climbOAT ) + 14.4   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 2000 )  );
        
    }
    
    
    if (climbHp >= 3000 & climbHp < 4000) {
        
        
        climbMaxPA_1 = (0.00128125 * powf(climbOAT, 2) )   + ( 0.09375  * climbOAT ) + 14.4   ; climbMaxPA_2 = (0.00178125 * powf(climbOAT, 2) )   + ( 0.14375  * climbOAT ) + 19.4   ;
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 3000 )  );
        
    }
    
    if (climbHp >= 4000 & climbHp < 5000) {
        
        
        climbMaxPA_1 = (0.00178125 * powf(climbOAT, 2) )   + ( 0.14375  * climbOAT ) + 19.4   ; climbMaxPA_2 = (0.00203125 * powf(climbOAT, 2) )   + ( 0.20375  * climbOAT ) + 24.4   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 4000 )  );
        
    }
    
    if (climbHp >= 5000 & climbHp < 6000) {
        
        
        climbMaxPA_1 = (0.00203125 * powf(climbOAT, 2) )   + ( 0.20375  * climbOAT ) + 24.4   ; climbMaxPA_2 = (0.0024375 * powf(climbOAT, 2) )   + ( 0.27  * climbOAT ) + 29.4   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 5000 )  );
        
    }
    
    
    if (climbHp >= 6000 & climbHp < 7000) {
        
        
        climbMaxPA_1 = (0.0024375 * powf(climbOAT, 2) )   + ( 0.27  * climbOAT ) + 29.4   ; climbMaxPA_2 = (0.00306249999999999 * powf(climbOAT, 2) )   + ( 0.32  * climbOAT ) + 34.9   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 6000 )  );
        
    }
    
    
    
    if (climbHp >= 7000 & climbHp < 8000) {
        
        
        climbMaxPA_1 = (0.00306249999999999 * powf(climbOAT, 2) )   + ( 0.32  * climbOAT ) + 34.9   ; climbMaxPA_2 = (0.00384374999999999 * powf(climbOAT, 2) )   + ( 0.40125  * climbOAT ) + 40.4   ;
        
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 7000 )  );
        
    }
    
    
    if (climbHp >= 8000 & climbHp < 9000) {
        
        
        climbMaxPA_1 = (0.00384374999999999 * powf(climbOAT, 2) )   + ( 0.40125  * climbOAT ) + 40.4   ; climbMaxPA_2 = (0.00384375 * powf(climbOAT, 2) )   + ( 0.45125  * climbOAT ) + 46.4   ;
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 8000 )  );
        
    }
    
    
    if (climbHp >= 9000 & climbHp < 10000) {
        
        
        climbMaxPA_1 = (0.00384375 * powf(climbOAT, 2) )   + ( 0.45125  * climbOAT ) + 46.4   ; climbMaxPA_2 = (0.00399999999999999 * powf(climbOAT, 2) )   + ( 0.495  * climbOAT ) + 52.4   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 9000 )  );
        
    }
    
    
    if (climbHp >= 10000 & climbHp < 11000) {
        
        
        climbMaxPA_1 = (0.00399999999999999 * powf(climbOAT, 2) )   + ( 0.495  * climbOAT ) + 52.4   ; climbMaxPA_2 = (0.00399999999999999 * powf(climbOAT, 2) )   + ( 0.545  * climbOAT ) + 58.4   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp -10000 )  );
        
    }
    
    if (climbHp >= 11000 & climbHp <= 12000) {
        
        
        climbMaxPA_1 = (0.003625 * powf(climbOAT, 2) )   + ( 0.56  * climbOAT ) + 58.9   ; climbMaxPA_2 = (0.003625 * powf(climbOAT, 2) )   + ( 0.61  * climbOAT ) + 64.9   ;
        
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 11000 )  );
        
    }
    
    
    /*
     if (climbIndexOAT > 62) {
     climbIndexOAT = 62;
     }
     */
    
    
    
    // climb time *******************************************************************************
    
    float climbMinutes = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 40) {
        climbMinutes =  (0.000125 * powf(climbIndexOAT, 3) )  + (-0.00374999999999998 * powf(climbIndexOAT, 2) )   + ( 0.425  *climbIndexOAT ) + -4.44089209850063E-16 ;
        
    }
    
    
    if (climbIndexOAT >= 40 & climbIndexOAT <= 60) {
        climbMinutes =  (0.000666666666666663 * powf(climbIndexOAT, 3) )  + (-0.0599999999999994 * powf(climbIndexOAT, 2) )   + ( 2.4833333333333  * climbIndexOAT ) + -26.9999999999994 ;
    }
    
    
    // climb fuel *******************************************************************************
    
    float climbFuel = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 30) {        
        climbFuel =  (0.000116666666666666 * powf(climbIndexOAT, 3) )  + (-0.00599999999999998 * powf(climbIndexOAT, 2) )   + ( 0.148333333333333  *climbIndexOAT ) + 4.44089209850063E-16 ;
    }
    if (climbIndexOAT >= 30 & climbIndexOAT <= 60) {
        
        climbFuel =  (0.0001 * powf(climbIndexOAT, 3) )  + (-0.011 * powf(climbIndexOAT, 2) )   + ( 0.560000000000002  * climbIndexOAT ) + -7.40000000000003 ;
        
    }
    
    // climb distance *******************************************************************************
    
    float climbDistance = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 40) {
        climbDistance =  (0.000225000000000001 * powf(climbIndexOAT, 3) )  + (-0.00500000000000005 * powf(climbIndexOAT, 2) )   + ( 0.527500000000001  *climbIndexOAT ) + -8.88178419700125E-16 ;
    }
    if (climbIndexOAT >= 40 & climbIndexOAT <= 60) {
        climbDistance =  (0.00126041666666672 * powf(climbIndexOAT, 3) )  + (-0.107562500000009 * powf(climbIndexOAT, 2) )   + ( 3.55208333333381  * climbIndexOAT ) + -23.1500000000082 ;
    }
    
    resultClimbTime = climbMinutes; 
    resultClimbFuel = climbFuel;
    resultClimbDistance = climbDistance;
    resultClimbSpeed = climbDistance / (climbMinutes/60); 
    resultClimbRoC = PressureAltitude / climbMinutes; // this is feet per minute
    
    //NSLog(@"-------");    
    //NSLog(@"climbHp %.1f", climbHp);
    //NSLog(@"climbOAT %.1f", climbOAT);    
    //NSLog(@"ISAdiff %.1f", ISAdiff);
    //NSLog(@"resultClimbTime %.1f", resultClimbTime);
    //NSLog(@"resultClimbFuel %.1f", resultClimbFuel);
    //NSLog(@"resultClimbDistance %.1f", resultClimbDistance);
    //NSLog(@"resultClimbSpeed %.1f", resultClimbSpeed); 
    //NSLog(@"resultClimbRoC %.1f", resultClimbRoC);
    
    
    
}

- (void) landing_PA28WarriorIII {
    
    float Hp_LD = PressureAltitude;
    float MaxPA_1_LD = 0, MaxPA_2_LD = 0;
    float indexOAT_LD = 0;
    float OAT_LD = sliderOATvalue;
    float indexWeight_LD = 0;
    float indexWind_LD = 0;
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 2000) {
                
        MaxPA_1_LD = (0.000125 * powf(OAT_LD, 2) )   + ( 0.2  * OAT_LD ) + 29.3   ; MaxPA_2_LD = (0.00021875 * powf(OAT_LD, 2) )   + ( 0.21625  * OAT_LD ) + 33.5   ;
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD )  );
       
        
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 4000) {        
        
        MaxPA_1_LD = (0.00021875 * powf(OAT_LD, 2) )   + ( 0.21625  * OAT_LD ) + 33.5   ; MaxPA_2_LD = (0.000281249999999997 * powf(OAT_LD, 2) )   + ( 0.24125  * OAT_LD ) + 38.2   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 2000)  );
      
        
    }
    
    
    
    if (Hp_LD >= 4000 & Hp_LD < 6000) {
        
        
        MaxPA_1_LD = (0.000281249999999997 * powf(OAT_LD, 2) )   + ( 0.24125  * OAT_LD ) + 38.2   ; MaxPA_2_LD = (0.000156249999999999 * powf(OAT_LD, 2) )   + ( 0.25625  * OAT_LD ) + 43   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 4000)  );
       
    }
    
    
    if (Hp_LD >= 6000 & Hp_LD <= 7000) {
        
        
        MaxPA_1_LD = (0.000156249999999999 * powf(OAT_LD, 2) )   + ( 0.25625  * OAT_LD ) + 43   ; MaxPA_2_LD = (0.000187499999999997 * powf(OAT_LD, 2) )   + ( 0.2625  * OAT_LD ) + 46.2   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 6000)  );
      
        
    }
    
    
    /*
     if (indexOAT_LD > 60) {
     indexOAT_LD = 60;
     }    
     if (indexOAT_LD < 27) {
     indexOAT_LD = 27;
     }
     */
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    float index1_LD = ACweightLBS;
    
    if (indexOAT_LD >= 23.5  & indexOAT_LD < 32) { float y1 = 23.5;   float y2 = 32;
                
        MaxPA_1_LD =  (-1.3435003631081E-09 * powf(index1_LD, 3) )  + (9.52360203340532E-06 * powf(index1_LD, 2) )   + ( -0.000958968772692988  * index1_LD ) + -11.343093681918 ;  MaxPA_2_LD =  (-7.26216412490852E-10 * powf(index1_LD, 3) )  + (7.40014524328208E-06 * powf(index1_LD, 2) )   + ( 0.00412127814088682  * index1_LD ) + -11.5638344226585;
        
        
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    
    
    if (indexOAT_LD >= 32  & indexOAT_LD < 39) { float y1 = 32;   float y2 = 39;
        
        
        MaxPA_1_LD =  (-7.26216412490852E-10 * powf(index1_LD, 3) )  + (7.40014524328208E-06 * powf(index1_LD, 2) )   + ( 0.00412127814088682  * index1_LD ) + -11.5638344226585 ;  MaxPA_2_LD =  (2.95673825085566E-09 * powf(index1_LD, 3) )  + (-1.82244008714583E-05 * powf(index1_LD, 2) )   + ( 0.0648871770930566  * index1_LD ) + -53.7758169934622;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
      
    }
    
    
    if (indexOAT_LD >= 39  & indexOAT_LD < 46) { float y1 = 39;   float y2 = 46;
        
        
        MaxPA_1_LD =  (2.95673825085566E-09 * powf(index1_LD, 3) )  + (-1.82244008714583E-05 * powf(index1_LD, 2) )   + ( 0.0648871770930566  * index1_LD ) + -53.7758169934622 ;  MaxPA_2_LD =  (1.9452225334577E-09 * powf(index1_LD, 3) )  + (-1.08932461873631E-05 * powf(index1_LD, 2) )   + ( 0.0502108621226253  * index1_LD ) + -39.9183006535938;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    
    if (indexOAT_LD >= 46  & indexOAT_LD < 54) { float y1 = 46;   float y2 = 54;
                
        MaxPA_1_LD =  (1.9452225334577E-09 * powf(index1_LD, 3) )  + (-1.08932461873631E-05 * powf(index1_LD, 2) )   + ( 0.0502108621226253  * index1_LD ) + -39.9183006535938 ;  MaxPA_2_LD =  (6.48407511152458E-10 * powf(index1_LD, 3) )  + (-3.63108206245372E-06 * powf(index1_LD, 2) )   + ( 0.0417369540408739  * index1_LD ) + -35.6394335511971;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;            
            MaxPA_1_LD = -0.867 * index1_LD + 10 ;   MaxPA_2_LD = -1.067 *index1_LD + 20 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30) {  float y1 = 20;   float y2 = 30;            
            MaxPA_1_LD = -1.067 * index1_LD + 20 ;   MaxPA_2_LD = -1.133 *index1_LD + 30 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 40) {  float y1 = 30;   float y2 = 40;            
            MaxPA_1_LD = -1.133 * index1_LD + 30 ;   MaxPA_2_LD = -1.267 *index1_LD + 40 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 40  & indexWeight_LD < 50) {  float y1 = 40;   float y2 = 50;            
            MaxPA_1_LD = -1.267 * index1_LD + 40 ;   MaxPA_2_LD = -1.4 *index1_LD + 50 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 50  & indexWeight_LD < 60) {  float y1 = 50;   float y2 = 60;            
            MaxPA_1_LD = -1.4 * index1_LD + 50 ;   MaxPA_2_LD = -1.333 *index1_LD + 60 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
                        
        }
        
        
    }else{
        //Tailwind           
        index1_LD = headWindKts * -1;  
        
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD= 2.4 * index1_LD + 0 ;   MaxPA_2_LD = 2.533 *index1_LD + 10 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD= 2.533 * index1_LD + 10 ;   MaxPA_2_LD = 3.333 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30) {  float y1 = 20;   float y2 = 30;
            MaxPA_1_LD= 3.333 * index1_LD + 20 ;   MaxPA_2_LD = 4 *index1_LD + 30 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 40) {  float y1 = 30;   float y2 = 40;
            MaxPA_1_LD= 4 * index1_LD + 30 ;   MaxPA_2_LD = 5.333 *index1_LD + 40 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 40  & indexWeight_LD < 60) {  float y1 = 40;   float y2 = 60;
            MaxPA_1_LD= 5.333 * index1_LD + 40 ;   MaxPA_2_LD = 8 *index1_LD + 60 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
    }// end head/tailwind
    
    
    float resultWithWind = (indexWind_LD * 10 ) + 300;
    resultGroundRoll = (indexWeight_LD * 10 ) + 300;  
    resultWindDifferenceGR_LD = resultWithWind - resultGroundRoll;
    
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 2000) {
        
        MaxPA_1_LD = (-3.3993498887763E-19 * powf(OAT_LD, 2) )   + ( 0.15  * OAT_LD ) + 26   ; MaxPA_2_LD = (-3.12499999999991E-05 * powf(OAT_LD, 2) )   + ( 0.15625  * OAT_LD ) + 29   ;
       indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD )  );
       
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 4000) {
        
        MaxPA_1_LD = (-3.12499999999991E-05 * powf(OAT_LD, 2) )   + ( 0.15625  * OAT_LD ) + 29   ; MaxPA_2_LD = (-3.3993498887763E-19 * powf(OAT_LD, 2) )   + ( 0.175  * OAT_LD ) + 32   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 2000)  );
        
        
    }
    
    
    
    if (Hp_LD >= 4000 & Hp_LD < 6000) {
        MaxPA_1_LD = (-3.3993498887763E-19 * powf(OAT_LD, 2) )   + ( 0.175  * OAT_LD ) + 32   ; MaxPA_2_LD = (-3.12500000000004E-05 * powf(OAT_LD, 2) )   + ( 0.17375  * OAT_LD ) + 35.5   ;
       indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 4000)  );
        
        
    }
    
    
    if (Hp_LD >= 6000 & Hp_LD <= 7000) {        
        
        MaxPA_1_LD = (-3.12500000000004E-05 * powf(OAT_LD, 2) )   + ( 0.17375  * OAT_LD ) + 35.5   ; MaxPA_2_LD = (-0.00015625 * powf(OAT_LD, 2) )   + ( 0.19375  * OAT_LD ) + 38   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 6000)  );
        
        
    }
    
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1_LD = ACweightLBS;
    
    //NSLog(@"indexOAT_LD %.2f", indexOAT_LD);
    
    if (indexOAT_LD >= 13.5  & indexOAT_LD < 23.5) { float y1 = 13.5;   float y2 = 23.5;
        MaxPA_1_LD =  (-1.34350036310816E-09 * powf(index1_LD , 3) )  + (9.52360203340568E-06 * powf(index1_LD , 2) )   + ( -0.000958968772693691  * index1_LD  ) + -21.3430936819176 ;  MaxPA_2_LD  =  (-1.3435003631081E-09 * powf(index1_LD , 3) )  + (9.52360203340532E-06 * powf(index1_LD , 2) )   + ( -0.000958968772692988  * index1_LD  ) + -11.343093681918;
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    
    
    
    if (indexOAT_LD >= 23.5  & indexOAT_LD < 28) { float y1 = 23.5;   float y2 = 28;        
        MaxPA_1_LD =  (-1.3435003631081E-09 * powf(index1_LD , 3) )  + (9.52360203340532E-06 * powf(index1_LD , 2) )   + ( -0.000958968772692988  * index1_LD  ) + -11.343093681918 ;  MaxPA_2_LD  =  (-1.62879966801523E-09 * powf(index1_LD , 3) )  + (9.45461147421857E-06 * powf(index1_LD , 2) )   + ( 0.00524343811598864  * index1_LD  ) + -17.421742919391;
        
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    
    
    if (indexOAT_LD >= 28  & indexOAT_LD < 33) { float y1 = 28;   float y2 = 33;
        MaxPA_1_LD =  (-1.62879966801523E-09 * powf(index1_LD , 3) )  + (9.45461147421857E-06 * powf(index1_LD , 2) )   + ( 0.00524343811598864  * index1_LD  ) + -17.421742919391 ;  MaxPA_2_LD  =  (1.58730158730147E-09 * powf(index1_LD , 3) )  + (-1.02222222222215E-05 * powf(index1_LD , 2) )   + ( 0.0468253968253954  * index1_LD  ) + -43.4533333333324;
        
         indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    if (indexOAT_LD >= 33  & indexOAT_LD < 38) { float y1 = 33;   float y2 = 38;
        MaxPA_1_LD =  (1.58730158730147E-09 * powf(index1_LD , 3) )  + (-1.02222222222215E-05 * powf(index1_LD , 2) )   + ( 0.0468253968253954  * index1_LD  ) + -43.4533333333324 ;  MaxPA_2_LD  =  (3.31984645710098E-10 * powf(index1_LD , 3) )  + (-2.19244734930987E-06 * powf(index1_LD , 2) )   + ( 0.0312826538022612  * index1_LD  ) + -30.0993899782132;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
      
        
    }
    
    
    
    if (indexOAT_LD >= 38  & indexOAT_LD < 43.5) { float y1 = 38;   float y2 = 43.5;
        MaxPA_1_LD =  (3.31984645710098E-10 * powf(index1_LD , 3) )  + (-2.19244734930987E-06 * powf(index1_LD , 2) )   + ( 0.0312826538022612  * index1_LD  ) + -30.0993899782132 ;  MaxPA_2_LD  =  (-2.88411660960665E-09 * powf(index1_LD , 3) )  + (1.74843863471305E-05 * powf(index1_LD , 2) )   + ( -0.00529930490714618  * index1_LD  ) + -5.76779956427139;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
       
        
    }
    
    
    /*
     if (indexWeight_LD < 0) {
     indexWeight_LD = 0;
     }
     */
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;
        
        if (indexWeight_LD >= 5  & indexWeight_LD < 10) {  float y1 = 5;   float y2 = 10;
            MaxPA_1_LD = -0.733 * index1_LD + 5 ;   MaxPA_2_LD = -0.733 *index1_LD + 10 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
            
        }
        
        
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 15) {  float y1 = 10;   float y2 = 15;
            MaxPA_1_LD = -0.733 * index1_LD + 10 ;   MaxPA_2_LD = -0.8 *index1_LD + 15 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1_LD = -0.8 * index1_LD + 15 ;   MaxPA_2_LD = -0.833 *index1_LD + 25 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
            
        }
        
        
        
        if (indexWeight_LD >= 25  & indexWeight_LD < 35) {  float y1 = 25;   float y2 = 35;
            MaxPA_1_LD = -0.833 * index1_LD + 25 ;   MaxPA_2_LD = -0.867 *index1_LD + 35 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 35  & indexWeight_LD < 50) {  float y1 = 35;   float y2 = 50;
            MaxPA_1_LD = -0.867 * index1_LD + 35 ;   MaxPA_2_LD = -1 *index1_LD + 50 ;            
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        
            
        }
        
    }else{
        //Tailwind   
        
        index1_LD = headWindKts * -1;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = 2.533 * index1_LD + 0 ;   MaxPA_2_LD = 2.667 *index1_LD + 10 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD = 2.667 * index1_LD + 10 ;   MaxPA_2_LD = 2.667 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 20) {  float y1 = 15;   float y2 = 20;
            MaxPA_1_LD = 2.667 * index1_LD + 15 ;   MaxPA_2_LD = 2.8 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30) {  float y1 = 20;   float y2 = 30;
            MaxPA_1_LD = 2.667 * index1_LD + 20 ;   MaxPA_2_LD = 2.667 *index1_LD + 30 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
            
            
        }
        
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 40) {  float y1 = 30;   float y2 = 40;
            MaxPA_1_LD = 2.667 * index1_LD + 30 ;   MaxPA_2_LD = 2.667 *index1_LD + 40 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
        
        if (indexWeight_LD >= 40  & indexWeight_LD < 50) {  float y1 = 40;   float y2 = 50;
            MaxPA_1_LD = 2.667 * index1_LD + 40 ;   MaxPA_2_LD = 3.333 *index1_LD + 50 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }

        
    }// end head/tailwind
    
    /*
     if (indexWind_LD < 0) {
     indexWind_LD = 0;
     }
     
     if (indexWind_LD > 60) {
     indexWind_LD = 60;
     }
     */
    
    resultWithWind = (indexWind_LD * 20) + 600;
    resultDistanceOverObstacle = (indexWeight_LD * 20) + 600;
    resultWindDifference50ft_LD = resultWithWind - resultDistanceOverObstacle;
    
    
    
    
    //NSLog(@"landing_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}
- (void) calculate_PA28WarriorIIIClimb {
    
    
    float climbHp = PressureAltitude;    
    float climbMaxPA_1 = 0, climbMaxPA_2 = 0;    
    float climbIndexOAT = 0;
    
    //float  calcisa = 15 - (1.98 * (sliderHp.value/1000));
    
    float climbOAT = ((15.0 - (PressureAltitude / 1000) * 1.98) + ISAdiff); 
    
    
    
    
    // climb index OAT
    
    if (climbHp >= 0 & climbHp < 1000) {
        
        
        climbMaxPA_1 = (0 * powf(climbOAT, 2) )   + ( 0  * climbOAT ) + 0   ; climbMaxPA_2 = (0.000130952380952381 * powf(climbOAT, 2) )   + ( 0.025952380952381  * climbOAT ) + 3.56696428571429   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp )  );
        
    }
    
    
    
    if (climbHp >= 1000 & climbHp < 2000) {
        
        
        climbMaxPA_1 = (0.000130952380952381 * powf(climbOAT, 2) )   + ( 0.025952380952381  * climbOAT ) + 3.56696428571429   ; climbMaxPA_2 = (0.000535714285714285 * powf(climbOAT, 2) )   + ( 0.0607142857142857  * climbOAT ) + 6.68303571428572   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 1000 )  );
        
    }
    
    
    
    if (climbHp >= 2000 & climbHp < 3000) {
        
        
        climbMaxPA_1 = (0.000535714285714285 * powf(climbOAT, 2) )   + ( 0.0607142857142857  * climbOAT ) + 6.68303571428572   ; climbMaxPA_2 = (0.000773809523809524 * powf(climbOAT, 2) )   + ( 0.0988095238095238  * climbOAT ) + 9.98660714285714   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 2000 )  );
        
    }
    
    
    if (climbHp >= 3000 & climbHp < 4000) {
        
        
        climbMaxPA_1 = (0.000773809523809524 * powf(climbOAT, 2) )   + ( 0.0988095238095238  * climbOAT ) + 9.98660714285714   ; climbMaxPA_2 = (0.000833333333333334 * powf(climbOAT, 2) )   + ( 0.133333333333333  * climbOAT ) + 13.8125   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 3000 )  );
        
    }
    
    if (climbHp >= 4000 & climbHp < 5000) {
        
        
        climbMaxPA_1 = (0.000833333333333334 * powf(climbOAT, 2) )   + ( 0.133333333333333  * climbOAT ) + 13.8125   ; climbMaxPA_2 = (0.00125 * powf(climbOAT, 2) )   + ( 0.165  * climbOAT ) + 17.64375   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 4000 )  );
        
    }
    
    if (climbHp >= 5000 & climbHp < 6000) {
        
        
        climbMaxPA_1 = (0.00125 * powf(climbOAT, 2) )   + ( 0.165  * climbOAT ) + 17.64375   ; climbMaxPA_2 = (0.00179761904761905 * powf(climbOAT, 2) )   + ( 0.192619047619048  * climbOAT ) + 21.6919642857143   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 5000 )  );
        
    }
    
    
    if (climbHp >= 6000 & climbHp < 7000) {
        
        
        climbMaxPA_1 = (0.00179761904761905 * powf(climbOAT, 2) )   + ( 0.192619047619048  * climbOAT ) + 21.6919642857143   ; climbMaxPA_2 = (0.00178571428571429 * powf(climbOAT, 2) )   + ( 0.235714285714286  * climbOAT ) + 25.7767857142857   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 6000 )  );
        
    }
    
    
    
    if (climbHp >= 7000 & climbHp < 8000) {
        
        
        climbMaxPA_1 = (0.00178571428571429 * powf(climbOAT, 2) )   + ( 0.235714285714286  * climbOAT ) + 25.7767857142857   ; climbMaxPA_2 = (0.00142857142857143 * powf(climbOAT, 2) )   + ( 0.278571428571429  * climbOAT ) + 30.0714285714286   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 7000 )  );
        
    }
    
    
    if (climbHp >= 8000 & climbHp < 9000) {
        
        
        climbMaxPA_1 = (0.00142857142857143 * powf(climbOAT, 2) )   + ( 0.278571428571429  * climbOAT ) + 30.0714285714286   ; climbMaxPA_2 = (0.00226190476190476 * powf(climbOAT, 2) )   + ( 0.311904761904762  * climbOAT ) + 34.3839285714286   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 8000 )  );
        
    }
    
    
    if (climbHp >= 9000 & climbHp < 10000) {
        
        
        climbMaxPA_1 = (0.00226190476190476 * powf(climbOAT, 2) )   + ( 0.311904761904762  * climbOAT ) + 34.3839285714286   ; climbMaxPA_2 = (0.00291666666666667 * powf(climbOAT, 2) )   + ( 0.341666666666667  * climbOAT ) + 38.71875   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 9000 )  );
        
    }
    
    
    if (climbHp >= 10000 & climbHp < 11000) {
        
        
        climbMaxPA_1 = (0.00291666666666667 * powf(climbOAT, 2) )   + ( 0.341666666666667  * climbOAT ) + 38.71875   ; climbMaxPA_2 = (0.00511904761904762 * powf(climbOAT, 2) )   + ( 0.469047619047619  * climbOAT ) + 43.5267857142857   ;
        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp -10000 )  );
        
    }
    
    if (climbHp >= 11000 & climbHp <= 12000) {
        
        
        climbMaxPA_1 = (0.00511904761904762 * powf(climbOAT, 2) )   + ( 0.469047619047619  * climbOAT ) + 43.5267857142857   ; climbMaxPA_2 = (0.00514285714285714 * powf(climbOAT, 2) )   + ( 0.514285714285714  * climbOAT ) + 48.4428571428572   ;        
        climbIndexOAT   = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 1000  * ( climbHp - 11000 )  );
        
    }
    
    
    /*
    if (climbIndexOAT > 62) {
        climbIndexOAT = 62;
    }
     */
    
    
    
    // climb time *******************************************************************************
    
    float climbMinutes = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 25) {
        climbMinutes =  (7.61904761904753E-05 * powf(climbIndexOAT, 3) )  + (0.00308571428571431 * powf(climbIndexOAT, 2) )   + ( 0.403238095238095  * climbIndexOAT ) + -3.33066907387547E-16 ;   
    }
    
    
    if (climbIndexOAT >= 25 & climbIndexOAT <= 46) {
        climbMinutes =  (0.00661354748311254 * powf(climbIndexOAT, 3) )  + (-0.637539787104986 * powf(climbIndexOAT, 2) )   + ( 21.5164255390336  *climbIndexOAT ) + -229.584950958856 ;  
    }
    
    
    // climb fuel *******************************************************************************
    
    float climbFuel = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 25) {
        climbFuel =  (5.71428571428573E-05 * powf(climbIndexOAT, 3) )  + (0.000647619047619039 * powf(climbIndexOAT, 2) )   + ( 0.0640952380952382  *climbIndexOAT ) + 1 ;         
       
    }
    if (climbIndexOAT >= 25 & climbIndexOAT <= 46) {
        
        climbFuel =  (0.00144712716885724 * powf(climbIndexOAT, 3) )  + (-0.133094898963581 * powf(climbIndexOAT, 2) )   + ( 4.24800513384673  * climbIndexOAT ) + -41.7271785073246 ; 
    }
    
    // climb distance *******************************************************************************
    
    float climbDistance = 0;
    
    if (climbIndexOAT >= 0 & climbIndexOAT < 25) {
        climbDistance =  (-0.000216049382716049 * powf(climbIndexOAT, 3) )  + (0.018179012345679 * powf(climbIndexOAT, 2) )   + ( 0.520555555555556  *climbIndexOAT ) + -2.22044604925031E-16 ; 
    }
    if (climbIndexOAT >= 25 & climbIndexOAT <= 46) {
        climbDistance =  (0.00921536796536796 * powf(climbIndexOAT, 3) )  + (-0.789383116883116 * powf(climbIndexOAT, 2) )   + ( 23.9511093073593  * climbIndexOAT ) + -228.403409090909 ;         
        
    }
    
    resultClimbTime = climbMinutes; 
    resultClimbFuel = climbFuel;
    resultClimbDistance = climbDistance;
    resultClimbSpeed = climbDistance / (climbMinutes/60); 
    resultClimbRoC = PressureAltitude / climbMinutes; // this is feet per minute
    
    //NSLog(@"-------");    
    //NSLog(@"climbHp %.1f", climbHp);
    //NSLog(@"climbOAT %.1f", climbOAT);    
    //NSLog(@"ISAdiff %.1f", ISAdiff);
    //NSLog(@"resultClimbTime %.1f", resultClimbTime);
    //NSLog(@"resultClimbFuel %.1f", resultClimbFuel);
    //NSLog(@"resultClimbDistance %.1f", resultClimbDistance);
    //NSLog(@"resultClimbSpeed %.1f", resultClimbSpeed); 
    //NSLog(@"resultClimbRoC %.1f", resultClimbRoC);
    
    
    
}
- (void) calculate_PA28WarriorIIICruise {
    
    float  OATindex =0, KTAS55 =0, KTAS65 = 0, KTAS75 = 0, fuelFlow55 = 0, fuelFlow65 = 0, fuelFlow75 = 0, RPM55 = 0, RPM65 = 0, RPM75 = 0;
    
    
    
    // set RPM / Power Slider
    resultRPMmin = 55;
    resultRPMmax = 75;
    
    OATindex = (50.0 / 10000.0) *  PressureAltitude;
    OATindex = OATindex + (sliderOATvalue /1.7);  // OAT IDEX CORRECTION !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        
    
    fuelFlow55 = 7.9, fuelFlow65 = 9.2, fuelFlow75 = 11.4;
    RPM55 = (OATindex - -516.51376146789) / 0.229357798165138 ;    
    RPM65 = (OATindex - -506.452380952381) / 0.211904761904762 ;    
    RPM75 = (OATindex - -513.934426229508) / 0.204918032786885 ;
    
    KTAS55 = (OATindex  - -466.336633663367) / 4.95049504950495 ;    
    KTAS65 = (OATindex  - -461.25) / 4.5 ;    
    KTAS75 = (OATindex  - -466.379310344828) / 4.31034482758621 ;
    
    
    RPM = engineRPMcruise;
    
    if (RPM >= 55 & RPM < 65 ) {        
        KTAS = KTAS55 + ( ((KTAS65 - KTAS55) / 10) * (RPM - 55) );        
        GPH = fuelFlow55 + ( ((fuelFlow65 - fuelFlow55) / 10) * (RPM - 55) );         
        RPM = RPM55 + ( ((RPM65 - RPM55) / 10) * (RPM - 55) );
    }    
    
    if (RPM >= 65 & RPM <= 75 ) {        
        KTAS = KTAS65 + ( ((KTAS75 - KTAS65) / 10) * (RPM - 65) );        
        GPH = fuelFlow65 + ( ((fuelFlow75 - fuelFlow65) / 10) * (RPM - 65) );        
        RPM = RPM65 + ( ((RPM75 - RPM65) / 10) * (RPM - 65) );
    }
    
    
    resultCruiseBHP =    engineRPMcruise;
    resultCruiseKTAS =  KTAS;    
    resultCruiseFuelBurn =    GPH;
    
    //NSLog(@"resultCruiseKTAS %.1f", resultCruiseKTAS);
    //NSLog(@"resultCruiseFuelBurn %.1f", resultCruiseFuelBurn);
    
    
    
}

// PA28 Warrior II **************************************************************************************************


- (void) takeoff_PA28WarriorII {
    
    
    float indexOAT = sliderOATvalue;
    float MaxPA_1 = 0, MaxPA_2 = 0;
    float index1 = 0;
    float indexWeight = 0;
    float Hp = PressureAltitude;
    float OAT = sliderOATvalue;
    float indexWind = 0;
    
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 2000) {
        
        
        MaxPA_1 = (0 * powf(OAT, 2) )   + ( 0.275  * OAT ) + 17   ; MaxPA_2 = (-0.0003125 * powf(OAT, 2) )   + ( 0.2875  * OAT ) + 24   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        
        
    }
    
    if (Hp >= 2000 & Hp < 4000) {
        
        
        MaxPA_1 = (-0.0003125 * powf(OAT, 2) )   + ( 0.2875  * OAT ) + 24   ; MaxPA_2 = (-0.000468749999999999 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 31.5   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000)  );
        
        
    }
    
    
    
    if (Hp >= 4000 & Hp < 6000) {
        
        
        MaxPA_1 = (-0.000468749999999999 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 31.5   ; MaxPA_2 = (0.000375000000000001 * powf(OAT, 2) )   + ( 0.315  * OAT ) + 38.5   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000)  );
        
        
    }
    
    
    if (Hp >= 6000 & Hp <= 9000) {
        
        
        MaxPA_1 = (0.000375000000000001 * powf(OAT, 2) )   + ( 0.315  * OAT ) + 38.5   ; MaxPA_2 = (0.000218749999999999 * powf(OAT, 2) )   + ( 0.32375  * OAT ) + 42.7   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 6000)  );
        
    }
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 19  & indexOAT < 28.7) {
        
        float y1 = 19;   float y2 = 28.7;
        
        //float percentPlus =  ( 100 / (y2 - y1) )  * ( indexOAT - y1);
        
        MaxPA_1 =  (-6.3803299097413E-09 * powf(index1, 3) )  + (4.23965141612178E-05 * powf(index1, 2) )   + ( -0.0789582944288782  * index1 ) + 51.9320261437879 ;  MaxPA_2 =  (4.97976968565172E-10 * powf(index1, 3) )  + (8.77995642701718E-07 * powf(index1, 2) )   + ( 0.00800731403672541  * index1 ) + -3.29908496732;        
        
        //indexWeight   =   MaxPA_1 + (  (MaxPA_2 - MaxPA_1) * (percentPlus/100) );
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    
    
    if (indexOAT >= 28.7  & indexOAT < 37.0) {
        
        float y1 = 28.7;   float y2 = 37.0;
        
        //float percentPlus =  ( 100 / (y2 - y1) )  * ( indexOAT - y1);
        
        
        MaxPA_1 =  (4.97976968565172E-10 * powf(index1, 3) )  + (8.77995642701718E-07 * powf(index1, 2) )   + ( 0.00800731403672541  * index1 ) + -3.29908496732 ;  MaxPA_2 =  (-2.48988484282589E-09 * powf(index1, 3) )  + (2.06100217864916E-05 * powf(index1, 2) )   + ( -0.0285365701836274  * index1 ) + 20.0954248366002;
        
        
        //indexWeight   =   MaxPA_1 + (  (MaxPA_2 - MaxPA_1) * (percentPlus/100) );
        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    
    
    if (indexOAT >= 37.0  & indexOAT < 45.0) {
        
        float y1 = 37.0;   float y2 = 45.0;
        
        
        MaxPA_1 =  (-2.48988484282589E-09 * powf(index1, 3) )  + (2.06100217864916E-05 * powf(index1, 2) )   + ( -0.0285365701836274  * index1 ) + 20.0954248366002 ;  MaxPA_2 =  (-6.71750181554057E-09 * powf(index1, 3) )  + (0.000047618010167027 * powf(index1, 2) )   + ( -0.0797948438634657  * index1 ) + 53.7845315904103;        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    
    
    if (indexOAT >= 45.0  & indexOAT <= 53.0) {
        
        float y1 = 45.0;    float y2 =  53.0;
        
        
        MaxPA_1 =  (-6.71750181554057E-09 * powf(index1, 3) )  + (0.000047618010167027 * powf(index1, 2) )   + ( -0.0797948438634657  * index1 ) + 53.7845315904103 ;  MaxPA_2 =  (-7.87944807552597E-09 * powf(index1, 3) )  + (5.94582425562785E-05 * powf(index1, 2) )   + ( -0.108200798838047  * index1 ) + 77.4823965141569;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    
    
    
    if (indexWeight <= 10) {
        indexWeight = 10;
    }
    
    
    
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= 8  & indexWeight < 12.0) {
            
            float y1 = 8;   float y2 = 12.0;
            
            
            MaxPA_1= -0.2 * index1 + 8 ;   MaxPA_2 = -0.2 *index1 + 12 ;       
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 12.0  & indexWeight < 20.0) {
            
            float y1 = 12.0;   float y2 = 20.0;
            
            
            MaxPA_1= -0.2 * index1 + 12 ;   MaxPA_2 = -0.3 *index1 + 20 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 20.0  & indexWeight < 28.0) {
            
            float y1 = 20.0;   float y2 = 28.0;
            
            MaxPA_1= -0.3 * index1 + 20 ;   MaxPA_2 = -0.4 *index1 + 28 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        
        
        if (indexWeight >= 28.0  & indexWeight < 36.0) {
            
            float y1 = 28.0;    float y2 =  36.0;
            
            MaxPA_1= -0.4 * index1 + 28 ;   MaxPA_2 = -0.5 *index1 + 36 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        if (indexWeight >= 36.0  & indexWeight < 48.0) {
            
            float y1 = 36.0;    float y2 =  48.0;
            
            MaxPA_1= -0.5 * index1 + 36 ;   MaxPA_2 = -0.6 *index1 + 48 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= 8  & indexWeight < 12.0) {
            
            float y1 = 8;   float y2 = 12.0;            
            MaxPA_1= 0.733 * index1 + 8 ;   MaxPA_2 = 0.8 *index1 + 12 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
        }
        
        
        
        if (indexWeight >= 12.0  & indexWeight < 20.0) {
            
            float y1 = 12.0;   float y2 = 20.0;
            
            MaxPA_1= 0.8 * index1 + 12 ;   MaxPA_2 = 1.267 *index1 + 20 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        if (indexWeight >= 20.0  & indexWeight < 28.0) {
            
            float y1 = 20.0;   float y2 = 28.0;
            
            MaxPA_1= 1.267 * index1 + 20 ;   MaxPA_2 = 1.333 *index1 + 28 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        if (indexWeight >= 28.0  & indexWeight < 36.0) {
            
            float y1 = 28.0;    float y2 =  36.0;
            
            MaxPA_1= 1.333 * index1 + 28 ;   MaxPA_2 = 1.6 *index1 + 36 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        if (indexWeight >= 36.0  & indexWeight < 48.0) {
            
            float y1 = 36.0;    float y2 =  48.0;
            
            MaxPA_1= 1.6 * index1 + 36 ;   MaxPA_2 = 2.467 *index1 + 48 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
    }// end head/tailwind
    
    //NSLog(@"2 indexWind %.2f", indexWind);
    
    /*
     if (indexWind < 0) {
     indexWind = 0;
     }
     
     if (indexWind > 70) {
     indexWind = 70;
     }
     */
    
    
    float resultWithWind = (2500/50) * indexWind;
    resultGroundRoll = (2500/50) * indexWeight;   
    resultWindDifferenceGR_TO = resultWithWind - resultGroundRoll;
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp >= -1500 & Hp < 2000) {
        
        MaxPA_1 = (0.0003125 * powf(OAT, 2) )   + ( 0.2375  * OAT ) + 13   ; MaxPA_2 = (0.00025 * powf(OAT, 2) )   + ( 0.2475  * OAT ) + 18   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp )  );
        
        
    }
    
    if (Hp >= 2000 & Hp < 4000) {
        
        
        MaxPA_1 = (0.00025 * powf(OAT, 2) )   + ( 0.2475  * OAT ) + 18   ; MaxPA_2 = (0.000343750000000002 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 23.4   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 2000)  );
        
        
    }
    
    
    
    if (Hp >= 4000 & Hp < 6000) {
        
        
        MaxPA_1 = (0.000343750000000002 * powf(OAT, 2) )   + ( 0.28125  * OAT ) + 23.4   ; MaxPA_2 = (0.0003125 * powf(OAT, 2) )   + ( 0.3375  * OAT ) + 30.5   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 2000  * ( Hp - 4000)  );
        
    }
    
    
    if (Hp >= 6000 & Hp <= 9000) {
        
        
        MaxPA_1 = (0.0003125 * powf(OAT, 2) )   + ( 0.3375  * OAT ) + 30.5   ; MaxPA_2 = (0.0003125 * powf(OAT, 2) )   + ( 0.3375  * OAT ) + 34   ;
        
        indexOAT   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / 1000  * ( Hp - 6000)  );
        
        
    }
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1 = ACweightLBS;
    
    if (indexOAT >= 4.8  & indexOAT < 14.8) {        
        float y1 = 4.8;   float y2 = 14.8;
        
        
        
        MaxPA_1 =  (3.19535221495993E-09 * powf(index1, 3) )  + (-1.58939724037755E-05 * powf(index1, 2) )   + ( 0.0361997095134334  * index1 ) + -35.319128540304 ;  MaxPA_2 =  (3.19535221495993E-09 * powf(index1, 3) )  + (-1.58939724037755E-05 * powf(index1, 2) )   + ( 0.0361997095134334  * index1 ) + -25.319128540304;
        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    if (indexOAT >= 14.8  & indexOAT < 22.0) {
        
        float y1 = 14.8;   float y2 = 22.0;
        MaxPA_1 =  (3.19535221495993E-09 * powf(index1, 3) )  + (-1.58939724037755E-05 * powf(index1, 2) )   + ( 0.0361997095134334  * index1 ) + -25.319128540304 ;  MaxPA_2 =  (-1.37462392364339E-09 * powf(index1, 3) )  + (1.10312273057363E-05 * powf(index1, 2) )   + ( -0.0126156758999879  * index1 ) + 7.07559912853922;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    
    
    if (indexOAT >= 22.0  & indexOAT < 27.8) {        
        float y1 = 22.0;   float y2 = 27.8;
        MaxPA_1 =  (-1.37462392364339E-09 * powf(index1, 3) )  + (1.10312273057363E-05 * powf(index1, 2) )   + ( -0.0126156758999879  * index1 ) + 7.07559912853922 ;  MaxPA_2 =  (5.47255939412774E-09 * powf(index1, 3) )  + (-2.89796659404485E-05 * powf(index1, 2) )   + ( 0.0676932254383201  * index1 ) + -44.336819172111;
        
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
    }
    
    
    
    if (indexOAT >= 27.8  & indexOAT < 33.2) {        
        float y1 = 27.8;   float y2 = 33.2;
        
        MaxPA_1 =  (5.47255939412774E-09 * powf(index1, 3) )  + (-2.89796659404485E-05 * powf(index1, 2) )   + ( 0.0676932254383201  * index1 ) + -44.336819172111 ;  MaxPA_2 =  (2.4691358024691E-09 * powf(index1, 3) )  + (-8.49382716049361E-06 * powf(index1, 2) )   + ( 0.0253209876543205  * index1 ) + -13.8829629629627;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    if (indexOAT >= 33.2  & indexOAT <= 39.0) {        
        float y1 = 33.2;    float y2 =  39.0;        
        
        MaxPA_1 =  (2.4691358024691E-09 * powf(index1, 3) )  + (-8.49382716049361E-06 * powf(index1, 2) )   + ( 0.0253209876543205  * index1 ) + -13.8829629629627 ;  MaxPA_2 =  (7.23622782446283E-09 * powf(index1, 3) )  + (-0.000033856209150325 * powf(index1, 2) )   + ( 0.0725177404295016  * index1 ) + -41.4960784313702;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
        
    }
    
    if (indexOAT >= 39.0  & indexOAT <= 43.0) {
        
        float y1 = 39.0;    float y2 =  43.0;
        
        MaxPA_1 =  (7.23622782446283E-09 * powf(index1, 3) )  + (-0.000033856209150325 * powf(index1, 2) )   + ( 0.0725177404295016  * index1 ) + -41.4960784313702 ;  MaxPA_2 =  (7.23622782446283E-09 * powf(index1, 3) )  + (-0.000033856209150325 * powf(index1, 2) )   + ( 0.0725177404295016  * index1 ) + -37.4960784313702;
        
        indexWeight   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexOAT - y1 )  );
        
    }
    
    
    
    if (indexWeight <= 7) {
        indexWeight = 7;
    }
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1 = headWindKts;
        
        if (indexWeight >= -2  & indexWeight < 10) {   float y1 =-2;     float y2 = 10;
            MaxPA_1= -0.2 * index1 + -2 ;   MaxPA_2 = -0.167 *index1 + 10 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 10.0  & indexWeight < 20.0) {
            
            float y1 = 10.0;   float y2 = 20.0;
            
            
            MaxPA_1= -0.167 * index1 + 10 ;   MaxPA_2 = -0.233 *index1 + 20 ; ;
            
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        } 
        
        
        
        if (indexWeight >= 20.0  & indexWeight < 30.0) {
            
            float y1 = 20.0;   float y2 = 30.0;
            
            
            MaxPA_1= -0.233 * index1 + 20 ;   MaxPA_2 = -0.4 *index1 + 30 ;
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 30.0  & indexWeight <= 40.0) {
            
            float y1 = 28.0;    float y2 =  36.0;
            
            MaxPA_1= -0.4 * index1 + 30 ;   MaxPA_2 = -0.467 *index1 + 40 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
    }else{
        //Tailwind   
        
        index1 = headWindKts * -1;
        
        if (indexWeight >= 5  & indexWeight < 10.0) {
            
            float y1 = 5;   float y2 = 10.0;
            
            MaxPA_1= 0.4 * index1 + 5 ;   MaxPA_2 = 0.467 *index1 + 10 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        
        
        if (indexWeight >= 10.0  & indexWeight < 15.0) {
            
            float y1 = 10.0;   float y2 = 15.0;
            
            MaxPA_1= 0.467 * index1 + 10 ;   MaxPA_2 = 0.533 *index1 + 15 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
        }
        
        if (indexWeight >= 15.0  & indexWeight < 20.0) {
            
            float y1 = 15.0;   float y2 = 20.0;
            
            MaxPA_1= 0.533 * index1 + 15 ;   MaxPA_2 = 0.8 *index1 + 20 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        if (indexWeight >= 20.0  & indexWeight < 30.0) {
            
            float y1 = 20.0;    float y2 =  30.0;                        
            MaxPA_1= 0.8 * index1 + 20 ;   MaxPA_2 = 1.333 *index1 + 30 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
        if (indexWeight >= 30.0  & indexWeight < 48.0) {
            
            float y1 = 30.0;    float y2 =  48.0;
            
            MaxPA_1= 1.333 * index1 + 30 ;   MaxPA_2 = 2.467 *index1 + 48 ; 
            
            indexWind   = MaxPA_1 +   (  (MaxPA_2 - MaxPA_1) / (y2 - y1)  * ( indexWeight - y1 )  );
            
            
        }
        
    }// end head/tailwind
    
    //NSLog(@"indexWind %.2f", indexWind);
    /*
     if (indexWind < 0) {
     indexWind = 0;
     }
     
     if (indexWind > 70) {
     indexWind = 70;
     }
     
     */
    
    
    
    
    resultWithWind = (4000/40) * indexWind;
    resultDistanceOverObstacle = (4000/40) * indexWeight;
    resultWindDifference50ft_TO = resultWithWind - resultDistanceOverObstacle;
    
    
    
    
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultGroundRoll %.0f", resultGroundRoll);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}
- (void) landing_PA28WarriorII {
    
    float Hp_LD = PressureAltitude;
    float MaxPA_1_LD = 0, MaxPA_2_LD = 0;
    float indexOAT_LD = 0;
    float OAT_LD = sliderOATvalue;
    float indexWeight_LD = 0;
    float indexWind_LD = 0;
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 2000) {
        
        MaxPA_1_LD = (0.000125 * powf(OAT_LD, 2) )   + ( 0.2  * OAT_LD ) + 29.3   ; MaxPA_2_LD = (0.00021875 * powf(OAT_LD, 2) )   + ( 0.21625  * OAT_LD ) + 33.5   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD )  );
        
        
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 4000) {        
        
        MaxPA_1_LD = (0.00021875 * powf(OAT_LD, 2) )   + ( 0.21625  * OAT_LD ) + 33.5   ; MaxPA_2_LD = (0.000281249999999997 * powf(OAT_LD, 2) )   + ( 0.24125  * OAT_LD ) + 38.2   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 2000)  );
        
    }
    
    
    
    if (Hp_LD >= 4000 & Hp_LD < 6000) {
        
        MaxPA_1_LD = (0.000281249999999997 * powf(OAT_LD, 2) )   + ( 0.24125  * OAT_LD ) + 38.2   ; MaxPA_2_LD = (0.000156249999999999 * powf(OAT_LD, 2) )   + ( 0.25625  * OAT_LD ) + 43   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 4000)  );
        
        
    }
    
    
    if (Hp_LD >= 6000 & Hp_LD <= 7000) {
        
        MaxPA_1_LD = (0.000156249999999999 * powf(OAT_LD, 2) )   + ( 0.25625  * OAT_LD ) + 43   ; MaxPA_2_LD = (0.000187499999999997 * powf(OAT_LD, 2) )   + ( 0.2625  * OAT_LD ) + 46.2   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 6000)  );
        
        
    }
    
    
    /*
     if (indexOAT_LD > 60) {
     indexOAT_LD = 60;
     }    
     if (indexOAT_LD < 27) {
     indexOAT_LD = 27;
     }
     */
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    float index1_LD = ACweightLBS;
    
    if (indexOAT_LD >= 23.5  & indexOAT_LD < 32) { float y1 = 23.5;   float y2 = 32;
        
        
        MaxPA_1_LD =  (-1.3435003631081E-09 * powf(index1_LD, 3) )  + (9.52360203340532E-06 * powf(index1_LD, 2) )   + ( -0.000958968772692988  * index1_LD ) + -11.343093681918 ;  MaxPA_2_LD =  (-7.26216412490852E-10 * powf(index1_LD, 3) )  + (7.40014524328208E-06 * powf(index1_LD, 2) )   + ( 0.00412127814088682  * index1_LD ) + -11.5638344226585;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    
    
    if (indexOAT_LD >= 32  & indexOAT_LD < 39) { float y1 = 32;   float y2 = 39;
        
        MaxPA_1_LD =  (-7.26216412490852E-10 * powf(index1_LD, 3) )  + (7.40014524328208E-06 * powf(index1_LD, 2) )   + ( 0.00412127814088682  * index1_LD ) + -11.5638344226585 ;  MaxPA_2_LD =  (2.95673825085566E-09 * powf(index1_LD, 3) )  + (-1.82244008714583E-05 * powf(index1_LD, 2) )   + ( 0.0648871770930566  * index1_LD ) + -53.7758169934622;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    if (indexOAT_LD >= 39  & indexOAT_LD < 46) { float y1 = 39;   float y2 = 46;
        
        MaxPA_1_LD =  (2.95673825085566E-09 * powf(index1_LD, 3) )  + (-1.82244008714583E-05 * powf(index1_LD, 2) )   + ( 0.0648871770930566  * index1_LD ) + -53.7758169934622 ;  MaxPA_2_LD =  (1.9452225334577E-09 * powf(index1_LD, 3) )  + (-1.08932461873631E-05 * powf(index1_LD, 2) )   + ( 0.0502108621226253  * index1_LD ) + -39.9183006535938;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    
    if (indexOAT_LD >= 46  & indexOAT_LD < 54) { float y1 = 46;   float y2 = 54;
        
        MaxPA_1_LD =  (1.9452225334577E-09 * powf(index1_LD, 3) )  + (-1.08932461873631E-05 * powf(index1_LD, 2) )   + ( 0.0502108621226253  * index1_LD ) + -39.9183006535938 ;  MaxPA_2_LD =  (6.48407511152458E-10 * powf(index1_LD, 3) )  + (-3.63108206245372E-06 * powf(index1_LD, 2) )   + ( 0.0417369540408739  * index1_LD ) + -35.6394335511971;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    /*
     if (indexWeight_LD < 7) {
     indexWeight_LD = 7;
     }
     */
    
    //NSLog(@"index1_LD %.2f", index1_LD);
    //NSLog(@"indexWeight_LD %.2f", indexWeight_LD);
    
    //NSLog(@"1 indexWeight %.1f", indexWeight);    
    //NSLog(@"2 headWindKts %.0f", headWindKts);
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;            
            MaxPA_1_LD = -0.867 * index1_LD + 10 ;   MaxPA_2_LD = -1.067 *index1_LD + 20 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30) {  float y1 = 20;   float y2 = 30;            
            MaxPA_1_LD = -1.067 * index1_LD + 20 ;   MaxPA_2_LD = -1.133 *index1_LD + 30 ;  
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 40) {  float y1 = 30;   float y2 = 40;            
            MaxPA_1_LD = -1.133 * index1_LD + 30 ;   MaxPA_2_LD = -1.267 *index1_LD + 40 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 40  & indexWeight_LD < 50) {  float y1 = 40;   float y2 = 50;            
            MaxPA_1_LD = -1.267 * index1_LD + 40 ;   MaxPA_2_LD = -1.4 *index1_LD + 50 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        if (indexWeight_LD >= 50  & indexWeight_LD < 60) {  float y1 = 50;   float y2 = 60;            
            MaxPA_1_LD = -1.4 * index1_LD + 50 ;   MaxPA_2_LD = -1.333 *index1_LD + 60 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
        }
        
        
    }else{
        //Tailwind           
        index1_LD = headWindKts * -1;  
        
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD= 2.4 * index1_LD + 0 ;   MaxPA_2_LD = 2.533 *index1_LD + 10 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );            
            
        }
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD= 2.533 * index1_LD + 10 ;   MaxPA_2_LD = 3.333 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30) {  float y1 = 20;   float y2 = 30;
            MaxPA_1_LD= 3.333 * index1_LD + 20 ;   MaxPA_2_LD = 4 *index1_LD + 30 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
            
        }
        
        
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 40) {  float y1 = 30;   float y2 = 40;
            MaxPA_1_LD= 4 * index1_LD + 30 ;   MaxPA_2_LD = 5.333 *index1_LD + 40 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
            
        }
        
        
        if (indexWeight_LD >= 40  & indexWeight_LD < 60) {  float y1 = 40;   float y2 = 60;
            MaxPA_1_LD= 5.333 * index1_LD + 40 ;   MaxPA_2_LD = 8 *index1_LD + 60 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
    }// end head/tailwind
    
    
    /*
     if (indexWind_LD < 0) {
     indexWind_LD = 0;
     }
     
     if (indexWind_LD > 60) {
     indexWind_LD = 60;
     }
     */
    
    float resultWithWind = (indexWind_LD * 10 ) + 300;
    resultGroundRoll = (indexWeight_LD * 10 ) + 300; 
    resultWindDifferenceGR_LD = resultWithWind - resultGroundRoll;
    
    
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // ******************************************************************************************************************
    // compute Takeoff Distance over Obstacle
    
    
    // calcIndexOAT_25 *****************
    
    if (Hp_LD >= -1500 & Hp_LD < 2000) {
        
        MaxPA_1_LD = (-3.3993498887763E-19 * powf(OAT_LD, 2) )   + ( 0.15  * OAT_LD ) + 26   ; MaxPA_2_LD = (-3.12499999999991E-05 * powf(OAT_LD, 2) )   + ( 0.15625  * OAT_LD ) + 29   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD )  );
        
        
    }
    
    if (Hp_LD >= 2000 & Hp_LD < 4000) {
        
        MaxPA_1_LD = (-3.12499999999991E-05 * powf(OAT_LD, 2) )   + ( 0.15625  * OAT_LD ) + 29   ; MaxPA_2_LD = (-3.3993498887763E-19 * powf(OAT_LD, 2) )   + ( 0.175  * OAT_LD ) + 32   ;        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 2000)  );
        
    }
    
    
    
    if (Hp_LD >= 4000 & Hp_LD < 6000) {       
        
        MaxPA_1_LD = (-3.3993498887763E-19 * powf(OAT_LD, 2) )   + ( 0.175  * OAT_LD ) + 32   ; MaxPA_2_LD = (-3.12500000000004E-05 * powf(OAT_LD, 2) )   + ( 0.17375  * OAT_LD ) + 35.5   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 2000  * ( Hp_LD - 4000)  );
        
    }
    
    if (Hp_LD >= 6000 & Hp_LD <= 7000) {        
        
        MaxPA_1_LD = (-3.12500000000004E-05 * powf(OAT_LD, 2) )   + ( 0.17375  * OAT_LD ) + 35.5   ; MaxPA_2_LD = (-0.00015625 * powf(OAT_LD, 2) )   + ( 0.19375  * OAT_LD ) + 38   ;
        
        indexOAT_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / 1000  * ( Hp_LD - 6000)  );
        
        
    }
    
    
    
    // *************************************************************************************************************************************
    // now calc  weight index
    
    index1_LD = ACweightLBS;
    
    //NSLog(@"indexOAT_LD %.2f", indexOAT_LD);
    
    if (indexOAT_LD >= 13.5  & indexOAT_LD < 23.5) { float y1 = 13.5;   float y2 = 23.5;
        MaxPA_1_LD =  (-1.34350036310816E-09 * powf(index1_LD , 3) )  + (9.52360203340568E-06 * powf(index1_LD , 2) )   + ( -0.000958968772693691  * index1_LD  ) + -21.3430936819176 ;  MaxPA_2_LD  =  (-1.3435003631081E-09 * powf(index1_LD , 3) )  + (9.52360203340532E-06 * powf(index1_LD , 2) )   + ( -0.000958968772692988  * index1_LD  ) + -11.343093681918;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    if (indexOAT_LD >= 23.5  & indexOAT_LD < 28) { float y1 = 23.5;   float y2 = 28;
        
        MaxPA_1_LD =  (-1.3435003631081E-09 * powf(index1_LD , 3) )  + (9.52360203340532E-06 * powf(index1_LD , 2) )   + ( -0.000958968772692988  * index1_LD  ) + -11.343093681918 ;  MaxPA_2_LD  =  (-1.62879966801523E-09 * powf(index1_LD , 3) )  + (9.45461147421857E-06 * powf(index1_LD , 2) )   + ( 0.00524343811598864  * index1_LD  ) + -17.421742919391;
        
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
    }
    
    
    
    if (indexOAT_LD >= 28  & indexOAT_LD < 33) { float y1 = 28;   float y2 = 33;
        MaxPA_1_LD =  (-1.62879966801523E-09 * powf(index1_LD , 3) )  + (9.45461147421857E-06 * powf(index1_LD , 2) )   + ( 0.00524343811598864  * index1_LD  ) + -17.421742919391 ;  MaxPA_2_LD  =  (1.58730158730147E-09 * powf(index1_LD , 3) )  + (-1.02222222222215E-05 * powf(index1_LD , 2) )   + ( 0.0468253968253954  * index1_LD  ) + -43.4533333333324;
        
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    
    if (indexOAT_LD >= 33  & indexOAT_LD < 38) { float y1 = 33;   float y2 = 38;
        MaxPA_1_LD =  (1.58730158730147E-09 * powf(index1_LD , 3) )  + (-1.02222222222215E-05 * powf(index1_LD , 2) )   + ( 0.0468253968253954  * index1_LD  ) + -43.4533333333324 ;  MaxPA_2_LD  =  (3.31984645710098E-10 * powf(index1_LD , 3) )  + (-2.19244734930987E-06 * powf(index1_LD , 2) )   + ( 0.0312826538022612  * index1_LD  ) + -30.0993899782132;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    
    
    if (indexOAT_LD >= 38  & indexOAT_LD < 43.5) { float y1 = 38;   float y2 = 43.5;
        MaxPA_1_LD =  (3.31984645710098E-10 * powf(index1_LD , 3) )  + (-2.19244734930987E-06 * powf(index1_LD , 2) )   + ( 0.0312826538022612  * index1_LD  ) + -30.0993899782132 ;  MaxPA_2_LD  =  (-2.88411660960665E-09 * powf(index1_LD , 3) )  + (1.74843863471305E-05 * powf(index1_LD , 2) )   + ( -0.00529930490714618  * index1_LD  ) + -5.76779956427139;
        
        indexWeight_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexOAT_LD - y1 )  );
        
        
    }
    
    /*
     if (indexWeight_LD < 0) {
     indexWeight_LD = 0;
     }
     */
    
    
    
    // now calc wind
    
    if (headWindKts >= 0) {
        
        // headwind        
        index1_LD = headWindKts;
        
        if (indexWeight_LD >= 5  & indexWeight_LD < 10) {  float y1 = 5;   float y2 = 10;
            MaxPA_1_LD = -0.733 * index1_LD + 5 ;   MaxPA_2_LD = -0.733 *index1_LD + 10 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        if (indexWeight_LD >= 10  & indexWeight_LD < 15) {  float y1 = 10;   float y2 = 15;
            MaxPA_1_LD = -0.733 * index1_LD + 10 ;   MaxPA_2_LD = -0.8 *index1_LD + 15 ;
            
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 25) {  float y1 = 15;   float y2 = 25;
            MaxPA_1_LD = -0.8 * index1_LD + 15 ;   MaxPA_2_LD = -0.833 *index1_LD + 25 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 25  & indexWeight_LD < 35) {  float y1 = 25;   float y2 = 35;
            MaxPA_1_LD = -0.833 * index1_LD + 25 ;   MaxPA_2_LD = -0.867 *index1_LD + 35 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 35  & indexWeight_LD < 50) {  float y1 = 35;   float y2 = 50;
            MaxPA_1_LD = -0.867 * index1_LD + 35 ;   MaxPA_2_LD = -1 *index1_LD + 50 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
    }else{
        //Tailwind   
        
        index1_LD = headWindKts * -1;
        
        if (indexWeight_LD >= 0  & indexWeight_LD < 10) {  float y1 = 0;   float y2 = 10;
            MaxPA_1_LD = 2.533 * index1_LD + 0 ;   MaxPA_2_LD = 2.667 *index1_LD + 10 ;            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 10  & indexWeight_LD < 20) {  float y1 = 10;   float y2 = 20;
            MaxPA_1_LD = 2.667 * index1_LD + 10 ;   MaxPA_2_LD = 2.667 *index1_LD + 20 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 15  & indexWeight_LD < 20) {  float y1 = 15;   float y2 = 20;
            MaxPA_1_LD = 2.667 * index1_LD + 15 ;   MaxPA_2_LD = 2.8 *index1_LD + 20 ;
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        
        if (indexWeight_LD >= 20  & indexWeight_LD < 30) {  float y1 = 20;   float y2 = 30;
            MaxPA_1_LD = 2.667 * index1_LD + 20 ;   MaxPA_2_LD = 2.667 *index1_LD + 30 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
        if (indexWeight_LD >= 30  & indexWeight_LD < 40) {  float y1 = 30;   float y2 = 40;
            MaxPA_1_LD = 2.667 * index1_LD + 30 ;   MaxPA_2_LD = 2.667 *index1_LD + 40 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
            
        }
        
        
        
        if (indexWeight_LD >= 40  & indexWeight_LD < 50) {  float y1 = 40;   float y2 = 50;
            MaxPA_1_LD = 2.667 * index1_LD + 40 ;   MaxPA_2_LD = 3.333 *index1_LD + 50 ;
            
            indexWind_LD   = MaxPA_1_LD +   (  (MaxPA_2_LD - MaxPA_1_LD) / (y2 - y1)  * ( indexWeight_LD - y1 )  );
            
        }
        
        
    }// end head/tailwind
    
    /*
     if (indexWind_LD < 0) {
     indexWind_LD = 0;
     }
     
     if (indexWind_LD > 60) {
     indexWind_LD = 60;
     }
     */
    
    resultWithWind = (indexWind_LD * 20) + 600;
    resultDistanceOverObstacle = (indexWeight_LD * 20) + 600;
    resultWindDifference50ft_LD = resultWithWind - resultDistanceOverObstacle;
    
    
    //NSLog(@"landing_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    //NSLog(@"takeoff_PA28ArcherIIFlaps25 resultDistanceOverObstacle %.0f", resultDistanceOverObstacle);
    
    
}


- (void) cruiseDA40180 {
    
    float climbMaxPA_1 = 0, climbMaxPA_2 = 0;
    
    int   PressAltforDensity = PressureAltitude;    
    float TKelvin = 273.15 + sliderOATvalue;    
    float TSuper = 273.15 + ( 15 - ( 0.0019812 * PressAltforDensity) );    
    float densityaltCruise = PressAltforDensity + (TSuper / 0.0019812) * ( 1- ( powf (TSuper / TKelvin, .2349690) ) ) ;    
    float HpCr = densityaltCruise;
    
    if (HpCr < 0) {
        HpCr =0;
    }    
    if (HpCr > 14000) {
        HpCr = 14000;
    }
    
    
    resultRPMmin = 45;
    resultRPMmax = 85;
    
    
    float Load = engineRPMcruise;
    float resultTAS = 0;
    
    if (Load >= 45 & Load < 55 & HpCr >  8000 ) {
        climbMaxPA_1 = (-1.81547619047619E-07 * powf(HpCr, 2) )   + ( 0.00411071428571428  * HpCr ) + 86.2333333333334   ; climbMaxPA_2 = (-1.77827380952381E-07 * powf(HpCr, 2) )   + ( 0.00394553571428571  * HpCr ) + 100.116666666667   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 45 )  );
         }
    
    if (Load >= 45 & Load < 55 & HpCr <=  8000 ) {
        climbMaxPA_1 = (7.54248020136969E-23 * powf(HpCr, 2) )   + ( 0.001125  * HpCr) + 98.5   ; climbMaxPA_2 = (-2.49999999999997E-08 * powf(HpCr, 2) )   + ( 0.001425  * HpCr ) + 110.5   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 45 )  );
        }
    if (Load >= 55 & Load < 65 & HpCr >  8000 ) {
        climbMaxPA_1 = (-1.77827380952381E-07 * powf(HpCr, 2) )   + ( 0.00394553571428571  * HpCr ) + 100.116666666667   ; climbMaxPA_2 = (-3.12500000000001E-07 * powf(HpCr, 2) )   + ( 0.00512500000000001  * HpCr ) + 110   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 55 )  );
        }
    if (Load >= 55 & Load < 65 & HpCr <=  8000 ) {
        climbMaxPA_1 = (-2.49999999999997E-08 * powf(HpCr, 2) )   + ( 0.001425  * HpCr) + 110.5   ; climbMaxPA_2 = (-6.24999999999998E-08 * powf(HpCr, 2) )   + ( 0.001875  * HpCr ) + 120   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 55 )  );
         }
    if (Load >= 65 & Load < 75 & HpCr >  8000 ) {
        climbMaxPA_1 = (-3.12500000000001E-07 * powf(HpCr, 2) )   + ( 0.00512500000000001  * HpCr ) + 110   ; climbMaxPA_2 = (-0.000000109375 * powf(HpCr, 2) )   + ( 0.000125  * HpCr ) + 140.1875   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 65 )  );
         }
    if (Load >= 65 & Load < 75 & HpCr <=  8000 ) {
        climbMaxPA_1 = (-6.24999999999998E-08 * powf(HpCr, 2) )   + ( 0.001875  * HpCr) + 120   ; climbMaxPA_2 = (-1.75000000000001E-07 * powf(HpCr, 2) )   + ( 0.00255  * HpCr ) + 128   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 65 )  );
         }
    if (Load >= 75 & Load < 85 & HpCr >  6000 ) {
        climbMaxPA_1 = (-0.000000109375 * powf(HpCr, 2) )   + ( 0.000125  * HpCr ) + 140.1875   ; climbMaxPA_2 = (-1.02608695652174E-07 * powf(HpCr, 2) )   + ( -3.73913043478285E-05  * HpCr ) + 141.134782608696   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 75 )  );
         }
    if (Load >= 75 & Load < 85 & HpCr <=  6000 ) {
        climbMaxPA_1 = (-1.75000000000001E-07 * powf(HpCr, 2) )   + ( 0.00255  * HpCr) + 128   ; climbMaxPA_2 = (-3.59999999999998E-07 * powf(HpCr, 2) )   + ( 0.00286  * HpCr ) + 135.5   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 10  * ( Load - 75 )  );
         }
    if (Load >= 85 & Load < 90 & HpCr >  2500 ) {
        climbMaxPA_1 = (-1.02608695652174E-07 * powf(HpCr, 2) )   + ( -3.73913043478285E-05  * HpCr ) + 141.134782608696   ; climbMaxPA_2 = (-1.02095170454545E-07 * powf(HpCr, 2) )   + ( -4.97159090909086E-05  * HpCr ) + 141.206676136364   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 5  * ( Load - 85 )  );
        }
    if (Load >= 85 & Load < 90 & HpCr <=  2500 ) {
        climbMaxPA_1 = (-3.59999999999998E-07 * powf(HpCr, 2) )   + ( 0.00286  * HpCr) + 135.5   ; climbMaxPA_2 = (-1.04166666666667E-06 * powf(HpCr, 2) )   + ( 0.00208333333333333  * HpCr ) + 140   ;
        resultTAS  = climbMaxPA_1 +   (  (climbMaxPA_2 - climbMaxPA_1) / 5  * ( Load - 85 )  );
        }
    
    if (resultTAS < 100) {
        resultTAS = 100;
    }
    float boundary = (-9.55357142857142E-08 * powf(HpCr, 2) )   + ( -0.000148214285714288  * HpCr) + 141.3 ;    
    if (resultTAS > boundary) {
        resultTAS = boundary;
    }
    
    resultCruiseKTAS =resultTAS;
    //NSLog(@"resultCruiseKTAS %.0f", resultCruiseKTAS);
    
    //calcFuelFlow
    
   
    float powerValue = engineRPMcruise;
    float flow1 = 0, flow2 = 0, resultFlow = 0; 
    if (powerValue >= 45 & powerValue < 55  ) {        
        flow1 = 7.7   ;  flow2 = 8.7 ;        
        resultFlow  = flow1 +   (  (flow2 - flow1) / 10  * ( powerValue - 45 )  );        
    }
    if (powerValue >= 55 & powerValue < 65  ) {        
        flow1 = 8.7   ;  flow2 = 9.8 ;        
        resultFlow  = flow1 +   (  (flow2 - flow1) / 10  * ( powerValue - 55 )  );
    }    
    
    if (powerValue >= 65 & powerValue <= 75  ) {        
        flow1 = 9.8  ;  flow2 = 11 ;        
        resultFlow  = flow1 +   (  (flow2 - flow1) / 10  * ( powerValue - 65 )  );
    }
    
    if (powerValue >= 75   ) {
        resultFlow  = 11; 
    }
    
    resultCruiseFuelBurn = resultFlow;
    //NSLog(@"computed resultCruiseFuelBurn in Gallons! %.1f", resultCruiseFuelBurn);
    
    
}
- (void) calculate_PA28WarriorIICruise {
    
    float  OATindex =0, KTAS55 =0, KTAS65 = 0, KTAS75 = 0, fuelFlow55 = 0, fuelFlow65 = 0, fuelFlow75 = 0, RPM55 = 0, RPM65 = 0, RPM75 = 0;
    
    float HpC = PressureAltitude;
    
    float cruiseMaxPa_1 = 0, cruiseMaxPa_2 = 0;
    
    float indexOATcruise =0;
    float OATC = sliderOATvalue;
    
    if (HpC >= 0 & HpC < 1000 ) {
        cruiseMaxPa_1 = (-0.000750000000000001 * powf(OATC, 2) )   + ( 0.6175  * OATC ) + -9.1   ; cruiseMaxPa_2 = (-0.000812500000000003 * powf(OATC, 2) )   + ( 0.615  * OATC ) + -2.9   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 1000  * ( HpC - 0 )  );
        
    }
    
    
    if (HpC >= 1000 & HpC < 2000 ) {
        cruiseMaxPa_1 = (-0.000812500000000003 * powf(OATC, 2) )   + ( 0.615  * OATC ) + -2.9   ; cruiseMaxPa_2 = (-0.0011875 * powf(OATC, 2) )   + ( 0.6  * OATC ) + 3.3   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 1000  * ( HpC - 1000 )  );
        
    }
    
    
    if (HpC >= 2000 & HpC < 3000 ) {
        cruiseMaxPa_1 = (-0.0011875 * powf(OATC, 2) )   + ( 0.6  * OATC ) + 3.3   ; cruiseMaxPa_2 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 9.5   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 1000  * ( HpC - 2000 )  );
        
    }
    
    
    if (HpC >= 3000 & HpC < 4000 ) {
        cruiseMaxPa_1 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 9.5   ; cruiseMaxPa_2 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 15.7   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 1000  * ( HpC - 3000 )  );
        
    }
    
    
    if (HpC >= 4000 & HpC < 5000 ) {
        cruiseMaxPa_1 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 15.7   ; cruiseMaxPa_2 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 21.9   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 1000  * ( HpC - 4000 )  );
        
    }
    
    
    if (HpC >= 5000 & HpC < 6000 ) {
        cruiseMaxPa_1 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 21.9   ; cruiseMaxPa_2 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 28.1   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 1000  * ( HpC - 5000 )  );
        
    }
    
    
    if (HpC >= 6000 & HpC < 8000 ) {
        cruiseMaxPa_1 = (-0.0015625 * powf(OATC, 2) )   + ( 0.615  * OATC ) + 28.1   ; cruiseMaxPa_2 = (-0.00109375 * powf(OATC, 2) )   + ( 0.59625  * OATC ) + 40.1   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 2000  * ( HpC - 6000 )  );
        
    }
    
    
    if (HpC >= 8000 & HpC < 10000 ) {
        cruiseMaxPa_1 = (-0.00109375 * powf(OATC, 2) )   + ( 0.59625  * OATC ) + 40.1   ; cruiseMaxPa_2 = (-0.00125 * powf(OATC, 2) )   + ( 0.5775  * OATC ) + 53.1   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 2000  * ( HpC - 8000 )  );
        
    }
    
    
    if (HpC >= 10000 & HpC < 12000 ) {
        cruiseMaxPa_1 = (-0.00125 * powf(OATC, 2) )   + ( 0.5775  * OATC ) + 53.1   ; cruiseMaxPa_2 = (-0.00140624999999999 * powf(OATC, 2) )   + ( 0.57125  * OATC ) + 65.1   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 2000  * ( HpC - 10000 )  );
        
    }
    
    
    if (HpC >= 12000 & HpC < 14000 ) {
        cruiseMaxPa_1 = (-0.00140624999999999 * powf(OATC, 2) )   + ( 0.57125  * OATC ) + 65.1   ; cruiseMaxPa_2 = (-0.0015625 * powf(OATC, 2) )   + ( 0.5525  * OATC ) + 77.6   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 2000  * ( HpC - 12000 )  );
        
    }
    
    
    if (HpC >= 14000 & HpC < 16000 ) {
        cruiseMaxPa_1 = (-0.0015625 * powf(OATC, 2) )   + ( 0.5525  * OATC ) + 77.6   ; cruiseMaxPa_2 = (-0.0021875 * powf(OATC, 2) )   + ( 0.54  * OATC ) + 90.1   ;
        indexOATcruise   = cruiseMaxPa_1 +   (  (cruiseMaxPa_2 - cruiseMaxPa_1) / 2000  * ( HpC - 14000 )  );
        
    }
    
    OATindex = indexOATcruise;
    
    // set RPM / Power Slider
    resultRPMmin = 55;
    resultRPMmax = 75;
    
    
    
    
    fuelFlow55 = 7.8, fuelFlow65 = 8.8, fuelFlow75 = 10.0;
    RPM55 = (OATindex - -474.594) / 0.2162162 ;    
    RPM65 = (OATindex - -520.0) / 0.222222 ;    
    RPM75 = (OATindex - -536.216216216216) / 0.216216216216216 ;  
    
    KTAS55 = (OATindex  - -498.2608) / 5.217391 ;    
    KTAS65 = (OATindex  - -525.0) / 5.0 ;    
    KTAS75 = (OATindex  - -375.0) / 3.3333 ;
    
    
    RPM = engineRPMcruise;
    
    if (RPM >= 55 & RPM < 65 ) {        
        KTAS = KTAS55 + ( ((KTAS65 - KTAS55) / 10) * (RPM - 55) );        
        GPH = fuelFlow55 + ( ((fuelFlow65 - fuelFlow55) / 10) * (RPM - 55) );         
        RPM = RPM55 + ( ((RPM65 - RPM55) / 10) * (RPM - 55) );
    }    
    
    if (RPM >= 65 & RPM <= 75 ) {        
        KTAS = KTAS65 + ( ((KTAS75 - KTAS65) / 10) * (RPM - 65) );        
        GPH = fuelFlow65 + ( ((fuelFlow75 - fuelFlow65) / 10) * (RPM - 65) );        
        RPM = RPM65 + ( ((RPM75 - RPM65) / 10) * (RPM - 65) );
    }
    
    
    resultCruiseBHP =    engineRPMcruise;
    resultCruiseKTAS =  KTAS;    
    resultCruiseFuelBurn =    GPH;
    
    //NSLog(@"resultCruiseKTAS %.1f", resultCruiseKTAS);
    //NSLog(@"resultCruiseFuelBurn %.1f", resultCruiseFuelBurn);
    
    
    
}


// C172 S **************************************************************************************************

- (void) shortfield_LandingC152 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_lowLD = 450; cl_0_lowLD = 1160;    gR_10_lowLD = 465; cl_10_lowLD = 1185;   gR_20_lowLD = 485; cl_20_lowLD = 1215;   gR_30_lowLD = 500; cl_30_lowLD = 1240;   gR_40_lowLD = 515; cl_40_lowLD = 1265; 
        gR_0_higLD = 465; cl_0_higLD = 1185;    gR_10_higLD = 485; cl_10_higLD = 1215;   gR_20_higLD = 500; cl_20_higLD = 1240;   gR_30_higLD = 520; cl_30_higLD = 1270;   gR_40_higLD = 535; cl_40_higLD = 1295; 
        
        PAlevelShortfieldLD = 0;
        
        
      
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_lowLD = 465; cl_0_lowLD = 1185;    gR_10_lowLD = 485; cl_10_lowLD = 1215;   gR_20_lowLD = 500; cl_20_lowLD = 1240;   gR_30_lowLD = 520; cl_30_lowLD = 1270;   gR_40_lowLD = 535; cl_40_lowLD = 1295; 
        gR_0_higLD = 485; cl_0_higLD = 1215;    gR_10_higLD = 500; cl_10_higLD = 1240;   gR_20_higLD = 520; cl_20_higLD = 1270;   gR_30_higLD = 535; cl_30_higLD = 1300;   gR_40_higLD = 555; cl_40_higLD = 1330;  
        
        PAlevelShortfieldLD = 1000;
        
    
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_lowLD = 485; cl_0_lowLD = 1215;    gR_10_lowLD = 500; cl_10_lowLD = 1240;   gR_20_lowLD = 520; cl_20_lowLD = 1270;   gR_30_lowLD = 535; cl_30_lowLD = 1300;   gR_40_lowLD = 555; cl_40_lowLD = 1330; 
        gR_0_higLD = 500; cl_0_higLD = 1240;    gR_10_higLD = 520; cl_10_higLD = 1275;   gR_20_higLD = 540; cl_20_higLD = 1305;   gR_30_higLD = 560; cl_30_higLD = 1335;   gR_40_higLD = 575; cl_40_higLD = 1360; 
        
        PAlevelShortfieldLD = 2000;
        
      
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_lowLD = 500; cl_0_lowLD = 1240;    gR_10_lowLD = 520; cl_10_lowLD = 1275;   gR_20_lowLD = 540; cl_20_lowLD = 1305;   gR_30_lowLD = 560; cl_30_lowLD = 1335;   gR_40_lowLD = 575; cl_40_lowLD = 1360; 
        gR_0_higLD = 520; cl_0_higLD = 1275;    gR_10_higLD = 540; cl_10_higLD = 1305;   gR_20_higLD = 560; cl_20_higLD = 1335;   gR_30_higLD = 580; cl_30_higLD = 1370;   gR_40_higLD = 600; cl_40_higLD = 1400; 
        
        PAlevelShortfieldLD = 3000;
        
            
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_lowLD = 520; cl_0_lowLD = 1275;    gR_10_lowLD = 540; cl_10_lowLD = 1305;   gR_20_lowLD = 560; cl_20_lowLD = 1335;   gR_30_lowLD = 580; cl_30_lowLD = 1370;   gR_40_lowLD = 600; cl_40_lowLD = 1400; 
        gR_0_higLD = 540; cl_0_higLD = 1305;    gR_10_higLD = 560; cl_10_higLD = 1335;   gR_20_higLD = 580; cl_20_higLD = 1370;   gR_30_higLD = 600; cl_30_higLD = 1400;   gR_40_higLD = 620; cl_40_higLD = 1435; 
        
        PAlevelShortfieldLD = 4000;
        
        
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_lowLD = 540; cl_0_lowLD = 1305;    gR_10_lowLD = 560; cl_10_lowLD = 1335;   gR_20_lowLD = 580; cl_20_lowLD = 1370;   gR_30_lowLD = 600; cl_30_lowLD = 1400;   gR_40_lowLD = 620; cl_40_lowLD = 1435; 
        gR_0_higLD = 560; cl_0_higLD = 1340;    gR_10_higLD = 580; cl_10_higLD = 1370;   gR_20_higLD = 605; cl_20_higLD = 1410;   gR_30_higLD = 625; cl_30_higLD = 1440;   gR_40_higLD = 645; cl_40_higLD = 1475; 
        
        PAlevelShortfieldLD = 5000;
        
        
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_lowLD = 560; cl_0_lowLD = 1340;    gR_10_lowLD = 580; cl_10_lowLD = 1370;   gR_20_lowLD = 605; cl_20_lowLD = 1410;   gR_30_lowLD = 625; cl_30_lowLD = 1440;   gR_40_lowLD = 645; cl_40_lowLD = 1475; 
        gR_0_higLD = 585; cl_0_higLD = 1375;    gR_10_higLD = 605; cl_10_higLD = 1410;   gR_20_higLD = 625; cl_20_higLD = 1440;   gR_30_higLD = 650; cl_30_higLD = 1480;   gR_40_higLD = 670; cl_40_higLD = 1515; 
        
        PAlevelShortfieldLD = 6000;
        
         
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_lowLD = 585; cl_0_lowLD = 1375;    gR_10_lowLD = 605; cl_10_lowLD = 1410;   gR_20_lowLD = 625; cl_20_lowLD = 1440;   gR_30_lowLD = 650; cl_30_lowLD = 1480;   gR_40_lowLD = 670; cl_40_lowLD = 1515; ;
        gR_0_higLD = 605; cl_0_higLD = 1410;    gR_10_higLD = 630; cl_10_higLD = 1450;   gR_20_higLD = 650; cl_20_higLD = 1480;   gR_30_higLD = 675; cl_30_higLD = 1520;   gR_40_higLD = 695; cl_40_higLD = 1555; 
        
        PAlevelShortfieldLD = 7000;
        
       
        
    } // end if  
    
    
  
    
    
    return;
    
} // end void

- (void) shortfieldC152_2200 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 640; cl_0_low = 1190;    gR_10_low = 695; cl_10_low = 1290;   gR_20_low = 755; cl_20_low = 1390;   gR_30_low = 810; cl_30_low = 1495;   gR_40_low = 875; cl_40_low = 1605; 
        gR_0_hig = 705; cl_0_hig = 1310;    gR_10_hig = 765; cl_10_hig = 1420;   gR_20_hig = 825; cl_20_hig = 1530;   gR_30_hig = 890; cl_30_hig = 1645;   gR_40_hig = 960; cl_40_hig = 1770; 
        
        PAlevelShortfield = 0;
        
        
        // interpolate ground roll
      
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 705; cl_0_low = 1310;    gR_10_low = 765; cl_10_low = 1420;   gR_20_low = 825; cl_20_low = 1530;   gR_30_low = 890; cl_30_low = 1645;   gR_40_low = 960; cl_40_low = 1770; 
        gR_0_hig = 775; cl_0_hig = 1445;    gR_10_hig = 840; cl_10_hig = 1565;   gR_20_hig = 910; cl_20_hig = 1690;   gR_30_hig = 980; cl_30_hig = 1820;   gR_40_hig = 1055; cl_40_hig = 1960; 
        
        PAlevelShortfield = 1000;
        
        
    
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 775; cl_0_low = 1445;    gR_10_low = 840; cl_10_low = 1565;   gR_20_low = 910; cl_20_low = 1690;   gR_30_low = 980; cl_30_low = 1820;   gR_40_low = 1055; cl_40_low = 1960; 
        gR_0_hig = 855; cl_0_hig = 1600;    gR_10_hig = 825; cl_10_hig = 1730;   gR_20_hig = 1000; cl_20_hig = 1870;   gR_30_hig = 1080; cl_30_hig = 2020;   gR_40_hig = 1165; cl_40_hig = 2185; 
        
        PAlevelShortfield = 2000;
        
        // interpolate ground roll
        
     
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 855; cl_0_low = 1600;    gR_10_low = 825; cl_10_low = 1730;   gR_20_low = 1000; cl_20_low = 1870;   gR_30_low = 1080; cl_30_low = 2020;   gR_40_low = 1165; cl_40_low = 2185; 
        gR_0_hig = 940; cl_0_hig = 1775;    gR_10_hig = 1020; cl_10_hig = 1920;   gR_20_hig = 1100; cl_20_hig = 2080;   gR_30_hig = 1190; cl_30_hig = 2250;   gR_40_hig = 1285; cl_40_hig = 2440; 
        
        PAlevelShortfield = 3000;
        
        // interpolate ground roll
        
           
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 940; cl_0_low = 1775;    gR_10_low = 1020; cl_10_low = 1920;   gR_20_low = 1100; cl_20_low = 2080;   gR_30_low = 1190; cl_30_low = 2250;   gR_40_low = 1285; cl_40_low = 2440; 
        gR_0_hig = 1040; cl_0_hig = 1970;    gR_10_hig = 1125; cl_10_hig = 2140;   gR_20_hig = 1215; cl_20_hig = 2320;   gR_30_hig = 1315; cl_30_hig = 2525;   gR_40_hig = 1420; cl_40_hig = 2750; 
        
        PAlevelShortfield = 4000;
        
        // interpolate ground roll
        
           
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1040; cl_0_low = 1970;    gR_10_low = 1125; cl_10_low = 2140;   gR_20_low = 1215; cl_20_low = 2320;   gR_30_low = 1315; cl_30_low = 2525;   gR_40_low = 1420; cl_40_low = 2750; 
        gR_0_hig = 1145; cl_0_hig = 2200;    gR_10_hig = 1245; cl_10_hig = 2395;   gR_20_hig = 1345; cl_20_hig = 2610;   gR_30_hig = 1455; cl_30_hig = 2855;   gR_40_hig = 1570; cl_40_hig = 3125; 
        
        PAlevelShortfield = 5000;
        
        // interpolate ground roll
        
      
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1145; cl_0_low = 2200;    gR_10_low = 1245; cl_10_low = 2395;   gR_20_low = 1345; cl_20_low = 2610;   gR_30_low = 1455; cl_30_low = 2855;   gR_40_low = 1570; cl_40_low = 3125; 
        gR_0_hig = 1270; cl_0_hig = 2470;    gR_10_hig = 1375; cl_10_hig = 2705;   gR_20_hig = 1490; cl_20_hig = 2960;   gR_30_hig = 1615; cl_30_hig = 3255;   gR_40_hig = 1745; cl_40_hig = 3590; 
        
        PAlevelShortfield = 6000;
        
        // interpolate ground roll
        
       
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1270; cl_0_low = 2470;    gR_10_low = 1375; cl_10_low = 2705;   gR_20_low = 1490; cl_20_low = 2960;   gR_30_low = 1615; cl_30_low = 3255;   gR_40_low = 1745; cl_40_low = 3590; 
        gR_0_hig = 1405; cl_0_hig = 2800;    gR_10_hig = 1525; cl_10_hig = 3080;   gR_20_hig = 1655; cl_20_hig = 3395;   gR_30_hig = 1795; cl_30_hig = 3765;   gR_40_hig = 1940; cl_40_hig = 4195; 
        
        PAlevelShortfield = 7000;
        
        // interpolate ground roll
        
       
        
        
    } // end if  
    
    
    
    [self shortfield2200C172_interpolation];
    
    
    
    // ausgabe
    
    
    //labelClear1.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_1];
    //labelClear2.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_2];
    
    //labelTotalToClear50ftShortField.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_interpolated];
    
    return;
    
}

- (void) shortfieldC152_2400 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 745; cl_0_low = 1275;    gR_10_low = 800; cl_10_low = 1370;   gR_20_low = 860; cl_20_low = 1470;   gR_30_low = 925; cl_30_low = 1570;   gR_40_low = 995; cl_40_low = 1685;
        gR_0_hig = 810; cl_0_hig = 1390;    gR_10_hig = 875; cl_10_hig = 1495;   gR_20_hig = 940; cl_20_hig = 1605;   gR_30_hig = 1010; cl_30_hig = 1720;   gR_40_hig = 1085; cl_40_hig = 1845;
        
        PAlevelShortfield = 0;
        
        
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 810; cl_0_low = 1390;    gR_10_low = 875; cl_10_low = 1495;   gR_20_low = 940; cl_20_low = 1605;    gR_30_low = 1010; cl_30_low = 1720;   gR_40_low = 1085; cl_40_low = 1845;
        gR_0_hig = 885; cl_0_hig = 1520;    gR_10_hig = 955; cl_10_hig = 1635;   gR_20_hig = 1030; cl_20_hig = 1760;   gR_30_hig = 1110; cl_30_hig = 1890;   gR_40_hig = 1190; cl_40_hig = 2030;
        
        PAlevelShortfield = 1000;
        
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 885; cl_0_low = 1520;    gR_10_low = 955;  cl_10_low = 1635;   gR_20_low = 1030; cl_20_low = 1760;   gR_30_low = 1110; cl_30_low = 1890;   gR_40_low = 1190; cl_40_low = 2030;
        gR_0_hig = 970; cl_0_hig = 1665;    gR_10_hig = 1050; cl_10_hig = 1795;   gR_20_hig = 1130; cl_20_hig = 1930;   gR_30_hig = 1215; cl_30_hig = 2080;   gR_40_hig = 1305; cl_40_hig = 2230;
        
        PAlevelShortfield = 2000;
             
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 970;  cl_0_low = 1665;    gR_10_low = 1050; cl_10_low = 1795;   gR_20_low = 1130;  cl_20_low = 1930;   gR_30_low = 1215; cl_30_low = 2080;   gR_40_low = 1305; cl_40_low = 2230;
        gR_0_hig = 1065; cl_0_hig = 1830;    gR_10_hig = 1150; cl_10_hig = 1975;   gR_20_hig = 1240;  cl_20_hig = 2130;   gR_30_hig = 1335; cl_30_hig = 2295;   gR_40_hig = 1430; cl_40_hig = 2455;
        
        PAlevelShortfield = 3000;
        
    
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1065; cl_0_low = 1830;    gR_10_low = 1150;  cl_10_low = 1975;   gR_20_low = 1240; cl_20_low = 2130;   gR_30_low = 1335; cl_30_low = 2295;   gR_40_low = 1430; cl_40_low = 2455;
        gR_0_hig = 1170; cl_0_hig = 2015;    gR_10_hig = 1265;  cl_10_hig = 2180;   gR_20_hig = 1360; cl_20_hig = 2355;   gR_30_hig = 1465; cl_30_hig = 2530;   gR_40_hig = 1570; cl_40_hig = 2715;
        
        PAlevelShortfield = 4000;
        
       
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1170; cl_0_low = 2015;    gR_10_low = 1265; cl_10_low = 2180;   gR_20_low = 1360; cl_20_low = 2355;   gR_30_low = 1465; cl_30_low = 2530;   gR_40_low = 1570; cl_40_low = 2715;
        gR_0_hig = 1285; cl_0_hig = 2230;    gR_10_hig = 1390; cl_10_hig = 2410;   gR_20_hig = 1500; cl_20_hig = 2610;   gR_30_hig = 1610; cl_30_hig = 2805;   gR_40_hig = 1725; cl_40_hig = 3015;
        
        PAlevelShortfield = 5000;
        
        
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1285; cl_0_low = 2230;    gR_10_low = 1390; cl_10_low = 2410;   gR_20_low = 1500; cl_20_low = 2610;   gR_30_low = 1610; cl_30_low = 2805;   gR_40_low = 1725; cl_40_low = 3015;
        gR_0_hig = 1415; cl_0_hig = 2470;    gR_10_hig = 1530; cl_10_hig = 2685;   gR_20_hig = 1650; cl_20_hig = 2900;   gR_30_hig = 1770; cl_30_hig = 3125;   gR_40_hig = 1900; cl_40_hig = 3370;
        
        PAlevelShortfield = 6000;
        
      
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1415; cl_0_low = 2470;    gR_10_low = 1530; cl_10_low = 2685;   gR_20_low = 1650; cl_20_low = 2900;   gR_30_low = 1770; cl_30_low = 3125;   gR_40_low = 1900; cl_40_low = 3370;
        gR_0_hig = 1560; cl_0_hig = 2755;    gR_10_hig = 1690; cl_10_hig = 3000;   gR_20_hig = 1815; cl_20_hig = 3240;   gR_30_hig = 1950; cl_30_hig = 3500;   gR_40_hig = 2095; cl_40_hig = 3790;
        
        PAlevelShortfield = 7000;
        
       
        
        
    } // end if  
    
    
    [self shortfield2400C172_interpolation];
    
    
    // ausgabe
    
    //labelGrndRollSF12400.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_12400];
    
    //labelGrndRollSF22400.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_22400];
    
    //labelGrndRollShortField2400.text = [ [NSString alloc] initWithFormat:@"%.0f",  GrndRollShortField_interpolated2400];
    
    
    
    //labelClear12400.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_12400];
    //labelClear22400.text =  [ [NSString alloc] initWithFormat:@"%.0f",  ObstClearance_22400];
    
    //labelTotalToClear50ftShortField2400.text =  [ [NSString alloc] initWithFormat:@"%.0f", ObstClearance_interpolated2400];
    
    return;
    
}

- (void) shortfieldC152_2550 {
    
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {  // if 1
        
        gR_0_low = 860; cl_0_low = 1465;    gR_10_low = 925;  cl_10_low = 1575;   gR_20_low =  995; cl_20_low = 1690;   gR_30_low = 1070; cl_30_low = 1810;   gR_40_low = 1150; cl_40_low = 1945;
        gR_0_hig = 940; cl_0_hig = 1600;    gR_10_hig = 1010; cl_10_hig = 1720;   gR_20_hig = 1090; cl_20_hig = 1850;   gR_30_hig = 1170; cl_30_hig = 1990;   gR_40_hig = 1260; cl_40_hig = 2135;
        
        PAlevelShortfield = 0;
        
        
        
        
    }  // end if 0-1000
    
    
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        gR_0_low = 940;  cl_0_low = 1600;    gR_10_low = 1010; cl_10_low = 1720;   gR_20_low = 1090; cl_20_low = 1850;   gR_30_low = 1170; cl_30_low = 1990;   gR_40_low = 1260; cl_40_low = 2135;
        gR_0_hig = 1025; cl_0_hig = 1755;    gR_10_hig = 1110; cl_10_hig = 1890;   gR_20_hig = 1195; cl_20_hig = 2035;   gR_30_hig = 1285; cl_30_hig = 2190;   gR_40_hig = 1380; cl_40_hig = 2355;
        
        PAlevelShortfield = 1000;
        
        
        
        
    } // end if 1000-2000
    
    
    
    // press alt 2000 - 3000
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        gR_0_low = 1025; cl_0_low = 1755;    gR_10_low = 1110;  cl_10_low = 1890;   gR_20_low = 1195; cl_20_low = 2035;   gR_30_low = 1285; cl_30_low = 2190;   gR_40_low = 1380; cl_40_low = 2355;
        gR_0_hig = 1125; cl_0_hig = 1925;    gR_10_hig = 1215;  cl_10_hig = 2080;   gR_20_hig = 1310; cl_20_hig = 2240;   gR_30_hig = 1410; cl_30_hig = 2420;   gR_40_hig = 1515; cl_40_hig = 2605;
        
        PAlevelShortfield = 2000;
        
        
        
        
    } // end if 2000 - 3000 
    
    
    
    
    
    // press alt 3000 - 4000
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        gR_0_low = 1125; cl_0_low = 1925;    gR_10_low = 1215; cl_10_low = 2080;   gR_20_low = 1310;  cl_20_low = 2240;   gR_30_low = 1410; cl_30_low = 2420;   gR_40_low = 1515; cl_40_low = 2605;
        gR_0_hig = 1235; cl_0_hig = 2120;    gR_10_hig = 1335; cl_10_hig = 2295;   gR_20_hig = 1440;  cl_20_hig = 2480;   gR_30_hig = 1550; cl_30_hig = 2685;   gR_40_hig = 1660; cl_40_hig = 2880;
        
        PAlevelShortfield = 3000;
        
      
        
    } // end if   
    
    
    
    
    // press alt 4000 - 5000
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        gR_0_low = 1235; cl_0_low = 2120;    gR_10_low = 1335;  cl_10_low = 2295;   gR_20_low = 1440; cl_20_low = 2480;   gR_30_low = 1550; cl_30_low = 2685;   gR_40_low = 1660; cl_40_low = 2880;
        gR_0_hig = 1355; cl_0_hig = 2345;    gR_10_hig = 1465;  cl_10_hig = 2545;   gR_20_hig = 1585; cl_20_hig = 2755;   gR_30_hig = 1705; cl_30_hig = 2975;   gR_40_hig = 1825; cl_40_hig = 3205;
        
        PAlevelShortfield = 4000;
        
       
        
    } // end if   
    
    
    
    
    // press alt 5000 - 6000
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        gR_0_low = 1355; cl_0_low = 2345;    gR_10_low = 1465; cl_10_low = 2545;   gR_20_low = 1585; cl_20_low = 2755;   gR_30_low = 1705; cl_30_low = 2975;   gR_40_low = 1825; cl_40_low = 3205;
        gR_0_hig = 1495; cl_0_hig = 2605;    gR_10_hig = 1615; cl_10_hig = 2830;   gR_20_hig = 1745; cl_20_hig = 3075;   gR_30_hig = 1875; cl_30_hig = 3320;   gR_40_hig = 2010; cl_40_hig = 3585;
        
        PAlevelShortfield = 5000;
        
        
        
    } // end if   
    
    
    
    // press alt 6000 - 7000
    
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        gR_0_low = 1495; cl_0_low = 2605;    gR_10_low = 1615; cl_10_low = 2830;   gR_20_low = 1745; cl_20_low = 3075;   gR_30_low = 1875; cl_30_low = 3320;   gR_40_low = 2010; cl_40_low = 3585;
        gR_0_hig = 1645; cl_0_hig = 2910;    gR_10_hig = 1785; cl_10_hig = 3170;   gR_20_hig = 1920; cl_20_hig = 3440;   gR_30_hig = 2065; cl_30_hig = 3730;   gR_40_hig = 2215; cl_40_hig = 4045;
        
        PAlevelShortfield = 6000;
        
        
        
        
    } // end if  
    
    
    
    // press alt 7000 - 8000
    
    
    if (PressureAltitude >=7000 & PressureAltitude <= 8000) {
        
        gR_0_low = 1645; cl_0_low = 2910;    gR_10_low = 1785; cl_10_low = 3170;   gR_20_low = 1920; cl_20_low = 3440;   gR_30_low = 2065; cl_30_low = 3730;   gR_40_low = 2215; cl_40_low = 4045;
        gR_0_hig = 1820; cl_0_hig = 3265;    gR_10_hig = 1970; cl_10_hig = 3575;   gR_20_hig = 2120; cl_20_hig = 3880;   gR_30_hig = 2280; cl_30_hig = 4225;   gR_40_hig = 2450; cl_40_hig = 4615;
        
        PAlevelShortfield = 7000;
        
       
        
        
    } // end if  
    
    
    [self shortfield2550C172_interpolation];
    
    
    
    
    return;
    
}

- (void) shortfiedC152InterpolationToACWEight {
    
    
    if (ACweightLBS >= 2200 & ACweightLBS < 2400) {
        
        
        
        GroundRolltoWeight = GrndRollShortField_interpolated + ( ( (GrndRollShortField_interpolated2400 - GrndRollShortField_interpolated)/200 ) * (ACweightLBS-2200))  ;
        
        //labelInterpolatedShortFieldGroundRoll.text  = [ [NSString alloc] initWithFormat:@"%.0f'", GroundRolltoWeight];
        //metersGroundRoll.text                       = [ [NSString alloc] initWithFormat:@"%.0fm", GroundRolltoWeight * 0.3048 ]; // kink
        
        
        
        totalToClear = ObstClearance_interpolated + ( ( (ObstClearance_interpolated2400 - ObstClearance_interpolated)/200 ) * (ACweightLBS-2200))  ;
        
        //labelInterpolatedTotalToClear.text  = [ [NSString alloc] initWithFormat:@"%.0f'", totalToClear];
        //meterToClear.text                   = [ [NSString alloc] initWithFormat:@"%.0fm", totalToClear * 0.3048 ]; // kink
        
        
        liftoffspeed = 44 +  ( 0.02 * (ACweightLBS-2200));
        
        //labelLiftOffKIAS.text =  [ [NSString alloc] initWithFormat:@"%.1f KIAS", liftoffspeed];
        
        
        
    }
    
    
    
    if (ACweightLBS >= 2400 & ACweightLBS <= 2550) {
        
        
        
        GroundRolltoWeight = GrndRollShortField_interpolated2400 + ( ( (GrndRollShortField_interpolated2550 - GrndRollShortField_interpolated2400)/150 ) * (ACweightLBS-2400))  ;
        
        //labelInterpolatedShortFieldGroundRoll.text = [ [NSString alloc] initWithFormat:@"%.0f'", GroundRolltoWeight];
        //metersGroundRoll.text                       = [ [NSString alloc] initWithFormat:@"%.0fm", GroundRolltoWeight * 0.3048 ]; // kink2
        
        
        
        totalToClear = ObstClearance_interpolated2400 + ( ( (ObstClearance_interpolated2550 - ObstClearance_interpolated2400)/150 ) * (ACweightLBS-2400))  ;
        
        //labelInterpolatedTotalToClear.text = [ [NSString alloc] initWithFormat:@"%.0f'", totalToClear];
        
        //meterToClear.text                   = [ [NSString alloc] initWithFormat:@"%.0fm", totalToClear * 0.3048 ]; // kink
        
        liftoffspeed = 48 +  ( 0.02 * (ACweightLBS-2400));
        
        //labelLiftOffKIAS.text =  [ [NSString alloc] initWithFormat:@"%.1f KIAS", liftoffspeed];
        
        
        
        
    }
    
    resultTODistancefeet = totalToClear;
    
    resultTOGroundRollfeet = GroundRolltoWeight;
    
    
    
}
- (void) calculate_ClimbC152 {
    
    if (PressureAltitude >=0 & PressureAltitude < 1000) {
        
        climb_low2  = 67; RoC_low2   = 715; time_low2   = 0; fuel_low2   = 0;    distNM_low2   = 0; 
        climb_high2 = 66; RoC_high2  = 675; time_high2  = 1; fuel_high2  = 0.2;    distNM_high2   = 2; PAlevel2 = 0;
        
    
    }
    
    if (PressureAltitude >=1000 & PressureAltitude < 2000) {
        
        climb_low2  = 66; RoC_low2   = 675; time_low2   = 1; fuel_low2   = 0.2;    distNM_low2   = 2; PAlevel2 = 1000;   
        climb_high2 = 66; RoC_high2  = 630; time_high2  = 3; fuel_high2  = 0.4;    distNM_high2   = 3; PAlevel2 = 1000;
       
    }
    
    
    if (PressureAltitude >=2000 & PressureAltitude < 3000) {
        
        climb_low2  = 66; RoC_low2   = 630; time_low2   = 3; fuel_low2   = 0.4;    distNM_low2   = 3; PAlevel2 = 2000;             
        climb_high2 = 65; RoC_high2  = 590; time_high2  = 5; fuel_high2  = 0.7;    distNM_high2   = 5; PAlevel2 = 2000;    
        
        
    }
    
    
    if (PressureAltitude >=3000 & PressureAltitude < 4000) {
        
        climb_low2  = 65; RoC_low2   = 590; time_low2   = 5; fuel_low2   = 0.7;    distNM_low2   = 5; PAlevel2 = 3000;   
        climb_high2 = 65; RoC_high2  = 550; time_high2  = 6; fuel_high2  = 0.9;    distNM_high2   = 7; PAlevel2 = 3000;
      
    }
    
    
    if (PressureAltitude >=4000 & PressureAltitude < 5000) {
        
        climb_low2  = 65; RoC_low2   = 550; time_low2   = 6; fuel_low2   = 0.9;    distNM_low2   = 7; PAlevel2 = 4000;   
        climb_high2 = 64; RoC_high2  = 505; time_high2  = 8; fuel_high2  = 1.2;    distNM_high2   = 9; PAlevel2 = 4000;        
     
    }
    
    
    if (PressureAltitude >=5000 & PressureAltitude < 6000) {
        
        climb_low2  = 64; RoC_low2   = 505; time_low2   = 8; fuel_low2   = 1.2;    distNM_low2   = 9; PAlevel2 = 5000;   
        climb_high2 = 63; RoC_high2  = 465; time_high2  = 10; fuel_high2  = 1.4;    distNM_high2   = 12; PAlevel2 = 5000; 
       
    }
    
    if (PressureAltitude >=6000 & PressureAltitude < 7000) {
        
        climb_low2  = 63; RoC_low2   = 465; time_low2   = 10; fuel_low2   = 1.4;    distNM_low2   = 12; PAlevel2 = 6000;   
        climb_high2 = 63; RoC_high2  = 425; time_high2  = 13; fuel_high2  = 1.7;    distNM_high2   = 14; PAlevel2 = 6000;
        
      
    }
    
    if (PressureAltitude >=7000 & PressureAltitude < 8000) {
        
        climb_low2  = 63; RoC_low2   = 425; time_low2   = 13; fuel_low2   = 1.7;    distNM_low2   = 14; PAlevel2 = 7000;   
        climb_high2 = 62; RoC_high2  = 380; time_high2  = 15; fuel_high2  = 2;    distNM_high2   = 17; PAlevel2 = 7000;
        
    }
    
    if (PressureAltitude >=8000 & PressureAltitude < 9000) {
        
        climb_low2  = 62; RoC_low2   = 380; time_low2   = 15; fuel_low2   = 2;    distNM_low2   = 17; PAlevel2 = 8000;   
        climb_high2 = 62; RoC_high2  = 340; time_high2  = 18; fuel_high2  = 2.3;    distNM_high2   = 21; PAlevel2 = 8000;
        
       
    }
    
    
    if (PressureAltitude >=9000 & PressureAltitude < 10000) {
        
        climb_low2  = 62; RoC_low2   = 340; time_low2   = 18; fuel_low2   = 2.3;    distNM_low2   = 21; PAlevel2 = 9000;   
        climb_high2 = 61; RoC_high2  = 300; time_high2  = 21; fuel_high2  = 2.6;    distNM_high2   = 25; PAlevel2 = 9000;
       
    }
    
    
    if (PressureAltitude >=10000 & PressureAltitude < 11000) {
        
        climb_low2  = 61; RoC_low2   = 300; time_low2   = 21; fuel_low2   = 2.6;    distNM_low2   = 25; PAlevel2 = 10000;   
        climb_high2 = 61; RoC_high2  = 255; time_high2  = 25; fuel_high2  = 3;    distNM_high2   = 29; PAlevel2 = 10000;
        
       
    }
    
    if (PressureAltitude >=11000 & PressureAltitude < 12000) {
        
        climb_low2  = 61; RoC_low2   = 255; time_low2   = 25; fuel_low2   = 3;    distNM_low2   = 29; PAlevel2 = 11000;   
        climb_high2 = 60; RoC_high2  = 215; time_high2  = 29; fuel_high2  = 3.4;    distNM_high2   = 34; PAlevel2 = 11000;
       
    }
    
    
    if (PressureAltitude >=12000 ) {
        
        climb_low2  = 60; RoC_low2   = 215; time_low2   = 29; fuel_low2   = 3.4;    distNM_low2   = 34; PAlevel2 = 12000;   
        climb_high2 = 60; RoC_high2  = 215; time_high2  = 29; fuel_high2  = 3.4;    distNM_high2   = 34; PAlevel2 = 12000;
        
    }
    
    [self interpolateClimbC172S];
    
}

- (void) InterpolateCruiseValuesC152 {
    
    
    RPM = engineRPMcruise;
    
    // define RPM  high and low
    
    if (RPM >= 2100 & RPM < 2200) {
        RPM_LOW = 2100; RPM_HIGH = 2200;
    }
    
    if (RPM >= 2200 & RPM < 2300) {
        RPM_LOW = 2200; RPM_HIGH = 2300;
    }
    
    if (RPM >= 2300 & RPM < 2400) {
        RPM_LOW = 2300; RPM_HIGH = 2400;
    }
    
    if (RPM >= 2400 & RPM < 2500) {
        RPM_LOW = 2400; RPM_HIGH = 2500;
    }
    
    if (RPM >= 2500 & RPM < 2600) {
        RPM_LOW = 2500; RPM_HIGH = 2600;
    }
    
    if (RPM >= 2600 & RPM <= 2700) {
        RPM_LOW = 2600; RPM_HIGH = 2700;
    }
    
    if (RPM >= 2600 & RPM <= 2700 & PressureAltitude > 11999) {
        RPM_LOW = 2600; RPM_HIGH = 2650;
    }
    
    
    //NSLog (@"RPM_LOW %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_LOW]);
    
    //NSLog (@"RPM_HIGH %@ ", [ [NSString alloc] initWithFormat:@"%.0f", RPM_HIGH]);
    
    
    
    // get RPM
    
    if (PressureAltitude < 2001) {
        PressureAltitude = 2001;
    }
    
    if (PressureAltitude > 11999) {
        PressureAltitude = 12000;
    }
    
    
    
    if (PressureAltitude >= 2000 & PressureAltitude < 4000) {
        
        PressAltAbzug = 2000;
        
        
        //NSLog (@"Hello 2000");
        
        
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 5.7;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 101;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 70;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 76;  M20_KTAS_UPP = 102;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 103;  STD_GPH_UPP = 6.1;   P20_BHP_UPP = 70;  P20_KTAS_UPP = 102;  P20_GPH_UPP = 5.7; }
        
        if (RPM == 2400) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 98;  M20_GPH_DWN = 5.7;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 101;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 70;  P20_KTAS_DWN = 101;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 76;  M20_KTAS_UPP = 102;  M20_GPH_UPP = 6.1;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 101;  STD_GPH_UPP = 5.7;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 100;  P20_GPH_UPP = 5.4; }
        
        if (RPM == 2300) {M20_BHP_DWN = 71;  M20_KTAS_DWN = 97;  M20_GPH_DWN = 5.7;   STD_BHP_DWN = 66;  STD_KTAS_DWN = 96;  STD_GPH_DWN = 5.4;   P20_BHP_DWN = 63;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 5.1;M20_BHP_UPP = 67;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 5.4;   STD_BHP_UPP = 63;  STD_KTAS_UPP = 95;  STD_GPH_UPP = 5.1;   P20_BHP_UPP = 60;  P20_KTAS_UPP = 95;  P20_GPH_UPP = 4.9; }
        
        if (RPM == 2200) {M20_BHP_DWN = 62;  M20_KTAS_DWN = 92;  M20_GPH_DWN = 5.1;   STD_BHP_DWN = 59;  STD_KTAS_DWN = 91;  STD_GPH_DWN = 4.8;   P20_BHP_DWN = 56;  P20_KTAS_DWN = 90;  P20_GPH_DWN = 4.6;M20_BHP_UPP = 60;  M20_KTAS_UPP = 91;  M20_GPH_UPP = 4.8;   STD_BHP_UPP = 56;  STD_KTAS_UPP = 90;  STD_GPH_UPP = 4.6;   P20_BHP_UPP = 54;  P20_KTAS_UPP = 89;  P20_GPH_UPP = 4.4; }
        
        if (RPM == 2100) {M20_BHP_DWN = 55;  M20_KTAS_DWN = 87;  M20_GPH_DWN = 4.5;   STD_BHP_DWN = 53;  STD_KTAS_DWN = 86;  STD_GPH_DWN = 4.3;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 85;  P20_GPH_DWN = 4.2;M20_BHP_UPP = 53;  M20_KTAS_UPP = 86;  M20_GPH_UPP = 4.4;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 85;  STD_GPH_UPP = 4.2;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 84;  P20_GPH_UPP = 4; }
        
        if (RPM == 2000) {M20_BHP_DWN = 49;  M20_KTAS_DWN = 81;  M20_GPH_DWN = 4.1;   STD_BHP_DWN = 47;  STD_KTAS_DWN = 80;  STD_GPH_DWN = 3.9;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 79;  P20_GPH_DWN = 3.8;M20_BHP_UPP = 48;  M20_KTAS_UPP = 81;  M20_GPH_UPP = 3.9;   STD_BHP_UPP = 46;  STD_KTAS_UPP = 80;  STD_GPH_UPP = 3.8;   P20_BHP_UPP = 45;  P20_KTAS_UPP = 78;  P20_GPH_UPP = 3.7; } 
        
        
        //  ***************
        
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 5.7;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 101;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 70;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 102;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 103;  STD_GPH_UPP2 = 6.1;   P20_BHP_UPP2 = 70;  P20_KTAS_UPP2 = 102;  P20_GPH_UPP2 = 5.7; }
        
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 98;  M20_GPH_DWN2 = 5.7;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 101;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 70;  P20_KTAS_DWN2 = 101;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 102;  M20_GPH_UPP2 = 6.1;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 101;  STD_GPH_UPP2 = 5.7;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 100;  P20_GPH_UPP2 = 5.4; }
        
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 71;  M20_KTAS_DWN2 = 97;  M20_GPH_DWN2 = 5.7;   STD_BHP_DWN2 = 66;  STD_KTAS_DWN2 = 96;  STD_GPH_DWN2 = 5.4;   P20_BHP_DWN2 = 63;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 5.1;M20_BHP_UPP2 = 67;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 5.4;   STD_BHP_UPP2 = 63;  STD_KTAS_UPP2 = 95;  STD_GPH_UPP2 = 5.1;   P20_BHP_UPP2 = 60;  P20_KTAS_UPP2 = 95;  P20_GPH_UPP2 = 4.9; }
        
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 62;  M20_KTAS_DWN2 = 92;  M20_GPH_DWN2 = 5.1;   STD_BHP_DWN2 = 59;  STD_KTAS_DWN2 = 91;  STD_GPH_DWN2 = 4.8;   P20_BHP_DWN2 = 56;  P20_KTAS_DWN2 = 90;  P20_GPH_DWN2 = 4.6;M20_BHP_UPP2 = 60;  M20_KTAS_UPP2 = 91;  M20_GPH_UPP2 = 4.8;   STD_BHP_UPP2 = 56;  STD_KTAS_UPP2 = 90;  STD_GPH_UPP2 = 4.6;   P20_BHP_UPP2 = 54;  P20_KTAS_UPP2 = 89;  P20_GPH_UPP2 = 4.4; }
        
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 55;  M20_KTAS_DWN2 = 87;  M20_GPH_DWN2 = 4.5;   STD_BHP_DWN2 = 53;  STD_KTAS_DWN2 = 86;  STD_GPH_DWN2 = 4.3;   P20_BHP_DWN2 = 51;  P20_KTAS_DWN2 = 85;  P20_GPH_DWN2 = 4.2;M20_BHP_UPP2 = 53;  M20_KTAS_UPP2 = 86;  M20_GPH_UPP2 = 4.4;   STD_BHP_UPP2 = 51;  STD_KTAS_UPP2 = 85;  STD_GPH_UPP2 = 4.2;   P20_BHP_UPP2 = 49;  P20_KTAS_UPP2 = 84;  P20_GPH_UPP2 = 4; }
        
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 49;  M20_KTAS_DWN2 = 81;  M20_GPH_DWN2 = 4.1;   STD_BHP_DWN2 = 47;  STD_KTAS_DWN2 = 80;  STD_GPH_DWN2 = 3.9;   P20_BHP_DWN2 = 46;  P20_KTAS_DWN2 = 79;  P20_GPH_DWN2 = 3.8;M20_BHP_UPP2 = 48;  M20_KTAS_UPP2 = 81;  M20_GPH_UPP2 = 3.9;   STD_BHP_UPP2 = 46;  STD_KTAS_UPP2 = 80;  STD_GPH_UPP2 = 3.8;   P20_BHP_UPP2 = 45;  P20_KTAS_UPP2 = 78;  P20_GPH_UPP2 = 3.7; }       
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 2000 und 4000
    
    
    
    
    
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        
        PressAltAbzug = 4000;
        
        //NSLog (@"Hello 4000");
        
        if (RPM == 2500) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 102;  M20_GPH_DWN = 6.1;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 103;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 70;  P20_KTAS_DWN = 102;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 72;  M20_KTAS_UPP = 101;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 75;  STD_KTAS_UPP = 105;  STD_GPH_UPP = 6.1;   P20_BHP_UPP = 71;  P20_KTAS_UPP = 104;  P20_GPH_UPP = 5.7; }
        
        if (RPM == 2400) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 102;  M20_GPH_DWN = 6.1;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 101;  STD_GPH_DWN = 5.7;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 100;  P20_GPH_DWN = 5.4;M20_BHP_UPP = 72;  M20_KTAS_UPP = 101;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 67;  STD_KTAS_UPP = 100;  STD_GPH_UPP = 5.4;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 99;  P20_GPH_UPP = 5.247; }
        
        if (RPM == 2300) {M20_BHP_DWN = 67;  M20_KTAS_DWN = 96;  M20_GPH_DWN = 5.4;   STD_BHP_DWN = 63;  STD_KTAS_DWN = 95;  STD_GPH_DWN = 5.1;   P20_BHP_DWN = 60;  P20_KTAS_DWN = 95;  P20_GPH_DWN = 4.9;M20_BHP_UPP = 64;  M20_KTAS_UPP = 96;  M20_GPH_UPP = 5.2;   STD_BHP_UPP = 60;  STD_KTAS_UPP = 95;  STD_GPH_UPP = 4.9;   P20_BHP_UPP = 57;  P20_KTAS_UPP = 94;  P20_GPH_UPP = 4.7; }
        
        if (RPM == 2200) {M20_BHP_DWN = 60;  M20_KTAS_DWN = 91;  M20_GPH_DWN = 4.8;   STD_BHP_DWN = 56;  STD_KTAS_DWN = 90;  STD_GPH_DWN = 4.6;   P20_BHP_DWN = 54;  P20_KTAS_DWN = 89;  P20_GPH_DWN = 4.4;M20_BHP_UPP = 57;  M20_KTAS_UPP = 90;  M20_GPH_UPP = 4.6;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 89;  STD_GPH_UPP = 4.4;   P20_BHP_UPP = 52;  P20_KTAS_UPP = 88;  P20_GPH_UPP = 4.3; }
        
        if (RPM == 2100) {M20_BHP_DWN = 53;  M20_KTAS_DWN = 86;  M20_GPH_DWN = 4.4;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 85;  STD_GPH_DWN = 4.2;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 84;  P20_GPH_DWN = 4;M20_BHP_UPP = 51;  M20_KTAS_UPP = 85;  M20_GPH_UPP = 4.2;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 84;  STD_GPH_UPP = 4;   P20_BHP_UPP = 48;  P20_KTAS_UPP = 83;  P20_GPH_UPP = 3.9; }
        
        if (RPM == 2000) {M20_BHP_DWN = 48;  M20_KTAS_DWN = 81;  M20_GPH_DWN = 3.9;   STD_BHP_DWN = 46;  STD_KTAS_DWN = 80;  STD_GPH_DWN = 3.8;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 78;  P20_GPH_DWN = 3.7;M20_BHP_UPP = 46;  M20_KTAS_UPP = 80;  M20_GPH_UPP = 3.8;   STD_BHP_UPP = 45;  STD_KTAS_UPP = 79;  STD_GPH_UPP = 3.7;   P20_BHP_UPP = 44;  P20_KTAS_UPP = 77;  P20_GPH_UPP = 3.6; }
        
        //  ***************
        
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 102;  M20_GPH_DWN2 = 6.1;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 103;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 70;  P20_KTAS_DWN2 = 102;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 101;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 75;  STD_KTAS_UPP2 = 105;  STD_GPH_UPP2 = 6.1;   P20_BHP_UPP2 = 71;  P20_KTAS_UPP2 = 104;  P20_GPH_UPP2 = 5.7; }
        
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 76;  M20_KTAS_DWN2 = 102;  M20_GPH_DWN2 = 6.1;   STD_BHP_DWN2 = 71;  STD_KTAS_DWN2 = 101;  STD_GPH_DWN2 = 5.7;   P20_BHP_DWN2 = 67;  P20_KTAS_DWN2 = 100;  P20_GPH_DWN2 = 5.4;M20_BHP_UPP2 = 72;  M20_KTAS_UPP2 = 101;  M20_GPH_UPP2 = 5.8;   STD_BHP_UPP2 = 67;  STD_KTAS_UPP2 = 100;  STD_GPH_UPP2 = 5.4;   P20_BHP_UPP2 = 64;  P20_KTAS_UPP2 = 99;  P20_GPH_UPP2 = 5.247; }
        
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 67;  M20_KTAS_DWN2 = 96;  M20_GPH_DWN2 = 5.4;   STD_BHP_DWN2 = 63;  STD_KTAS_DWN2 = 95;  STD_GPH_DWN2 = 5.1;   P20_BHP_DWN2 = 60;  P20_KTAS_DWN2 = 95;  P20_GPH_DWN2 = 4.9;M20_BHP_UPP2 = 64;  M20_KTAS_UPP2 = 96;  M20_GPH_UPP2 = 5.2;   STD_BHP_UPP2 = 60;  STD_KTAS_UPP2 = 95;  STD_GPH_UPP2 = 4.9;   P20_BHP_UPP2 = 57;  P20_KTAS_UPP2 = 94;  P20_GPH_UPP2 = 4.7; }
        
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 60;  M20_KTAS_DWN2 = 91;  M20_GPH_DWN2 = 4.8;   STD_BHP_DWN2 = 56;  STD_KTAS_DWN2 = 90;  STD_GPH_DWN2 = 4.6;   P20_BHP_DWN2 = 54;  P20_KTAS_DWN2 = 89;  P20_GPH_DWN2 = 4.4;M20_BHP_UPP2 = 57;  M20_KTAS_UPP2 = 90;  M20_GPH_UPP2 = 4.6;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 89;  STD_GPH_UPP2 = 4.4;   P20_BHP_UPP2 = 52;  P20_KTAS_UPP2 = 88;  P20_GPH_UPP2 = 4.3; }
        
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 53;  M20_KTAS_DWN2 = 86;  M20_GPH_DWN2 = 4.4;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 85;  STD_GPH_DWN2 = 4.2;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 84;  P20_GPH_DWN2 = 4;M20_BHP_UPP2 = 51;  M20_KTAS_UPP2 = 85;  M20_GPH_UPP2 = 4.2;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 84;  STD_GPH_UPP2 = 4;   P20_BHP_UPP2 = 48;  P20_KTAS_UPP2 = 83;  P20_GPH_UPP2 = 3.9; }
        
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 48;  M20_KTAS_DWN2 = 81;  M20_GPH_DWN2 = 3.9;   STD_BHP_DWN2 = 46;  STD_KTAS_DWN2 = 80;  STD_GPH_DWN2 = 3.8;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 78;  P20_GPH_DWN2 = 3.7;M20_BHP_UPP2 = 46;  M20_KTAS_UPP2 = 80;  M20_GPH_UPP2 = 3.8;   STD_BHP_UPP2 = 45;  STD_KTAS_UPP2 = 79;  STD_GPH_UPP2 = 3.7;   P20_BHP_UPP2 = 44;  P20_KTAS_UPP2 = 77;  P20_GPH_UPP2 = 3.6; }
        
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 4000 und 6000
    
    
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000) {
        

        
        PressAltAbzug = 6000;
        
        
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 75;  STD_KTAS_DWN = 105;  STD_GPH_DWN = 6.1;   P20_BHP_DWN = 71;  P20_KTAS_DWN = 104;  P20_GPH_DWN = 5.7;M20_BHP_UPP = 76;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 6.2;   STD_BHP_UPP = 71;  STD_KTAS_UPP = 104;  STD_GPH_UPP = 5.8;   P20_BHP_UPP = 67;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 5.4; }
        
        if (RPM == 2400) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 101;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 67;  STD_KTAS_DWN = 100;  STD_GPH_DWN = 5.4;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 99;  P20_GPH_DWN = 5.247;M20_BHP_UPP = 68;  M20_KTAS_UPP = 100;  M20_GPH_UPP = 5.5;   STD_BHP_UPP = 64;  STD_KTAS_UPP = 99;  STD_GPH_UPP = 5.2;   P20_BHP_UPP = 61;  P20_KTAS_UPP = 98;  P20_GPH_UPP = 4.9; }
        
        if (RPM == 2300) {M20_BHP_DWN = 64;  M20_KTAS_DWN = 96;  M20_GPH_DWN = 5.2;   STD_BHP_DWN = 60;  STD_KTAS_DWN = 95;  STD_GPH_DWN = 4.9;   P20_BHP_DWN = 57;  P20_KTAS_DWN = 94;  P20_GPH_DWN = 4.7;M20_BHP_UPP = 61;  M20_KTAS_UPP = 95;  M20_GPH_UPP = 5;   STD_BHP_UPP = 58;  STD_KTAS_UPP = 94;  STD_GPH_UPP = 4.7;   P20_BHP_UPP = 55;  P20_KTAS_UPP = 93;  P20_GPH_UPP = 4.5; }
        
        if (RPM == 2200) {M20_BHP_DWN = 57;  M20_KTAS_DWN = 90;  M20_GPH_DWN = 4.6;   STD_BHP_DWN = 54;  STD_KTAS_DWN = 89;  STD_GPH_DWN = 4.4;   P20_BHP_DWN = 52;  P20_KTAS_DWN = 88;  P20_GPH_DWN = 4.3;M20_BHP_UPP = 55;  M20_KTAS_UPP = 90;  M20_GPH_UPP = 4.5;   STD_BHP_UPP = 52;  STD_KTAS_UPP = 89;  STD_GPH_UPP = 4.3;   P20_BHP_UPP = 51;  P20_KTAS_UPP = 87;  P20_GPH_UPP = 4.2; }
        
        if (RPM == 2100) {M20_BHP_DWN = 51;  M20_KTAS_DWN = 85;  M20_GPH_DWN = 4.2;   STD_BHP_DWN = 49;  STD_KTAS_DWN = 84;  STD_GPH_DWN = 4;   P20_BHP_DWN = 48;  P20_KTAS_DWN = 83;  P20_GPH_DWN = 3.9;M20_BHP_UPP = 49;  M20_KTAS_UPP = 84;  M20_GPH_UPP = 4.1;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 83;  STD_GPH_UPP = 3.9;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 82;  P20_GPH_UPP = 3.8; }
        
        if (RPM == 2000) {M20_BHP_DWN = 46;  M20_KTAS_DWN = 80;  M20_GPH_DWN = 3.8;   STD_BHP_DWN = 45;  STD_KTAS_DWN = 79;  STD_GPH_DWN = 3.7;   P20_BHP_DWN = 44;  P20_KTAS_DWN = 77;  P20_GPH_DWN = 3.6;M20_BHP_UPP = 49;  M20_KTAS_UPP = 84;  M20_GPH_UPP = 4.1;   STD_BHP_UPP = 48;  STD_KTAS_UPP = 83;  STD_GPH_UPP = 3.9;   P20_BHP_UPP = 46;  P20_KTAS_UPP = 82;  P20_GPH_UPP = 3.8; }        
        
        
        //  ***************
        
        
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 75;  STD_KTAS_DWN2 = 105;  STD_GPH_DWN2 = 6.1;   P20_BHP_DWN2 = 71;  P20_KTAS_DWN2 = 104;  P20_GPH_DWN2 = 5.7;M20_BHP_UPP2 = 76;  M20_KTAS_UPP2 = 105;  M20_GPH_UPP2 = 6.2;   STD_BHP_UPP2 = 71;  STD_KTAS_UPP2 = 104;  STD_GPH_UPP2 = 5.8;   P20_BHP_UPP2 = 67;  P20_KTAS_UPP2 = 103;  P20_GPH_UPP2 = 5.4; }
        
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 101;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 67;  STD_KTAS_DWN2 = 100;  STD_GPH_DWN2 = 5.4;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 99;  P20_GPH_DWN2 = 5.247;M20_BHP_UPP2 = 68;  M20_KTAS_UPP2 = 100;  M20_GPH_UPP2 = 5.5;   STD_BHP_UPP2 = 64;  STD_KTAS_UPP2 = 99;  STD_GPH_UPP2 = 5.2;   P20_BHP_UPP2 = 61;  P20_KTAS_UPP2 = 98;  P20_GPH_UPP2 = 4.9; }
        
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 64;  M20_KTAS_DWN2 = 96;  M20_GPH_DWN2 = 5.2;   STD_BHP_DWN2 = 60;  STD_KTAS_DWN2 = 95;  STD_GPH_DWN2 = 4.9;   P20_BHP_DWN2 = 57;  P20_KTAS_DWN2 = 94;  P20_GPH_DWN2 = 4.7;M20_BHP_UPP2 = 61;  M20_KTAS_UPP2 = 95;  M20_GPH_UPP2 = 5;   STD_BHP_UPP2 = 58;  STD_KTAS_UPP2 = 94;  STD_GPH_UPP2 = 4.7;   P20_BHP_UPP2 = 55;  P20_KTAS_UPP2 = 93;  P20_GPH_UPP2 = 4.5; }
        
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 57;  M20_KTAS_DWN2 = 90;  M20_GPH_DWN2 = 4.6;   STD_BHP_DWN2 = 54;  STD_KTAS_DWN2 = 89;  STD_GPH_DWN2 = 4.4;   P20_BHP_DWN2 = 52;  P20_KTAS_DWN2 = 88;  P20_GPH_DWN2 = 4.3;M20_BHP_UPP2 = 55;  M20_KTAS_UPP2 = 90;  M20_GPH_UPP2 = 4.5;   STD_BHP_UPP2 = 52;  STD_KTAS_UPP2 = 89;  STD_GPH_UPP2 = 4.3;   P20_BHP_UPP2 = 51;  P20_KTAS_UPP2 = 87;  P20_GPH_UPP2 = 4.2; }
        
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 51;  M20_KTAS_DWN2 = 85;  M20_GPH_DWN2 = 4.2;   STD_BHP_DWN2 = 49;  STD_KTAS_DWN2 = 84;  STD_GPH_DWN2 = 4;   P20_BHP_DWN2 = 48;  P20_KTAS_DWN2 = 83;  P20_GPH_DWN2 = 3.9;M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 84;  M20_GPH_UPP2 = 4.1;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 83;  STD_GPH_UPP2 = 3.9;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 82;  P20_GPH_UPP2 = 3.8; }
        
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 46;  M20_KTAS_DWN2 = 80;  M20_GPH_DWN2 = 3.8;   STD_BHP_DWN2 = 45;  STD_KTAS_DWN2 = 79;  STD_GPH_DWN2 = 3.7;   P20_BHP_DWN2 = 44;  P20_KTAS_DWN2 = 77;  P20_GPH_DWN2 = 3.6;M20_BHP_UPP2 = 49;  M20_KTAS_UPP2 = 84;  M20_GPH_UPP2 = 4.1;   STD_BHP_UPP2 = 48;  STD_KTAS_UPP2 = 83;  STD_GPH_UPP2 = 3.9;   P20_BHP_UPP2 = 46;  P20_KTAS_UPP2 = 82;  P20_GPH_UPP2 = 3.8; }
        
        
        
        
        
        
    } // end if Pressue Alt zwischen 6000 und 8000
    
    
    
    
    
    
    
    
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        
        //NSLog (@"Hello 8000");
        
        PressAltAbzug = 8000;
        
        if (RPM == 2500) {M20_BHP_DWN = 76;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 6.2;   STD_BHP_DWN = 71;  STD_KTAS_DWN = 104;  STD_GPH_DWN = 5.8;   P20_BHP_DWN = 67;  P20_KTAS_DWN = 103;  P20_GPH_DWN = 5.4;M20_BHP_UPP = 72;  M20_KTAS_UPP = 105;  M20_GPH_UPP = 5.8;   STD_BHP_UPP = 68;  STD_KTAS_UPP = 103;  STD_GPH_UPP = 5.5;   P20_BHP_UPP = 64;  P20_KTAS_UPP = 103;  P20_GPH_UPP = 5.2; }
        
        if (RPM == 2400) {M20_BHP_DWN = 68;  M20_KTAS_DWN = 100;  M20_GPH_DWN = 5.5;   STD_BHP_DWN = 64;  STD_KTAS_DWN = 99;  STD_GPH_DWN = 5.2;   P20_BHP_DWN = 61;  P20_KTAS_DWN = 98;  P20_GPH_DWN = 4.9;M20_BHP_UPP = 65;  M20_KTAS_UPP = 99;  M20_GPH_UPP = 5.3;   STD_BHP_UPP = 61;  STD_KTAS_UPP = 98;  STD_GPH_UPP = 5;   P20_BHP_UPP = 58;  P20_KTAS_UPP = 97;  P20_GPH_UPP = 4.8; }
        
        if (RPM == 2300) {M20_BHP_DWN = 61;  M20_KTAS_DWN = 95;  M20_GPH_DWN = 5;   STD_BHP_DWN = 58;  STD_KTAS_DWN = 94;  STD_GPH_DWN = 4.7;   P20_BHP_DWN = 55;  P20_KTAS_DWN = 93;  P20_GPH_DWN = 4.5;M20_BHP_UPP = 58;  M20_KTAS_UPP = 94;  M20_GPH_UPP = 4.7;   STD_BHP_UPP = 56;  STD_KTAS_UPP = 93;  STD_GPH_UPP = 4.5;   P20_BHP_UPP = 53;  P20_KTAS_UPP = 92;  P20_GPH_UPP = 4.4; }
        
        if (RPM == 2200) {M20_BHP_DWN = 55;  M20_KTAS_DWN = 90;  M20_GPH_DWN = 4.5;   STD_BHP_DWN = 52;  STD_KTAS_DWN = 89;  STD_GPH_DWN = 4.3;   P20_BHP_DWN = 51;  P20_KTAS_DWN = 87;  P20_GPH_DWN = 4.2;M20_BHP_UPP = 53;  M20_KTAS_UPP = 89;  M20_GPH_UPP = 4.3;   STD_BHP_UPP = 51;  STD_KTAS_UPP = 88;  STD_GPH_UPP = 4.2;   P20_BHP_UPP = 49;  P20_KTAS_UPP = 86;  P20_GPH_UPP = 4; }
        
        if (RPM == 2100) {M20_BHP_DWN = 49;  M20_KTAS_DWN = 84;  M20_GPH_DWN = 4.1;   STD_BHP_DWN = 48;  STD_KTAS_DWN = 83;  STD_GPH_DWN = 3.9;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 82;  P20_GPH_DWN = 3.8;M20_BHP_UPP = 48;  M20_KTAS_UPP = 83;  M20_GPH_UPP = 4;   STD_BHP_UPP = 46;  STD_KTAS_UPP = 82;  STD_GPH_UPP = 3.9;   P20_BHP_UPP = 45;  P20_KTAS_UPP = 81;  P20_GPH_UPP = 3.8; }
        
        if (RPM == 2000) {M20_BHP_DWN = 49;  M20_KTAS_DWN = 84;  M20_GPH_DWN = 4.1;   STD_BHP_DWN = 48;  STD_KTAS_DWN = 83;  STD_GPH_DWN = 3.9;   P20_BHP_DWN = 46;  P20_KTAS_DWN = 82;  P20_GPH_DWN = 3.8;M20_BHP_UPP = 48;  M20_KTAS_UPP = 83;  M20_GPH_UPP = 4;   STD_BHP_UPP = 46;  STD_KTAS_UPP = 82;  STD_GPH_UPP = 3.9;   P20_BHP_UPP = 45;  P20_KTAS_UPP = 81;  P20_GPH_UPP = 3.8; }
        
        
        
        //  ***************
        
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    
    if (PressureAltitude >= 10000 & PressureAltitude <= 12000) {
        
        //NSLog (@"Hello 10000");
        
        PressAltAbzug = 10000;
        
        
        if (RPM == 2500) {M20_BHP_DWN = 72;  M20_KTAS_DWN = 105;  M20_GPH_DWN = 5.8;   STD_BHP_DWN = 68;  STD_KTAS_DWN = 103;  STD_GPH_DWN = 5.5;   P20_BHP_DWN = 64;  P20_KTAS_DWN = 103;  P20_GPH_DWN = 5.2;M20_BHP_UPP = 65;  M20_KTAS_UPP = 101;  M20_GPH_UPP = 5.3;   STD_BHP_UPP = 62;  STD_KTAS_UPP = 100;  STD_GPH_UPP = 5;   P20_BHP_UPP = 59;  P20_KTAS_UPP = 99;  P20_GPH_UPP = 4.8; }
        
        if (RPM == 2400) {M20_BHP_DWN = 65;  M20_KTAS_DWN = 99;  M20_GPH_DWN = 5.3;   STD_BHP_DWN = 61;  STD_KTAS_DWN = 98;  STD_GPH_DWN = 5;   P20_BHP_DWN = 58;  P20_KTAS_DWN = 97;  P20_GPH_DWN = 4.8;M20_BHP_UPP = 62;  M20_KTAS_UPP = 99;  M20_GPH_UPP = 5;   STD_BHP_UPP = 59;  STD_KTAS_UPP = 97;  STD_GPH_UPP = 4.8;   P20_BHP_UPP = 56;  P20_KTAS_UPP = 96;  P20_GPH_UPP = 4.6; }
        
        if (RPM == 2300) {M20_BHP_DWN = 58;  M20_KTAS_DWN = 94;  M20_GPH_DWN = 4.7;   STD_BHP_DWN = 56;  STD_KTAS_DWN = 93;  STD_GPH_DWN = 4.5;   P20_BHP_DWN = 53;  P20_KTAS_DWN = 92;  P20_GPH_DWN = 4.4;M20_BHP_UPP = 56;  M20_KTAS_UPP = 93;  M20_GPH_UPP = 4.6;   STD_BHP_UPP = 54;  STD_KTAS_UPP = 82;  STD_GPH_UPP = 4.4;   P20_BHP_UPP = 52;  P20_KTAS_UPP = 91;  P20_GPH_UPP = 4.3; }
        
        if (RPM == 2200) {M20_BHP_DWN = 53;  M20_KTAS_DWN = 89;  M20_GPH_DWN = 4.3;   STD_BHP_DWN = 51;  STD_KTAS_DWN = 88;  STD_GPH_DWN = 4.2;   P20_BHP_DWN = 49;  P20_KTAS_DWN = 86;  P20_GPH_DWN = 4;M20_BHP_UPP = 51;  M20_KTAS_UPP = 88;  M20_GPH_UPP = 4.2;   STD_BHP_UPP = 49;  STD_KTAS_UPP = 87;  STD_GPH_UPP = 4.1;   P20_BHP_UPP = 48;  P20_KTAS_UPP = 85;  P20_GPH_UPP = 4; }
        
        if (RPM == 2100) {M20_BHP_DWN = 48;  M20_KTAS_DWN = 83;  M20_GPH_DWN = 4;   STD_BHP_DWN = 46;  STD_KTAS_DWN = 82;  STD_GPH_DWN = 3.9;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 81;  P20_GPH_DWN = 3.8;M20_BHP_UPP = 47;  M20_KTAS_UPP = 82;  M20_GPH_UPP = 3.9;   STD_BHP_UPP = 45;  STD_KTAS_UPP = 81;  STD_GPH_UPP = 3.8;   P20_BHP_UPP = 44;  P20_KTAS_UPP = 79;  P20_GPH_UPP = 3.7; }
        
        if (RPM == 2000) {M20_BHP_DWN = 48;  M20_KTAS_DWN = 83;  M20_GPH_DWN = 4;   STD_BHP_DWN = 46;  STD_KTAS_DWN = 82;  STD_GPH_DWN = 3.9;   P20_BHP_DWN = 45;  P20_KTAS_DWN = 81;  P20_GPH_DWN = 3.8;M20_BHP_UPP = 47;  M20_KTAS_UPP = 82;  M20_GPH_UPP = 3.9;   STD_BHP_UPP = 45;  STD_KTAS_UPP = 81;  STD_GPH_UPP = 3.8;   P20_BHP_UPP = 44;  P20_KTAS_UPP = 79;  P20_GPH_UPP = 3.7; }        
        
        //  ***************
        
        if (RPM_HIGH == 2500) {M20_BHP_DWN2 = 72;  M20_KTAS_DWN2 = 105;  M20_GPH_DWN2 = 5.8;   STD_BHP_DWN2 = 68;  STD_KTAS_DWN2 = 103;  STD_GPH_DWN2 = 5.5;   P20_BHP_DWN2 = 64;  P20_KTAS_DWN2 = 103;  P20_GPH_DWN2 = 5.2;M20_BHP_UPP2 = 65;  M20_KTAS_UPP2 = 101;  M20_GPH_UPP2 = 5.3;   STD_BHP_UPP2 = 62;  STD_KTAS_UPP2 = 100;  STD_GPH_UPP2 = 5;   P20_BHP_UPP2 = 59;  P20_KTAS_UPP2 = 99;  P20_GPH_UPP2 = 4.8; }
        
        if (RPM_HIGH == 2400) {M20_BHP_DWN2 = 65;  M20_KTAS_DWN2 = 99;  M20_GPH_DWN2 = 5.3;   STD_BHP_DWN2 = 61;  STD_KTAS_DWN2 = 98;  STD_GPH_DWN2 = 5;   P20_BHP_DWN2 = 58;  P20_KTAS_DWN2 = 97;  P20_GPH_DWN2 = 4.8;M20_BHP_UPP2 = 62;  M20_KTAS_UPP2 = 99;  M20_GPH_UPP2 = 5;   STD_BHP_UPP2 = 59;  STD_KTAS_UPP2 = 97;  STD_GPH_UPP2 = 4.8;   P20_BHP_UPP2 = 56;  P20_KTAS_UPP2 = 96;  P20_GPH_UPP2 = 4.6; }
        
        if (RPM_HIGH == 2300) {M20_BHP_DWN2 = 58;  M20_KTAS_DWN2 = 94;  M20_GPH_DWN2 = 4.7;   STD_BHP_DWN2 = 56;  STD_KTAS_DWN2 = 93;  STD_GPH_DWN2 = 4.5;   P20_BHP_DWN2 = 53;  P20_KTAS_DWN2 = 92;  P20_GPH_DWN2 = 4.4;M20_BHP_UPP2 = 56;  M20_KTAS_UPP2 = 93;  M20_GPH_UPP2 = 4.6;   STD_BHP_UPP2 = 54;  STD_KTAS_UPP2 = 82;  STD_GPH_UPP2 = 4.4;   P20_BHP_UPP2 = 52;  P20_KTAS_UPP2 = 91;  P20_GPH_UPP2 = 4.3; }
        
        if (RPM_HIGH == 2200) {M20_BHP_DWN2 = 53;  M20_KTAS_DWN2 = 89;  M20_GPH_DWN2 = 4.3;   STD_BHP_DWN2 = 51;  STD_KTAS_DWN2 = 88;  STD_GPH_DWN2 = 4.2;   P20_BHP_DWN2 = 49;  P20_KTAS_DWN2 = 86;  P20_GPH_DWN2 = 4;M20_BHP_UPP2 = 51;  M20_KTAS_UPP2 = 88;  M20_GPH_UPP2 = 4.2;   STD_BHP_UPP2 = 49;  STD_KTAS_UPP2 = 87;  STD_GPH_UPP2 = 4.1;   P20_BHP_UPP2 = 48;  P20_KTAS_UPP2 = 85;  P20_GPH_UPP2 = 4; }
        
        if (RPM_HIGH == 2100) {M20_BHP_DWN2 = 48;  M20_KTAS_DWN2 = 83;  M20_GPH_DWN2 = 4;   STD_BHP_DWN2 = 46;  STD_KTAS_DWN2 = 82;  STD_GPH_DWN2 = 3.9;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 81;  P20_GPH_DWN2 = 3.8;M20_BHP_UPP2 = 47;  M20_KTAS_UPP2 = 82;  M20_GPH_UPP2 = 3.9;   STD_BHP_UPP2 = 45;  STD_KTAS_UPP2 = 81;  STD_GPH_UPP2 = 3.8;   P20_BHP_UPP2 = 44;  P20_KTAS_UPP2 = 79;  P20_GPH_UPP2 = 3.7; }
        
        if (RPM_HIGH == 2000) {M20_BHP_DWN2 = 48;  M20_KTAS_DWN2 = 83;  M20_GPH_DWN2 = 4;   STD_BHP_DWN2 = 46;  STD_KTAS_DWN2 = 82;  STD_GPH_DWN2 = 3.9;   P20_BHP_DWN2 = 45;  P20_KTAS_DWN2 = 81;  P20_GPH_DWN2 = 3.8;M20_BHP_UPP2 = 47;  M20_KTAS_UPP2 = 82;  M20_GPH_UPP2 = 3.9;   STD_BHP_UPP2 = 45;  STD_KTAS_UPP2 = 81;  STD_GPH_UPP2 = 3.8;   P20_BHP_UPP2 = 44;  P20_KTAS_UPP2 = 79;  P20_GPH_UPP2 = 3.7; }
        
        
        
        
    } // end if Pressue Alt zwischen 8000 und 10000
    
    
    
    
    
    // interpolate RPM
    
    M20_BHP_DWN_MED = M20_BHP_DWN + ((M20_BHP_DWN2 - M20_BHP_DWN ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_BHP_UPP_MED = M20_BHP_UPP + ((M20_BHP_UPP2 - M20_BHP_UPP ) / (RPM_HIGH - RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    
    
    M20_KTAS_DWN_MED = M20_KTAS_DWN + ((M20_KTAS_DWN2 - M20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_KTAS_UPP_MED = M20_KTAS_UPP + ((M20_KTAS_UPP2 - M20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    M20_GPH_DWN_MED = M20_GPH_DWN + ((M20_GPH_DWN2 - M20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    M20_GPH_UPP_MED = M20_GPH_UPP + ((M20_GPH_UPP2 - M20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_BHP_DWN_MED = STD_BHP_DWN + ((STD_BHP_DWN2 - STD_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_BHP_UPP_MED = STD_BHP_UPP + ((STD_BHP_UPP2 - STD_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_KTAS_DWN_MED = STD_KTAS_DWN + ((STD_KTAS_DWN2 - STD_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_KTAS_UPP_MED = STD_KTAS_UPP + ((STD_KTAS_UPP2 - STD_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    STD_GPH_DWN_MED = STD_GPH_DWN + ((STD_GPH_DWN2 - STD_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    STD_GPH_UPP_MED = STD_GPH_UPP + ((STD_GPH_UPP2 - STD_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_BHP_DWN_MED = P20_BHP_DWN + ((P20_BHP_DWN2 - P20_BHP_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_BHP_UPP_MED = P20_BHP_UPP + ((P20_BHP_UPP2 - P20_BHP_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_KTAS_DWN_MED = P20_KTAS_DWN + ((P20_KTAS_DWN2 - P20_KTAS_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_KTAS_UPP_MED = P20_KTAS_UPP + ((P20_KTAS_UPP2 - P20_KTAS_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    P20_GPH_DWN_MED = P20_GPH_DWN + ((P20_GPH_DWN2 - P20_GPH_DWN ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    P20_GPH_UPP_MED = P20_GPH_UPP + ((P20_GPH_UPP2 - P20_GPH_UPP ) / (RPM_HIGH-RPM_LOW)) * (RPM - RPM_LOW);
    
    
    
    
    temp = ISAdiff;
    //NSLog(@"temp = %.1f ", temp);
    
    // interpolate temperature
    
    if (temp >= 0 & temp <= 20) {
        
        low_BHP     = STD_BHP_DWN_MED      - (( (STD_BHP_DWN_MED   - P20_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED     - (( (STD_KTAS_DWN_MED  - P20_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED      - (( (STD_GPH_DWN_MED   - P20_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        high_BHP    = STD_BHP_UPP_MED     - (( (STD_BHP_UPP_MED   - P20_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS   = STD_KTAS_UPP_MED    - (( (STD_KTAS_UPP_MED  - P20_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED     - (( (STD_GPH_UPP_MED   - P20_GPH_UPP_MED)  / 20 ) * temp) ;
        
        
        
        
    }
    
    
    
    if (temp < 0 & temp >= -20) {
        
        low_BHP     = STD_BHP_DWN_MED   - (( (M20_BHP_DWN_MED   - STD_BHP_DWN_MED)  / 20 ) * temp) ;
        
        low_KTAS    = STD_KTAS_DWN_MED  - (( (M20_KTAS_DWN_MED  - STD_KTAS_DWN_MED) / 20 ) * temp) ;
        
        low_GPH     = STD_GPH_DWN_MED   - (( (M20_GPH_DWN_MED   - STD_GPH_DWN_MED)  / 20 ) * temp) ;
        
        
        
        
        high_BHP   = STD_BHP_UPP_MED    - (( (M20_BHP_UPP_MED   - STD_BHP_UPP_MED)  / 20 ) * temp) ;
        
        high_KTAS  = STD_KTAS_UPP_MED   - (( (M20_KTAS_UPP_MED  - STD_KTAS_UPP_MED) / 20 ) * temp) ;
        
        high_GPH    = STD_GPH_UPP_MED   - (( (M20_GPH_UPP_MED   - STD_GPH_UPP_MED)  / 20 ) * temp) ;
    }
    
    
    
    // interpolate for PRESSURE ALT    
    resultCruiseBHP =    low_BHP -  ( ((low_BHP - high_BHP) / 2000) * (PressureAltitude - PressAltAbzug) );
    resultCruiseKTAS =  low_KTAS -  ( ((low_KTAS - high_KTAS) / 2000) * (PressureAltitude - PressAltAbzug) );    
    resultCruiseFuelBurn =    low_GPH -  ( ((low_GPH - high_GPH) / 2000) * (PressureAltitude - PressAltAbzug) );
    
    //NSLog(@"RPM %f", RPM);
    //NSLog(@"resultCruiseBHP %f", resultCruiseBHP);
    
    return;
    
    
}
- (void) setRPMsliderValuesC152 {
    
    
    if (PressureAltitude >= 0 & PressureAltitude < 4000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2550;       
    }
    
    if (PressureAltitude >= 4000 & PressureAltitude < 6000) {
        sliderRPMmin = 2100;
        sliderRPMmax = 2600;
    }
    
    
    if (PressureAltitude >= 6000 & PressureAltitude < 8000 ) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2650;        
        
    }
    
    if (PressureAltitude >= 8000 & PressureAltitude < 10000) {
        sliderRPMmin = 2200;
        sliderRPMmax = 2700;
        
    }
    
    if (PressureAltitude >= 10000 & PressureAltitude < 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2700;        
        
    }
    
    if (PressureAltitude >= 12000) {
        sliderRPMmin = 2300;
        sliderRPMmax = 2650;
    }
    
    resultRPMmin = sliderRPMmin;
    resultRPMmax = sliderRPMmax;
    
    
}
@end

